/**
 * output package name
 */
package com.kingdee.eas.custom.workflow.client;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;

import javax.swing.tree.TreeModel;

import org.apache.log4j.Logger;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgUtils;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.custom.workflow.WorkflowPostionInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.xr.XRSQLFacadeFactory;
import com.kingdee.jdbc.rowset.IRowSet;

/**
 * output class name
 */
public class CompanyWorkflowListUI extends AbstractCompanyWorkflowListUI
{
    private static final Logger logger = CoreUIObject.getLogger(CompanyWorkflowListUI.class);
    
    /**
     * output class constructor
     */
    public CompanyWorkflowListUI() throws Exception
    {
        super();
    }
    public void onLoad() throws Exception {
    	// TODO Auto-generated method stub
    	super.onLoad();
    	tblMain.getDataRequestManager().setDataRequestMode(KDTDataRequestManager.REAL_MODE);
    	buildOrgTree();
    }
    
    protected void buildOrgTree() throws Exception{
		OrgUnitInfo cuInfo = SysContext.getSysContext().getCurrentOrgUnit();
//		if (!cuInfo.isIsPurchaseOrgUnit()) {
//			MsgBox.showInfo(this, "ҵ֯ܲ");
//			SysUtil.abort();
//		}
		
		TreeModel orgTreeModel = NewOrgUtils.getTreeModel(OrgViewType.ADMIN,"", cuInfo.getId().toString(), null,getActionPK(this.actionOnLoad));
//		TreeModel orgTreeModel = NewOrgUtils.getTreeModel(OrgViewType.ADMIN, null,false, false, "", false, null, 10, null, getActionPK(this.actionOnLoad));
		this.kDTree1.setModel(orgTreeModel);
		this.kDTree1.setSelectionRow(0);
	}
    
    public void actionTb_actionPerformed(ActionEvent e) throws Exception {
    	super.actionTb_actionPerformed(e);
    	if(kDBizPromptBox1.getValue()!=null&&kDBizPromptBox2.getValue()!=null&&kDBizPromptBox3.getValue()!=null){
    		PersonInfo p1Info = (PersonInfo) kDBizPromptBox1.getValue();
    		PersonInfo p2Info = (PersonInfo) kDBizPromptBox2.getValue();
    		WorkflowPostionInfo workInfo = (WorkflowPostionInfo) kDBizPromptBox3.getValue();
    		String sql1=" select fid from CT_WOR_CompanyWorkflowEntry  where CFPersonID='"+p1Info.getId()+"' and CFPostionID='"+workInfo.getId()+"' ";
    		IRowSet  RowSet= XRSQLFacadeFactory.getRemoteInstance().executeQuery(sql1, null);
    		if(RowSet.size()>0){
    			String sql=" update CT_WOR_CompanyWorkflowEntry set CFPersonID='"+p2Info.getId()+"'  where CFPersonID='"+p1Info.getId()+"' and CFPostionID='"+workInfo.getId()+"'  ";
        		boolean flag =MsgBox.isYes(MsgBox.showConfirm3a(""+RowSet.size()+"Ҫ滻,ȷ滻","ȷ滻"));
        		if(flag){
        			List list=new ArrayList();
        			XRSQLFacadeFactory.getRemoteInstance().executeUpdate(sql, list);
        			  MsgBox.showInfo("滻ɹ");
        		}
    		}else{
    			  MsgBox.showInfo("ԭԱûҵλ");
    		}
    		
    	}
    }
    
    /**
	 * õactionPK
	 *
	 * @param action
	 * @return
	 */
	public static IMetaDataPK getActionPK(ItemAction action) {
		if (action == null) {
			return null;
		}
		String actoinName = action.getClass().getName();
		if (actoinName.indexOf("$") >= 0) {
			actoinName = actoinName.substring(actoinName.indexOf("$") + 1);
		}

		return new MetaDataPK(actoinName);
	}

    /**
     * output storeFields method
     */
    public void storeFields()
    {
        super.storeFields();
    }

	 protected void prepareUIContext(UIContext uiContext, ActionEvent e) {
		 super.prepareUIContext(uiContext, e);
		 ItemAction act = getActionFromActionEvent(e);
//			if (act.equals(actionAddNew)) {
//				if("".equals(getTreeNode().toString())){
//					MsgBox.showWarning("ѡҵڵ");
//					SysUtil.abort();
//				}
				FullOrgUnitInfo orgInfo = null;
				if(getTreeNode().getUserObject() instanceof FullOrgUnitInfo)
					orgInfo = ((FullOrgUnitInfo) getTreeNode().getUserObject());
				if(getTreeNode().getUserObject() instanceof OrgStructureInfo )
					orgInfo = ((OrgStructureInfo) getTreeNode().getUserObject()).getUnit();
				uiContext.put("orgInfo", orgInfo);
			
		}

    
	public DefaultKingdeeTreeNode getTreeNode() {
		return (DefaultKingdeeTreeNode)kDTree1.getLastSelectedPathComponent();
	}
	protected String getEditUIModal() {
		 return "com.kingdee.eas.base.uiframe.client.UINewTabFactory";
	}
    
	
	
    protected IQueryExecutor getQueryExecutor(IMetaDataPK pk,EntityViewInfo viewInfo){
		EntityViewInfo view = (EntityViewInfo)viewInfo.clone();
		FilterInfo filInfo = new FilterInfo();
		DefaultKingdeeTreeNode OrgNode = this.getTreeNode();
		String orgId = "";
		if(OrgNode.getUserObject() instanceof OrgStructureInfo )
			orgId = ((OrgStructureInfo) OrgNode.getUserObject()).getUnit().getId().toString();
 		if(OrgNode.getUserObject() instanceof FullOrgUnitInfo)
 			orgId = ((FullOrgUnitInfo) OrgNode.getUserObject()).getId().toString();
 		String orgLongNumber = "xxx";
 		if(UIRuleUtil.isNotNull(orgId)){
 			SelectorItemCollection sic = new SelectorItemCollection();
 			sic.add("longNumber");
 			try {
				orgLongNumber = AdminOrgUnitFactory.getRemoteInstance().getAdminOrgUnitInfo(new ObjectUuidPK(orgId),sic).getLongNumber();
			} catch (EASBizException e) {
				e.printStackTrace();
			} catch (BOSException e) {
				e.printStackTrace();
			};
 		}
 		filInfo.getFilterItems().add(new FilterItemInfo("deparment.longNumber",orgLongNumber+"%",CompareType.LIKE));
// 		filInfo.setMaskString("#0 and( #1 or ( #2 and #3))");
 		
		if(view.getFilter()==null){
			view.setFilter(filInfo);
		}else{
			try {
				view.getFilter().mergeFilter(filInfo, "and");
			} catch (BOSException e) {
				e.printStackTrace();
			}
		}
    	return super.getQueryExecutor(pk, view);
    }
    
	protected void kDTree1_mouseClicked(MouseEvent e) throws Exception {
		super.kDTree1_mouseClicked(e);
		refreshList();
		
	}
	
    
    
    /**
     * output tblMain_tableClicked method
     */
    protected void tblMain_tableClicked(com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent e) throws Exception
    {
        super.tblMain_tableClicked(e);
    }




    /**
     * output actionAddNew_actionPerformed
     */
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception
    {
     	if(tblMain.getRowCount()>0){
    		MsgBox.showConfirm2("һֻһ¼");
    		SysUtil.abort();
    	}
    		
        super.actionAddNew_actionPerformed(e);
    }

    /**
     * output actionView_actionPerformed
     */
    public void actionView_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionView_actionPerformed(e);
    }

    /**
     * output actionEdit_actionPerformed
     */
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionEdit_actionPerformed(e);
    }

    /**
     * output actionRemove_actionPerformed
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionRemove_actionPerformed(e);
    }

    /**
     * output actionRefresh_actionPerformed
     */
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionRefresh_actionPerformed(e);
    }



    /**
     * output actionQuery_actionPerformed
     */
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionQuery_actionPerformed(e);
    }





    /**
     * output getBizInterface method
     */
    protected com.kingdee.eas.framework.ICoreBase getBizInterface() throws Exception
    {
        return com.kingdee.eas.custom.workflow.CompanyWorkflowFactory.getRemoteInstance();
    }

    /**
     * output createNewData method
     */
    protected com.kingdee.bos.dao.IObjectValue createNewData()
    {
        com.kingdee.eas.custom.workflow.CompanyWorkflowInfo objectValue = new com.kingdee.eas.custom.workflow.CompanyWorkflowInfo();
		
        return objectValue;
    }

}