/**
 * output package name
 */
package com.kingdee.eas.custom.gggl.client;

import java.awt.event.*;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

import org.apache.log4j.Logger;

import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.custom.gggl.AdvertInfo;
import com.kingdee.eas.custom.gggl.DTypeEnum;
import com.kingdee.eas.custom.gggl.Hyhelper;
import com.kingdee.eas.framework.*;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.xr.helper.DateDaySub;
import com.kingdee.eas.xr.helper.PersonXRHelper;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;

/**
 * output class name
 */
public class SchedulBillEditUI extends AbstractSchedulBillEditUI
{
    private static final Logger logger = CoreUIObject.getLogger(SchedulBillEditUI.class);
    
    /**
     * output class constructor
     */
    public SchedulBillEditUI() throws Exception
    {
        super();
    }
    
	//ע⣺༭ Ժ ¼  kdtE1  kdtE2  λֶ  չұ Ľע ҪȻ˲. Ĵ 
//	kdtE2_ggw_PromptBox.addSelectorListener(new SelectorListener() {
//	com.kingdee.eas.custom.gggl.client.AdvertListUI kdtE2_ggw_PromptBox_F7ListUI = null;
//	public void willShow(SelectorEvent e) {
//		if (kdtE2_ggw_PromptBox_F7ListUI == null) {
//			try {
//				kdtE2_ggw_PromptBox_F7ListUI = new com.kingdee.eas.custom.gggl.client.AdvertListUI();
//			} catch (Exception e1) {
//				e1.printStackTrace();
//			}
//			HashMap ctx = new HashMap();
//			ctx.put("bizUIOwner",javax.swing.SwingUtilities.getWindowAncestor(kdtE2_ggw_PromptBox_F7ListUI));
//			kdtE2_ggw_PromptBox_F7ListUI.setF7Use(true,ctx);
//			kdtE2_ggw_PromptBox.setSelector(kdtE2_ggw_PromptBox_F7ListUI);
//		}
//	}
//});
    /**
     * output loadFields method
     */
    public void loadFields()
    {
        super.loadFields();
        kdtE1.getColumn("zlzq").getStyleAttributes().setLocked(true);
        kdtE1.getColumn("ggw").getStyleAttributes().setLocked(true);
        kdtE1.getColumn("seq").getStyleAttributes().setHided(true);
		 setPreferredSize(getMaximumSize());
        
        
        
      //ͥ
		if(djType.getSelectedItem()!=null &&  djType.getSelectedItem()==DTypeEnum.zt){
			
	    	EntityViewInfo view = new EntityViewInfo();
			FilterInfo filInfo = new FilterInfo();
			filInfo.getFilterItems().add(new FilterItemInfo("treeid.id","JQcAAAAAgOrsyXfw" ,CompareType.EQUALS));//idǹλ Ӧͥ
			view.setFilter(filInfo);
			KDBizPromptBox bizBox = (KDBizPromptBox) kdtE1.getColumn("ggw").getEditor().getComponent();//ȡ¼F7ֶ
			bizBox.setEntityViewInfo(view);
			
	
		
		}
		
		//
		if( djType.getSelectedItem()!=null &&  djType.getSelectedItem()==DTypeEnum.gg){
			
	    	EntityViewInfo view = new EntityViewInfo();
			FilterInfo filInfo = new FilterInfo();
			filInfo.getFilterItems().add(new FilterItemInfo("treeid.id","JQcAAAAAgOrsyXfw" ,CompareType.NOTEQUALS));//idǹλ Ӧͥ
			view.setFilter(filInfo);
			KDBizPromptBox bizBox = (KDBizPromptBox) kdtE1.getColumn("ggw").getEditor().getComponent();//ȡ¼F7ֶ
			bizBox.setEntityViewInfo(view);
		
		}
        
    }
    
    protected void verifyInput(ActionEvent e) throws Exception {
		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(prmtcontract.getValue())) {
			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"ͬ/"});
		}
		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(prmtcompany.getData())) {
			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"˾"});
		}
		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(prmtcustomer.getData())) {
			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"ͻ"});
		}
	
		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(prmtzrPerson.getData())) {
			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {""});
		}
		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(prmtdeparment.getData())) {
			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"β"});
		}
		if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(txthtnn.getText())) {
			throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {""});
		}
		for (int i=0,n=kdtE1.getRowCount();i<n;i++) {
			if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(kdtE1.getCell(i,"ggw").getValue())) {
				throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"λ"});
			}
		}
		for (int i=0,n=kdtE1.getRowCount();i<n;i++) {
			if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(kdtE1.getCell(i,"zlStartDate").getValue())) {
				throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"ʼ"});
			}
		}
		for (int i=0,n=kdtE1.getRowCount();i<n;i++) {
			if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(kdtE1.getCell(i,"zlEndDate").getValue())) {
				throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"ڵ"});
			}
		}
		for (int i=0,n=kdtE1.getRowCount();i<n;i++) {
			if (com.kingdee.bos.ui.face.UIRuleUtil.isNull(kdtE1.getCell(i,"zlzq").getValue())) {
				throw new com.kingdee.eas.common.EASBizException(com.kingdee.eas.common.EASBizException.CHECKBLANK,new Object[] {"/"});
			}
		}

		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		for (int i = 0; i < kdtE1.getRowCount(); i++) {
			if(kdtE1.getCell(i, "ggw").getValue()!=null && kdtE1.getCell(i, "zlStartDate").getValue()!=null){
			AdvertInfo advertInfo=(AdvertInfo) kdtE1.getCell(i, "ggw").getValue();
			Date zlStartDate=(Date) kdtE1.getCell(i, "zlStartDate").getValue();
			String  zlStartDates=  sdf.format(zlStartDate);
			if(!"JQcAAAAAgOnsyXfw".equals(advertInfo.getTreeid().getId().toString())){
				 boolean  flag=	Hyhelper.isGgwCheck(editData.getId(), editData.getContract().getId(), advertInfo.getId().toString(), zlStartDates);
	             if(flag){
	            		MsgBox.showWarning("λ("+advertInfo.getName()+") :ڿʼͬظڣѡ");
						SysUtil.abort();
	             	}
				}
			}
		}
	}

    
	protected void btnGgPq_actionPerformed(ActionEvent e) throws Exception {
		super.btnGgPq_actionPerformed(e);
		if(kdtE1.getSelectManager().getActiveRowIndex()==-1){
			MsgBox.showConfirm2("ѡУ");
			SysUtil.abort();
			}
		int row=kdtE1.getSelectManager().getActiveRowIndex();
		if(kdtE1.getCell(row, "ggw").getValue()!=null){
			UIContext  context = new UIContext(this);
			String ggname=kdtE1.getCell(row, "ggw").getValue().toString();
			context.put("ggname", ggname);

			if(djType.getSelectedItem()==DTypeEnum.zt){
				IUIWindow create = UIFactory.createUIFactory(UIFactoryName.NEWWIN).create(AdvertManUI.class.getName(),context,null,OprtState.VIEW);
				create.show();
				}
			
			if(djType.getSelectedItem()==DTypeEnum.gg){
				IUIWindow create = UIFactory.createUIFactory(UIFactoryName.NEWWIN).create(AdvertGuangGaoPaiQiUI.class.getName(),context,null,OprtState.VIEW);
				create.show();
				}
		}else{
			MsgBox.showConfirm2("ѡλ룡");
			SysUtil.abort();
		}
	}
    
    public void storeFields()
    {
        super.storeFields();
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionAddNew_actionPerformed(e);
    }

    /**
     * output actionEdit_actionPerformed
     */
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionEdit_actionPerformed(e);
    }

    /**
     * output actionRemove_actionPerformed
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionRemove_actionPerformed(e);
    }

    /**
     * output actionAudit_actionPerformed
     */
    public void actionAudit_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionAudit_actionPerformed(e);
    }

    /**
     * output actionUnAudit_actionPerformed
     */
    public void actionUnAudit_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionUnAudit_actionPerformed(e);
    }

    /**
     * output getBizInterface method
     */
    protected com.kingdee.eas.framework.ICoreBase getBizInterface() throws Exception
    {
        return com.kingdee.eas.custom.gggl.SchedulBillFactory.getRemoteInstance();
    }

    /**
     * output createNewDetailData method
     */
    protected IObjectValue createNewDetailData(KDTable table)
    {
		
        return null;
    }

    /**
     * output createNewData method
     */
    protected com.kingdee.bos.dao.IObjectValue createNewData()
    {
        com.kingdee.eas.custom.gggl.SchedulBillInfo objectValue = new com.kingdee.eas.custom.gggl.SchedulBillInfo();
        objectValue.setCreator((com.kingdee.eas.base.permission.UserInfo)(com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentUser()));
        if(getUIContext().get("dyType")!=null){
    		objectValue.setDjType(DTypeEnum.zt);
    	}
        
    	CompanyOrgUnitInfo info= SysContext.getSysContext().getCurrentFIUnit();
    	if(SysContext.getSysContext().getCurrentUserInfo()!=null){
    		PersonInfo uinf0= SysContext.getSysContext().getCurrentUserInfo().getPersonId();
    		objectValue.setZrPerson(uinf0);
    		objectValue.setCompany(info);
    		objectValue.setDeparment(PersonXRHelper.getPosiMemByDeptUser(uinf0));
    	}
        
        return objectValue;
    }
	protected void attachListeners() {
	}
	protected void detachListeners() {
	}
	protected KDTextField getNumberCtrl() {
		return null;
	}
	protected void verifyInputForSave() throws Exception {
	}
	protected void verifyInputForSubmit() throws Exception {
		
	}
	protected void kdtE1_editStopped(KDTEditEvent e) throws Exception {
		int rowIndex = e.getRowIndex();
		  int colIndex = e.getColIndex();
		    String fieldName = this.kdtE1.getColumnKey(colIndex);
		    if ("zlStartDate".equalsIgnoreCase(fieldName)||"zlEndDate".equalsIgnoreCase(fieldName)) {
		    	if(this.kdtE1.getCell(rowIndex, "zlStartDate").getValue()!=null&&this.kdtE1.getCell(rowIndex, "zlEndDate").getValue()!=null){
		    	 Date  	zlStartDate=(Date) this.kdtE1.getCell(rowIndex, "zlStartDate").getValue();
		    	 Date  	zlEndDate=(Date) this.kdtE1.getCell(rowIndex, "zlEndDate").getValue();
		    	 if(zlEndDate.getTime()<zlStartDate.getTime()){
		    		 this.kdtE1.getCell(rowIndex, "zlEndDate").setValue(null);
		    		 MsgBox.showWarning("ڵڲСڿʼڣ");
		    			SysUtil.abort();
		    		 }
		    	 }
		    	}
		super.kdtE1_editStopped(e);
		if ("zlStartDate".equalsIgnoreCase(fieldName)||"zlEndDate".equalsIgnoreCase(fieldName)) {
			if(this.kdtE1.getCell(rowIndex, "zlStartDate").getValue()!=null&&this.kdtE1.getCell(rowIndex, "zlEndDate").getValue()!=null){
				Date  	zlStartDate=(Date) this.kdtE1.getCell(rowIndex, "zlStartDate").getValue();
				Date  	zlEndDate=(Date) this.kdtE1.getCell(rowIndex, "zlEndDate").getValue();
				Calendar c = Calendar.getInstance();       
				c.setTime(zlEndDate);       
				c.add(Calendar.DAY_OF_MONTH,1);//+1
				Date zlEndDate2 = c.getTime();
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
				String  zlStartDates=  sdf.format(zlStartDate);
				String  zlEndDates=  sdf.format(zlEndDate2);
				String mmdd=	DateDaySub.remainDateToString(zlStartDates, zlEndDates);
				this.kdtE1.getCell(rowIndex, "zlzq").setValue(mmdd);

			}

		}
	}
	protected void initWorkButton() {
		actionAddNew.setVisible(false);
		actionCopy.setVisible(false);
		actionAttachment.setVisible(false);
		actionPrint.setVisible(false);
		actionPrintPreview.setVisible(false);
		actionAudit.setVisible(false);
		actionUnAudit.setVisible(false);
		actionCreateFrom.setVisible(false);
		actionAddLine.setVisible(false);
		actionInsertLine.setVisible(false);
		actionRemoveLine.setVisible(false);
		super.initWorkButton();
	}

}