package com.kingdee.eas.xr.helper;


import java.awt.event.ActionEvent;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractBaseObjectCollection;
import com.kingdee.bos.dao.DataAccessException;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.InvalidDAOMetaDataException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.DynamicObjectFactory;
import com.kingdee.bos.framework.IDynamicObject;
import com.kingdee.bos.metadata.IMetaDataLoader;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataUtils;
import com.kingdee.bos.metadata.data.ColumnInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.LinkPropertyInfo;
import com.kingdee.bos.metadata.entity.PropertyCollection;
import com.kingdee.bos.metadata.entity.PropertyInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.framework.AbstractCoreBaseInfo;
import com.kingdee.util.StringUtils;

public class MtaDatasHelper {
	
	public static String  getBillData(String billId)throws Exception {
		IMetaDataLoader metaDataLoader = MetaDataLoaderFactory.getRemoteMetaDataLoader();
		IDynamicObject idynamicObject = DynamicObjectFactory.getRemoteInstance();
		
		BOSObjectType bosType = BOSUuid.read(billId).getType();
		EntityObjectInfo entity = metaDataLoader.getEntity(bosType);
		PropertyCollection properties = entity.getInheritedNoDuplicatedPropertiesRuntime();
		
		IObjectValue objectValue = idynamicObject.getValue(bosType,new ObjectUuidPK(billId),getEntitySelectorItem(properties));
		
		List listData = new ArrayList();
		List entryData = new ArrayList();
		Gson g = new Gson();
		
    	Map billMap = new HashMap();
    	Map map = new HashMap();
		for (int i = 0; i < properties.size(); i++) {
			PropertyInfo propertyInfo = properties.get(i);
			String propertyName = propertyInfo.getName();
			String name = propertyInfo.getAlias();
			
			String string = UIRuleUtil.getString(getProperty(billMap,idynamicObject,objectValue,propertyName,propertyInfo.getAlias(),metaDataLoader,false));
			if(string!=null &&!chechkBosId(string)){
				if(propertyInfo.getMappingField()!=null&&propertyInfo.getMappingField().getTypeName().getAlias().equals("INT")){
					string = string.equals("true")?"":"";
				}
//				System.out.println(name +"-->"+string);
				map.put(name+"@"+propertyName, string);
			}
		}
		billMap.put("Ϣ", map);
		listData.add(billMap);
		
		return g.toJson(listData);
	}
	
	public static Object getProperty(Map billMap,IDynamicObject idynamicObject,IObjectValue objValue, String propertyName,String name,IMetaDataLoader metaDataLoader,boolean isEntry) throws DataAccessException, BOSException{
		if(objValue == null || StringUtils.isEmpty(propertyName))
			return null;
		String propertys[] = StringUtils.split(propertyName, ".");
		IObjectValue tempObj = objValue;
		Object retObj = null;
		if(propertys.length == 1){
			fillLinkProperty(tempObj, propertyName);
		} else{
			int i = 0;
			int n = propertys.length;
			do{
				if(i >= n - 1)
					break;
				fillLinkProperty(tempObj, propertys[i]);
				tempObj = (IObjectValue)tempObj.get(propertys[i]);
				if(tempObj == null)
					break;
				i++;
			} while(true);
		}
		if(tempObj != null){
			Class type = tempObj.getClass();
			try{
				Method method = type.getMethod((new StringBuilder()).append("get").append(StringUtils.headCharUpperCase(propertys[propertys.length - 1])).toString(), null);
				retObj = method.invoke(tempObj, null);
			}catch(Exception e){
				retObj = tempObj.get(propertys[propertys.length - 1]);
			}
		}
		
		if(retObj instanceof AbstractBaseObjectCollection &&!isEntry){
			AbstractBaseObjectCollection collection = (AbstractBaseObjectCollection)retObj;
			
			List entryData = new ArrayList();
			for (int i = 0; i < collection.size(); i++) {
				IObjectValue objectInfo = collection.getObject(i);
				
				String billId = objectInfo.get("id").toString();
				BOSObjectType bosType = BOSUuid.read(billId).getType();
				EntityObjectInfo entity = metaDataLoader.getEntity(bosType);
				PropertyCollection properties = entity.getInheritedNoDuplicatedPropertiesRuntime();
				
				FilterInfo filInfo = new FilterInfo();
				filInfo.getFilterItems().add(new FilterItemInfo("id",billId));
				if(!idynamicObject.exists(bosType, filInfo))
					continue;
				IObjectValue objectValue = idynamicObject.getValue(bosType,new ObjectUuidPK(billId),getEntitySelectorItem(properties));
				
				Map entryMap = new HashMap();
				for (int i1 = 0; i1 < properties.size(); i1++) {
					PropertyInfo propertyInfo = properties.get(i1);
					String propertyEntryName = propertyInfo.getName();
					String entryName = propertyInfo.getAlias();
					
					if(entryName.equals("ͷ")){
						System.out.println("");
					}
					
					String string = UIRuleUtil.getString(getProperty(billMap,idynamicObject,objectValue,propertyEntryName,entryName,metaDataLoader,true));
					if(string!=null &&!chechkBosId(string)){
						if(propertyInfo.getMappingField()!=null&&propertyInfo.getMappingField().getTypeName().getAlias().equals("INT")){
							string = string.equals("true")?"":"";
						}
						
//						System.out.println(name +"-->"+string);
						entryMap.put(entryName+"@"+propertyEntryName, string);
					}
				}
				entryData.add(entryMap);
			}
			
			billMap.put(name+"@"+propertyName, entryData);
			retObj = null;
		}
		if(retObj instanceof AbstractCoreBaseInfo){
			AbstractCoreBaseInfo info = (AbstractCoreBaseInfo)retObj;
			if(info.get("name")!=null){
				retObj = info.get("name");
			}else{
				retObj = info.get("number")!=null?info.get("number"):null;
			}
		}
		return retObj;
	}
	
	public static boolean chechkBosId(String id){
		boolean flse = true;
		try {
			BOSUuid.read(id);
		} catch (Exception e) {
			flse = false;
		}
		return flse;
	}
	
	public static SelectorItemCollection getEntitySelectorItem(PropertyCollection properties){
		Set<String> colSet = new HashSet<String>();
		for (int i1 = 0; i1 < properties.size(); i1++) {
			PropertyInfo propertyInfo = properties.get(i1);
			String propertyEntryName = propertyInfo.getName();
			
			ColumnInfo colInfo = propertyInfo.getMappingField();
			if(colInfo==null){
				colSet.add(propertyEntryName+".*");
			}else{
				colSet.add(propertyEntryName);
			}
		}
		SelectorItemCollection sic = new SelectorItemCollection();
		Iterator<String> iterator = colSet.iterator();
		while(iterator.hasNext()){
			sic.add(iterator.next());
		}
		return sic;
	}
	
	public static  void fillLinkProperty(IObjectValue objValue, String propertyName) throws DataAccessException, BOSException{
    	Object subObj = objValue.get(propertyName);
    	if(subObj != null && (subObj instanceof IObjectValue)){
    		IObjectValue ov = (IObjectValue)subObj;
    		if(!ov.getBoolean("_loaded_")){
    			com.kingdee.bos.dao.IObjectPK pk = new ObjectUuidPK(ov.getBOSUuid(ov.getPKField()));
    			ov = DynamicObjectFactory.getRemoteInstance().getValue(ov.getBOSType(), pk);
    			ov.setBoolean("_loaded_", true);
    			objValue.put(propertyName, ov);
    		}
    	}
    }
}