package com.kingdee.eas.xr.helper;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
 
 
public class DateDaySub {
 
    private static Calendar calS = Calendar.getInstance();
    private static Pattern p = Pattern.compile("\\d{4}-\\d{2}-\\d{2}");//ʽ
 
 
    /**
     * ʣʱ
     *
     * @param startDateStr yyyy-MM-dd
     * @param endDateStr yyyy-MM-dd
     * @return      ꣿ£
     */
    public static String remainDateToString(String startDateStr, String endDateStr) {
        java.util.Date startDate = null;
        java.util.Date endDate = null;
        try {
            startDate = new SimpleDateFormat("yyyy-MM-dd").parse(startDateStr);
        } catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
        try {
            endDate = new SimpleDateFormat("yyyy-MM-dd").parse(endDateStr);
        } catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
        calS.setTime(startDate);
        int startY = calS.get(Calendar.YEAR);
        int startM = calS.get(Calendar.MONTH);
        int startD = calS.get(Calendar.DATE);
        int startDayOfMonth = calS.getActualMaximum(Calendar.DAY_OF_MONTH);
 
        calS.setTime(endDate);
        int endY = calS.get(Calendar.YEAR);
        int endM = calS.get(Calendar.MONTH);
        //2011-01-102011-01-10ΪΪһ
        int endD = calS.get(Calendar.DATE) ;//
        int endDayOfMonth = calS.getActualMaximum(Calendar.DAY_OF_MONTH);
 
        StringBuilder sBuilder = new StringBuilder();
        if (endDate.compareTo(startDate) < 0) {
        	   return "0";
        }
        int lday = endD - startD;
        if (lday < 0) {
            endM = endM - 1;
            lday = startDayOfMonth + lday;
        }
        //⣬磺2011-01-01  2013-12-31  21131     ʵϾ3
        if (lday == endDayOfMonth) {
            endM = endM + 1;
            lday = 0;
        }
        int mos = (endY - startY) * 12 + (endM - startM);
        int lyear = mos / 12;
        int lmonth = mos % 12;
        int lmonth2=0;
        if (lyear > 0) {
//            sBuilder.append(lyear + "");
            lmonth2=lyear*12;//0ʱ ·ݳ12
        }
        if (lmonth > 0) {
//            sBuilder.append(lmonth + "");
            lmonth2=  lmonth2+lmonth;
        }
       // if(lyear==0)//Ŀ һ겻ʾ
        sBuilder.append(lmonth2 + "");
        
        if (lday > 0) {
            sBuilder.append(lday + "");
        }
        return sBuilder.toString();
    }
    
    /**
     * ʣʱ
     *
     * @param startDateStr yyyy-MM-dd
     * @param endDateStr yyyy-MM-dd
     * @return      ꣿ£
     */
    public static int getSubMonth(Date startDate, Date endDate) {
      
        calS.setTime(startDate);
        int startY = calS.get(Calendar.YEAR);
        int startM = calS.get(Calendar.MONTH);
        int startD = calS.get(Calendar.DATE);
        int startDayOfMonth = calS.getActualMaximum(Calendar.DAY_OF_MONTH);
 
        calS.setTime(endDate);
        int endY = calS.get(Calendar.YEAR);
        int endM = calS.get(Calendar.MONTH);
        //2011-01-102011-01-10ΪΪһ
        int endD = calS.get(Calendar.DATE) ;//
        int endDayOfMonth = calS.getActualMaximum(Calendar.DAY_OF_MONTH);
 
        StringBuilder sBuilder = new StringBuilder();
        if (endDate.compareTo(startDate) < 0) {
        	   return 0;
        }
        int lday = endD - startD;
        if (lday < 0) {
            endM = endM - 1;
            lday = startDayOfMonth + lday;
        }
        //⣬磺2011-01-01  2013-12-31  21131     ʵϾ3
        if (lday == endDayOfMonth) {
            endM = endM + 1;
            lday = 0;
        }
        int mos = (endY - startY) * 12 + (endM - startM);
        int lyear = mos / 12;
        int lmonth = mos % 12;
        int lmonth2=0;
        if (lyear > 0) {
//            sBuilder.append(lyear + "");
            lmonth2=lyear*12;//0ʱ ·ݳ12
        }
        if (lmonth > 0) {
//            sBuilder.append(lmonth + "");
            lmonth2=  lmonth2+lmonth;
        }
        return lmonth2;
    }
    
 
    /*
     * ת dataAndTime 2013-12-31 23:59:59 
     * date 2013-12-31
     */
    public static String getDate(String dateAndTime) {
        if (dateAndTime != null && !"".equals(dateAndTime.trim())) {
            Matcher m = p.matcher(dateAndTime);
            if (m.find()) {
                return dateAndTime.subSequence(m.start(), m.end()).toString();
            }
        }
        return "data error";
    }
}