package com.kingdee.eas.xr.helper;

import java.math.BigDecimal;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;

import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.eas.fm.common.FMConstants;
import com.kingdee.eas.framework.CoreBaseInfo;

public class CommonXRHelper {
	
	public static final BigDecimal BIGZERO = new BigDecimal("0.0");
    public static final int TRUE = 1;
    public static final int FALSE = 0;

	public static final String TIME_FORMAT = "yyyy-mm-dd hh:mm:ss";
	
    public static final DateFormat FORMAT_DAY = new SimpleDateFormat("yyyy-MM-dd");
    
    public static final DateFormat FORMAT_TIME = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    public static final DateFormat FORMAT_MONTH = new SimpleDateFormat("yyyy-MM");
    
    /**
	 * ȡļԴ·ðťԶͼ꣩ 
	 * java.net.URL url = ClassUtil.getResource("com/kingdee/eas/custom/images/search.gif", MaterialInfoBaseEditUI.class);
     * ImageIcon icon = new ImageIcon(url);
     * this.wbtnContract.setIcon(icon);
	 * @return boolean, true,Ascillַ
	 */
    public static URL getResource(final String resourceName,
			final Class callingClass) {
		URL url = null;
		try {
			url = (URL) AccessController.doPrivileged(new PrivilegedAction() {
				public Object run() {
					return Thread.currentThread().getContextClassLoader()
							.getResource(resourceName);
				}
			});
			if (url == null) {
				url = (URL) AccessController
						.doPrivileged(new PrivilegedAction() {
							public Object run() {
								return CommonXRHelper.class.getClassLoader()
										.getResource(resourceName);
							}
						});

			}
			if (url == null) {
				url = (URL) AccessController
						.doPrivileged(new PrivilegedAction() {
							public Object run() {
								return callingClass.getClassLoader()
										.getResource(resourceName);
							}
						});
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		return url;
	}
	/**
	 * жһַAscillַַ纺գַ
	 * 
	 * @param char c, Ҫжϵַ
	 * @return boolean, true,Ascillַ
	 */
    private static boolean isLetter(char c) {
		int k = 0x80;
		return c / k == 0 ? true : false;
	}
	/**
	 *жǷΪ
	 * */
	public static boolean isEmpty(Object param[])
    {
		return param == null || param.length == 0 || isEmpty(param[0]);
    }

    public static boolean isEmpty(String s)
    {
    	return s == null || s.trim().length() == 0;
    }

    public static boolean isEmpty(Object o)
    {
    	if(o instanceof String)
    		return o == null || o.toString().trim().length() == 0;
    	else
    		return o == null;
    }

    public static boolean isEmpty(Collection coll)
    {
    	return coll == null || coll.isEmpty();
    }

    public static boolean isEmpty(AbstractObjectCollection coll)
    {
    	return coll == null || coll.isEmpty();
    }

    public static boolean isZERO(BigDecimal o)
    {
    	return o == null || o.compareTo(FMConstants.ZERO) == 0;
    }

    public static boolean isEmpty(CoreBaseInfo info)
    {
    	return info == null || isEmpty(info.getId());
    }
    /**
	  * תΪӢĴдʽ
	  * @param x
	  * @returnӢĴдʽ
	  */
	 public static String parse(String x) {
	     int z = x.indexOf("."); // ȡСλ
	     String lstr = "", rstr = "";
	     if (z > -1) { // ǷСУֱȡߺұ
	      lstr = x.substring(0, z);
	      rstr = x.substring(z + 1);
	      } else // ȫ
	      lstr = x;

	     String lstrrev = reverse(lstr); // ߵִȡ
	     String[] a = new String[5]; // 5ִŽλһִ

	     switch (lstrrev.length() % 3) {
	      case 1 :
	       lstrrev += "00";
	       break;
	      case 2 :
	       lstrrev += "0";
	       break;
	      }
	     String lm = ""; // ת
	     for (int i = 0; i < lstrrev.length() / 3; i++) {
	      a[i] = reverse(lstrrev.substring(3 * i, 3 * i + 3)); // ȡһλ
	      if (!a[i].equals("000")) { // 1000000 = one million thousand only
	       if (i != 0){  
	         
	        lm = transThree(a[i]) + " " + parseMore(String.valueOf(i)) + " " + lm; // : thousandmillionbillion
	       }
	       else if(Integer.parseInt(a[i]) <  100 && lstrrev.length() > 3){
	               //жϸ,ʮ,λС100 Ҫתִ1000ʱҪAND 
	           // :1001 ӦΪ:ONE THOUSAND AND ONE ONLY ҪAND ONE THOUSAND ONE ONLY
	             lm = "AND " + transThree(a[i]); 
	            }else{
	             lm = transThree(a[i]); // ֹi=0ʱ ڶո.
	            }
	       } else
	       lm += transThree(a[i]);
	      }

	     String xs = ""; // תС
	     if (z > -1)
	      xs = "AND " + transTwo(rstr) + " CENT(S) "; // СִʱתС

	     return "SAY USD "+ lm.trim() + " " + xs ;//+ "ONLY";
	     }

	 private static String parseFirst(String s) {
	     String[] a =
	      new String[] { "", "ONE", "TWO", "THREE", "FOUR", "FIVE", "SIX", "SEVEN", "EIGHT", "NINE" };
	     return a[Integer.parseInt(s.substring(s.length() - 1))];
	     }

	 private static String parseTeen(String s) {
	     String[] a =
	      new String[] {
	       "TEN",
	       "ELEVEN",
	       "TWELEVE",
	       "THIRTEEN",
	       "FOURTEEN",
	       "FIFTEEN",
	       "SIXTEEN",
	       "SEVENTEEN",
	       "EIGHTEEN",
	       "NINETEEN" };
	     return a[Integer.parseInt(s) - 10];
	     }

	 private static String parseTen(String s) {
	     String[] a =
	      new String[] {
	       "TEN",
	       "TWENTY",
	       "THIRTY",
	       "FORTY",
	       "FIFTY",
	       "SIXTY",
	       "SEVENTY",
	       "EIGHTY",
	       "NINETY" };
	     return a[Integer.parseInt(s.substring(0, 1)) - 1];
	     }

	//  λ
	 private static String transTwo(String s) {
	     String value = "";
	     // жλ
	     if (s.length() > 2)
	      s = s.substring(0, 2);
	     else if (s.length() < 2)
	      s = "0" + s;

	     if (s.startsWith("0")) // 07 - seven ǷС10
	      value = parseFirst(s);
	     else if (s.startsWith("1")) // 17 seventeen Ƿ1020֮
	      value = parseTeen(s);
	     else if (s.endsWith("0")) // Ƿ10100ܱ֮10
	      value = parseTen(s);
	     else
	      value = parseTen(s) + " " + parseFirst(s);
	     return value;
	     }

	 private static String parseMore(String s) {
	     String[] a = new String[] { "", "THOUSAND", "MILLION", "BILLION" };
	     return a[Integer.parseInt(s)];
	     }

	//  λ
	//  s.length = 3
	 private static String transThree(String s) {
	     String value = "";
	     if (s.startsWith("0")) // ǷС100
	      value = transTwo(s.substring(1));
	     else if (s.substring(1).equals("00")) // Ƿ100
	      value = parseFirst(s.substring(0, 1)) + " HUNDRED";
	     else
	      value = parseFirst(s.substring(0, 1)) + " HUNDRED AND " + transTwo(s.substring(1));
	     return value;
	     }

	 /**
	  * ֽзת
	  * @param s
	  * @return ת
	  */
	 private static String reverse(String s) {
	     char[] aChr = s.toCharArray();
	     StringBuffer tmp = new StringBuffer();
	     for (int i = aChr.length - 1; i >= 0; i--) {
	      tmp.append(aChr[i]);
	      }
	     return tmp.toString();
	 }
	 
	 /** 
		 * --------תĽĴдʽʾ------------
		 *   123.45 --> Ҽ۷ʰԪ
		 *  TransRMB t2r = new TransRMB();
		 *  String s = t2r.cleanZero(t2r.splitNum(t2r.roundString("")));
		 */  

		
	    /** 
	     * жûǷϷûַֻ֣ 
	     * @param s String 
	     * @return ûݺϷ true򷵻 false 
	     */  
	    public boolean checkNum(String s) {  
	        // ûзַΪǷݣ false  
	        try {  
	            float f = Float.valueOf(s);  
	            // СΪǷݣ false  
	            if(f < 0) {  
	                System.out.println("Ƿݣ飡");  
	                return false;  
	            }else {  
	                return true;  
	            }  
	        } catch (NumberFormatException e) {  
	            System.out.println("Ƿݣ飡");  
	            return false;  
	        }     
	    }  
	      
	    /** 
	     * ûСΪָ numFormat()  
	     * ӦĽдʽת 
	     * עӦǾ roundString()  
	     * @param s String 
	     * @return תõĽдʽַ 
	     */  
	    public static String splitNum(String s) {  
	        // ǿմؿմ  
	        if("".equals(s)) {  
	            return "";  
	        }  
	        // СΪַָ  
	        int index = s.indexOf(".");  
	        // ȡת  
	        String intOnly = s.substring(0, index);  
	        String part1 = numFormat(1, intOnly);  
	        // ȡתС  
	        String smallOnly = s.substring(index + 1);  
	        String part2 = numFormat(2, smallOnly);  
	        // ת˵ֺСƴһµַ  
	        String newS = part1 + part2;  
	        return newS;  
	    }  
	          
	    /** 
	     * Դ 
	     * תɴд
	     * @param s String Ǹ 
	     * @return ֵ 
	     */  
	    public static String roundString(String s) {  
	        // ǿմؿմ  
	        if("".equals(s)) {  
	            return "";  
	        }  
	        // ת double ͣ  
	        double d = Double.parseDouble(s);  
	        // ˲Сλ  
	        d = (d * 100 + 0.5) / 100;  
	        //  d иʽ  
	        s = new java.text.DecimalFormat("##0.000").format(d);  
	        // СΪַָ  
	        int index = s.indexOf(".");  
	        //   
	        String intOnly = s.substring(0, index);  
	        // 涨ֵ󳤶ֻܵڵλ򷵻 "0"  
	        if(intOnly.length() > 13) {  
	            System.out.println("ݹ󣡣13λ");  
	            return "";  
	        }  
	        // С  
	        String smallOnly = s.substring(index + 1);  
	        // СִλֻȡСλ  
	        if(smallOnly.length() > 2) {  
	            String roundSmall = smallOnly.substring(0, 2);  
	            // ֺ½ȡСƴַ  
	            s = intOnly + "." + roundSmall;  
	        }  
	        s = splitNum(s);
	        s = cleanZero(s);
	        return s;  
	    }  
	      
	    /** 
	     * ѴתΪĽдʽ 
	     * @param flag int ־λ1 ʾת֣0 ʾתС 
	     * @param s String Ҫתַ 
	     * @return תõĴλĽдʽ 
	     */  
	    public static String numFormat(int flag, String s) {  
	        int sLength = s.length();  
	        // Ҵдʽ  
	        String bigLetter[] = {"", "Ҽ", "", "", "", "", "½", "", "", ""};  
	        // ҵλ  
	        String unit[] = {"Ԫ", "ʰ", "", "Ǫ", "",   
	                // ʰλǪλ  
	                "ʰ", "", "Ǫ",  
	                // λλ  
	                "", "ʰ", "", "Ǫ", ""};  
	        String small[] = {"", ""};  
	        // תַ  
	        String newS = "";  
	        // λ滻ΪĴдʽ  
	        for(int i = 0; i < sLength; i ++) {  
	            if(flag == 1) {  
	                // תΪĴдʽλ  
	                newS = newS + bigLetter[s.charAt(i) - 48] + unit[sLength - i - 1];  
	            } else if(flag == 2) {  
	                // תС֣λ  
	                newS = newS + bigLetter[s.charAt(i) - 48] + small[sLength - i - 1];  
	            }  
	        }  
	        return newS;  
	    }  
	      
	    /** 
	     * ѾתõĽдʽԸĽ 
	     * 㣬ַøӿɹ 
	     * עӦǾ splitNum() д 
	     * ӦѾĽдʽʾ 
	     * @param s String Ѿתõַ 
	     * @return Ľַ 
	     */  
	    public static String cleanZero(String s) {  
	        // ǿմؿմ  
	        if("".equals(s)) {  
	            return "";  
	        }  
	        // ûʼ˺ܶ 0 ȥַǰ''ʹ俴ȥϰ  
	        while(s.charAt(0) == '') {  
	            // ַе "" Ӧĵλȥ  
	            s = s.substring(2);  
	            // ûʱֻ 0ֻһ ""  
	            if(s.length() == 0) {  
	                return "";  
	            }  
	        }  
	        // ַдڶ''һʱֻһ''ʡԶĵλ  
	        /* ڱ˶㷨о̫ˣֻ4ʽȥתˣλϺ... */  
	        String regex1[] = {"Ǫ", "", "ʰ"};  
	        String regex2[] = {"", "", "Ԫ"};  
	        String regex3[] = {"", "", "Ԫ"};  
	        String regex4[] = {"", ""};  
	        // һת "Ǫ", ","ʰ"ַ滻һ""  
	        for(int i = 0; i < 3; i ++) {  
	            s = s.replaceAll(regex1[i], "");  
	        }  
	        // ڶת "","","Ԫ"  
	        // "","","Ԫ"ЩλЩǲʡģҪ  
	        for(int i = 0; i < 3; i ++) {  
	            // һתпкܶһ  
	            // ҪѺܶظһ  
	            s = s.replaceAll("", "");  
	            s = s.replaceAll("", "");  
	            s = s.replaceAll(regex2[i], regex3[i]);  
	        }  
	        // ת"",""ַʡ  
	        for(int i = 0; i < 2; i ++) {  
	            s = s.replaceAll(regex4[i], "");  
	        }  
	        // """"֮ȫ""ʱ򣬺""λֻһ""  
	        s = s.replaceAll("", "");  
	        return s;  
	    } 
}
