/**
 * output package name
 */
package com.kingdee.eas.scm.common;

import java.util.Map;
import java.util.List;
import java.util.Iterator;
import com.kingdee.util.enums.IntEnum;

/**
 * output class name
 */
public class BillBaseStatusEnum extends IntEnum
{
    public static final int NULL_VALUE = -1;//alias=
    public static final int ADD_VALUE = 0;//alias=
    public static final int TEMPORARILYSAVED_VALUE = 1;//alias=
    public static final int SUBMITED_VALUE = 2;//alias=ύ
    public static final int DELETED_VALUE = 3;//alias=
    public static final int AUDITED_VALUE = 4;//alias=
    public static final int RELEASED_VALUE = 5;//alias=´
    public static final int BLOCKED_VALUE = 6;//alias=
    public static final int CLOSED_VALUE = 7;//alias=ر
    public static final int COMPLETE_VALUE = 8;//alias=깤
    public static final int FINISH_VALUE = 90;//alias=
    public static final int PUBLISHED_VALUE = 10;//alias=
    public static final int FINCLOSED_VALUE = 11;//alias=᰸
    public static final int ALTERING_VALUE = -2;//alias=
    public static final int VERSION_VALUE = -3;//alias=ʷ汾

    public static final BillBaseStatusEnum NULL = new BillBaseStatusEnum("NULL", NULL_VALUE);
    public static final BillBaseStatusEnum ADD = new BillBaseStatusEnum("ADD", ADD_VALUE);
    public static final BillBaseStatusEnum TEMPORARILYSAVED = new BillBaseStatusEnum("TEMPORARILYSAVED", TEMPORARILYSAVED_VALUE);
    public static final BillBaseStatusEnum SUBMITED = new BillBaseStatusEnum("SUBMITED", SUBMITED_VALUE);
    public static final BillBaseStatusEnum DELETED = new BillBaseStatusEnum("DELETED", DELETED_VALUE);
    public static final BillBaseStatusEnum AUDITED = new BillBaseStatusEnum("AUDITED", AUDITED_VALUE);
    public static final BillBaseStatusEnum RELEASED = new BillBaseStatusEnum("RELEASED", RELEASED_VALUE);
    public static final BillBaseStatusEnum BLOCKED = new BillBaseStatusEnum("BLOCKED", BLOCKED_VALUE);
    public static final BillBaseStatusEnum CLOSED = new BillBaseStatusEnum("CLOSED", CLOSED_VALUE);
    public static final BillBaseStatusEnum COMPLETE = new BillBaseStatusEnum("COMPLETE", COMPLETE_VALUE);
    public static final BillBaseStatusEnum FINISH = new BillBaseStatusEnum("FINISH", FINISH_VALUE);
    public static final BillBaseStatusEnum PUBLISHED = new BillBaseStatusEnum("PUBLISHED", PUBLISHED_VALUE);
    public static final BillBaseStatusEnum FINCLOSED = new BillBaseStatusEnum("FINCLOSED", FINCLOSED_VALUE);
    public static final BillBaseStatusEnum ALTERING = new BillBaseStatusEnum("ALTERING", ALTERING_VALUE);
    public static final BillBaseStatusEnum VERSION = new BillBaseStatusEnum("VERSION", VERSION_VALUE);

    /**
     * construct function
     * @param integer billBaseStatusEnum
     */
    private BillBaseStatusEnum(String name, int billBaseStatusEnum)
    {
        super(name, billBaseStatusEnum);
    }
    
    /**
     * getEnum function
     * @param String arguments
     */
    public static BillBaseStatusEnum getEnum(String billBaseStatusEnum)
    {
        return (BillBaseStatusEnum)getEnum(BillBaseStatusEnum.class, billBaseStatusEnum);
    }

    /**
     * getEnum function
     * @param String arguments
     */
    public static BillBaseStatusEnum getEnum(int billBaseStatusEnum)
    {
        return (BillBaseStatusEnum)getEnum(BillBaseStatusEnum.class, billBaseStatusEnum);
    }

    /**
     * getEnumMap function
     */
    public static Map getEnumMap()
    {
        return getEnumMap(BillBaseStatusEnum.class);
    }

    /**
     * getEnumList function
     */
    public static List getEnumList()
    {
         return getEnumList(BillBaseStatusEnum.class);
    }
    
    /**
     * getIterator function
     */
    public static Iterator iterator()
    {
         return iterator(BillBaseStatusEnum.class);
    }
}