package com.kingdee.eas.fdc.invite.news.client;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.swing.SwingUtilities;

import org.apache.log4j.Logger;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormat;
import com.kingdee.bos.ctrl.extendcontrols.BizDataFormatter;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.IColumn;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTCell;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditAdapter;
import com.kingdee.bos.ctrl.kdf.table.event.KDTEditEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseListener;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.render.ObjectValueRender;
import com.kingdee.bos.ctrl.report.forapp.kdnote.client.KDNoteHelper;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDContainer;
import com.kingdee.bos.ctrl.swing.KDFormattedTextField;
import com.kingdee.bos.ctrl.swing.KDLabel;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDTextField;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.AttachmentCollection;
import com.kingdee.eas.base.attachment.AttachmentFactory;
import com.kingdee.eas.base.attachment.AttachmentFtpFacadeFactory;
import com.kingdee.eas.base.attachment.AttachmentInfo;
import com.kingdee.eas.base.attachment.BizobjectFacadeFactory;
import com.kingdee.eas.base.attachment.client.AttachmentUIContextInfo;
import com.kingdee.eas.base.attachment.common.AttachmentClientManager;
import com.kingdee.eas.base.attachment.common.AttachmentManagerFactory;
import com.kingdee.eas.base.attachment.util.FileGetter;
import com.kingdee.eas.base.codingrule.CodingRuleException;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.fdc.basedata.ContractCodingTypeCollection;
import com.kingdee.eas.fdc.basedata.ContractCodingTypeInfo;
import com.kingdee.eas.fdc.basedata.ContractDetailDefCollection;
import com.kingdee.eas.fdc.basedata.ContractDetailDefFactory;
import com.kingdee.eas.fdc.basedata.ContractDetailDefInfo;
import com.kingdee.eas.fdc.basedata.ContractSourceFactory;
import com.kingdee.eas.fdc.basedata.ContractSourceInfo;
import com.kingdee.eas.fdc.basedata.ContractTypeInfo;
import com.kingdee.eas.fdc.basedata.CostSplitStateEnum;
import com.kingdee.eas.fdc.basedata.CurProjectInfo;
import com.kingdee.eas.fdc.basedata.FDCBillInfo;
import com.kingdee.eas.fdc.basedata.FDCBillStateEnum;
import com.kingdee.eas.fdc.basedata.FDCHelper;
import com.kingdee.eas.fdc.basedata.FDCNumberHelper;
import com.kingdee.eas.fdc.basedata.FDCSQLBuilder;
import com.kingdee.eas.fdc.basedata.SourceTypeEnum;
import com.kingdee.eas.fdc.basedata.client.AttachmentUtils;
import com.kingdee.eas.fdc.basedata.client.FDCClientHelper;
import com.kingdee.eas.fdc.basedata.client.FDCClientUtils;
import com.kingdee.eas.fdc.basedata.client.FDCMsgBox;
import com.kingdee.eas.fdc.basedata.util.FdcWfUtil;
import com.kingdee.eas.fdc.basedata.util.FdcYgzUtil;
import com.kingdee.eas.fdc.contract.ConSplitExecStateEnum;
import com.kingdee.eas.fdc.contract.ContractBailInfo;
import com.kingdee.eas.fdc.contract.ContractBillEntryInfo;
import com.kingdee.eas.fdc.contract.ContractBillFactory;
import com.kingdee.eas.fdc.contract.ContractBillInfo;
import com.kingdee.eas.fdc.contract.ContractPropertyEnum;
import com.kingdee.eas.fdc.contract.ContractUtil;
import com.kingdee.eas.fdc.contract.client.ContractBillEditUI;
import com.kingdee.eas.fdc.contract.client.ContractBillNoYgzEditUI;
import com.kingdee.eas.fdc.contract.programming.ProgrammingContractCollection;
import com.kingdee.eas.fdc.contract.programming.ProgrammingContractFactory;
import com.kingdee.eas.fdc.contract.programming.ProgrammingContractInfo;
import com.kingdee.eas.fdc.invite.AuthorizedPersonCollection;
import com.kingdee.eas.fdc.invite.AuthorizedPersonFactory;
import com.kingdee.eas.fdc.invite.InviteProjectFactory;
import com.kingdee.eas.fdc.invite.InviteProjectInfo;
import com.kingdee.eas.fdc.invite.InviteProjectMethodEnum;
import com.kingdee.eas.fdc.invite.InviteProjectSegmentEnum;
import com.kingdee.eas.fdc.invite.news.AppprasingMethodEnum;
import com.kingdee.eas.fdc.invite.news.AppraisingInvaildReasonEnum;
import com.kingdee.eas.fdc.invite.news.BidNoticeCollection;
import com.kingdee.eas.fdc.invite.news.BidNoticeFactory;
import com.kingdee.eas.fdc.invite.news.InvProHandlerTypeEnum;
import com.kingdee.eas.fdc.invite.news.InviteAppraisingFactory;
import com.kingdee.eas.fdc.invite.news.InviteAppraisingInfo;
import com.kingdee.eas.fdc.invite.news.InviteAppraisingSegmentEntryCollection;
import com.kingdee.eas.fdc.invite.news.InviteAppraisingSegmentEntryInfo;
import com.kingdee.eas.fdc.invite.news.InviteBackBidRegFactory;
import com.kingdee.eas.fdc.invite.news.InviteBackBidRegInfo;
import com.kingdee.eas.fdc.invite.news.InviteBackBidRegSupplierEntryCollection;
import com.kingdee.eas.fdc.invite.news.InviteBackBidRegSupplierEntryInfo;
import com.kingdee.eas.fdc.invite.news.InviteDistributedCollection;
import com.kingdee.eas.fdc.invite.news.InviteDistributedFactory;
import com.kingdee.eas.fdc.invite.news.InviteProcessEnum;
import com.kingdee.eas.fdc.invite.news.InviteProjectContactEntryCollection;
import com.kingdee.eas.fdc.invite.news.InviteProjectContactEntryFactory;
import com.kingdee.eas.fdc.invite.news.InviteProjectContactEntryInfo;
import com.kingdee.eas.fdc.invite.news.InviteTenderTypeEnum;
import com.kingdee.eas.fdc.invite.news.MaterialPriceDataEntryCollection;
import com.kingdee.eas.fdc.invite.news.MaterialPriceDataEntryFactory;
import com.kingdee.eas.fdc.invite.news.PriceInfoForWebCollection;
import com.kingdee.eas.fdc.invite.news.PriceInfoForWebEntryCollection;
import com.kingdee.eas.fdc.invite.news.PriceInfoForWebEntryInfo;
import com.kingdee.eas.fdc.invite.news.PriceInfoForWebFactory;
import com.kingdee.eas.fdc.invite.news.PriceInfoForWebInfo;
import com.kingdee.eas.fdc.invite.news.QuotePriceTypeEnum;
import com.kingdee.eas.fdc.invite.news.StartBidCollection;
import com.kingdee.eas.fdc.invite.news.StartBidEntryCollection;
import com.kingdee.eas.fdc.invite.news.StartBidEntryFactory;
import com.kingdee.eas.fdc.invite.news.StartBidEntryInfo;
import com.kingdee.eas.fdc.invite.news.StartBidFactory;
import com.kingdee.eas.fdc.invite.news.StartBidInfo;
import com.kingdee.eas.fdc.invite.news.StartBidModelEnum;
import com.kingdee.eas.fdc.invite.news.StrategyPactCollection;
import com.kingdee.eas.fdc.invite.news.StrategyPactFactory;
import com.kingdee.eas.fdc.invite.news.StrategyPactInfo;
import com.kingdee.eas.fdc.invite.news.utils.NumberDataFormat;
import com.kingdee.eas.fdc.invite.supplier.SupplierStockInfo;
import com.kingdee.eas.fdc.invite.supplier.client.FDCSupplierHelper;
import com.kingdee.eas.fdc.invite.utils.InviteParamFetcher;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.util.UIConfigUtility;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.xr.helper.PersonXRHelper;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.UuidException;
import com.kingdee.util.enums.EnumUtils;

public class InviteAppraisingEditUI extends AbstractInviteAppraisingEditUI
{
  private static final Logger logger = CoreUIObject.getLogger(InviteAppraisingEditUI.class);
  private String invProIdStr = null;

  private KDContainer tmpContSeg = null;
  private KDTable tmpSegEntry = null;
  private Map entryMap = null;
  private Boolean isView;
  private Boolean isBizPerson;
  private boolean isLimitModel = true;
  private int currSeg;
  private Map entryPriceMap = null;
  private BigDecimal techPercent;
  private BigDecimal bizPercent;
  private String attachMentTempID = null;
  private String attachContractTempID = null;
  private SupplierStockInfo currSelectSupp;
  private IRow currSelectRow;
  private Map tableTitleNameMap;
  private Map<String, PriceInfoForWebInfo> tenderQInfoMap = new HashMap();
  private Map setMentMap = new HashMap();
  private Map project2segment = new HashMap();
  private StartBidInfo startBidInfo = null;

  Set personIds = null;
  private final ArrayList orgIDList = new ArrayList();
  private Rectangle pnlAttBound;
  private Rectangle contEntrBound;
  protected boolean isEnabledYGZ;
  boolean clcikAppraising = false;

  private FileGetter fileGetter = new FileGetter(AttachmentFactory.getRemoteInstance(), AttachmentFtpFacadeFactory.getRemoteInstance());

  public InviteAppraisingEditUI()
    throws Exception
  {
    initButtonStyle();
  }

  private void initButtonStyle()
  {
    this.btnAddChecker.setIcon(EASResource.getIcon("imgTbtn_stafferbatch"));
    this.btnClarify.setIcon(EASResource.getIcon("imgTbtn_simulate"));
    this.btnAppraising.setIcon(EASResource.getIcon("imgTbtn_resultemend"));
    this.btnBussAppraising.setIcon(EASResource.getIcon("imgTbtn_function"));
    this.btnSign.setIcon(EASResource.getIcon("imgTbtn_grantcollocate"));
    this.btnInvFile.setIcon(EASResource.getIcon("imgTbtn_chooseout"));
  }

  protected void beforeStoreFields(ActionEvent e)
    throws Exception
  {
    super.beforeStoreFields(e);
  }

  public void storeFields()
  {
    super.storeFields();
    InviteAppraisingSegmentEntryCollection col = this.editData.getSegEntry();
    if ((col != null) && (col.size() > 0)) {
      int size = col.size();
      for (int i = 0; i < size; i++) {
        InviteAppraisingSegmentEntryInfo entryInfo = col.get(i);
        BigDecimal finalAmount = entryInfo.getFinalAmount();
        BigDecimal finalCtrlVAT = entryInfo.getFinalCtrlVAT();
        entryInfo.setFinalCtrlIncTaxAmt(FDCHelper.subtract(finalAmount, finalCtrlVAT));
      }
    }
  }

  protected KDTable cloneXColumns(KDTable oldTable, KDTable table) {
    int sum = oldTable.getColumnCount();

    table.getHead().addRow(0, (KDTRow)oldTable.getHeadRow(oldTable.getHeadRowCount() - 1).getKDTRow().clone());
    for (int i = 0; i < sum; i++)
    {
      table.getHead().getRow(0).addCell((KDTCell)oldTable.getHeadRow(0).getCell(i).getKDTCell().clone());
      table.addColumn(i, (IColumn)oldTable.getColumn(i).clone());
    }

    for (int i = 0; i < sum; i++) {
      table.getHead().addColumn(i, (KDTCell)oldTable.getHeadRow(oldTable.getHeadRowCount() - 1).getKDTRow().getCell(i).clone());
    }

    return table;
  }

  protected KDTable cloneTable(KDTable oldTable) {
    KDTable loadTable = new KDTable();

    loadTable.setSize(oldTable.getSize());
    loadTable.setVisible(true);
    loadTable.setAutoscrolls(true);

    loadTable = cloneXColumns(oldTable, loadTable);

    loadTable.checkParsed();
    loadTable.addKDTMouseListener(new KDTMouseListener()
    {
      public void tableClicked(KDTMouseEvent e) {
        if (e.getType() == 0) {
          return;
        }

        KDTable selsTable = (KDTable)e.getSource();
        int index = selsTable.getSelectManager().getActiveRowIndex();
        if (index < 0) {
          return;
        }
        IRow row = selsTable.getRow(index);
        SupplierStockInfo supplier = (SupplierStockInfo)row.getCell("supplier").getValue();
//        InviteAppraisingEditUI.access$002(InviteAppraisingEditUI.this, row);
//        InviteAppraisingEditUI.access$102(InviteAppraisingEditUI.this, supplier);
		PersonInfo personInfo= SysContext.getSysContext().getCurrentUserInfo().getPersonId();
		String deparmentName=null;
		if(personInfo!=null){
			AdminOrgUnitInfo adminInfo=PersonXRHelper.getPosiMemByDeptUser(personInfo);
			deparmentName=adminInfo.getDisplayName();
		}
        
        try {
          if (e.getColIndex() == selsTable.getColumnIndex("techCount")) {
        		  if(!deparmentName.contains("")){
        		  InviteAppraisingEditUI.this.openQuoteAmtUI(null, supplier, row, "caseAmount", 1);
        	  }
          
          }
          else if (e.getColIndex() == selsTable.getColumnIndex("bizCount")) {
        	  if(!deparmentName.contains("")&&!deparmentName.contains("")&&!deparmentName.contains("")){
        		   InviteAppraisingEditUI.this.openQuoteAmtUI(null, supplier, row, "caseAmount", 2);
        	  }
           
          }
          else if (e.getColIndex() == selsTable.getColumnIndex("quotePriceDcrp")) {//ʽ
        	  if(!deparmentName.contains("")&&!deparmentName.contains("")){
        		  InviteAppraisingEditUI.this.getZjAtt( row, "quotePriceDcrp");
        	  }
             
           }
          
          else if (e.getClickCount() == 2) {
            if ((e.getColIndex() == selsTable.getColumnIndex("caseAmount")) || (e.getColIndex() == selsTable.getColumnIndex("clarifyAmount")))
            {
              if (InviteParamFetcher.isEanableOutNet(null)) {
                InviteAppraisingEditUI.this.openQuoteAmtUI(null, supplier, row, selsTable.getColumnKey(e.getColIndex()), 0);
              }
            }
            else if (e.getColIndex() == selsTable.getColumnIndex("supplier")) {
              InviteAppraisingEditUI.this.openSupplierUI(supplier, row, selsTable.getColumnKey(e.getColIndex()));
            }
          }
        }
        catch (UIException e1)
        {
          InviteAppraisingEditUI.this.handUIException(e1);
        } catch (BOSException e1) {
          InviteAppraisingEditUI.this.handUIException(e1);
        }
      }
    });
    return loadTable;
  }

  private void openSupplierUI(SupplierStockInfo supplier, IRow row, String colKey) throws BOSException {
    UIContext uiContext = new UIContext(this);
    IUIWindow uiWindow = null;

    if (!colKey.equals("supplier")) {
      return;
    }
    if (supplier != null) {
      String className = "com.kingdee.eas.fdc.invite.supplier.client.SupplierStockEditUI";
      String ID = supplier.getId().toString();
      uiContext.put("ID", ID);
      uiWindow = UIFactory.createUIFactory("com.kingdee.eas.base.uiframe.client.UINewTabFactory").create(className, uiContext, null, OprtState.VIEW);
      uiWindow.show();
    }
  }

  private void openQuoteAmtUI(InviteProjectInfo invInfo, SupplierStockInfo supplier, IRow row, String colKey, int state) throws BOSException
  {
    try
    {
      QuotePriceTypeEnum quoteType = null;

      if (colKey.equals("askAmount"))
        quoteType = QuotePriceTypeEnum.ASK_QUOTE;
      else if (colKey.equals("caseAmount"))
        quoteType = QuotePriceTypeEnum.TENDER_QUOTE;
      else if (colKey.equals("clarifyAmount")) {
        quoteType = QuotePriceTypeEnum.CLEAR_QUOTE;
      }
      PriceInfoForWebInfo info = getQuoteBill(invInfo, supplier, quoteType);
      AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();

      boolean isEdit = true;
      if (InviteParamFetcher.isEanableOutNet(null))
        isEdit = false;
      else if ((!OprtState.EDIT.equals(getOprtState())) && (!OprtState.ADDNEW.equals(getOprtState()))) {
        isEdit = false;
      }

      if (state == 1) {
        if (info == null) {
          info = createPriceInfoForWebInfo(supplier, quoteType);
        }
        acm.showAttachmentListUIByBoID(info.getTechAttID(), this, isEdit);
        try {
          actionRefresh_actionPerformed(null);
        } catch (Exception e) {
          e.printStackTrace();
        }
      } else if (state == 2) {
        if (info == null) {
          info = createPriceInfoForWebInfo(supplier, quoteType);
        }
        acm.showAttachmentListUIByBoID(info.getBizAttID(), this, isEdit);
        try {
          actionRefresh_actionPerformed(null);
        } catch (Exception e) {
          e.printStackTrace();
        }
      } else if (state == 0) {
        UIContext uiContext = new UIContext(this);
        IUIWindow uiWindow = null;

        String ID = null;

        InviteProjectSegmentEnum seg = (InviteProjectSegmentEnum)row.getCell("segment").getValue();
        CurProjectInfo project = (CurProjectInfo)row.getCell("project").getValue();

        ID = getQuoteBillID(invInfo, supplier, quoteType);
        if (ID != null) {
          if (QuotePriceTypeEnum.CLEAR_QUOTE.equals(quoteType)) {
            PriceInfoForWebInfo tenderQInfo = getQuoteBill(invInfo, supplier, QuotePriceTypeEnum.TENDER_QUOTE);
            if ((tenderQInfo != null) && (tenderQInfo.getPrjManager() != null)) {
              uiContext.put("PROJECTINFO", tenderQInfo.getPrjManager());
            }
          }
          BigDecimal price = (BigDecimal)row.getCell(colKey).getValue();
          price = price == null ? BigDecimal.ZERO : price;
          uiContext.put("totalPrice", price);
          uiContext.put("ID", ID);
          uiContext.put("SEGMENT", seg);
          uiContext.put("PROJECT", project);
          uiContext.put("isBizPerson", this.isBizPerson);
          uiWindow = UIFactory.createUIFactory("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(QuoteAmtEditUI.class.getName(), uiContext, null, OprtState.VIEW);

          uiWindow.show();
        }
      }
    }
    catch (UIException e1) {
      handUIException(e1);
    } catch (EASBizException e) {
      handUIException(e);
    }
  }
  
  /***
   *ʽļ 
   * */
  private void getZjAtt(IRow row, String colKey){
				String id=row.getCell("id").getValue().toString();
				AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
		        boolean isEdit = false;
		        if(OprtState.EDIT.equals(getOprtState()) || OprtState.ADDNEW.equals(getOprtState()))
		            isEdit = true;
		        AttachmentUIContextInfo info = new AttachmentUIContextInfo();
		        info.setBoID(id);
		        info.setEdit(isEdit);
		        String multi = (String)getUIContext().get("MultiapproveAttachment");
		      if(multi != null && multi.equals("true")){
		        	acm.showAttachmentListUIByBoIDNoAlready(this, info);
		        }else{
		        	acm.showAttachmentListUIByBoID(this, info);
		        }
	}
  
  

  private PriceInfoForWebInfo createPriceInfoForWebInfo(SupplierStockInfo supplier, QuotePriceTypeEnum quoteType)
  {
    PriceInfoForWebInfo info = new PriceInfoForWebInfo();
    info.setInviteProject(this.editData.getInvPro());
    info.setId(BOSUuid.create(info.getBOSType()));
    info.setSupplier(supplier);
    info.setTechAttID(BOSUuid.create(info.getBOSType()).toString());
    info.setBizAttID(BOSUuid.create(info.getBOSType()).toString());
    info.setInviteType(InviteTenderTypeEnum.INVITE_TYPE);
    info.setType(quoteType);
    info.setIsQuote(true);
    try {
      PriceInfoForWebFactory.getRemoteInstance().addnew(new ObjectUuidPK(info.getId()), info);
    } catch (EASBizException e) {
      e.printStackTrace();
    } catch (BOSException e) {
      e.printStackTrace();
    }
    return info;
  }

  private String getQuoteBillID(InviteProjectInfo invInfo, SupplierStockInfo supplier, QuotePriceTypeEnum quoteType) throws BOSException, EASBizException
  {
    PriceInfoForWebInfo info = getQuoteBill(invInfo, supplier, quoteType);
    return info == null ? null : info.getId().toString();
  }

  private PriceInfoForWebInfo getQuoteBill(InviteProjectInfo invInfo, SupplierStockInfo supplier, QuotePriceTypeEnum quoteType) throws BOSException, EASBizException
  {
    if ((supplier == null) || (supplier.getId() == null)) {
      return null;
    }
    EntityViewInfo view = new EntityViewInfo();
    FilterInfo filter = new FilterInfo();
    view.setFilter(filter);
    filter.getFilterItems().add(new FilterItemInfo("supplier.id", supplier.getId().toString()));
    filter.getFilterItems().add(new FilterItemInfo("inviteProject.id", this.editData.getInvPro().getId().toString()));

    PriceInfoForWebInfo info = PriceInfoForWebFactory.getRemoteInstance().getVaildVersionInfo(new ObjectUuidPK(this.editData.getInvPro().getId()), new ObjectUuidPK(supplier.getId()), quoteType, InviteTenderTypeEnum.INVITE_TYPE);

    return info;
  }

  private KDBizPromptBox getQueryF7FilterByCU(String queryInfo) {
    KDBizPromptBox purProductF7 = new KDBizPromptBox();
    EntityViewInfo view = new EntityViewInfo();
    FilterInfo filter = new FilterInfo();
    filter.getFilterItems().add(new FilterItemInfo("CU.id", this.editData.getCU() != null ? this.editData.getCU().getId().toString() : SysContext.getSysContext().getCurrentCtrlUnit().getId().toString()));

    view.setFilter(filter);

    purProductF7.setEntityViewInfo(view);
    purProductF7.setQueryInfo(queryInfo);

    return purProductF7;
  }

  private void loadSegEntry(InviteProjectInfo invProInfo) {
    try {
      invProInfo = getInvProjectInfo(invProInfo);
    } catch (BOSException e1) {
      e1.printStackTrace();
    }
    Component[] coms = (Component[])this.kdpnl.getComponents();
    for (int i = 0; i < coms.length; i++) {
      if ((!coms[i].getName().equals(this.kdtSegEntry.getName())) && (!coms[i].getName().equals(this.contSeg1.getName()))) {
        this.kdpnl.remove(coms[i]);
      }
    }

    this.kdtSegEntry.checkParsed();
    this.kdtSegEntry.removeRows();
    this.entryMap = new HashMap();
    this.setMentMap.clear();
    this.project2segment.clear();

    int segs = this.currSeg;

    updatePanelHeight(segs);
    int entryCount = this.editData.getInvPro().getContractProEntry().size();
    this.tableTitleNameMap = new HashMap();
    try {
      Map setTitleMap = InviteClientSegTitleUtils.getSegTitle(this.editData.getInvPro());
      String entryID = null;
      CurProjectInfo tempCurProject = null;
      InviteProjectSegmentEnum tempSeg = null;
      String project_Seg = null;
      String titleName = null;
      if (InviteProjectMethodEnum.STRATEGYINVITEDMETHOD.equals(invProInfo.getInviteMethod())) {
        createTables(1, "սԲɹ", "սԲɹ");
        this.tableTitleNameMap.put("SegEntry1", "սԲɹ");
      } else {
        for (int i = 0; i < entryCount; i++) {
          tempCurProject = this.editData.getInvPro().getContractProEntry().get(i).getCurProject();
          if (tempCurProject == null)
            continue;
          tempSeg = this.editData.getInvPro().getContractProEntry().get(i).getBidNum();
          project_Seg = tempCurProject.getId().toString() + "_" + tempSeg.getValue();

          entryID = this.editData.getInvPro().getContractProEntry().get(i).getId().toString();
          titleName = (String)setTitleMap.get(entryID);
          createTables(i + 1, titleName, project_Seg);
          this.tableTitleNameMap.put("SegEntry" + (i + 1), titleName);
        }
      }
    } catch (EASBizException e) {
      handUIException(e);
    } catch (BOSException e) {
      handUIException(e);
    }
  }

  private void createTables(int seg, String title, String tablekey)
  {
    KDContainer contSeg2 = new KDContainer();
    contSeg2.setName("contSeg_" + seg);

    contSeg2.setTitle(title);
    KDTable kDTable1 = new KDTable();
    kDTable1 = cloneTable(this.kdtSegEntry);
    kDTable1.setName("SegEntry" + seg);
    kDTable1.setPreferredSize(new Dimension(0, 110));
    KDTSortManager sm = new KDTSortManager(kDTable1);
    kDTable1.getColumn("finalAmount").setSortable(true);
    kDTable1.getColumn("busScore").setSortable(true);
    kDTable1.getColumn("techScore").setSortable(true);
    kDTable1.getColumn("busNeogiateAmount").setSortable(true);
    sm.setSortAuto(true);

    this.entryMap.put(tablekey, kDTable1);

    contSeg2.setBounds(new Rectangle(0, 188 * (seg - 1), 834, 180));
    this.kdpnl.add(contSeg2, new KDLayout.Constraints(0, 188 * (seg - 1), 845, 180, 12));

    contSeg2.getContentPane().setLayout(new KDLayout());
    contSeg2.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 188 * (seg - 1), 845, 180));
    kDTable1.setBounds(new Rectangle(1, 2, 840, 171));
    contSeg2.getContentPane().add(kDTable1, new KDLayout.Constraints(1, 2, 840, 171, 15));

    this.kdpnl.updateUI();
    this.kdpnl.repaint();
  }

  private void updatePanelHeight(int segs) {
    if (this.kdtSegEntry.getHeight() * segs > this.kdpnl.getPreferredSize().getHeight()) {
      Dimension d = new Dimension(this.kDScrollPane1.getWidth(), this.kdtSegEntry.getHeight() * (segs + 1));

      this.kdpnl.setPreferredSize(d);
    }
    else if (segs == 0) {
      segs = 1;
    }
  }

  private void initEntryUI()
  {
    this.kdtSegEntry.checkParsed();
    KDBizPromptBox supplierF7 = new KDBizPromptBox();
    supplierF7.setDisplayFormat("$name$");
    supplierF7.setEditFormat("$number$");
    supplierF7.setCommitFormat("$number$");
    FDCSupplierHelper.initFDCSupplierF7(this, supplierF7, true, null, true);
    KDTDefaultCellEditor kdtEntrys_supplier_name_CellEditor = new KDTDefaultCellEditor(supplierF7);
    this.kdtSegEntry.getColumn("supplier").setEditor(kdtEntrys_supplier_name_CellEditor);
    ObjectValueRender kdtEntrys_supplier_OVR = new ObjectValueRender();
    kdtEntrys_supplier_OVR.setFormat(new BizDataFormat("$name$"));
    this.kdtSegEntry.getColumn("supplier").setRenderer(kdtEntrys_supplier_OVR);
    this.kdtSegEntry.getColumn("supplier").setRequired(true);
    this.kdtSegEntry.getColumn("supplier").getStyleAttributes().setHided(false);

    this.kdtSegEntry.getColumn("supplier.taxPayerType").getStyleAttributes().setHided(false);

    initNumCol(this.kdtSegEntry, "askAmount");
    initNumCol(this.kdtSegEntry, "caseAmount");
    initNumCol(this.kdtSegEntry, "amendAmount");
    initNumCol(this.kdtSegEntry, "clarifyAmount");
    initNumCol(this.kdtSegEntry, "clarAmendAmount");

    initNumCol(this.kdtSegEntry, "clarAmendAmount");

    if (this.isEnabledYGZ) {
      initNumCol(this.kdtSegEntry, "caseCtrlVAT");
      initNumCol(this.kdtSegEntry, "caseCtrlIncTaxAmt");
      initNumCol(this.kdtSegEntry, "clarifyCtrlVAT");
      initNumCol(this.kdtSegEntry, "clarifyCtrlIncTaxAmt");
      initNumCol(this.kdtSegEntry, "finalCtrlVAT");
      initNumCol(this.kdtSegEntry, "finalCtrlIncTaxAmt");
    }

    KDComboBox tmpComBox = new KDComboBox();
    tmpComBox.addItems(EnumUtils.getEnumList("com.kingdee.eas.fdc.invite.news.AppraisingInvaildReasonEnum").toArray());
    this.kdtSegEntry.getColumn("invalidReason").setEditor(new KDTDefaultCellEditor(tmpComBox));

    initNumCol(this.kdtSegEntry, "dicountRate", BigDecimal.ZERO, new BigDecimal(5));
    initNumCol(this.kdtSegEntry, "appraisingAmount");
    initNumCol(this.kdtSegEntry, "finalAmount");

    initNumCol(this.kdtSegEntry, "techScore");
    initNumCol(this.kdtSegEntry, "busScore");
    initNumCol(this.kdtSegEntry, "comScore");
    initNumCol(this.kdtSegEntry, "busNeogiateAmount");

    KDComboBox segComBox = new KDComboBox();
    segComBox.addItems(EnumUtils.getEnumList("com.kingdee.eas.fdc.invite.InviteProjectSegmentEnum").toArray());
    this.kdtSegEntry.getColumn("segment").setEditor(new KDTDefaultCellEditor(segComBox));

    this.prmtProgrammingContract.setEnabledMultiSelection(true);
    this.prmtProgrammingContract.setQueryInfo("com.kingdee.eas.fdc.contract.programming.app.ProgrammingContractF7Query");
    this.prmtProgrammingContract.setEditFormat("$name$");
    this.prmtProgrammingContract.setDisplayFormat("$name$($controlAmount$)");
    this.prmtProgrammingContract.setCommitFormat("$name$");
    BizDataFormatter formater = new BizDataFormatter();
    formater.setFormat(new NumberDataFormat("$name$($controlAmount$)"));
    this.prmtProgrammingContract.setDisplayFormatter(formater);
    this.kDFormattedTextField1.setEnabled(true);
  }

  private void loadContractAddNew(InviteProjectInfo inviteProject) throws BOSException {
    InviteProjectContactEntryCollection contractColl = null;
    if ((inviteProject.getContractProEntry() == null) || (inviteProject.getContractProEntry().size() == 0) || (inviteProject.getContractProEntry().get(0).getContractPro() == null) || (this.oprtState == OprtState.ADDNEW))
    {
      EntityViewInfo view = new EntityViewInfo();
      FilterInfo filter = new FilterInfo();
      view.setFilter(filter);

      view.getSelector().add(new SelectorItemInfo("contractPro.name"));
      view.getSelector().add(new SelectorItemInfo("contractPro.controlAmount"));

      if (this.isEnabledYGZ) {
        view.getSelector().add(new SelectorItemInfo("contractPro.ctrlVAT"));
        view.getSelector().add(new SelectorItemInfo("contractPro.ctrlIncTaxAmt"));
      }

      view.getSelector().add(new SelectorItemInfo("contractPro.costEntries.id"));
      filter.getFilterItems().add(new FilterItemInfo("parent.id", inviteProject.getId().toString()));
      contractColl = InviteProjectContactEntryFactory.getRemoteInstance().getInviteProjectContactEntryCollection(view);
    } else {
      contractColl = inviteProject.getContractProEntry();
    }
    ProgrammingContractCollection revColl = new ProgrammingContractCollection();
    if ((contractColl != null) && (contractColl.size() > 0)) {
      int count = contractColl.size();
      Set personSet = new HashSet();
      for (int i = 0; i < count; i++) {
        if (contractColl.get(i).getContractPro() != null) {
          personSet.add(contractColl.get(i).getContractPro());
          revColl.add(contractColl.get(i).getContractPro());
        }
      }
      this.prmtProgrammingContract.setValue(personSet.toArray(new ProgrammingContractInfo[0]));

      if (this.isEnabledYGZ)
        initCtrlAmt(revColl);
    }
  }

  private void initCtrlAmt(ProgrammingContractCollection coll)
  {
    if ((coll != null) && (coll.size() > 0)) {
      ProgrammingContractInfo info = null;
      String strCtrlAMT = "";
      String strCtrlIncAmount = "";
      for (int i = 0; i < coll.size(); i++) {
        info = coll.get(i);
        String name = info.getName();
        BigDecimal ctrlAMT = info.getCtrlVat();
        BigDecimal ctrlIncAmount = info.getExcTaxCtrlAmt();

        ctrlAMT = FDCHelper.toBigDecimal(ctrlAMT, 2);
        ctrlIncAmount = FDCHelper.toBigDecimal(ctrlIncAmount, 2);
        if (i != coll.size() - 1) {
          strCtrlAMT = strCtrlAMT + name + "(" + ctrlAMT + ");";
          strCtrlIncAmount = strCtrlIncAmount + name + "(" + ctrlIncAmount + ");";
        }
        else {
          strCtrlAMT = strCtrlAMT + name + "(" + ctrlAMT + ")";
          strCtrlIncAmount = strCtrlIncAmount + name + "(" + ctrlIncAmount + ")";
        }

      }

      this.txtCtrlIncTaxAmt.setText(strCtrlIncAmount);
    }
    else {
      this.txtCtrlIncTaxAmt.setText(null);
    }
  }

  private void initLinsten()
  {
    for (Iterator it = this.entryMap.keySet().iterator(); it.hasNext(); ) {
      KDTable table = (KDTable)this.entryMap.get(it.next());
      table.addKDTEditListener(new KDTEditAdapter() {
        public void editStopped(KDTEditEvent e) {
          try {
            InviteAppraisingEditUI.this.kdtEntry_editStopped(e);
          } catch (Exception exc) {
            InviteAppraisingEditUI.this.handUIException(exc);
          }
        }

        public void editValueChanged(KDTEditEvent e) {
          try {
            InviteAppraisingEditUI.this.kdtEntry_editValueChanged(e);
          } catch (Exception exc) {
            InviteAppraisingEditUI.this.handUIException(exc);
          }
        } } );
    }
  }

  private void kdtEntry_editValueChanged(KDTEditEvent e) throws EASBizException {
    if ((e.getSource() instanceof KDTable)) {
      int rowIndex = e.getRowIndex();

      KDTable table = (KDTable)(KDTable)e.getSource();
      if ((e.getColIndex() == table.getColumn("isRecommand").getColumnIndex()) || (e.getColIndex() == table.getColumn("caseAmount").getColumnIndex()))
      {
        if (((Boolean)e.getValue()).booleanValue())
        {
          table.getCell(rowIndex, "isRecommand").setValue(e.getValue());

          AppprasingMethodEnum method = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();
          checkRowCallBid(table, rowIndex, method);

          setCellBackGroud(table.getRow(rowIndex));
        } else {
          setBgColor(table.getRow(rowIndex));
        }
        if (e.getColIndex() == table.getColumn("isRecommand").getColumnIndex()) {
          table.getCell(rowIndex, "isRecommand").setValue(e.getValue());
        }
        SupplierStockInfo supp = (SupplierStockInfo)table.getCell(rowIndex, "supplier").getValue();
        InviteProjectSegmentEnum tempSeg = (InviteProjectSegmentEnum)table.getCell(rowIndex, "segment").getValue();
        CurProjectInfo tempProject = (CurProjectInfo)table.getCell(rowIndex, "project").getValue();
        int segRowIndex = getSegEntryRowIndexBySegAndSupp(supp, tempSeg, tempProject);
        this.kdtSegEntry.getCell(segRowIndex, "isRecommand").setValue(e.getValue());
        IRow row = table.getRow(rowIndex);
        Boolean value = Boolean.FALSE;
        if (e.getColIndex() == table.getColumn("isRecommand").getColumnIndex()) {
          value = Boolean.valueOf(e.getValue() == null ? false : Boolean.valueOf(e.getValue().toString()).booleanValue());
        }

        calformateTotoalAmount();
      }
    }
  }

  private void checkRowCallBid(KDTable table, int rowIndex, AppprasingMethodEnum method)
  {
    if (method.equals(AppprasingMethodEnum.ReasonableLowPrice)) {
      BigDecimal lowPrice = getLowPrice(table);
      BigDecimal price = getAmount(table.getRow(rowIndex), method);
      BigDecimal dicountRate = (BigDecimal)table.getCell(rowIndex, "dicountRate").getValue();
      if (dicountRate == null) {
        dicountRate = BigDecimal.ZERO;
      }

      dicountRate = dicountRate.divide(new BigDecimal(100));
    }
  }

  private void reCalcFinalAmount()
  {
    AppprasingMethodEnum method = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();
    InviteAppraisingSegmentEntryInfo entryInfo = null;
    BigDecimal finprice = null;
    if ((method != null) && (method.equals(AppprasingMethodEnum.ReasonableLowPrice)))
      for (int i = 0; i < this.editData.getSegEntry().size(); i++) {
        entryInfo = this.editData.getSegEntry().get(i);
        finprice = getAmount(entryInfo, method, false);
        entryInfo.setFinalAmount(finprice);
      }
    else
      for (int i = 0; i < this.editData.getSegEntry().size(); i++) {
        entryInfo = this.editData.getSegEntry().get(i);
        finprice = getAmount(entryInfo, method, false);
        entryInfo.setBusNeogiateAmount(finprice);
      }
  }

  private void kdtEntry_editStopped(KDTEditEvent e)
    throws EASBizException
  {
    if ((e.getSource() instanceof KDTable))
    {
      int colIndex = e.getColIndex();
      int rowIndex = e.getRowIndex();
      if (((e.getValue() != null) && (e.getValue().equals(e.getOldValue()))) || ((e.getValue() == null) && (e.getOldValue() == null))) {
        return;
      }

      InviteProjectSegmentEnum tempSeg = null;
      SupplierStockInfo supp = null;
      CurProjectInfo tempProject = null;
      KDTable table = (KDTable)(KDTable)e.getSource();
      tempSeg = (InviteProjectSegmentEnum)table.getCell(rowIndex, "segment").getValue();
      supp = (SupplierStockInfo)table.getCell(rowIndex, "supplier").getValue();
      tempProject = (CurProjectInfo)table.getCell(rowIndex, "project").getValue();
      int invideResIndex = table.getColumn("invalidReason").getColumnIndex();
      int segRowIndex = getSegEntryRowIndexBySegAndSupp(supp, tempSeg, tempProject);

      if (colIndex == invideResIndex) {
        AppraisingInvaildReasonEnum reason = (AppraisingInvaildReasonEnum)table.getCell(rowIndex, "invalidReason").getValue();
        if (reason != null) {
          if (reason.equals(AppraisingInvaildReasonEnum.NULL)) {
            lockRowCell(table.getRow(rowIndex), false);
            table.getRow(rowIndex).getStyleAttributes().setBackground(Color.WHITE);
          } else {
            lockRowCell(table.getRow(rowIndex), true);
            table.getRow(rowIndex).getStyleAttributes().setBackground(Color.gray);
            table.getCell(rowIndex, "isRecommand").setValue(Boolean.FALSE);
            this.kdtSegEntry.getCell(segRowIndex, "comScore").setValue(Boolean.FALSE);
          }
        } else {
          lockRowCell(table.getRow(rowIndex), false);
          table.getRow(rowIndex).getStyleAttributes().setBackground(Color.WHITE);
        }
      } else if ((colIndex == table.getColumn("techScore").getColumnIndex()) || (colIndex == table.getColumn("busScore").getColumnIndex()))
      {
        BigDecimal val = calcTotalScore(table.getRow(rowIndex));
        table.getCell(rowIndex, "comScore").setValue(val);
        this.kdtSegEntry.getCell(segRowIndex, "comScore").setValue(val);
      } else if ((colIndex == table.getColumn("clarAmendAmount").getColumnIndex()) || (colIndex == table.getColumn("amendAmount").getColumnIndex()))
      {
        BigDecimal val = calcAppraisingPrice(table.getRow(rowIndex));
        table.getCell(rowIndex, "appraisingAmount").setValue(val);
        this.kdtSegEntry.getCell(segRowIndex, "appraisingAmount").setValue(val);
      }
      else if (colIndex != table.getColumnIndex("isRecommand"));
      if ((colIndex == table.getColumn("finalAmount").getColumnIndex()) || (colIndex == table.getColumn("busNeogiateAmount").getColumnIndex()) || (colIndex == table.getColumn("clarAmendAmount").getColumnIndex()) || (colIndex == table.getColumn("clarifyAmount").getColumnIndex()) || (colIndex == table.getColumn("amendAmount").getColumnIndex()) || (colIndex == table.getColumn("caseAmount").getColumnIndex()))
      {
        setBgColor(table.getRow(rowIndex));

        setCellBackGroud(table.getRow(rowIndex));
      }

      if ((this.isEnabledYGZ) && ((colIndex == table.getColumn("caseCtrlVAT").getColumnIndex()) || (colIndex == table.getColumn("clarifyCtrlVAT").getColumnIndex()) || (colIndex == table.getColumn("finalCtrlVAT").getColumnIndex())))
      {
        setBgColor(table.getRow(rowIndex));

        setCellBackGroud(table.getRow(rowIndex));
      }

      this.kdtSegEntry.getCell(segRowIndex, colIndex).setValue(e.getValue());

      if ((this.isEnabledYGZ) && ((colIndex == table.getColumn("caseAmount").getColumnIndex()) || (colIndex == table.getColumn("caseCtrlVAT").getColumnIndex())))
      {
        Object caseAmount = table.getCell(rowIndex, "caseAmount").getValue();
        Object caseCtrlVAT = table.getCell(rowIndex, "caseCtrlVAT").getValue();

        table.getCell(rowIndex, "caseCtrlIncTaxAmt").setValue(FDCHelper.subtract(caseAmount, caseCtrlVAT));
        table.getCell(rowIndex, "finalCtrlVAT").setValue(FDCHelper.toBigDecimal(caseCtrlVAT));

        this.kdtSegEntry.getCell(segRowIndex, "caseCtrlIncTaxAmt").setValue(FDCHelper.subtract(caseAmount, caseCtrlVAT));
        this.kdtSegEntry.getCell(segRowIndex, "finalCtrlVAT").setValue(FDCHelper.toBigDecimal(caseCtrlVAT));
      }

      if ((this.isEnabledYGZ) && ((colIndex == table.getColumn("clarifyAmount").getColumnIndex()) || (colIndex == table.getColumn("clarifyCtrlVAT").getColumnIndex())))
      {
        Object clarifyAmount = table.getCell(rowIndex, "clarifyAmount").getValue();
        Object clarifyCtrlVAT = table.getCell(rowIndex, "clarifyCtrlVAT").getValue();

        table.getCell(rowIndex, "clarifyCtrlIncTaxAmt").setValue(FDCHelper.subtract(clarifyAmount, clarifyCtrlVAT));
        table.getCell(rowIndex, "finalCtrlVAT").setValue(FDCHelper.toBigDecimal(clarifyCtrlVAT));

        this.kdtSegEntry.getCell(segRowIndex, "clarifyCtrlIncTaxAmt").setValue(FDCHelper.subtract(clarifyAmount, clarifyCtrlVAT));
        this.kdtSegEntry.getCell(segRowIndex, "finalCtrlVAT").setValue(FDCHelper.toBigDecimal(clarifyCtrlVAT));
      }

      if ((colIndex != table.getColumn("finalAmount").getColumnIndex()) && (colIndex != table.getColumn("busNeogiateAmount").getColumnIndex()) && (colIndex != table.getColumn("quotePriceDcrp").getColumnIndex()) && (colIndex != table.getColumn("invalidReason").getColumnIndex()) && (colIndex != table.getColumn("techScore").getColumnIndex()) && (colIndex != table.getColumn("busScore").getColumnIndex()) && (colIndex != table.getColumn("comScore").getColumnIndex()) && (colIndex != table.getColumn("appraiseRank").getColumnIndex()) && (((this.isEnabledYGZ) && (colIndex != table.getColumn("finalAmount").getColumnIndex())) || (!this.isEnabledYGZ)))
      {
        AppprasingMethodEnum method = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();
        BigDecimal finprice = getAmount(table.getRow(rowIndex), method, false);
        if (method.equals(AppprasingMethodEnum.ReasonableLowPrice)) {
          table.getCell(rowIndex, "finalAmount").setValue(finprice);
          this.kdtSegEntry.getCell(segRowIndex, "finalAmount").setValue(finprice);

          if (this.isEnabledYGZ) {
            Object finalCtrlVAT = table.getCell(rowIndex, "finalCtrlVAT").getValue();
            table.getCell(rowIndex, "finalCtrlIncTaxAmt").setValue(FDCHelper.subtract(finprice, finalCtrlVAT));
            this.kdtSegEntry.getCell(segRowIndex, "finalCtrlIncTaxAmt").setValue(FDCHelper.subtract(finprice, finalCtrlVAT));
          }
        }
        else
        {
          table.getCell(rowIndex, "busNeogiateAmount").setValue(finprice);
          this.kdtSegEntry.getCell(segRowIndex, "busNeogiateAmount").setValue(finprice);

          if (this.isEnabledYGZ) {
            Object finalCtrlVAT = table.getCell(rowIndex, "finalCtrlVAT").getValue();
            table.getCell(rowIndex, "finalCtrlIncTaxAmt").setValue(FDCHelper.subtract(finprice, finalCtrlVAT));
            this.kdtSegEntry.getCell(segRowIndex, "finalCtrlIncTaxAmt").setValue(FDCHelper.subtract(finprice, finalCtrlVAT));
          }

        }

      }

      if ((this.isEnabledYGZ) && ((colIndex == table.getColumn("finalAmount").getColumnIndex()) || (colIndex == table.getColumn("finalCtrlVAT").getColumnIndex()))) {
        Object finalAmount = table.getCell(rowIndex, "finalAmount").getValue();
        Object finalCtrlVAT = table.getCell(rowIndex, "finalCtrlVAT").getValue();

        table.getCell(rowIndex, "finalCtrlIncTaxAmt").setValue(FDCHelper.subtract(finalAmount, finalCtrlVAT));
        this.kdtSegEntry.getCell(rowIndex, "finalCtrlIncTaxAmt").setValue(FDCHelper.subtract(finalAmount, finalCtrlVAT));
      }
      else if ((this.isEnabledYGZ) && (colIndex == table.getColumn("busNeogiateAmount").getColumnIndex())) {
        Object busNeogiateAmount = table.getCell(rowIndex, "busNeogiateAmount").getValue();
        Object finalCtrlVAT = table.getCell(rowIndex, "finalCtrlVAT").getValue();

        table.getCell(rowIndex, "finalCtrlIncTaxAmt").setValue(FDCHelper.subtract(busNeogiateAmount, finalCtrlVAT));

        this.kdtSegEntry.getCell(rowIndex, "finalCtrlIncTaxAmt").setValue(FDCHelper.subtract(busNeogiateAmount, finalCtrlVAT));
      }

    }

    setEntryHighDataState();

    calformateTotoalAmount();
  }

  private void calformateTotoalAmount()
  {
    AppprasingMethodEnum method = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();

    BigDecimal totalAmount = BigDecimal.ZERO;
    BigDecimal totalBidTax = BigDecimal.ZERO;
    BigDecimal totalBidTaxMny = BigDecimal.ZERO;

    for (Iterator it = this.entryMap.keySet().iterator(); it.hasNext(); ) {
      KDTable table = (KDTable)this.entryMap.get(it.next());
      if ((method != null) && (method.equals(AppprasingMethodEnum.ReasonableLowPrice))) {
        for (int i = 0; i < table.getRowCount(); i++) {
          IRow row = table.getRow(i);
          Object obj = row.getCell("isRecommand").getValue();

          if (((Boolean)obj).booleanValue()) {
            BigDecimal finalAmount = FDCNumberHelper.toBigDecimal(row.getCell("finalAmount").getValue());
            totalAmount = totalAmount.add(finalAmount);

            if (this.isEnabledYGZ) {
              BigDecimal finalCtrlVAT = FDCNumberHelper.toBigDecimal(row.getCell("finalCtrlVAT").getValue());
              totalBidTax = totalBidTax.add(finalCtrlVAT);
              BigDecimal finalCtrlIncTaxAmt = FDCNumberHelper.toBigDecimal(row.getCell("finalCtrlIncTaxAmt").getValue());
              totalBidTaxMny = totalBidTaxMny.add(finalCtrlIncTaxAmt);
            }
          }
        }
      }
      else {
        for (int i = 0; i < table.getRowCount(); i++) {
          IRow row = table.getRow(i);
          Object obj = row.getCell("isRecommand").getValue();

          if (((Boolean)obj).booleanValue()) {
            BigDecimal busNeogiateAmount = FDCNumberHelper.toBigDecimal(row.getCell("busNeogiateAmount").getValue());

            totalAmount = totalAmount.add(busNeogiateAmount);

            if (this.isEnabledYGZ) {
              BigDecimal finalCtrlVAT = FDCNumberHelper.toBigDecimal(row.getCell("finalCtrlVAT").getValue());
              totalBidTax = totalBidTax.add(finalCtrlVAT);
              BigDecimal finalCtrlIncTaxAmt = FDCNumberHelper.toBigDecimal(row.getCell("finalCtrlIncTaxAmt").getValue());
              totalBidTaxMny = totalBidTaxMny.add(finalCtrlIncTaxAmt);
            }
          }

        }

      }

    }

    this.formateTotoalAmount.setValue(totalAmount);

    if (this.isEnabledYGZ) {
      this.txtBidTaxMny.setValue(totalBidTaxMny);
      this.txtBidTax.setValue(totalBidTax);
    }
  }

  private void setBgColor(IRow row)
  {
    String[] columnsName;
    if (this.isEnabledYGZ) {
      columnsName = new String[] { "finalAmount", "busNeogiateAmount", "clarAmendAmount", "clarifyAmount", "amendAmount", "caseAmount", "caseCtrlVAT", "clarifyCtrlVAT", "finalCtrlVAT" };
    }
    else {
      columnsName = new String[] { "finalAmount", "busNeogiateAmount", "clarAmendAmount", "clarifyAmount", "amendAmount", "caseAmount" };
    }

    for (int i = 0; i < columnsName.length; i++)
      if (row.getCell(columnsName[i]).getStyleAttributes().getBackground() == Color.yellow)
        if (row.getCell("supplier").getStyleAttributes().getBackground() == Color.pink)
          row.getCell(columnsName[i]).getStyleAttributes().setBackground(Color.pink);
        else
          row.getCell(columnsName[i]).getStyleAttributes().setBackground(Color.WHITE);
  }

  private BigDecimal calcTotalScore(IRow row)
  {
    BigDecimal techval = (BigDecimal)row.getCell("techScore").getValue();
    BigDecimal bizval = (BigDecimal)row.getCell("busScore").getValue();
    BigDecimal total = BigDecimal.ZERO;
    if ((techval != null) && (this.techPercent != null)) {
      techval = techval.multiply(this.techPercent).divide(new BigDecimal(100));
      total = total.add(techval);
    }
    if ((bizval != null) && (this.bizPercent != null)) {
      bizval = bizval.multiply(this.bizPercent).divide(new BigDecimal(100));
      total = total.add(bizval);
    }

    return total;
  }

  private void calcAppraisingPrice(KDTable table)
    throws EASBizException
  {
    int count = table.getRowCount();
    BigDecimal val = null;
    InviteProjectSegmentEnum tempSeg = null;
    SupplierStockInfo supp = null;
    CurProjectInfo tempProject = null;
    for (int i = 0; i < count; i++)
    {
      val = calcAppraisingPrice(table.getRow(i));
      table.getCell(i, "appraisingAmount").setValue(val);
      if (!table.getName().equals(this.kdtSegEntry.getName())) {
        tempSeg = (InviteProjectSegmentEnum)table.getCell(i, "segment").getValue();
        supp = (SupplierStockInfo)table.getCell(i, "supplier").getValue();
        tempProject = (CurProjectInfo)table.getCell(i, "project").getValue();
        int segRowIndex = getSegEntryRowIndexBySegAndSupp(supp, tempSeg, tempProject);
        this.kdtSegEntry.getCell(segRowIndex, "appraisingAmount").setValue(val);
      }
    }
  }

  private BigDecimal calcAppraisingPrice(IRow row)
  {
    BigDecimal clarAmendAmt = row.getCell("clarAmendAmount").getStyleAttributes().isHided() ? null : (BigDecimal)row.getCell("clarAmendAmount").getValue();

    BigDecimal clarAmt = row.getCell("clarifyAmount").getStyleAttributes().isHided() ? null : (BigDecimal)row.getCell("clarifyAmount").getValue();

    BigDecimal amendAmt = (BigDecimal)row.getCell("amendAmount").getValue();
    BigDecimal caseAmt = (BigDecimal)row.getCell("caseAmount").getValue();
    BigDecimal askAmt = (BigDecimal)row.getCell("askAmount").getValue();

    BigDecimal bit = (BigDecimal)row.getCell("dicountRate").getValue();
    BigDecimal hundred = new BigDecimal(100);
    if (bit == null) {
      bit = BigDecimal.ZERO;
    }
    bit = hundred.subtract(bit).divide(hundred);
    BigDecimal val = null;

    if ((clarAmendAmt != null) && (BigDecimal.ZERO.compareTo(clarAmendAmt) != 0))
      val = clarAmendAmt;
    else if ((clarAmt != null) && (BigDecimal.ZERO.compareTo(clarAmt) != 0))
      val = clarAmt;
    else if ((amendAmt != null) && (BigDecimal.ZERO.compareTo(amendAmt) != 0))
      val = amendAmt;
    else if ((caseAmt != null) && (BigDecimal.ZERO.compareTo(caseAmt) != 0))
      val = caseAmt;
    else if ((askAmt != null) && (BigDecimal.ZERO.compareTo(askAmt) != 0)) {
      val = askAmt;
    }

    if (val != null) {
      return val.multiply(bit);
    }
    return null;
  }

  private void lockRowCell(IRow row, boolean lock)
  {
    row.getCell("amendAmount").getStyleAttributes().setLocked(lock);
    row.getCell("clarAmendAmount").getStyleAttributes().setLocked(lock);
    row.getCell("dicountRate").getStyleAttributes().setLocked(lock);
    row.getCell("appraisingAmount").getStyleAttributes().setLocked(lock);
    row.getCell("finalAmount").getStyleAttributes().setLocked(lock);
    row.getCell("techScore").getStyleAttributes().setLocked(lock);
    row.getCell("busScore").getStyleAttributes().setLocked(lock);
    row.getCell("comScore").getStyleAttributes().setLocked(lock);
    row.getCell("busNeogiateAmount").getStyleAttributes().setLocked(lock);
    row.getCell("isRecommand").getStyleAttributes().setLocked(lock);
  }

  private int getSegEntryRowIndexBySegAndSupp(SupplierStockInfo supp, InviteProjectSegmentEnum seg, CurProjectInfo projectInfo)
    throws EASBizException
  {
    int count = this.kdtSegEntry.getRowCount();
    InviteProjectSegmentEnum tempSeg = null;
    SupplierStockInfo tempSupp = null;
    CurProjectInfo tempProject = null;
    for (int i = 0; i < count; i++) {
      tempSeg = (InviteProjectSegmentEnum)this.kdtSegEntry.getCell(i, "segment").getValue();
      tempSupp = (SupplierStockInfo)this.kdtSegEntry.getCell(i, "supplier").getValue();
      Object obj = this.kdtSegEntry.getCell(i, "project").getValue();
      if (obj != null) {
        tempProject = (CurProjectInfo)obj;
      }

      if (((tempSeg == null) && (seg == null)) || ((tempSeg.getValue() == seg.getValue()) && (supp.getId().toString().equals(tempSupp.getId().toString())) && (((projectInfo == null) && (tempProject == null)) || ((projectInfo != null) && (projectInfo != null) && (projectInfo.getId().toString().equals(tempProject.getId().toString()))))))
      {
        return i;
      }
    }

    throw new EASBizException(new NumericExceptionSubItem("fff", ""));
  }

  private void initNumCol(KDTable table, String amtKey, BigDecimal min, BigDecimal max) {
    KDFormattedTextField kdtEntry_amt_TextField = new KDFormattedTextField();
    kdtEntry_amt_TextField.setName("kdtEntry_" + amtKey + "_TextField");
    kdtEntry_amt_TextField.setVisible(true);
    kdtEntry_amt_TextField.setEditable(true);
    kdtEntry_amt_TextField.setHorizontalAlignment(2);
    kdtEntry_amt_TextField.setDataType(1);
    kdtEntry_amt_TextField.setMinimumValue(min);
    kdtEntry_amt_TextField.setMaximumValue(max);
    kdtEntry_amt_TextField.setPrecision(2);
    KDTDefaultCellEditor kdtEntry_score_CellEditor = new KDTDefaultCellEditor(kdtEntry_amt_TextField);
    table.getColumn(amtKey).setEditor(kdtEntry_score_CellEditor);
  }

  private void initNumCol(KDTable table, String amtKey)
  {
    initNumCol(table, amtKey, new BigDecimal("0"), new BigDecimal("1.0E18"));
  }

  private void loadBindEntry2Entry(InviteProjectInfo invProInfo)
    throws BOSException
  {
    try
    {
      invProInfo = getInvProjectInfo(invProInfo);
    } catch (BOSException e) {
      e.printStackTrace();
    }
    int count = this.kdtSegEntry.getRowCount();
    if (count > 0) {
      InviteProjectSegmentEnum tempSeg = null;
      CurProjectInfo tempCurProject = null;
      IRow bindRow = null;
      int tblRows = 0;
      KDTable table = null;
      String project_Seg = null;

      for (int i = 0; i < count; i++) {
        bindRow = this.kdtSegEntry.getRow(i);
        tempCurProject = (CurProjectInfo)bindRow.getCell("project").getValue();
        tempSeg = (InviteProjectSegmentEnum)bindRow.getCell("segment").getValue();
        if (InviteProjectMethodEnum.STRATEGYINVITEDMETHOD.equals(invProInfo.getInviteMethod())) {
          table = (KDTable)this.entryMap.get("սԲɹ");
          AppprasingMethodEnum method = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();
          if ((method == null) || (AppprasingMethodEnum.ReasonableLowPrice.equals(method)))
          {
            table.getColumn("finalAmount").getStyleAttributes().setHided(false);
            table.getColumn("isRecommand").getStyleAttributes().setHided(false);
          } else if (AppprasingMethodEnum.COMBINEDPRICE.equals(method)) {
            table.getColumn("techScore").getStyleAttributes().setHided(false);
            table.getColumn("busScore").getStyleAttributes().setHided(false);
            table.getColumn("comScore").getStyleAttributes().setHided(false);
            table.getColumn("isRecommand").getStyleAttributes().setHided(false);

            table.getColumn("techScore").setRequired(true);
            table.getColumn("busScore").setRequired(true);
          }

          if (table != null) {
            tblRows = table.getRowCount();
            IRow addedRow = table.addRow(tblRows, (IRow)bindRow.clone());
            if (!table.getColumn("techScore").getStyleAttributes().isHided()) {
              table.getColumn("techScore").setRequired(true);
              table.getColumn("busScore").setRequired(true);
            }
          }
        } else if ((tempSeg != null) && (tempCurProject != null)) {
          if ((tempSeg == InviteProjectSegmentEnum.S7) || (-1 == Integer.parseInt(tempSeg.toString())))
            project_Seg = tempCurProject.getId().toString();
          else {
            project_Seg = tempCurProject.getId().toString() + "_" + tempSeg.getValue();
          }
          table = (KDTable)this.entryMap.get(project_Seg);

          if (table != null) {
            tblRows = table.getRowCount();
            IRow addedRow = table.addRow(tblRows, (IRow)bindRow.clone());
            if (!table.getColumn("techScore").getStyleAttributes().isHided()) {
              table.getColumn("techScore").setRequired(true);
              table.getColumn("busScore").setRequired(true);
            }
          }
        }
        if (table != null) {
          table.getColumn("appraiseRank").getStyleAttributes().setHided(false);
        }
        if ((table != null) && (this.oprtState != OprtState.ADDNEW) && (this.oprtState != OprtState.EDIT) && (table.isEnabled()))
          table.setEnabled(false);
      }
    }
  }

  private InviteAppraisingSegmentEntryCollection getAllSegData(InviteProjectInfo invProInfo)
    throws BOSException
  {
    invProInfo = getInvProjectInfo(invProInfo);
    this.kdtSegEntry.checkParsed();
    InviteAppraisingSegmentEntryCollection coll = getSupplierInfo(this.editData.getInvPro().getId().toString());
    InviteAppraisingSegmentEntryCollection revColl = new InviteAppraisingSegmentEntryCollection();
    this.editData.setInvPro(invProInfo);
    try {
      Map askMap = getQuotePrice(invProInfo.getId().toString(), QuotePriceTypeEnum.ASK_QUOTE, true, invProInfo.getInviteMethod());
      Map tenderMap = getQuotePrice(invProInfo.getId().toString(), QuotePriceTypeEnum.TENDER_QUOTE, false, invProInfo.getInviteMethod());
      if ((coll != null) && (coll.size() > 0)) {
        String supp = null;
        Map segMap = null;
        CurProjectInfo projectInfo = null;
        InviteProjectSegmentEnum invEntryBidNum = null;
        String project_Seg = null;

        AppprasingMethodEnum method = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();
        if (InviteProjectMethodEnum.STRATEGYINVITEDMETHOD.equals(invProInfo.getInviteMethod())) {
          invEntryBidNum = InviteProjectSegmentEnum.S1;
          project_Seg = "սЭ";
          for (int j = 0; j < coll.size(); j++) {
            InviteAppraisingSegmentEntryInfo entry = coll.get(j);
            entry.setSegment(invEntryBidNum);
            entry.setProject(projectInfo);
            InviteAppraisingSegmentEntryInfo myentry = (InviteAppraisingSegmentEntryInfo)entry.clone();

            supp = myentry.getSupplier().getId().toString();
            if (askMap.size() > 0) {
              segMap = (Map)askMap.get(supp);
              if ((segMap != null) && (segMap.size() > 0)) {
                myentry.setAskAmount((BigDecimal)segMap.get(project_Seg));
              }
            }
            if (tenderMap.size() > 0) {
              segMap = (Map)tenderMap.get(supp);
              if ((segMap != null) && (segMap.size() > 0)) {
                myentry.setCaseAmount((BigDecimal)segMap.get(project_Seg));
              }
            }

            if (AppprasingMethodEnum.ReasonableLowPrice.equals(method)) {
              if (myentry.getCaseAmount() != null)
                myentry.setFinalAmount(myentry.getCaseAmount());
              else if (myentry.getAskAmount() != null)
                myentry.setFinalAmount(myentry.getAskAmount());
            }
            else if (AppprasingMethodEnum.COMBINEDPRICE.equals(method)) {
              if (myentry.getCaseAmount() != null)
                myentry.setBusNeogiateAmount(myentry.getCaseAmount());
              else if (myentry.getAskAmount() != null) {
                myentry.setBusNeogiateAmount(myentry.getAskAmount());
              }
            }
            revColl.add(myentry);
          }

        }
        else
        {
          for (int j = 0; j < coll.size(); j++) {
            InviteAppraisingSegmentEntryInfo entryInfo = coll.get(j);
            invEntryBidNum = entryInfo.getSegment();
            projectInfo = entryInfo.getProject();
            project_Seg = projectInfo.getId().toString() + "_" + invEntryBidNum.getValue();

            InviteAppraisingSegmentEntryInfo myentry = (InviteAppraisingSegmentEntryInfo)entryInfo.clone();

            supp = myentry.getSupplier().getId().toString();
            if (askMap.size() > 0) {
              segMap = (Map)askMap.get(supp);
              if ((segMap != null) && (segMap.size() > 0)) {
                myentry.setAskAmount((BigDecimal)segMap.get(project_Seg));
              }
            }
            if (tenderMap.size() > 0) {
              segMap = (Map)tenderMap.get(supp);
              if ((segMap != null) && (segMap.size() > 0)) {
                myentry.setCaseAmount((BigDecimal)segMap.get(project_Seg));
              }
            }

            if (AppprasingMethodEnum.ReasonableLowPrice.equals(method)) {
              if (myentry.getCaseAmount() != null)
                myentry.setFinalAmount(myentry.getCaseAmount());
              else if (myentry.getAskAmount() != null)
                myentry.setFinalAmount(myentry.getAskAmount());
            }
            else if (AppprasingMethodEnum.COMBINEDPRICE.equals(method)) {
              if (myentry.getCaseAmount() != null)
                myentry.setBusNeogiateAmount(myentry.getCaseAmount());
              else if (myentry.getAskAmount() != null) {
                myentry.setBusNeogiateAmount(myentry.getAskAmount());
              }
            }
            revColl.add(myentry);
          }
        }
      }
    }
    catch (EASBizException e) {
      handleException(e);
    }

    return revColl;
  }

  private InviteProjectInfo getInvProjectInfo(InviteProjectInfo invProInfo) throws BOSException
  {
    SelectorItemCollection sic = new SelectorItemCollection();
    sic.add(new SelectorItemInfo("*"));
    sic.add(new SelectorItemInfo("contractProEntry.*"));
    try {
      invProInfo = InviteProjectFactory.getRemoteInstance().getInviteProjectInfo(new ObjectUuidPK(invProInfo.getId()), sic);
    } catch (EASBizException e) {
      e.printStackTrace();
    }
    return invProInfo;
  }

  private InviteAppraisingSegmentEntryCollection getSupplierInfo(String invPrjId)
    throws BOSException
  {
    EntityViewInfo view = new EntityViewInfo();
    FilterInfo filter = new FilterInfo();
    view.setFilter(filter);
    SelectorItemCollection sic = new SelectorItemCollection();
    sic.add("*");
    sic.add("supplier.*");
    sic.add("curProject.id");
    sic.add("curProject.name");
    sic.add("curProject.number");
    sic.add("parent.bizBit");
    sic.add("parent.techBit");
    sic.add("parent.isAgain");
    view.setSelector(sic);

    filter.getFilterItems().add(new FilterItemInfo("parent.inviteProject.id", invPrjId));

    filter.getFilterItems().add(new FilterItemInfo("isBid", Boolean.TRUE));
    filter.getFilterItems().add(new FilterItemInfo("isInvalid", Boolean.FALSE));
    filter.getFilterItems().add(new FilterItemInfo("parent.isAdd", Boolean.TRUE));
    StartBidEntryCollection entryColl = StartBidEntryFactory.getRemoteInstance().getStartBidEntryCollection(view);

    if ((entryColl != null) && (entryColl.size() > 0)) {
      InviteAppraisingSegmentEntryCollection revColl = new InviteAppraisingSegmentEntryCollection();
      this.startBidInfo = entryColl.get(0).getParent();
      boolean isAgain = this.startBidInfo.isIsAgain();

      for (int i = 0; i < entryColl.size(); i++) {
        InviteAppraisingSegmentEntryInfo temp = new InviteAppraisingSegmentEntryInfo();
        StartBidEntryInfo entryInfo = entryColl.get(i);
        temp.setSupplier(entryInfo.getSupplier());
        temp.setSegment(entryInfo.getBidNum());
        temp.setProject(entryInfo.getCurProject());

        temp.setCaseAmount(entryInfo.getBidMny());

        if (this.isEnabledYGZ) {
          temp.setCaseCtrlVAT(entryInfo.getBidCtrlVAT());
          temp.setCaseCtrlIncTaxAmt(entryInfo.getBidCtrlIncTaxAmt());
        }

        temp.setQuotePriceDcrp(entryInfo.getQuotePriceDcrp());

        if (isAgain) {
          temp.setClarifyAmount(entryInfo.getClarifyMny());

          if (this.isEnabledYGZ) {
            temp.setClarifyCtrlVAT(entryInfo.getClarifyCtrlVAT());
            temp.setClarifyCtrlIncTaxAmt(entryInfo.getClarifyCtrlIncTaxAmt());
          }

        }

        if ((entryInfo.getClarifyMny() != null) && (entryInfo.getClarifyMny().compareTo(new BigDecimal(0)) != 0)) {
          temp.setFinalAmount(entryInfo.getClarifyMny());

          if (this.isEnabledYGZ) {
            temp.setFinalCtrlVAT(entryInfo.getClarifyCtrlVAT());
            temp.setFinalCtrlIncTaxAmt(entryInfo.getClarifyCtrlIncTaxAmt());
          }
        }
        else {
          temp.setFinalAmount(entryInfo.getBidMny());

          if (this.isEnabledYGZ) {
            temp.setFinalCtrlVAT(entryInfo.getBidCtrlVAT());
            temp.setFinalCtrlIncTaxAmt(entryInfo.getBidCtrlIncTaxAmt());
          }
        }

        if (entryInfo.getDiscount() != null) {
          temp.setDicountRate(entryInfo.getDiscount());
        }
        revColl.add(temp);
      }
      loadTechAndBizPercent(this.startBidInfo);
      return revColl;
    }
    return null;
  }

  private void loadTechAndBizPercent(StartBidInfo info) {
    this.bizPercent = info.getBizBit();
    this.techPercent = info.getTechBit();
  }

  private void loadTechAndBizPercent(InviteProjectInfo info) throws BOSException {
    EntityViewInfo view = new EntityViewInfo();
    FilterInfo filter = new FilterInfo();
    view.setFilter(filter);
    view.getSelector().add(new SelectorItemInfo("*"));
    filter.getFilterItems().add(new FilterItemInfo("inviteProject.id", info.getId().toString()));

    StartBidCollection coll = StartBidFactory.getRemoteInstance().getStartBidCollection(view);
    if ((coll != null) && (coll.size() > 0)) {
      this.bizPercent = coll.get(0).getBizBit();
      this.techPercent = coll.get(0).getTechBit();
    }
  }

  private Map getQuotePrice(String invPrjId, QuotePriceTypeEnum quoteType, boolean checkBidNum, InviteProjectMethodEnum method)
    throws EASBizException, BOSException
  {
    PriceInfoForWebCollection coll = PriceInfoForWebFactory.getRemoteInstance().getVaildVersionInfo(new ObjectUuidPK(invPrjId), quoteType);

    PriceInfoForWebInfo info = null;
    Map map = new HashMap();

    String supp = null;
    PriceInfoForWebEntryCollection entrys = null;
    PriceInfoForWebEntryInfo entry = null;
    String project_Seg = null;
    for (int i = 0; i < coll.size(); i++) {
      info = coll.get(i);

      supp = info.getSupplier().getId().toString();
      entrys = info.getEntry();

      Map segMap = (Map)map.get(supp);
      if (segMap == null) {
        segMap = new HashMap();
      }
      for (int j = 0; j < entrys.size(); j++) {
        entry = entrys.get(j);
        if (InviteProjectMethodEnum.STRATEGYINVITEDMETHOD != method) {
          project_Seg = entry.getProject().getId().toString() + "_" + entry.getSeg().getValue();
          segMap.put(project_Seg, entry.getPrice());
        } else {
          segMap.put("սЭ", entry.getPrice());
        }
      }
      map.put(supp, segMap);
    }
    return map;
  }

  protected String transIntToSeg(int i) {
    switch (i) {
    case 1:
      return "һ";
    case 2:
      return "";
    case 3:
      return "";
    case 4:
      return "";
    case 5:
      return "";
    case 6:
      return "";
    case 7:
      return "";
    case 8:
      return "";
    case 9:
      return "";
    case 10:
      return "ʮ";
    }
    return "һ";
  }

  private void showInvData()
    throws BOSException
  {
    EntityViewInfo view = new EntityViewInfo();
    FilterInfo filter = new FilterInfo();
    SelectorItemCollection sels = new SelectorItemCollection();
    sels.add("apprasingMethod");
    sels.add("segments");
    view.setFilter(filter);
    view.setSelector(sels);
    if (this.invProIdStr == null) {
      throw new BOSException("ȱб");
    }
    filter.getFilterItems().add(new FilterItemInfo("invPro.id", this.invProIdStr));
    InviteDistributedCollection inviteDisCols = InviteDistributedFactory.getRemoteInstance().getInviteDistributedCollection(view);
    if ((inviteDisCols != null) && (inviteDisCols.size() > 0))
    {
      if (this.oprtState == OprtState.ADDNEW)
      {
        this.currSeg = inviteDisCols.get(0).getSegments();
        this.editData.setTotalSegment(this.currSeg);
      }
    }
    else if (this.oprtState == OprtState.ADDNEW) {
      FDCMsgBox.showWarning(this, "δ겻");
      abort();
    }

    filter.getFilterItems().clear();
    if (InviteParamFetcher.isEanableOutNet(null))
      filter.getFilterItems().add(new FilterItemInfo("inviteProject", this.invProIdStr));
    else {
      filter.getFilterItems().add(new FilterItemInfo("inviteProject.id", this.invProIdStr));
    }
    view.getSelector().clear();

    view.getSelector().add("id");
    view.getSelector().add("apprasingMethod");

    AppprasingMethodEnum methodItem = null;

    if (InviteParamFetcher.isEanableOutNet(null)) {
      view.getSelector().add("baseAmt");
      StartBidCollection starBidColl = StartBidFactory.getRemoteInstance().getStartBidCollection(view);
      if ((starBidColl != null) && (starBidColl.size() > 0)) {
        methodItem = starBidColl.get(0).getApprasingMethod();
        this.kDFormattedTextField1.setValue(starBidColl.get(0).getBaseAmt());
      }

    }
    else if (!InviteParamFetcher.isEanableOutNet(null))
    {
      StartBidCollection inviteColl = StartBidFactory.getRemoteInstance().getStartBidCollection(view);
      if ((inviteColl != null) && (inviteColl.size() > 0))
        methodItem = inviteColl.get(0).getApprasingMethod();
    }
    else
    {
      StartBidCollection inviteColl = StartBidFactory.getRemoteInstance().getStartBidCollection(view);
      if ((inviteColl != null) && (inviteColl.size() > 0)) {
        methodItem = inviteColl.get(0).getApprasingMethod();
      }

    }

    this.comboApprasingMethod.setSelectedItem(methodItem);
    if (AppprasingMethodEnum.COMBINEDPRICE.equals(methodItem))
    {
      this.labWeight1.setVisible(false);
      this.labWeight2.setVisible(false);
    } else {
      this.labWeight1.setVisible(false);
      this.labWeight2.setVisible(false);
    }

    if ("ADDNEW".equals(getOprtState()))
    {
      this.txtInvNum.setText(this.editData.getInvPro().getNumber());
    }

    MaterialPriceDataEntryCollection entryCol = MaterialPriceDataEntryFactory.getRemoteInstance().getMaterialPriceDataEntryCollection("where invPro.id='" + this.editData.getInvPro().getId() + "'");

    if (entryCol.size() > 0)
      this.txtImportState.setText("ѵ");
    else
      this.txtImportState.setText("δ");
  }

  private void setControlBtnState()
  {
    this.actionClarify.setVisible(true);
    this.btnAppraising.setVisible(false);

    if (this.editData.isIsClearfy())
    {
      this.actionClarify.setEnabled(false);
    }
    if (this.editData.isAppraising()) {
      this.btnAppraising.setVisible(false);
    }

    if (this.editData.isBizNegoiate()) {
      this.btnBussAppraising.setVisible(false);
    }
    this.actionSignContract.setEnabled(true);
    this.actionSignContract.setVisible(true);
    this.actionInvFile.setEnabled(true);

    if (!this.editData.isAppraising())
      this.btnBussAppraising.setVisible(false);
  }

  private void setAppraisingProcessModelTable(KDTable table)
  {
    if (this.comboApprasingMethod.getSelectedItem() == null) {
      FDCMsgBox.showWarning("׶ѡģʽ!");
      SysUtil.abort();
    }
    AppprasingMethodEnum method = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();

    for (int i = 3; i < table.getColumnCount(); i++) {
      IColumn col = table.getColumn(i);
      col.getStyleAttributes().setHided(true);
      if (("invalidReason".equals(col.getKey())) || ("quotePriceDcrp".equals(col.getKey())) || ("supplier.taxPayerType".equals(col.getKey())))
      {
        col.getStyleAttributes().setHided(false);
      }
      if ((this.startBidInfo != null) && (this.startBidInfo.isIsAgain())) {
        table.getColumn("clarifyAmount").getStyleAttributes().setHided(false);

        if (this.isEnabledYGZ) {
          table.getColumn("clarifyCtrlVAT").getStyleAttributes().setHided(false);
          table.getColumn("clarifyCtrlIncTaxAmt").getStyleAttributes().setHided(false);
        }
      }

    }

    if ((!this.isLimitModel) || ((this.isBizPerson != null) && (this.isBizPerson.booleanValue())))
    {
      table.getColumn("caseAmount").getStyleAttributes().setHided(false);

      if (this.isEnabledYGZ) {
        table.getColumn("caseCtrlVAT").getStyleAttributes().setHided(false);
        table.getColumn("caseCtrlIncTaxAmt").getStyleAttributes().setHided(false);
      }

    }
    else
    {
      table.getColumn("caseAmountP").getStyleAttributes().setHided(false);
    }

    if (this.editData.isIsClearfy()) {
      table.getColumn("invalidReason").getStyleAttributes().setHided(false);
    }

    if (this.editData.isAppraising()) {
      if ((method == null) || (AppprasingMethodEnum.ReasonableLowPrice.equals(method)))
      {
        table.getColumn("finalAmount").getStyleAttributes().setHided(false);
        table.getColumn("isRecommand").getStyleAttributes().setHided(false);

        if (this.isEnabledYGZ) {
          table.getColumn("finalCtrlVAT").getStyleAttributes().setHided(false);
          table.getColumn("finalCtrlIncTaxAmt").getStyleAttributes().setHided(false);
        }
      }
      else if (AppprasingMethodEnum.COMBINEDPRICE.equals(method)) {
        table.getColumn("techScore").getStyleAttributes().setHided(false);
        table.getColumn("busScore").getStyleAttributes().setHided(false);
        table.getColumn("comScore").getStyleAttributes().setHided(false);
        table.getColumn("isRecommand").getStyleAttributes().setHided(false);

        table.getColumn("techScore").setRequired(true);

        table.getColumn("busScore").setRequired(true);
      }

    }

    if (this.editData.isBizNegoiate())
    {
      table.getColumn("techScore").getStyleAttributes().setHided(false);
      table.getColumn("busScore").getStyleAttributes().setHided(false);
      table.getColumn("comScore").getStyleAttributes().setHided(false);

      table.getColumn("isRecommand").getStyleAttributes().setHided(false);

      table.getColumn("techScore").setRequired(true);

      table.getColumn("busScore").setRequired(true);
    }

    if (AppprasingMethodEnum.COMBINEDPRICE.equals(method)) {
      table.getColumn("busNeogiateAmount").getStyleAttributes().setHided(false);
    }

    if ((method == null) || (AppprasingMethodEnum.ReasonableLowPrice.equals(method))) {
      table.getColumn("finalAmount").getStyleAttributes().setHided(false);
      try {
        calcAppraisingPrice(table);
      } catch (EASBizException e) {
        handleException(e);
      }
    }
    setControlBtnState();
  }

  public void loadFields()
  {
    this.startBidInfo = null;
    if (this.oprtState == OprtState.ADDNEW) {
      this.chkAppraising.setSelected(true);
      this.editData.setAppraising(true);
      this.clcikAppraising = true;
      try {
        showInvData();
        InviteAppraisingSegmentEntryCollection coll = getAllSegData(this.editData.getInvPro());
        coll = orderbySegmentEntry(coll);
        this.editData.getSegEntry().addCollection(coll);
      } catch (BOSException e) {
        e.printStackTrace();
      }
    } else {
      this.currSeg = this.editData.getTotalSegment();
      if ((this.invProIdStr == null) && (this.editData != null) && (this.editData.getInvPro() != null))
        this.invProIdStr = this.editData.getInvPro().getId().toString();
      try
      {
        showInvData();
        loadTechAndBizPercent(this.editData.getInvPro());
        initBizPersonProperty();
      } catch (BOSException e) {
        handleException(e);
      } catch (EASBizException e) {
        handleException(e);
      }
      if (this.oprtState == OprtState.VIEW) {
        this.actionUpLoadFile.setEnabled(false);
        this.actionUpLoadContractFile.setEnabled(false);
      }

    }

    initStartBidInfo();

    ordSegentryInfo();
    initLimitModel(this.editData.getInvPro());
    setAppraisingProcessModelTable(this.kdtSegEntry);
    loadSegEntry(this.editData.getInvPro());

    super.loadFields();
    try {
      loadContractAddNew(this.editData.getInvPro());
      setEntryPermissionFiled();
      loadBindEntry2Entry(this.editData.getInvPro());
    } catch (BOSException e) {
      handUIExceptionAndAbort(e);
    }

    initLinsten();

    setEntryHighDataState();
    setAppraisingRankRequired();
    setFieldStatus();

    setEntryFileCount();
    processAttachments(this.kDPanel1, this.editData.getId() == null ? null : this.editData.getId().toString());
    processAttachments(this.kDPanel2, this.editData.getId() == null ? null : this.editData.getContractFileTmpID(), false);

    this.numWeight1.setValue(this.techPercent);
    this.numWeight2.setValue(this.bizPercent);

    calformateTotoalAmount();
  }

  private void setFieldStatus()
  {
    AppprasingMethodEnum method = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();
    if (AppprasingMethodEnum.COMBINEDPRICE == method);
  }

  private void setAppraisingRankRequired()
  {
    AppprasingMethodEnum method = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();
    Iterator it;
    if (AppprasingMethodEnum.COMBINEDPRICE == method)
      for (it = this.entryMap.keySet().iterator(); it.hasNext(); ) {
        KDTable entryTbl = (KDTable)this.entryMap.get(it.next());
        entryTbl.getColumn("appraiseRank").setRequired(true);
        for (int i = 0; i < entryTbl.getRowCount(); i++)
        {
          int apprainsing = entryTbl.getCell(i, "appraiseRank").getValue() == null ? 0 : Integer.parseInt(entryTbl.getCell(i, "appraiseRank").getValue().toString());
          if (apprainsing <= 0)
            entryTbl.getCell(i, "appraiseRank").setValue(null);
        }
      }
  }

  protected void ordSegentryInfo()
  {
    if (getOprtState() != OprtState.ADDNEW)
    {
      InviteAppraisingSegmentEntryInfo entryi = null;
      InviteAppraisingSegmentEntryInfo entryj = null;
      int min_index = -1;
      int minVal = 0;

      InviteAppraisingSegmentEntryCollection segEntrys = this.editData.getSegEntry();
      InviteAppraisingSegmentEntryCollection entrys = (InviteAppraisingSegmentEntryCollection)segEntrys.clone();
      segEntrys.clear();
      for (int i = entrys.size() - 1; i > 0; i--) {
        entryi = entrys.get(i);
        min_index = i;
        minVal = entryi.getAppraiseRank();
        for (int j = i - 1; j >= 0; j--) {
          entryj = entrys.get(j);

          if (minVal > entryj.getAppraiseRank()) {
            min_index = j;
            minVal = entryj.getAppraiseRank();
          }
        }
        segEntrys.addObjectDirect((InviteAppraisingSegmentEntryInfo)entrys.removeObject(min_index));
      }

      if (entrys.size() > 0) {
        segEntrys.addObjectDirect(entrys.getObject(0));
      }

      segEntrys.copyNewToOld();
    }
  }

  protected void initStartBidInfo() {
    if (this.startBidInfo == null) {
      EntityViewInfo view = new EntityViewInfo();
      FilterInfo filter = new FilterInfo();
      view.setFilter(filter);
      view.getSelector().add(new SelectorItemInfo("id"));
      view.getSelector().add(new SelectorItemInfo("isAgain"));
      view.getSelector().add(new SelectorItemInfo("againState"));
      filter.getFilterItems().add(new FilterItemInfo("inviteProject.id", this.editData.getInvPro().getId().toString()));
      try
      {
        StartBidCollection entryColl = StartBidFactory.getRemoteInstance().getStartBidCollection(view);
        if ((entryColl != null) && (entryColl.size() > 0))
          this.startBidInfo = entryColl.get(0);
      }
      catch (BOSException e) {
        handUIExceptionAndAbort(e);
      }
    }
  }

  private void getInviteBackBidRegByIsEanableOutNet()
  {
    if ((!getOprtState().equals(OprtState.VIEW)) && (!InviteParamFetcher.isEanableOutNet(null)))
      try {
        InviteBackBidRegInfo inviteBackBidRegInfo = null;
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("invPro.id", this.editData.getInvPro().getId().toString()));
        if (InviteBackBidRegFactory.getRemoteInstance().exists(filter))
        {
          inviteBackBidRegInfo = InviteBackBidRegFactory.getRemoteInstance().getInviteBackBidRegInfo("where invPro='" + this.editData.getInvPro().getId().toString() + "' ");
        }
        if (inviteBackBidRegInfo == null) {
          return;
        }

        InviteBackBidRegSupplierEntryCollection entry = inviteBackBidRegInfo.getSupplerEntrys();
        if (!entry.isEmpty()) {
          this.editData.getSegEntry().clear();
          int i = 0; for (int size = entry.size(); i < size; i++) {
            InviteBackBidRegSupplierEntryInfo backbidEntry = entry.get(i);
            if (backbidEntry.isIsBid()) {
              InviteAppraisingSegmentEntryInfo info = new InviteAppraisingSegmentEntryInfo();
              info.setSupplier(backbidEntry.getSupplier());
              info.setInvAppraising(this.editData);
              info.setProject(this.editData.getInvPro().getContractProEntry().get(0).getCurProject());
              info.setSegment(InviteProjectSegmentEnum.S0);
              this.editData.getSegEntry().add(info);
            }
          }
          if (this.editData.getId() == null) {
            IObjectPK pk = InviteAppraisingFactory.getRemoteInstance().save(this.editData);
            this.editData.setId(new ObjectUuidPK(pk.toString()).getKeyValue());
          } else {
            InviteAppraisingFactory.getRemoteInstance().update(new ObjectUuidPK(this.editData.getId()), this.editData);
          }
          this.editData = InviteAppraisingFactory.getRemoteInstance().getInviteAppraisingInfo(new ObjectUuidPK(this.editData.getId()), getSelectors());
        }
      }
      catch (Exception e) {
        handUIExceptionAndAbort(e);
      }
  }

  private void setEntryCaseAmountEnable()
  {
    if (InviteParamFetcher.isEanableOutNet(null)) {
      return;
    }

    for (Iterator it = this.entryMap.keySet().iterator(); it.hasNext(); ) {
      KDTable entryTbl = (KDTable)this.entryMap.get(it.next());
      entryTbl.getColumn("caseAmount").getStyleAttributes().setLocked(false);
    }
  }
  private void setEntryFileCount(IRow row, SupplierStockInfo supplier, InviteProjectInfo invInfo)
  {
    if (supplier != null) {
      PriceInfoForWebInfo tenderQInfo = null;
      try {
        tenderQInfo = getQuoteBill(invInfo.getId().toString(), supplier, QuotePriceTypeEnum.TENDER_QUOTE);
      } catch (EASBizException e) {
        handUIExceptionAndAbort(e);
      } catch (BOSException e) {
        handUIExceptionAndAbort(e);
      }

      if (tenderQInfo != null) {
        try {
          AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
          row.getCell("techCount").setValue(Integer.valueOf(acm.getAttachmentCountByBoID(tenderQInfo.getTechAttID())));
          row.getCell("bizCount").setValue(Integer.valueOf(acm.getAttachmentCountByBoID(tenderQInfo.getBizAttID())));
          String id=row.getCell("id").getValue().toString();
          row.getCell("quotePriceDcrp").setValue(Integer.valueOf(acm.getAttachmentCountByBoID(id)));
          
          
        } catch (BOSException e) {
          handUIExceptionAndAbort(e);
        }
      } else {
        row.getCell("techCount").setValue(Integer.valueOf(0));
        row.getCell("bizCount").setValue(Integer.valueOf(0));
        row.getCell("quotePriceDcrp").setValue(Integer.valueOf(0));
      }
    }
  }

  private PriceInfoForWebInfo getQuoteBill(String invProID, SupplierStockInfo supplier, QuotePriceTypeEnum quoteType)
    throws BOSException, EASBizException
  {
    if ((supplier == null) || (supplier.getId() == null)) {
      return null;
    }
    EntityViewInfo view = new EntityViewInfo();
    FilterInfo filter = new FilterInfo();
    view.setFilter(filter);
    filter.getFilterItems().add(new FilterItemInfo("supplier.id", supplier.getId().toString()));
    filter.getFilterItems().add(new FilterItemInfo("inviteProject.id", invProID));

    PriceInfoForWebInfo info = PriceInfoForWebFactory.getRemoteInstance().getVaildVersionInfo(new ObjectUuidPK(invProID), new ObjectUuidPK(supplier.getId()), quoteType, InviteTenderTypeEnum.INVITE_TYPE);

    return info;
  }

  private void setEntryFileCount()
  {
    AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();
    for (Iterator it = this.entryMap.keySet().iterator(); it.hasNext(); ) {
      KDTable entryTbl = (KDTable)this.entryMap.get(it.next());
      entryTbl.getColumn("techCount").getStyleAttributes().setFontColor(Color.blue);
      entryTbl.getColumn("bizCount").getStyleAttributes().setFontColor(Color.blue);
      entryTbl.getColumn("quotePriceDcrp").getStyleAttributes().setFontColor(Color.blue);
      
      entryTbl.getColumn("techCount").getStyleAttributes().setHided(false);
      entryTbl.getColumn("bizCount").getStyleAttributes().setHided(false);
      entryTbl.getColumn("techCount").getStyleAttributes().setLocked(true);
      entryTbl.getColumn("bizCount").getStyleAttributes().setLocked(true);
      for (int i = 0; i < entryTbl.getRowCount(); i++) {
        IRow row = entryTbl.getRow(i);
        SupplierStockInfo supplier = (SupplierStockInfo)row.getCell("supplier").getValue();
        if (supplier != null) {
          PriceInfoForWebInfo tenderQInfo = null;
          if (!this.tenderQInfoMap.containsKey(supplier.getId().toString()))
            try {
              tenderQInfo = getQuoteBill(this.editData.getInvPro(), supplier, QuotePriceTypeEnum.TENDER_QUOTE);
            } catch (EASBizException e) {
              handUIExceptionAndAbort(e);
            } catch (BOSException e) {
              handUIExceptionAndAbort(e);
            }
          else {
            tenderQInfo = (PriceInfoForWebInfo)this.tenderQInfoMap.get(supplier.getId().toString());
          }

          if (tenderQInfo != null) {
            try {
              row.getCell("techCount").setValue(Integer.valueOf(acm.getAttachmentCountByBoID(tenderQInfo.getTechAttID())));
              row.getCell("bizCount").setValue(Integer.valueOf(acm.getAttachmentCountByBoID(tenderQInfo.getBizAttID())));
              if(row.getCell("id").getValue()!=null){
            	  String id=row.getCell("id").getValue().toString();
                  row.getCell("quotePriceDcrp").setValue(Integer.valueOf(acm.getAttachmentCountByBoID(id)));
              }
            } catch (BOSException e) {
              handUIExceptionAndAbort(e);
            }
          } else {
            row.getCell("techCount").setValue(Integer.valueOf(0));
            row.getCell("bizCount").setValue(Integer.valueOf(0));
            row.getCell("quotePriceDcrp").setValue(Integer.valueOf(0));
            
          }
        }
      }
    }
  }

  protected void initLimitModel(InviteProjectInfo inviteInfo)
  {
    if (inviteInfo != null) {
      StartBidModelEnum model = inviteInfo.getStartBidModel();
      if ((model == null) && (inviteInfo.getId() != null)) {
        try {
          InviteProjectInfo tempInfo = InviteProjectFactory.getRemoteInstance().getInviteProjectInfo(new ObjectUuidPK(inviteInfo.getId()));

          model = tempInfo.getStartBidModel();
        } catch (EASBizException e) {
          handUIException(e);
        } catch (BOSException e) {
          handUIException(e);
        }
      }
      if (!StartBidModelEnum.LIMITED_MODEL.equals(model))
        this.isLimitModel = false;
      else
        this.isLimitModel = true;
    }
    else {
      this.isLimitModel = true;
    }
  }

  private void initSegment(InviteProjectInfo inviteInfo) {
    EntityViewInfo view = new EntityViewInfo();
    FilterInfo filter = new FilterInfo();
    view.setFilter(filter);
  }

  private void setEntryPermissionFiled()
  {
    int count = this.kdtSegEntry.getRowCount();
    for (int i = 0; i < count; i++) {
      this.kdtSegEntry.getCell(i, "askAmountP").setValue("*");
      this.kdtSegEntry.getCell(i, "caseAmountP").setValue("*");
      this.kdtSegEntry.getCell(i, "amendAmountP").setValue("*");
      this.kdtSegEntry.getCell(i, "clarifyAmountP").setValue("*");
      this.kdtSegEntry.getCell(i, "clarAmendAmountP").setValue("*");
    }
  }

  private KDBizPromptBox getF7Supplier()
  {
    KDBizPromptBox supplierF7 = new KDBizPromptBox();
    String cuId = SysContext.getSysContext().getCurrentCtrlUnit().getId().toString();
    supplierF7.setQueryInfo("com.kingdee.eas.fdc.invite.supplier.app.F7SupplierStockQuery");
    supplierF7.setEditable(true);
    supplierF7.setDisplayFormat("$name$");
    supplierF7.setEditFormat("$name$");
    supplierF7.setCommitFormat("$name$");
    supplierF7.setRequired(true);
    supplierF7.setEnabledMultiSelection(true);
    return supplierF7;
  }

  private IRow initAddRow(KDTable table) {
    IRow row = table.addRow();
    KDBizPromptBox supplierf7 = getF7Supplier();
    row.getCell("supplier").setEditor(new KDTDefaultCellEditor(supplierf7));

    row.getCell("askAmount").setEditor(FDCClientHelper.getNumberEditor());
    row.getCell("caseAmount").setEditor(FDCClientHelper.getNumberEditor());
    row.getCell("amendAmount").setEditor(FDCClientHelper.getNumberEditor());
    row.getCell("clarifyAmount").setEditor(FDCClientHelper.getNumberEditor());
    KDComboBox tmpComBox = new KDComboBox();
    tmpComBox.addItems(EnumUtils.getEnumList("com.kingdee.eas.fdc.invite.news.AppraisingInvaildReasonEnum").toArray());
    row.getCell("invalidReason").setEditor(new KDTDefaultCellEditor(tmpComBox));
    row.getCell("dicountRate").setEditor(FDCClientHelper.getNumberEditor());
    row.getCell("appraisingAmount").setEditor(FDCClientHelper.getNumberEditor());
    row.getCell("finalAmount").setEditor(FDCClientHelper.getNumberEditor());
    row.getCell("techScore").setEditor(FDCClientHelper.getNumberEditor());
    row.getCell("busScore").setEditor(FDCClientHelper.getNumberEditor());
    row.getCell("comScore").setEditor(FDCClientHelper.getNumberEditor());
    row.getCell("busNeogiateAmount").setEditor(FDCClientHelper.getNumberEditor());
    row.getCell("isRecommand").setValue(Boolean.FALSE);
    return row;
  }

  public void onLoad() throws Exception
  {
    this.isView = ((Boolean)getUIContext().get("isView"));
    this.isBizPerson = ((Boolean)getUIContext().get("isBizPerson"));
    setQueryPreference(false);
    this.pnlAttBound = ((Rectangle)this.kDPanel1.getBounds().clone());
    this.contEntrBound = ((Rectangle)this.kDPanel2.getBounds().clone());

    setPreferredSize(new Dimension(870, 600));
    super.onLoad();

    this.kdpnl.putClientProperty("OriginalBounds", new Rectangle(0, 0, 849, 446));

    this.kdtSegEntry.setVisible(false);
    this.contSeg1.setVisible(false);

    this.actionTenderNotice.putValue("SmallIcon", EASResource.getIcon("imgTbtn_accept"));
    this.actionThanksLetter.putValue("SmallIcon", EASResource.getIcon("imgTbtn_accept"));
    if (InviteParamFetcher.isEanableOutNet(null)) {
      this.actionTenderNotice.setVisible(true);
      this.actionThanksLetter.setVisible(true);
    } else {
      this.actionTenderNotice.setVisible(false);
      this.actionThanksLetter.setVisible(false);
    }

    this.actionAuditResult.setVisible(false);
    this.btnPriceImport.setVisible(false);
    this.btnClarify.setVisible(true);

    if (FDCBillStateEnum.AUDITTED.equals(this.editData.getState()))
      this.actionBidNotice.setEnabled(true);
    else {
      this.actionBidNotice.setEnabled(false);
    }

    if ((OprtState.ADDNEW.equals(getOprtState())) || (OprtState.EDIT.equals(getOprtState()))) {
      setEntryCaseAmountEnable();
    }
    setWokflowButtonStyle();
  }

  protected void checkTableParsed()
  {
    super.checkTableParsed();

    if (!this.isEnabledYGZ) {
      this.kdCtrlIncTaxAmt.setVisible(false);
      this.kdBidTaxMny.setVisible(false);
      this.kdBidTax.setVisible(false);

      this.contProcessDes.setBounds(new Rectangle(10, 68, 849, 101));
      add(this.contProcessDes, new KDLayout.Constraints(10, 68, 849, 101, 13));

      this.dataBinder.unRegisterBinding("segEntry.caseCtrlVAT", BigDecimal.class, this.kdtSegEntry, "caseCtrlVAT.text");
      this.dataBinder.unRegisterBinding("segEntry.caseCtrlIncTaxAmt", BigDecimal.class, this.kdtSegEntry, "caseCtrlIncTaxAmt.text");
      this.dataBinder.unRegisterBinding("segEntry.clarifyCtrlVAT", BigDecimal.class, this.kdtSegEntry, "clarifyCtrlVAT.text");
      this.dataBinder.unRegisterBinding("segEntry.clarifyCtrlIncTaxAmt", BigDecimal.class, this.kdtSegEntry, "clarifyCtrlIncTaxAmt.text");
      this.dataBinder.unRegisterBinding("segEntry.finalCtrlVAT", BigDecimal.class, this.kdtSegEntry, "finalCtrlVAT.text");
      this.dataBinder.unRegisterBinding("segEntry.finalCtrlIncTaxAmt", BigDecimal.class, this.kdtSegEntry, "finalCtrlIncTaxAmt.text");
      this.kdtSegEntry.removeColumn(this.kdtSegEntry.getColumnIndex("caseCtrlVAT"));
      this.kdtSegEntry.removeColumn(this.kdtSegEntry.getColumnIndex("caseCtrlIncTaxAmt"));
      this.kdtSegEntry.removeColumn(this.kdtSegEntry.getColumnIndex("clarifyCtrlVAT"));
      this.kdtSegEntry.removeColumn(this.kdtSegEntry.getColumnIndex("clarifyCtrlIncTaxAmt"));
      this.kdtSegEntry.removeColumn(this.kdtSegEntry.getColumnIndex("finalCtrlVAT"));
      this.kdtSegEntry.removeColumn(this.kdtSegEntry.getColumnIndex("finalCtrlIncTaxAmt"));
    }
  }

  protected void fetchInitParam()
    throws Exception
  {
    super.fetchInitParam();

    if (getUIContext().get("IsEnabledYGZ") != null) {
      this.isEnabledYGZ = ((Boolean)getUIContext().get("IsEnabledYGZ")).booleanValue();
    }

    initEntryUI();
  }

  protected void setWokflowButtonStyle()
  {
    this.menuWorkflow.setVisible(true);
    this.MenuItemWFG.setVisible(true);
    this.MenuItemWFG.setEnabled(true);
    this.menuItemWorkFlowList.setVisible(true);
    this.menuItemMultiapprove.setVisible(true);
    this.menuItemNextPerson.setVisible(true);
    this.menuItemAuditResult.setVisible(true);
    this.btnAuditResult.setVisible(true);
    this.btnAuditResult.setEnabled(true);
    this.btnWorkFlowG.setVisible(true);
    this.btnWorkFlowG.setEnabled(true);
  }

  private void initBizPersonProperty()
    throws BOSException, EASBizException
  {
    if ((this.isBizPerson == null) && (this.isView == null)) {
      String invProId = this.editData.getInvPro().getId().toString();

      PersonInfo personInfo = SysContext.getSysContext().getCurrentUserInfo().getPerson();
      String curPersonId = personInfo == null ? "" : personInfo.getId().toString();
      EntityViewInfo view = new EntityViewInfo();
      FilterInfo filter = new FilterInfo();
      view.setFilter(filter);

      filter.getFilterItems().add(new FilterItemInfo("parent.id", invProId));
      filter.getFilterItems().add(new FilterItemInfo("invProHanlderType", "9BUSEVAH"));
      filter.getFilterItems().add(new FilterItemInfo("invProHanlderType", "8TECEVAH"));
      filter.getFilterItems().add(new FilterItemInfo("person.id", curPersonId));
      filter.setMaskString("#0 and (#1 or #2) and #3");
      AuthorizedPersonCollection authColl = AuthorizedPersonFactory.getRemoteInstance().getAuthorizedPersonCollection(view);
      boolean isView = false;
      for (int i = 0; i < authColl.size(); i++)
      {
        if (InvProHandlerTypeEnum.BussinessEvaluator.equals(authColl.get(i).getInvProHanlderType())) {
          this.isBizPerson = Boolean.TRUE;
          isView = authColl.get(i).isIsView();
          break;
        }if (!InvProHandlerTypeEnum.TechnicalEvaluator.equals(authColl.get(i).getInvProHanlderType()))
          continue;
        this.isBizPerson = Boolean.FALSE;
      }

      if (this.isBizPerson == null) {
        this.isBizPerson = Boolean.FALSE;
      }

      this.isView = Boolean.valueOf(isView);
    }
  }

  protected void initWorkButton() {
    super.initWorkButton();
    this.actionAddNew.setVisible(false);
    this.actionTraceDown.setVisible(false);
    this.actionTraceUp.setVisible(false);
    this.actionFirst.setVisible(false);
    this.actionPre.setVisible(false);
    this.actionNext.setVisible(false);
    this.actionLast.setVisible(false);
    this.actionCreateFrom.setVisible(false);
    this.actionCreateTo.setVisible(false);
    this.actionCopy.setVisible(false);
    this.actionNextPerson.setVisible(false);
    this.actionMultiapprove.setVisible(false);
    this.actionWorkflowList.setVisible(false);
    this.actionWorkFlowG.setVisible(false);
    this.actionCalculator.setVisible(false);
    this.actionRemove.setVisible(false);
    this.actionCopyFrom.setVisible(false);

    this.actionAddLine.setVisible(false);
    this.actionRemoveLine.setVisible(false);
    this.actionInsertLine.setVisible(false);

    this.actionUpLoadFile.setEnabled(true);
    this.actionUpLoadContractFile.setEnabled(true);

    this.chkMenuItemSubmitAndAddNew.setVisible(false);
    this.chkMenuItemSubmitAndAddNew.setSelected(false);

    this.actionAddChecker.setEnabled(true);
    if (InviteParamFetcher.isEanableOutNet(null)) {
      this.actionInvFile.setEnabled(true);
    }
    this.actionClarify.setEnabled(true);
    if ((this.isView != null) && (this.isView.booleanValue())) {
      this.actionEdit.setEnabled(false);
      this.actionEdit.setVisible(false);
    }
    this.actionRefresh.setEnabled(false);
    this.actionRefresh.setVisible(false);
    this.btnBidNotice.setIcon(EASResource.getIcon("imgTbtn_bluepencil"));
    this.btnPriceImport.setIcon(EASResource.getIcon("imgTbtn_input"));

    this.btnBussAppraising.setVisible(false);
    this.actionBidNotice.setVisible(false);
  }

  protected void setAuditButtonStatus(String oprtType)
  {
    this.actionAudit.setVisible(false);
    this.actionUnAudit.setVisible(false);
    this.actionAudit.setEnabled(false);
    this.actionUnAudit.setEnabled(false);

    if ((this.oprtState == OprtState.VIEW) && (this.editData != null) && 
      (!FDCBillStateEnum.SAVED.equals(this.editData.getState())) && (!FDCBillStateEnum.SUBMITTED.equals(this.editData.getState())))
      this.actionEdit.setEnabled(false);
  }

  public void setOprtState(String oprtType)
  {
    super.setOprtState(oprtType);
    if (OprtState.EDIT.equals(getOprtState())) {
      this.actionUpLoadFile.setEnabled(true);
      this.actionUpLoadContractFile.setEnabled(true);
    } else {
      this.actionUpLoadFile.setEnabled(false);
      this.actionUpLoadContractFile.setEnabled(false);
    }
  }

  protected void updateButtonStatus()
  {
    super.updateButtonStatus();
    this.actionSubmit.setEnabled(false);
  }

  protected boolean isShowAttachmentAction() {
    return false;
  }

  protected IObjectValue createNewData() {
    InviteAppraisingInfo invAppr = new InviteAppraisingInfo();
    if ((getUIContext().get("org") != null) && ((getUIContext().get("org") instanceof FullOrgUnitInfo))) {
      invAppr.setOrgUnit((FullOrgUnitInfo)getUIContext().get("org"));
    }
    if ((getUIContext().get("project") != null) && ((getUIContext().get("project") instanceof CurProjectInfo))) {
      invAppr.setProject((CurProjectInfo)getUIContext().get("project"));
    }
    invAppr.setContractFileTmpID(BOSUuid.create("D9F05C62").toString());
    if (getUIContext().get("invPro") != null) {
      InviteProjectInfo invPro = null;
      this.invProIdStr = getUIContext().get("invPro").toString();
      try {
        SelectorItemCollection sels = new SelectorItemCollection();
        sels.add("name");
        sels.add("number");
        sels.add("orgUnit");
        sels.add(new SelectorItemInfo("contractProEntry.*"));
        sels.add(new SelectorItemInfo("contractProEntry.curProject.*"));
        invPro = InviteProjectFactory.getRemoteInstance().getInviteProjectInfo(new ObjectUuidPK(BOSUuid.read(this.invProIdStr)), sels);
      } catch (EASBizException e) {
        handUIExceptionAndAbort(e);
      } catch (BOSException e) {
        handUIExceptionAndAbort(e);
      } catch (UuidException e) {
        handUIExceptionAndAbort(e);
      }
      invAppr.setInvPro(invPro);
      invAppr.setTotalSegment(invPro.getSegments());
    }
    return invAppr;
  }

  protected void refreshAttachLabels()
    throws BOSException
  {
    this.kDPanel1.removeAll();
    AttachmentCollection attachs = null;
    attachs = AttachmentUtils.getAttachmentsByBoID(getSelectBOID());

    String name = "";
    Iterator it;
    if ((attachs != null) && (attachs.size() > 0)) {
      for (it = attachs.iterator(); it.hasNext(); ) {
        AttachmentInfo tmpAttch = (AttachmentInfo)it.next();
        name = name + tmpAttch.getName() + ";  ";
      }
    }

    KDLabel label = new KDLabel();
    label.setText(name);
    label.setForeground(Color.BLUE);
    Dimension d = new Dimension(650, 20);
    label.setSize(d);
    this.kDPanel1.add(label);
  }

  protected void comboAppraisingProcess_itemStateChanged(ItemEvent e)
    throws Exception
  {
    for (Iterator it = this.entryMap.keySet().iterator(); it.hasNext(); ) {
      KDTable table = (KDTable)this.entryMap.get(it.next());
      setAppraisingProcessModelTable(table);
    }
  }

  protected void tblDetail_tableSelectChanged(KDTSelectEvent e) throws Exception
  {
    super.tblDetail_tableSelectChanged(e);
    KDTable selsTable = (KDTable)e.getSource();
    int index = selsTable.getSelectManager().getActiveRowIndex();
    IRow row = selsTable.getRow(index);
    if (row.getCell("id").getValue() != null) {
      String id = row.getCell("id").getValue().toString();
      UIContext uiContext = new UIContext(this);
      IUIWindow uiWindow = null;
      uiContext.put("entryParent.id", id);
      try {
        uiWindow = UIFactory.createUIFactory("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(InvApprasSegAmtRecListUI.class.getName(), uiContext, null, OprtState.VIEW);
      }
      catch (UIException e1) {
        handUIException(e1);
      }
      uiWindow.show();
    }
  }

  public void actionClarify_actionPerformed(ActionEvent e)
    throws Exception
  {
    if (!this.oprtState.equals("ADDNEW")) {
      UIContext uiContext = new UIContext(this);
      uiContext.put("UINumber", new Integer(0));
      uiContext.put("info", this.editData);
      IUIWindow uiWindow = null;
      try {
        uiWindow = UIFactory.createUIFactory("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(ClarifyQuoteUI.class.getName(), uiContext, null, OprtState.VIEW);
      }
      catch (UIException e1) {
        handUIException(e1);
      }

      ClarifyQuoteUI ui = (ClarifyQuoteUI)uiWindow.getUIObject();
      uiWindow.show();
      if (ui.isIsClar()) {
        this.chkIsClearfy.setSelected(true);
        this.editData.setIsClearfy(true);
        this.actionClarify.setEnabled(false);
      }
    }
    else {
      FDCMsgBox.showWarning(this, "ȱ浥");
      abort();
    }
  }

  public void actionInvFile_actionPerformed(ActionEvent e)
    throws Exception
  {
    AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();

    boolean isEdit = false;
    if ((OprtState.EDIT.equals(getOprtState())) || (OprtState.ADDNEW.equals(getOprtState()))) {
      isEdit = true;
    }
    AttachmentUIContextInfo info = getAttacheInfo();
    if (info == null)
      info = new AttachmentUIContextInfo();
    if ((info.getBoID() == null) || (info.getBoID().trim().equals(""))) {
      String boID = getSelectBOID();
      if (boID == null) {
        if (OprtState.ADDNEW.equals(getOprtState())) {
          if (this.attachMentTempID == null) {
            boID = acm.getAttID().toString();
            this.attachMentTempID = boID;
          } else {
            boID = this.attachMentTempID;
          }
        }
        else return;
      }

      info.setBoID(boID);
    }

    info.setEdit(isEdit);

    String multi = (String)getUIContext().get("MultiapproveAttachment");
    if ((multi != null) && (multi.equals("true")))
      acm.showAttachmentListUIByBoIDNoAlready(this, info);
    else
      acm.showAttachmentListUIByBoID(this, info);
  }

  protected void showAttachmentByEval(String boID)
  {
    AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();

    AttachmentUIContextInfo info = new AttachmentUIContextInfo();

    info.setBoID(boID);
    info.setEdit(false);

    String multi = (String)getUIContext().get("MultiapproveAttachment");
    if ((multi != null) && (multi.equals("true")))
      acm.showAttachmentListUIByBoIDNoAlready(this, info);
    else
      acm.showAttachmentListUIByBoID(this, info);
  }

  public void actionAddChecker_actionPerformed(ActionEvent e)
    throws Exception
  {
    String invProID = null;
    if (getUIContext().get("invPro") != null) {
      invProID = getUIContext().get("invPro").toString();
    }
    if ((invProID == null) && (this.editData.getInvPro() != null)) {
      invProID = this.editData.getInvPro().getId().toString();
    }
    if (invProID == null) {
      FDCMsgBox.showWarning("δѡб!");
      SysUtil.abort();
    }

    UIContext uiContext = new UIContext(this);
    uiContext.put("invPro", this.editData.getInvPro());

    IUIWindow guideF = UIFactory.createUIFactory("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(CheckerPerosonListUI.class.getName(), uiContext, null, OprtState.VIEW);

    guideF.show();
  }

  private BigDecimal getLowPrice(KDTable table)
  {
    IRow row = null;
    Object obj = null;
    BigDecimal price = new BigDecimal("0");
    BigDecimal tempPrice = new BigDecimal("0");
    AppprasingMethodEnum method = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();
    boolean isfirst = true;
    for (int i = 0; i < table.getRowCount(); i++) {
      row = table.getRow(i);
      AppraisingInvaildReasonEnum reason = (AppraisingInvaildReasonEnum)row.getCell("invalidReason").getValue();
      if ((reason == null) || (reason.equals(AppraisingInvaildReasonEnum.NULL))) {
        obj = getAmount(row, method);
        if (obj != null) {
          if (isfirst) {
            price = new BigDecimal(obj.toString());
            isfirst = false;
          }
          tempPrice = new BigDecimal(obj.toString());
          if (price.compareTo(tempPrice) > 0) {
            price = tempPrice;
          }
        }
      }
    }
    return price;
  }

  private void getEntryLowPrice()
  {
    this.entryPriceMap = new HashMap();
    KDTable entryTbl = null;
    IRow row = null;
    Object obj = null;
    BigDecimal price = new BigDecimal("0");
    for (Iterator it = this.entryMap.keySet().iterator(); it.hasNext(); ) {
      entryTbl = (KDTable)this.entryMap.get(it.next());
      for (int i = 0; i < entryTbl.getRowCount(); i++) {
        row = entryTbl.getRow(i);
        AppraisingInvaildReasonEnum reason = (AppraisingInvaildReasonEnum)row.getCell("invalidReason").getValue();
        if ((reason == null) || (reason.equals(AppraisingInvaildReasonEnum.NULL))) {
          obj = row.getCell("amendAmount").getValue() == null ? row.getCell("caseAmount").getValue() : row.getCell("amendAmount").getValue();

          if (obj != null) {
            price = new BigDecimal(obj.toString());
            if (this.entryPriceMap.containsKey(entryTbl)) {
              if (((BigDecimal)this.entryPriceMap.get(entryTbl)).compareTo(price) > 0)
                this.entryPriceMap.put(entryTbl, price);
            }
            else {
              this.entryPriceMap.put(entryTbl, price);
            }
          }
        }
        else if (reason.equals(AppraisingInvaildReasonEnum.NULL)) {
          lockRowCell(row, false);
          row.getStyleAttributes().setBackground(Color.WHITE);
        } else {
          lockRowCell(row, true);
          row.getStyleAttributes().setBackground(Color.gray);
        }
      }
    }

    setEntryDataState();
  }

  private void setEntryDataState()
  {
    KDTable entryTbl = null;
    IRow row = null;
    Object obj = null;
    BigDecimal price = new BigDecimal("0");
    BigDecimal mapPrice = new BigDecimal("0");
    BigDecimal wightsPrice = new BigDecimal("0");
    BigDecimal wightsMapPrice = new BigDecimal("0");
    BigDecimal wights = new BigDecimal("0");
    BigDecimal temps = new BigDecimal("0");
    for (Iterator it = this.entryPriceMap.keySet().iterator(); it.hasNext(); ) {
      entryTbl = (KDTable)it.next();
      mapPrice = (BigDecimal)this.entryPriceMap.get(entryTbl);
      for (int i = 0; i < entryTbl.getRowCount(); i++) {
        row = entryTbl.getRow(i);
        AppraisingInvaildReasonEnum reason = (AppraisingInvaildReasonEnum)row.getCell("invalidReason").getValue();
        if ((reason != null) && (!reason.equals(AppraisingInvaildReasonEnum.NULL)))
          continue;
        row.getStyleAttributes().setLocked(false);
        row.getStyleAttributes().setBackground(Color.white);

        obj = row.getCell("amendAmount").getValue() == null ? row.getCell("caseAmount").getValue() : row.getCell("amendAmount").getValue();

        if (obj != null) {
          price = new BigDecimal(obj.toString());
          temps = price.add(mapPrice);
          wightsPrice = price.divide(temps, 6, 0);
          wightsMapPrice = mapPrice.divide(temps, 6, 0);
          wights = wightsPrice.subtract(wightsMapPrice).multiply(new BigDecimal(100));
          if (wights.compareTo(new BigDecimal("5")) >= 0) {
            row.getStyleAttributes().setLocked(true);
            row.getStyleAttributes().setBackground(Color.gray);
          }
        }
      }
    }
  }

  private Map getEntryHighPrice()
  {
    Map entryHighMap = new HashMap();
    KDTable entryTbl = null;
    IRow row = null;
    Object obj = null;
    BigDecimal price = new BigDecimal("0");
    AppraisingInvaildReasonEnum reason = null;
    for (Iterator it = this.entryMap.keySet().iterator(); it.hasNext(); ) {
      entryTbl = (KDTable)this.entryMap.get(it.next());
      for (int i = 0; i < entryTbl.getRowCount(); i++) {
        row = entryTbl.getRow(i);
        reason = (AppraisingInvaildReasonEnum)row.getCell("invalidReason").getValue();
        if ((reason == null) || (reason.equals(AppraisingInvaildReasonEnum.NULL))) {
          obj = row.getCell("amendAmount").getValue() == null ? row.getCell("caseAmount").getValue() : row.getCell("amendAmount").getValue();

          if (obj != null) {
            price = new BigDecimal(obj.toString());
            if (entryHighMap.containsKey(entryTbl)) {
              if (((BigDecimal)entryHighMap.get(entryTbl)).compareTo(price) < 0)
                entryHighMap.put(entryTbl, price);
            }
            else {
              entryHighMap.put(entryTbl, price);
            }
          }
        }
      }
    }
    return entryHighMap;
  }

  private void setEntryHighDataState()
  {
    Map entryHighMap = getEntryHighPrice();
    KDTable entryTbl = null;
    IRow row = null;
    Object obj = null;
    BigDecimal price = new BigDecimal("0");
    BigDecimal mapPrice = new BigDecimal("0");
    AppraisingInvaildReasonEnum reason = null;
    for (Iterator it = entryHighMap.keySet().iterator(); it.hasNext(); ) {
      entryTbl = (KDTable)it.next();
      mapPrice = (BigDecimal)entryHighMap.get(entryTbl);
      if (entryTbl.getRowCount() < 2) {
        continue;
      }
      for (int i = 0; i < entryTbl.getRowCount(); i++) {
        row = entryTbl.getRow(i);
        reason = (AppraisingInvaildReasonEnum)row.getCell("invalidReason").getValue();
        if ((reason == null) || (reason.equals(AppraisingInvaildReasonEnum.NULL)))
        {
          row.getStyleAttributes().setLocked(false);
          row.getStyleAttributes().setBackground(Color.white);

          if (!row.getCell("techScore").getStyleAttributes().isHided())
          {
            row.getCell("techScore").getStyleAttributes().setBackground(new Color(252, 251, 223));
            row.getCell("busScore").getStyleAttributes().setBackground(new Color(252, 251, 223));
          }

          obj = row.getCell("amendAmount").getValue() == null ? row.getCell("caseAmount").getValue() : row.getCell("amendAmount").getValue();
        }
        else if (reason.equals(AppraisingInvaildReasonEnum.NULL)) {
          lockRowCell(row, false);
          row.getStyleAttributes().setBackground(Color.WHITE);
        } else {
          lockRowCell(row, true);
          row.getStyleAttributes().setBackground(Color.gray);
        }

        setCellBackGroud(row);
      }
    }
  }

  private void setCellBackGroud(IRow row)
  {
    BigDecimal amount = new BigDecimal("0");
    String appMethod = ((AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem()).getValue();
    boolean isRecommand = ((Boolean)row.getCell("isRecommand").getValue()).booleanValue();
    if (isRecommand) {
      if (appMethod.equals("1REALOWPRICE")) {
        amount = row.getCell("finalAmount").getValue() != null ? new BigDecimal(row.getCell("finalAmount").getValue().toString()) : new BigDecimal("0");
      }
      else {
        amount = row.getCell("busNeogiateAmount").getValue() != null ? new BigDecimal(row.getCell("busNeogiateAmount").getValue().toString()) : new BigDecimal("0");
      }

      if (amount.compareTo(new BigDecimal("0")) == 0) {
        if ((row.getCell("clarAmendAmount").getValue() == null) || (new BigDecimal(row.getCell("clarAmendAmount").getValue().toString()).compareTo(new BigDecimal("0")) == 0))
        {
          if ((row.getCell("clarifyAmount").getValue() == null) || (new BigDecimal(row.getCell("clarifyAmount").getValue().toString()).compareTo(new BigDecimal("0")) == 0))
          {
            if ((row.getCell("amendAmount").getValue() == null) || (new BigDecimal(row.getCell("amendAmount").getValue().toString()).compareTo(new BigDecimal("0")) == 0))
            {
              if ((row.getCell("caseAmount").getValue() == null) || (new BigDecimal(row.getCell("caseAmount").getValue().toString()).compareTo(new BigDecimal("0")) != 0))
              {
                row.getCell("caseAmount").getStyleAttributes().setBackground(Color.yellow);
              }
            }
            else row.getCell("amendAmount").getStyleAttributes().setBackground(Color.yellow);
          }
          else
            row.getCell("clarifyAmount").getStyleAttributes().setBackground(Color.yellow);
        }
        else {
          row.getCell("clarAmendAmount").getStyleAttributes().setBackground(Color.yellow);
        }
      }
      else if (appMethod.equals("1REALOWPRICE"))
        row.getCell("finalAmount").getStyleAttributes().setBackground(Color.yellow);
      else
        row.getCell("busNeogiateAmount").getStyleAttributes().setBackground(Color.yellow);
    }
  }

  protected void btnAppraising_actionPerformed(ActionEvent e)
    throws Exception
  {
    this.chkAppraising.setSelected(true);
    this.editData.setAppraising(true);

    comboAppraisingProcess_itemStateChanged(null);
    this.clcikAppraising = true;
  }

  protected void btnBussAppraising_actionPerformed(ActionEvent e)
    throws Exception
  {
    this.chkBizNegoiate.setSelected(true);
    this.editData.setBizNegoiate(true);

    comboAppraisingProcess_itemStateChanged(null);
  }

  protected void btnSign_actionPerformed(ActionEvent e)
    throws Exception
  {
  }

  protected void btnInvFile_actionPerformed(ActionEvent e)
    throws Exception
  {
  }

  protected void attachListeners()
  {
  }

  protected void detachListeners()
  {
  }

  protected ICoreBase getBizInterface()
    throws Exception
  {
    return InviteAppraisingFactory.getRemoteInstance();
  }

  protected KDTable getDetailTable() {
    return null;
  }

  protected KDTextField getNumberCtrl() {
    return new KDTextField();
  }

  public SelectorItemCollection getSelectors()
  {
    SelectorItemCollection sic = super.getSelectors();

    sic.add(new SelectorItemInfo("id"));
    sic.add(new SelectorItemInfo("state"));
    sic.add(new SelectorItemInfo("totalSegment"));
    sic.add(new SelectorItemInfo("invPro.inviteType.*"));
    sic.add(new SelectorItemInfo("invPro.inviteMethod"));

    sic.add(new SelectorItemInfo("invPro.inviteType.contractType.*"));
    sic.add(new SelectorItemInfo("invPro.contractProEntry.*"));
    sic.add(new SelectorItemInfo("invPro.contractProEntry.curProject.*"));
    sic.add(new SelectorItemInfo("invPro.contractProEntry.contractPro.*"));
    sic.add(new SelectorItemInfo("invPro.contractProEntry.contractPro.name"));
    sic.add(new SelectorItemInfo("invPro.contractProEntry.contractPro.controlAmount"));
    sic.add(new SelectorItemInfo("invPro.orgUnit.id"));
    sic.add(new SelectorItemInfo("invPro.orgUnit.number"));
    sic.add(new SelectorItemInfo("invPro.orgUnit.name"));
    sic.add(new SelectorItemInfo("clarifyCutoffTime"));
    sic.add(new SelectorItemInfo("isDistributeNet"));
    sic.add(new SelectorItemInfo("contractFileTmpID"));
    sic.add(new SelectorItemInfo("segEntry.*"));

    sic.add(new SelectorItemInfo("orgUnit.id"));
    sic.add(new SelectorItemInfo("orgUnit.name"));
    sic.add(new SelectorItemInfo("bidMny"));

    if (this.isEnabledYGZ) {
      sic.add(new SelectorItemInfo("bidTaxmny"));
      sic.add(new SelectorItemInfo("bidTax"));
    }

    sic.add(new SelectorItemInfo("isDisThankLetterNet"));
    return sic;
  }

  public void actionRefresh_actionPerformed(ActionEvent e)
    throws Exception
  {
    if (this.editData.getId() == null) {
      return;
    }
    inOnload();
    getUILifeCycleHandler().fireAfterLoadField(this, this.editData);
    initOldData(this.editData);
    showMessageForStatus();
  }

  public void actionSubmit_actionPerformed(ActionEvent e)
    throws Exception
  {
    super.actionSubmit_actionPerformed(e);
  }

  protected void verifyInputForSubmint()
    throws Exception
  {
    super.verifyInputForSubmint();

    if (this.comboApprasingMethod.getSelectedItem() == AppprasingMethodEnum.COMBINEDPRICE)
    {
      if ((this.clcikAppraising) || (this.editData.isAppraising())) {
        Iterator keys = this.entryMap.keySet().iterator();
        while (keys.hasNext()) {
          KDTable table = (KDTable)this.entryMap.get(keys.next());
          for (int i = 0; i < table.getRowCount(); i++) {
            BigDecimal tech = (BigDecimal)table.getRow(i).getCell("techScore").getValue();
            BigDecimal biz = (BigDecimal)table.getRow(i).getCell("busScore").getValue();
            int apprainsing = table.getCell(i, "appraiseRank").getValue() == null ? 0 : Integer.parseInt(table.getCell(i, "appraiseRank").getValue().toString());
            AppraisingInvaildReasonEnum reason = (AppraisingInvaildReasonEnum)table.getRow(i).getCell("invalidReason").getValue();
            if (((tech == null) || (biz == null) || (apprainsing <= 0)) && ((reason == null) || (AppraisingInvaildReasonEnum.NULL == reason))) {
              MsgBox.showError(this, "¼δ");
              SysUtil.abort();
            }
          }
        }
      }
    }
    checkCanBid();
  }

  public void actionAttachment_actionPerformed(ActionEvent e)
    throws Exception
  {
    AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();

    boolean isEdit = false;
    if ((OprtState.EDIT.equals(getOprtState())) || (OprtState.ADDNEW.equals(getOprtState()))) {
      isEdit = true;
    }
    AttachmentUIContextInfo info = getAttacheInfo();
    if (info == null)
      info = new AttachmentUIContextInfo();
    if ((info.getBoID() == null) || (info.getBoID().trim().equals(""))) {
      String boID = getSelectBOID();
      if (boID == null) {
        if (OprtState.ADDNEW.equals(getOprtState())) {
          if (this.attachMentTempID == null) {
            boID = acm.getAttID().toString();
            this.attachMentTempID = boID;
          } else {
            boID = this.attachMentTempID;
          }
        }
        else return;
      }

      info.setBoID(boID);
    }
    info.setEdit(isEdit);

    String multi = (String)getUIContext().get("MultiapproveAttachment");
    if ((multi != null) && (multi.equals("true")))
      acm.showAttachmentListUIByBoIDNoAlready(this, info);
    else {
      acm.showAttachmentListUIByBoID(this, info);
    }
    if (this.kDPanel1 != null)
      processAttachments(this.kDPanel1, info.getBoID());
  }

  public void actionUpLoadFile_actionPerformed(ActionEvent e) throws Exception
  {
    AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();

    boolean isEdit = false;
    if ((OprtState.EDIT.equals(getOprtState())) || (OprtState.ADDNEW.equals(getOprtState()))) {
      isEdit = true;
    }
    AttachmentUIContextInfo info = getAttacheInfo();
    if (info == null)
      info = new AttachmentUIContextInfo();
    if ((info.getBoID() == null) || (info.getBoID().trim().equals(""))) {
      String boID = getSelectBOID();
      if (boID == null) {
        if (OprtState.ADDNEW.equals(getOprtState())) {
          if (this.attachMentTempID == null) {
            boID = acm.getAttID().toString();
            this.attachMentTempID = boID;
          } else {
            boID = this.attachMentTempID;
          }
        }
        else return;
      }

      info.setBoID(boID);
    }
    info.setEdit(isEdit);

    acm.showUploadFilesUI(this, info);

    if (this.kDPanel1 != null)
      processAttachments(this.kDPanel1, info.getBoID());
  }

  public void actionUpLoadContractFile_actionPerformed(ActionEvent e)
    throws Exception
  {
    AttachmentClientManager acm = AttachmentManagerFactory.getClientManager();

    boolean isEdit = false;
    if ((OprtState.EDIT.equals(getOprtState())) || (OprtState.ADDNEW.equals(getOprtState()))) {
      isEdit = true;
    }
    AttachmentUIContextInfo info = getAttacheInfo();
    if (info == null)
      info = new AttachmentUIContextInfo();
    if ((info.getBoID() == null) || (info.getBoID().trim().equals(""))) {
      String boID = this.editData.getContractFileTmpID();
      if (boID == null) {
        if (OprtState.ADDNEW.equals(getOprtState())) {
          if (this.attachContractTempID == null) {
            boID = this.editData.getContractFileTmpID();
            this.attachContractTempID = boID;
          } else {
            boID = this.attachContractTempID;
          }
        }
        else return;
      }

      info.setBoID(boID);
    }
    info.setEdit(isEdit);

    acm.showUploadFilesUI(this, info);

    if (this.kDPanel2 != null)
      processAttachments(this.kDPanel2, info.getBoID(), false);
  }

  protected void processAttachments(KDPanel pnlAttachment, String boID)
  {
    processAttachments(pnlAttachment, boID, true);
  }

  protected void processAttachments(KDPanel pnlAttachment, String boID, boolean needChangeNextCom)
  {
    pnlAttachment.removeAll();
    pnlAttachment.setAutoscrolls(true);
    if (boID == null) {
      pnlAttachment.repaint();
      return;
    }

    FDCSQLBuilder fdcBuilder = new FDCSQLBuilder();
    fdcBuilder.appendSql(" select at.FID,at.FName_l2,at.FSimpleName from T_BAS_Attachment at");
    fdcBuilder.appendSql(" join T_BAS_BoAttchAsso boAt on at.FID=boAt.FAttachmentID");
    fdcBuilder.appendSql(" where boAt.FBoID = '" + boID + "'");
    IRowSet rs = null;
    try
    {
      rs = fdcBuilder.executeQuery();
      int index = 0;
      int cols = 3;
      int lblW = 1000;
      if (needChangeNextCom)
        lblW = (this.pnlAttBound.width - 3) / cols;
      else {
        lblW = (this.contEntrBound.width - 3) / cols;
      }
      int lblh = 19;
      int lblStartx = 1;

      int changeH = 0;
      while (rs.next()) {
        KDLabel att = new KDLabel();
        att.setName(rs.getString("FID"));
        att.setText(rs.getString("FName_l2") + "." + rs.getString("FSimpleName") + ";");
        att.setForeground(Color.BLUE);

        att.addMouseListener(new MouseAdapter() {
          public void mouseClicked(MouseEvent e) {
            try {
              KDLabel source = (KDLabel)e.getSource();
              InviteAppraisingEditUI.this.getFileGetter().viewAttachment(source.getName());
            } catch (Exception e1) {
              InviteAppraisingEditUI.this.handleControlException();
            }
          }
        });
        att.setBounds(new Rectangle((index + 1) % cols * lblStartx + index % cols * lblW, index / cols * lblh + (index + cols) / cols * 1, lblW, lblh));

        pnlAttachment.add(att, new KDLayout.Constraints(lblStartx + index % cols * lblW, index / cols * lblh + (index + cols) / cols * 1, lblW, lblh, getLblANCHOR(cols, index % cols)));

        index++;
      }

      changeH = (index - 1) / cols * lblh + 5;
      Rectangle nextB1 = null;
      if (needChangeNextCom)
        nextB1 = (Rectangle)this.pnlAttBound.clone();
      else {
        nextB1 = (Rectangle)this.contEntrBound.clone();
      }
      nextB1.height += changeH;
      pnlAttachment.setBounds(nextB1);

      add(pnlAttachment, new KDLayout.Constraints(nextB1.x, nextB1.y, nextB1.width, nextB1.height, 385));
      remove(this.kDSeparator7);

      pnlAttachment.repaint();
      if ((needChangeNextCom) && 
        (changeH > 20)) {
        Rectangle uibounds = pnlAttachment.getBounds();
        pnlAttachment.setBounds(new Rectangle(uibounds.x, uibounds.y, uibounds.width, uibounds.height + changeH));
        pnlAttachment.putClientProperty("OriginalBounds", new Rectangle(uibounds.x, uibounds.y, uibounds.width, uibounds.height + changeH));
      }

      repaint();
      updateUI();
    } catch (BOSException e) {
      logger.error(e.getMessage());
      handUIException(e);
    } catch (SQLException e) {
      logger.error(e.getMessage());
      handUIException(e);
    }
  }

  private KDContainer getNextContainer() {
    return null;
  }

  private int getLblANCHOR(int cols, int index)
  {
    if (index == 0)
      return 261;
    if (cols - 1 == index)
      return 137;
    if (cols - 1 > index) {
      return 385;
    }

    return -1;
  }

  protected FileGetter getFileGetter()
    throws Exception
  {
    if (this.fileGetter == null)
      this.fileGetter = new FileGetter(AttachmentFactory.getRemoteInstance(), AttachmentFtpFacadeFactory.getRemoteInstance());
    return this.fileGetter;
  }

  private void checkCanBid() {
    KDTable entryTbl = null;
    Boolean isRecommand = null;
    AppprasingMethodEnum method = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();
    for (Iterator it = this.entryMap.keySet().iterator(); it.hasNext(); ) {
      entryTbl = (KDTable)this.entryMap.get(it.next());
      for (int i = 0; i < entryTbl.getRowCount(); i++) {
        isRecommand = (Boolean)entryTbl.getCell(i, "isRecommand").getValue();
        if ((isRecommand != null) && (isRecommand.booleanValue()))
          checkRowCallBid(entryTbl, i, method);
      }
    }
  }

  private void checkSuccessTender()
  {
    InviteProjectInfo invProject = (InviteProjectInfo)this.prmtProject.getValue();

    if (invProject.getInviteMethod() == InviteProjectMethodEnum.AREAINVITEDMETHOD) {
      return;
    }

    if (this.comboApprasingMethod.getSelectedItem() == AppprasingMethodEnum.COMBINEDPRICE) {
      Map comPriceMap = new HashMap();
      KDTable entryTbl = null;
      IRow row = null;
      Object obj = null;
      BigDecimal price = new BigDecimal("0");
      for (Iterator it = this.entryMap.keySet().iterator(); it.hasNext(); ) {
        entryTbl = (KDTable)this.entryMap.get(it.next());
        for (int i = 0; i < entryTbl.getRowCount(); i++) {
          row = entryTbl.getRow(i);
          if (((row.getCell("invalidReason").getValue() != null) && (!AppraisingInvaildReasonEnum.NULL.equals(row.getCell("invalidReason").getValue()))) || (row.getStyleAttributes().isLocked())) {
            continue;
          }
          if (row.getCell("clarAmendAmount").getValue() != null)
            obj = row.getCell("clarAmendAmount").getValue();
          else if (row.getCell("clarifyAmount").getValue() != null)
            obj = row.getCell("clarifyAmount").getValue();
          else if (row.getCell("amendAmount").getValue() != null)
            obj = row.getCell("amendAmount").getValue();
          else if (row.getCell("caseAmount").getValue() != null) {
            obj = row.getCell("caseAmount").getValue();
          }

          if (obj != null) {
            price = new BigDecimal(obj.toString());
            if (comPriceMap.containsKey(entryTbl)) {
              if (((BigDecimal)comPriceMap.get(entryTbl)).compareTo(price) > 0)
                comPriceMap.put(entryTbl, price);
            }
            else {
              comPriceMap.put(entryTbl, price);
            }
          }
        }

      }

      BigDecimal mapPrice = new BigDecimal("0");
      BigDecimal wightsPrice = new BigDecimal("0");
      BigDecimal wightsMapPrice = new BigDecimal("0");
      BigDecimal wights = new BigDecimal("0");
      BigDecimal temps = new BigDecimal("0");
      BigDecimal wightTemp = null;
      String msg = "";

      if (invProject.getInviteMethod() == InviteProjectMethodEnum.PROJECTINVITEDMETHOD)
        wightTemp = new BigDecimal("3");
      else if (invProject.getInviteMethod() == InviteProjectMethodEnum.STRATEGYINVITEDMETHOD) {
        wightTemp = new BigDecimal("5");
      }

      for (Iterator it = comPriceMap.keySet().iterator(); it.hasNext(); ) {
        entryTbl = (KDTable)it.next();
        mapPrice = (BigDecimal)comPriceMap.get(entryTbl);
        for (int i = 0; i < entryTbl.getRowCount(); i++) {
          row = entryTbl.getRow(i);
          if (((Boolean)row.getCell("isRecommand").getValue()).booleanValue()) {
            if (row.getCell("clarAmendAmount").getValue() != null)
              obj = row.getCell("clarAmendAmount").getValue();
            else if (row.getCell("clarifyAmount").getValue() != null)
              obj = row.getCell("clarifyAmount").getValue();
            else if (row.getCell("amendAmount").getValue() != null)
              obj = row.getCell("amendAmount").getValue();
            else if (row.getCell("caseAmount").getValue() != null) {
              obj = row.getCell("caseAmount").getValue();
            }

            if (obj != null) {
              price = new BigDecimal(obj.toString());
              temps = price.add(mapPrice);
              wightsPrice = price.divide(temps, 6, 0);
              wightsMapPrice = mapPrice.divide(temps, 6, 0);
              wights = wightsPrice.subtract(wightsMapPrice).multiply(new BigDecimal(100));

              wightTemp = wightTemp == null ? BigDecimal.ZERO : wightTemp;
              if (wights.compareTo(wightTemp) > 0) {
                String title = (String)this.tableTitleNameMap.get(entryTbl.getName());
                msg = msg + title + "бƼλ" + row.getCell("supplier").getValue() + "ձ۸ںͼ۵" + wightTemp.intValue() + "%" + "\n";
              }
            }
          }
        }
      }

      if (msg.length() > 0) {
        int res = MsgBox.showConfirm3(this, "ڲбƼλǷȷύ", msg);
        if (res == 1)
          SysUtil.abort();
      }
    }
  }

  public void actionBidNotice_actionPerformed(ActionEvent e)
    throws Exception
  {
    if (this.editData.getId() == null) {
      FDCMsgBox.showWarning(this, "ȱ浥");
      abort();
    }
    boolean flag = true;
    for (int i = 0; i < this.editData.getSegEntry().size(); i++) {
      if (this.editData.getSegEntry().get(i).isIsRecommand()) {
        flag = false;
      }
    }

    if (flag) {
      FDCMsgBox.showWarning(this, "ûб깩Ӧ̣б֪ͨ");
      abort();
    }

    BidNoticeCollection bnCol = BidNoticeFactory.getRemoteInstance().getBidNoticeCollection("where invPro.id='" + this.editData.getInvPro().getId() + "'");

    UIContext uiContext = new UIContext(this);
    IUIWindow uiWindow = null;
    try {
      if ((bnCol != null) && (bnCol.size() > 0)) {
        uiContext.put("info", this.editData);
        uiContext.put("billType", InviteTenderTypeEnum.INVITE_TYPE);
        uiContext.put("invType", this.comboApprasingMethod.getSelectedItem());
        uiContext.put("invProID", this.editData.getInvPro().getId());
        uiContext.put("ID", bnCol.get(0).getId());
        uiWindow = UIFactory.createUIFactory("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BidNoticeEditUI.class.getName(), uiContext, null, OprtState.VIEW);
      }
      else {
        uiContext.put("billType", InviteTenderTypeEnum.INVITE_TYPE);
        uiContext.put("info", this.editData);
        uiContext.put("invType", this.comboApprasingMethod.getSelectedItem());
        uiWindow = UIFactory.createUIFactory("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(BidNoticeEditUI.class.getName(), uiContext, null, OprtState.ADDNEW);
      }
    }
    catch (UIException e1) {
      handUIException(e1);
    }
    uiWindow.show();
  }

  private List getSelectSupplierBySeg(CurProjectInfo curProjInfo, InviteProjectSegmentEnum selectSeg) {
    List result = new ArrayList();
    String project_Seg = curProjInfo.getId().toString() + "_" + selectSeg.getValue();
    KDTable table = (KDTable)this.entryMap.get(project_Seg);
    if ((table != null) && (table.getRowCount() > 0)) {
      Boolean isSelect = null;
      for (int i = 0; i < table.getRowCount(); i++) {
        isSelect = (Boolean)table.getCell(i, "isRecommand").getValue();
        if ((isSelect != null) && (isSelect.booleanValue())) {
          result.add(table.getRow(i));
        }
      }
    }

    return result;
  }

  protected BigDecimal getAmount(InviteAppraisingSegmentEntryInfo entryInfo, AppprasingMethodEnum method, boolean getFinalAmt) {
    if (getFinalAmt) {
      if (method.equals(AppprasingMethodEnum.ReasonableLowPrice)) {
        if ((entryInfo.getFinalAmount() != null) && (BigDecimal.ZERO.compareTo(entryInfo.getFinalAmount()) != 0)) {
          return entryInfo.getFinalAmount();
        }
      }
      else if ((entryInfo.getBusNeogiateAmount() != null) && (BigDecimal.ZERO.compareTo(entryInfo.getBusNeogiateAmount()) != 0)) {
        return entryInfo.getBusNeogiateAmount();
      }
    }

    if ((entryInfo.getClarAmendAmount() != null) && (BigDecimal.ZERO.compareTo(entryInfo.getClarAmendAmount()) != 0))
      return entryInfo.getClarAmendAmount();
    if ((entryInfo.getClarifyAmount() != null) && (BigDecimal.ZERO.compareTo(entryInfo.getClarifyAmount()) != 0))
      return entryInfo.getClarifyAmount();
    if ((entryInfo.getAmendAmount() != null) && (BigDecimal.ZERO.compareTo(entryInfo.getAmendAmount()) != 0)) {
      return entryInfo.getAmendAmount();
    }
    return entryInfo.getCaseAmount();
  }

  protected BigDecimal getAmount(IRow row, AppprasingMethodEnum method, boolean getFinalAmt)
  {
    if (getFinalAmt) {
      if (method.equals(AppprasingMethodEnum.ReasonableLowPrice)) {
        if ((row.getCell("finalAmount").getValue() != null) && (BigDecimal.ZERO.compareTo((BigDecimal)row.getCell("finalAmount").getValue()) != 0))
        {
          return (BigDecimal)row.getCell("finalAmount").getValue();
        }
      }
      else if ((row.getCell("busNeogiateAmount").getValue() != null) && (BigDecimal.ZERO.compareTo((BigDecimal)row.getCell("busNeogiateAmount").getValue()) != 0))
      {
        return (BigDecimal)row.getCell("busNeogiateAmount").getValue();
      }
    }

    if ((row.getCell("clarAmendAmount").getValue() != null) && (BigDecimal.ZERO.compareTo((BigDecimal)row.getCell("clarAmendAmount").getValue()) != 0))
    {
      return (BigDecimal)row.getCell("clarAmendAmount").getValue();
    }if ((row.getCell("clarifyAmount").getValue() != null) && (BigDecimal.ZERO.compareTo((BigDecimal)row.getCell("clarifyAmount").getValue()) != 0))
    {
      return (BigDecimal)row.getCell("clarifyAmount").getValue();
    }if ((row.getCell("amendAmount").getValue() != null) && (BigDecimal.ZERO.compareTo((BigDecimal)row.getCell("amendAmount").getValue()) != 0))
    {
      return (BigDecimal)row.getCell("amendAmount").getValue();
    }
    return (BigDecimal)row.getCell("caseAmount").getValue();
  }

  protected BigDecimal getFinalCtrlIncTaxAmt(IRow row, boolean getFinalAmt)
  {
    BigDecimal finalCtrlIncTaxAmt = FDCHelper.ZERO;
    if (getFinalAmt)
    {
      if ((this.isEnabledYGZ) && (row.getCell("finalCtrlIncTaxAmt").getValue() != null) && (BigDecimal.ZERO.compareTo((BigDecimal)row.getCell("finalCtrlIncTaxAmt").getValue()) != 0))
      {
        finalCtrlIncTaxAmt = FDCHelper.toBigDecimal(row.getCell("finalCtrlIncTaxAmt").getValue());
      }
    }

    return finalCtrlIncTaxAmt;
  }

  protected BigDecimal getTaxAmount(IRow row, boolean getFinalAmt)
  {
    BigDecimal taxAmount = FDCHelper.ZERO;
    if (getFinalAmt)
    {
      if ((this.isEnabledYGZ) && (row.getCell("finalCtrlVAT").getValue() != null) && (BigDecimal.ZERO.compareTo((BigDecimal)row.getCell("finalCtrlVAT").getValue()) != 0))
      {
        taxAmount = FDCHelper.toBigDecimal(row.getCell("finalCtrlVAT").getValue());
      }
    }

    return taxAmount;
  }

  protected BigDecimal getAmount(IRow row, AppprasingMethodEnum method)
  {
    return getAmount(row, method, true);
  }

  private InviteAppraisingSegmentEntryCollection orderbySegmentEntry(InviteAppraisingSegmentEntryCollection entrys) {
    InviteAppraisingSegmentEntryCollection revList = new InviteAppraisingSegmentEntryCollection();
    InviteAppraisingSegmentEntryInfo entryi = null;
    InviteAppraisingSegmentEntryInfo entryj = null;
    int min_index = -1;
    BigDecimal minVal = null;
    BigDecimal nextVal = null;

    AppprasingMethodEnum method = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();

    for (int i = entrys.size() - 1; i > 0; i--) {
      entryi = entrys.get(i);
      min_index = i;
      if (AppprasingMethodEnum.ReasonableLowPrice == method)
        minVal = entryi.getCaseAmount();
      else {
        minVal = entryi.getComScore();
      }
      for (int j = i - 1; j >= 0; j--) {
        entryj = entrys.get(j);
        if (AppprasingMethodEnum.ReasonableLowPrice == method)
          nextVal = entryj.getCaseAmount();
        else {
          nextVal = entryj.getComScore();
        }
        if ((AppprasingMethodEnum.ReasonableLowPrice == method) && (!numCompare(nextVal, minVal))) {
          min_index = j;
          minVal = nextVal;
        } else if ((AppprasingMethodEnum.COMBINEDPRICE == method) && (numCompare(nextVal, minVal))) {
          min_index = j;
          minVal = nextVal;
        }
      }
      revList.add((InviteAppraisingSegmentEntryInfo)entrys.removeObject(min_index));
    }

    if (entrys.size() > 0) {
      revList.addCollection(entrys);
    }
    if (AppprasingMethodEnum.ReasonableLowPrice == method) {
      genAppraisingRank(revList, method);
    }
    return revList;
  }

  private void genAppraisingRank(InviteAppraisingSegmentEntryCollection revList, AppprasingMethodEnum method) {
    InviteAppraisingSegmentEntryInfo entryi = null;
    InviteAppraisingSegmentEntryInfo entryj = null;
    BigDecimal minVal = null;
    BigDecimal nextVal = null;

    Map keyValueAppraiseRank = new HashMap();

    Map projectBidMap = new HashMap();
    for (int i = 0; i < revList.size(); i++)
      if (InviteProjectMethodEnum.STRATEGYINVITEDMETHOD == this.editData.getInvPro().getInviteMethod()) {
        entryi = revList.get(i);
        if (i == 0) {
          revList.get(0).setAppraiseRank(i + 1);
        }
        else {
          entryj = revList.get(i - 1);
          if (AppprasingMethodEnum.ReasonableLowPrice == method) {
            minVal = entryi.getCaseAmount() == null ? BigDecimal.ZERO : entryi.getCaseAmount();
            nextVal = entryj.getCaseAmount() == null ? BigDecimal.ZERO : entryj.getCaseAmount();
          } else {
            minVal = entryi.getComScore() == null ? BigDecimal.ZERO : entryi.getComScore();
            nextVal = entryj.getComScore() == null ? BigDecimal.ZERO : entryj.getComScore();
          }
          if (((AppprasingMethodEnum.ReasonableLowPrice == method) && (minVal.compareTo(nextVal) == 0)) || ((AppprasingMethodEnum.COMBINEDPRICE == method) && (minVal.compareTo(nextVal) == 0)))
          {
            entryi.setAppraiseRank(entryj.getAppraiseRank());
          }
          else entryi.setAppraiseRank(i + 1); 
        }
      }
      else
      {
        entryi = revList.get(i);
        String currentProject = entryi.getProject().getId().toString();
        String bidNum = entryi.getSegment().toString();
        String key = currentProject + bidNum;
        Integer apprank = Integer.valueOf((Integer)keyValueAppraiseRank.get(key) == null ? 0 : ((Integer)keyValueAppraiseRank.get(key)).intValue());
        List tempList = (List)projectBidMap.get(key);
        if ((tempList == null) || (tempList.size() <= 0)) {
          tempList = new ArrayList();
          projectBidMap.put(key, tempList);
          entryi.setAppraiseRank(1);
          keyValueAppraiseRank.put(key, Integer.valueOf(apprank.intValue() + 1));
          tempList.add(entryi);
        }
        else
        {
          entryj = (InviteAppraisingSegmentEntryInfo)tempList.get(tempList.size() - 1);
          if (AppprasingMethodEnum.ReasonableLowPrice == method) {
            minVal = entryi.getCaseAmount() == null ? BigDecimal.ZERO : entryi.getCaseAmount();
            nextVal = entryj.getCaseAmount() == null ? BigDecimal.ZERO : entryj.getCaseAmount();
          } else {
            minVal = entryi.getComScore() == null ? BigDecimal.ZERO : entryi.getComScore();
            nextVal = entryj.getComScore() == null ? BigDecimal.ZERO : entryj.getComScore();
          }
          if ((AppprasingMethodEnum.ReasonableLowPrice == method) && (minVal.compareTo(nextVal) == 0))
            entryi.setAppraiseRank(entryj.getAppraiseRank());
          else if (AppprasingMethodEnum.ReasonableLowPrice == method)
            entryi.setAppraiseRank(tempList.size() + 1);
          else if ((AppprasingMethodEnum.COMBINEDPRICE == method) && (minVal.compareTo(nextVal) == 0)) {
            entryi.setAppraiseRank(entryj.getAppraiseRank());
          }
          else if (AppprasingMethodEnum.COMBINEDPRICE == method) {
            entryi.setAppraiseRank(tempList.size() + 1);
          }
          tempList.add(entryi);
        }
      }
  }

  private boolean numCompare(BigDecimal a, BigDecimal b)
  {
    if (a == null) {
      a = BigDecimal.ZERO;
    }
    if (b == null) {
      b = BigDecimal.ZERO;
    }

    return a.compareTo(b) > 0;
  }

  public void actionSignContract_actionPerformed(ActionEvent e)
    throws Exception
  {
    actionSignContract2_actionPerformed(e);
  }

  public void actionSignContract2_actionPerformed(ActionEvent e) throws Exception
  {
    if ((this.oprtState == OprtState.ADDNEW) && (this.editData.getId() == null)) {
      MsgBox.showInfo(this, "δ겻ǩԼ!");
      return;
    }

    InviteAppraisingInfo dbData = this.editData;
    if (!FDCBillStateEnum.AUDITTED.equals(dbData.getState())) {
      MsgBox.showInfo(this, "δ겻ǩԼ!");
      return;
    }

    if (InviteProjectMethodEnum.STRATEGYINVITEDMETHOD.equals(dbData.getInvPro().getInviteMethod())) {
      StrategyPactCollection strategyPactCollection = StrategyPactFactory.getRemoteInstance().getStrategyPactCollection("where invProject ='" + this.editData.getInvPro().getId() + "'");

      if ((strategyPactCollection != null) && (strategyPactCollection.size() > 0)) {
        MsgBox.showInfo(this, "ǩԼսЭ飬ٴǩԼ!");
        return;
      }
    }
    else {
      boolean hasContract = ContractBillFactory.getRemoteInstance().exists(" where inviteBillID='" + this.editData.getInvPro().getId() + "'");

      if (hasContract) {
        MsgBox.showInfo(this, "ǩԼͬٴǩԼ!");
        return;
      }

    }

    if (InviteProjectMethodEnum.STRATEGYINVITEDMETHOD.equals(dbData.getInvPro().getInviteMethod())) {
      InviteAppraisingSegmentEntryCollection coll = dbData.getSegEntry();
      for (int i = 0; i < coll.size(); i++) {
        InviteAppraisingSegmentEntryInfo entryInfo = coll.get(i);
        if (entryInfo.isIsRecommand()) {
          StrategyPactInfo pactInfo = createStrategyPact(this.editData.getInvPro(), entryInfo.getSupplier());
          IObjectPK pk = StrategyPactFactory.getRemoteInstance().addnew(pactInfo);
          pactInfo.setId(BOSUuid.read(pk.toString()));
          showStrategyPactWin(pactInfo);
        }

      }

    }
    else
    {
      int entryCount = dbData.getInvPro().getContractProEntry().size();
      CurProjectInfo project = null;
      InviteProjectSegmentEnum tempSeg = null;
      String project_Seg = null;
      List segRowList = null;

      Set haveContractSet = new HashSet();

      ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getRemoteInstance();

      ContractCodingTypeCollection codingTypeList = ContractBillFactory.getRemoteInstance().getContractCodingType(this.editData.getInvPro().getInviteType().getContractType(), ContractPropertyEnum.DIRECT.getValue(), "NEW");

      for (int i = 0; i < entryCount; i++) {
        InviteProjectContactEntryInfo projectContactEntry = dbData.getInvPro().getContractProEntry().get(i);
        project = projectContactEntry.getCurProject();
        tempSeg = projectContactEntry.getBidNum();

        ProgrammingContractInfo prog = projectContactEntry.getContractPro();

        project_Seg = project.getId().toString() + "_" + tempSeg.getValue();

        segRowList = getSelectSupplierBySeg(project, tempSeg);

        for (int j = 0; (segRowList != null) && (j < segRowList.size()); j++) {
          IRow segRow = (IRow)segRowList.get(j);
          AppprasingMethodEnum method = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();
          InviteAppraisingSegmentEntryInfo entry = (InviteAppraisingSegmentEntryInfo)segRow.getUserObject();
          BigDecimal amount = getAmount(segRow, method);
          SupplierStockInfo supplier = (SupplierStockInfo)segRow.getCell("supplier").getValue();

          BigDecimal taxmount = getTaxAmount(segRow, true);
          BigDecimal unTaxAmount = getFinalCtrlIncTaxAmt(segRow, true);

          ContractBillInfo info = createContract(this.editData.getInvPro(), project, prog, supplier, amount, taxmount, unTaxAmount);
          info.setInviteBillID(this.editData.getInvPro().getId().toString());
          info.setInviteBillEntryID(entry.getId().toString());

          setNumberByCodingRule(info, codingTypeList, iCodingRuleManager);
          if (org.apache.commons.lang.StringUtils.isBlank(info.getNumber())) {
            info.setNumber("" + new Date().getTime());
          }
          info.setState(FDCBillStateEnum.SAVED);

          IObjectPK pk = ContractBillFactory.getRemoteInstance().addnew(info);
          info.setId(BOSUuid.read(pk.toString()));
          showContractWin(info);

          haveContractSet.add(project_Seg);
        }
      }
    }
    dbData = this.editData;
    dbData.setIsStrategyPact(true);
    SelectorItemCollection selector = new SelectorItemCollection();
    selector.add(new SelectorItemInfo("isStrategyPact"));
    InviteAppraisingFactory.getRemoteInstance().updatePartial(dbData, selector);
  }

  private void setNumberByCodingRule(ContractBillInfo info, ContractCodingTypeCollection codingTypeList, ICodingRuleManager iCodingRuleManager)
  {
    try
    {
      int size = codingTypeList.size();
      if (size > 0)
      {
        if (this.orgIDList.size() == 0) {
          ContractUtil.findParentOrgUnitIdToList(null, info.getCurProject().getCostCenter() == null ? info.getOrgUnit().getId().toString() : info.getCurProject().getCostCenter().getId().toString(), this.orgIDList);
        }
        for (int i = 0; i < size; i++) {
          ContractCodingTypeInfo codingType = codingTypeList.get(i);
          info.put("codeType", codingType);

          for (int j = 0; (j < this.orgIDList.size()) && 
            (!setNumber(iCodingRuleManager, this.orgIDList.get(j).toString(), "codeType.number", info)); j++);
        }
      }
    }
    catch (Exception err) {
      handUIExceptionAndAbort(err);
    }
  }

  protected boolean setNumber(ICodingRuleManager iCodingRuleManager, String orgId, String bindingProperty, ContractBillInfo contractBillInfo)
    throws CodingRuleException, EASBizException, BOSException
  {
    if (iCodingRuleManager.isExist(contractBillInfo, orgId, bindingProperty))
    {
      String costCenterId = null;
      if (((contractBillInfo instanceof FDCBillInfo)) && (contractBillInfo.getOrgUnit() != null))
      {
        costCenterId = contractBillInfo.getOrgUnit().getId().toString();
      }
      else costCenterId = SysContext.getSysContext().getCurrentCostUnit().getId().toString();

      try
      {
        String number = prepareNumberForAddnew(iCodingRuleManager, contractBillInfo, orgId, costCenterId, bindingProperty);

        contractBillInfo.setNumber(number);
      }
      catch (Exception e) {
        handUIExceptionAndAbort(e);
      }

      return true;
    }
    contractBillInfo.setNumber("" + new Date().getTime());

    return false;
  }

  private String convertNumber(String orgNumber)
  {
    return orgNumber.replaceAll("!", ".");
  }

  protected String prepareNumberForAddnew(ICodingRuleManager iCodingRuleManager, FDCBillInfo info, String orgId, String costerId, String bindingProperty)
    throws Exception
  {
    String number = null;
    FilterInfo filter = null;
    int i = 0;
    do
    {
      if (bindingProperty != null)
        number = iCodingRuleManager.getNumber(info, orgId, bindingProperty, "");
      else {
        number = iCodingRuleManager.getNumber(info, orgId);
      }

      filter = new FilterInfo();
      filter.getFilterItems().add(new FilterItemInfo("number", number));
      filter.getFilterItems().add(new FilterItemInfo("state", FDCBillStateEnum.INVALID.getValue(), CompareType.NOTEQUALS));

      filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", costerId));
      if (info.getId() != null) {
        filter.getFilterItems().add(new FilterItemInfo("id", info.getId().toString(), CompareType.NOTEQUALS));
      }

      i++;
    }while ((ContractBillFactory.getRemoteInstance().exists(filter)) && (i < 1000));

    return number;
  }

  private void showStrategyPactWin(StrategyPactInfo pactInfo)
    throws UIException
  {
    UIContext uiContext = new UIContext(this);
    if (pactInfo.getId() != null)
      uiContext.put("ID", pactInfo.getId().toString());
    else {
      uiContext.put("ID", null);
    }
    uiContext.put("source", "inviteAppraising");
    IUIFactory uiFactory = UIFactory.createUIFactory("com.kingdee.eas.base.uiframe.client.UINewFrameFactory");
    IUIWindow uiWindow = uiFactory.create(StrategyPactEditUI.class.getName(), uiContext, null, OprtState.EDIT);
    uiWindow.show();
  }

  private StrategyPactInfo createStrategyPact(InviteProjectInfo invPro, SupplierStockInfo supplier)
  {
    StrategyPactInfo info = new StrategyPactInfo();
    info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
    info.setInvProject(invPro);
    info.setSupplier(supplier);
    info.setSignDate(new Date());
    info.setState(FDCBillStateEnum.SAVED);
    info.setPerson(SysContext.getSysContext().getCurrentUserInfo().getPerson());
    info.setInvMothed(InviteProjectMethodEnum.STRATEGYINVITEDMETHOD);
    info.setInviteProcess(InviteProcessEnum.INVITEPROJECT);
    info.setTenderDiscussion(null);
    return info;
  }

  private Map getProgDetailInfo(Set ids)
    throws BOSException
  {
    if (ids.size() <= 0) {
      return new HashMap();
    }
    EntityViewInfo view = new EntityViewInfo();
    view.getSelector().add("*");
    view.getSelector().add("programming.project.id");
    view.getSelector().add("programming.project.isEnabled");
    view.getSelector().add("costEntries.assigned");
    view.getSelector().add("costEntries.contractAssign");
    view.getSelector().add("costEntries.contractScale");
    view.getSelector().add("costEntries.costAccount.id");
    view.getSelector().add("costEntries.costAccount.name");
    view.getSelector().add("costEntries.costAccount.number");
    view.getSelector().add("costEntries.costAccount.longNumber");
    view.getSelector().add("costEntries.buildings.building.id");
    view.getSelector().add("costEntries.buildings.building.number");
    view.getSelector().add("costEntries.buildings.building.name");
    FilterInfo filter = new FilterInfo();
    filter.getFilterItems().add(new FilterItemInfo("id", ids, CompareType.INCLUDE));
    view.setFilter(filter);
    SorterItemCollection sort = new SorterItemCollection();
    sort.add(new SorterItemInfo("sortNumber"));

    view.setSorter(sort);
    ProgrammingContractCollection coll = ProgrammingContractFactory.getRemoteInstance().getProgrammingContractCollection(view);

    Map revMap = new HashMap();

    for (int i = 0; i < coll.size(); i++) {
      revMap.put(coll.get(i).getId().toString(), coll.get(i));
    }
    return revMap;
  }

  private ProgrammingContractInfo[] getProgramIDSet(String invProID)
    throws BOSException
  {
    EntityViewInfo view = new EntityViewInfo();
    FilterInfo filter = new FilterInfo();
    view.setFilter(filter);
    view.getSelector().add(new SelectorItemInfo("contractPro.*"));
    filter.getFilterItems().add(new FilterItemInfo("parent.id", invProID));
    InviteProjectContactEntryCollection coll = InviteProjectContactEntryFactory.getRemoteInstance().getInviteProjectContactEntryCollection(view);

    ProgrammingContractInfo[] revArr = new ProgrammingContractInfo[coll.size()];
    for (int i = 0; i < coll.size(); i++) {
      revArr[i] = coll.get(i).getContractPro();
    }
    return revArr;
  }

  private void showContractWin(ContractBillInfo info) throws UIException {
    UIContext uiContext = new UIContext(this);
    if (info.getId() != null)
      uiContext.put("ID", info.getId().toString());
    else {
      uiContext.put("ID", null);
    }

    uiContext.put("INV_PROJECT_INFO", info);
    uiContext.put("projectId", info.getCurProject().getId());

    IUIFactory uiFactory = UIFactory.createUIFactory("com.kingdee.eas.base.uiframe.client.UINewTabFactory");
    String uiName = ContractBillEditUI.class.getName();
    if (!this.isEnabledYGZ) {
      uiName = ContractBillNoYgzEditUI.class.getName();
    }
    IUIWindow uiWindow = uiFactory.create(uiName, uiContext, null, OprtState.EDIT);

    uiWindow.show();
  }

  protected String getEditUIModal()
  {
    String openModel = UIConfigUtility.getOpenModel();
    if (openModel != null) {
      return openModel;
    }
    return "com.kingdee.eas.base.uiframe.client.UINewFrameFactory";
  }

  private ContractBillInfo createContract(InviteProjectInfo projectInfo, CurProjectInfo project, ProgrammingContractInfo selectProg, SupplierStockInfo paretB, BigDecimal amount, BigDecimal taxAmount, BigDecimal unTaxAmount)
    throws EASBizException, BOSException
  {
    ContractBillInfo info = new ContractBillInfo();
    info.setName(projectInfo.getName());
    SupplierInfo supplier = null;
    if (paretB != null) {
      supplier = SupplierFactory.getRemoteInstance().getSupplierInfo("where number ='" + paretB.getNumber() + "'");
    }
    info.setPartB(supplier);
    info.setCeremonyb(amount);
    info.setCeremonybb(amount);

    if (this.isEnabledYGZ) {
      info.setSignExcTaxLocAmt(unTaxAmount);
      info.setSignExcTaxOriAmt(unTaxAmount);
      info.setOriExcAmt(unTaxAmount);
      info.setLocExcAmt(unTaxAmount);

      info.setOriVAT(taxAmount);
      info.setLocVAT(taxAmount);

      info.setPreOriVAT(taxAmount);
      info.setPreLocVAT(taxAmount);
    }

    info.setInviteProject(projectInfo);
    ContractTypeInfo contractType = projectInfo.getInviteType().getContractType();
    info.setContractType(contractType);
    if ((contractType != null) && (contractType.isIsCost())) {
      info.setIsCoseSplit(true);
    }

    if (contractType != null) {
      try {
        fillDetailByContractType(contractType.getId().toString(), info);
      } catch (Exception e) {
        logger.error(e.getMessage());
        handUIException(e);
      }

    }

    info.setProgrammingContract(selectProg);
    ProgrammingContractInfo[] tempProg = new ProgrammingContractInfo[1];
    tempProg[0] = selectProg;

    info.setCreator(SysContext.getSysContext().getCurrentUserInfo());
    info.setCreateTime(new Timestamp(this.serverDate.getTime()));
    info.setSignDate(this.serverDate);
    info.setSourceType(SourceTypeEnum.ADDNEW);
    info.setContractPropert(ContractPropertyEnum.DIRECT);
    info.setSplitState(CostSplitStateEnum.NOSPLIT);
    ContractSourceInfo sourceInfo = null;
    try {
      sourceInfo = ContractSourceFactory.getRemoteInstance().getContractSourceInfo("where number ='002'");
    } catch (EASBizException e) {
      e.printStackTrace();
    } catch (BOSException e) {
      e.printStackTrace();
    }
    info.setContractSourceId(sourceInfo);
    info.setCurProject(project);

    info.setPayPercForWarn(new BigDecimal("85"));
    info.setChgPercForWarn(new BigDecimal("5"));

    info.setGrtRate(FDCHelper.ZERO);

    info.setCurrency(this.baseCurrency);
    info.setExRate(FDCHelper.ONE);
    info.setAmount(amount);
    info.setOriginalAmount(amount);
    info.setPayScale(FDCHelper.ZERO);
    info.setGrtAmount(FDCHelper.ZERO);

    info.setCU(projectInfo.getCU());

    info.setConSplitExecState(ConSplitExecStateEnum.COMMON);
    info.setOrgUnit(projectInfo.getOrgUnit());

    info.setPeriod(this.curPeriod);

    ContractBailInfo contractBail = new ContractBailInfo();
    contractBail.setId(BOSUuid.create(contractBail.getBOSType()));
    info.setBail(contractBail);

    info.setRespPerson(SysContext.getSysContext().getCurrentUserInfo().getPerson());

    return info;
  }

  private void fillDetailByContractType(String id, ContractBillInfo info)
    throws Exception
  {
    EntityViewInfo view = new EntityViewInfo();
    FilterInfo filter = new FilterInfo();
    filter.getFilterItems().add(new FilterItemInfo("contractType.id", id));
    filter.getFilterItems().add(new FilterItemInfo("isEnabled", Boolean.TRUE));

    view.setFilter(filter);
    SorterItemInfo sorterItemInfo = new SorterItemInfo("number");
    sorterItemInfo.setSortType(SortType.ASCEND);
    view.getSorter().add(sorterItemInfo);
    ContractDetailDefCollection contractDetailDefCollection = ContractDetailDefFactory.getRemoteInstance().getContractDetailDefCollection(view);

    ContractBillEntryInfo entryInfo = null;
    Iterator iter = contractDetailDefCollection.iterator();
    while (iter.hasNext()) {
      entryInfo = new ContractBillEntryInfo();
      entryInfo.setParent(info);
      ContractDetailDefInfo element = (ContractDetailDefInfo)iter.next();
      entryInfo.setDetail(element.getName());

      entryInfo.setDataType(element.getDataTypeEnum());
      entryInfo.setDetailDefID(element.getId().toString());
      info.getEntrys().add(entryInfo);
    }
  }

  public void actionPriceImport_actionPerformed(ActionEvent e)
    throws Exception
  {
    UIContext uiContext = new UIContext(this);
    uiContext.put("invProInfo", (InviteProjectInfo)this.prmtProject.getValue());

    this.uiWindow = UIFactory.createUIFactory("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory").create(MaterialPriceDataImportUI.class.getName(), uiContext, null, OprtState.ADDNEW);

    this.uiWindow.show();

    MaterialPriceDataEntryCollection entryCol = MaterialPriceDataEntryFactory.getRemoteInstance().getMaterialPriceDataEntryCollection("where invPro.id='" + this.editData.getInvPro().getId() + "'");

    if (entryCol.size() > 0)
      this.txtImportState.setText("ѵ");
    else
      this.txtImportState.setText("δ");
  }

  protected void doAfterSubmit(IObjectPK pk)
    throws Exception
  {
    super.doAfterSubmit(pk);
    if (OprtState.ADDNEW.equals(getOprtState()))
      attachmentPerform(this.attachMentTempID, pk.toString());
  }

  public void setDataObject(IObjectValue dataObject)
  {
    if (dataObject != null) {
      CoreBaseInfo baseInfo = (CoreBaseInfo)dataObject;
      if (baseInfo.getId() != null) {
        attachmentPerform(this.attachMentTempID, baseInfo.getId().toString());
      }
    }
    super.setDataObject(dataObject);
  }

  public boolean checkBeforeWindowClosing()
  {
    boolean b = super.checkBeforeWindowClosing();
    if ((this.editData != null) && (this.editData.getId() != null)) {
      attachmentPerform(this.attachMentTempID, this.editData.getId().toString());
    }

    return b;
  }

  private void attachmentPerform(String tempId, String pk)
  {
    try {
      if ((pk == null) || (tempId == null)) {
        return;
      }

      BizobjectFacadeFactory.getRemoteInstance().upAttID2BosID(tempId, pk);
      BizobjectFacadeFactory.getRemoteInstance().delTempAttachment(tempId);

      this.attachMentTempID = null;
    } catch (Exception e) {
      logger.error(e);
    }
  }

  public boolean destroyWindow() {
    boolean b = super.destroyWindow();
    if ((b) && (
      (this.editData == null) || (this.editData.getId() == null))) {
      if (this.attachMentTempID != null) {
        try {
          AttachmentManagerFactory.getClientManager().deleteAttachemtsByBoID(this.attachMentTempID);
          this.attachMentTempID = null;
        } catch (Exception e) {
          handUIException(e);
        }
      }
      if (this.attachContractTempID != null) {
        try {
          AttachmentManagerFactory.getClientManager().deleteAttachemtsByBoID(this.attachContractTempID);
          this.attachContractTempID = null;
        } catch (Exception e) {
          handUIException(e);
        }
      }
    }

    return b;
  }

  public void actionEdit_actionPerformed(ActionEvent e)
    throws Exception
  {
    setEntryCaseAmountEnable();
    super.actionEdit_actionPerformed(e);

    Set keySet = this.entryMap.keySet();
    for (Iterator it = keySet.iterator(); it.hasNext(); ) {
      KDTable table = (KDTable)this.entryMap.get(it.next());
      int count = table.getRowCount();
      table.checkParsed();
      table.setEnabled(true);
    }
  }

  protected void numWeight1_dataChanged(DataChangeEvent e)
    throws Exception
  {
    AppprasingMethodEnum methodItem = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();
    if (AppprasingMethodEnum.COMBINEDPRICE.equals(methodItem))
    {
      BigDecimal techBit = this.numWeight1.getBigDecimalValue() == null ? BigDecimal.ZERO : this.numWeight1.getBigDecimalValue();
      BigDecimal bizBit = this.numWeight2.getBigDecimalValue() == null ? BigDecimal.ZERO : this.numWeight2.getBigDecimalValue();
      if (techBit.compareTo(new BigDecimal(100)) > 0) {
        this.numWeight1.setValue(this.techPercent);
        this.numWeight2.setValue(this.bizPercent);
        FDCMsgBox.showWarning(this, "Ȩزܴ100%");
        abort();
      }
      BigDecimal tempbit = new BigDecimal(100).subtract(techBit);
      this.numWeight2.setValue(tempbit);
      this.bizPercent = tempbit;
      this.techPercent = this.numWeight1.getBigDecimalValue();

      refCalcTotalScore();
    }
  }

  protected void numWeight2_dataChanged(DataChangeEvent e)
    throws Exception
  {
    AppprasingMethodEnum methodItem = (AppprasingMethodEnum)this.comboApprasingMethod.getSelectedItem();
    if (AppprasingMethodEnum.COMBINEDPRICE.equals(methodItem))
    {
      BigDecimal techBit = this.numWeight1.getBigDecimalValue() == null ? BigDecimal.ZERO : this.numWeight1.getBigDecimalValue();
      BigDecimal bizBit = this.numWeight2.getBigDecimalValue() == null ? BigDecimal.ZERO : this.numWeight2.getBigDecimalValue();
      if (techBit.compareTo(new BigDecimal(100)) > 0) {
        this.numWeight1.setValue(this.techPercent);
        this.numWeight2.setValue(this.bizPercent);
        FDCMsgBox.showWarning(this, "Ȩزܴ100%");
        abort();
      }
      BigDecimal tempbit = new BigDecimal(100).subtract(bizBit);
      this.numWeight1.setValue(tempbit);
      this.techPercent = tempbit;
      this.bizPercent = this.numWeight2.getBigDecimalValue();

      refCalcTotalScore();
    }
  }

  private void refCalcTotalScore() {
    for (Iterator it = this.entryMap.keySet().iterator(); it.hasNext(); ) {
      KDTable entryTbl = (KDTable)this.entryMap.get(it.next());
      for (int i = 0; i < entryTbl.getRowCount(); i++)
        calcTotalScore(entryTbl.getRow(i));
    }
  }

  public void actionTenderNotice_actionPerformed(ActionEvent e)
    throws Exception
  {
    if ((this.editData != null) && (this.editData.getId() != null) && (this.editData.getState() == FDCBillStateEnum.AUDITTED))
    {
      UIContext context = new UIContext(this);

      context.put("data", this.editData);
      IUIFactory uiFactory = null;
      uiFactory = UIFactory.createUIFactory("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
      IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.fdc.invite.news.client.TenderNoticeDistriUI", context, null, OprtState.EDIT);

      TenderNoticeDistriUI editUI = (TenderNoticeDistriUI)uiWindow.getUIObject();

      uiWindow.show();

      inOnload();
      getUILifeCycleHandler().fireAfterLoadField(this, this.editData);
      initOldData(this.editData);
    }
    else
    {
      MsgBox.showWarning(this, "δͨзб깫!");
    }
  }

  public void actionPrintPreview_actionPerformed(ActionEvent e)
    throws Exception
  {
    ArrayList idList = new ArrayList();
    if ((this.editData != null) && (!org.apache.commons.lang.StringUtils.isEmpty(this.editData.getString("id")))) {
      idList.add(this.editData.getString("id"));
    }
    if ((idList == null) || (idList.size() == 0) || (getTDQueryPK() == null) || (getTDFileName() == null))
    {
      MsgBox.showWarning(this, FDCClientUtils.getRes("cantPrint"));
      return;
    }

    InviteAppraiseDataProvider data = new InviteAppraiseDataProvider(this.editData.getString("id"), getTDQueryPK());

    KDNoteHelper appHlp = new KDNoteHelper();
    appHlp.printPreview(getTDFileName(), data, SwingUtilities.getWindowAncestor(this));
  }

  protected void disablePrintFunc()
  {
  }

  public void actionPrint_actionPerformed(ActionEvent e)
    throws Exception
  {
    ArrayList idList = new ArrayList();
    if ((this.editData != null) && (!com.kingdee.bos.ctrl.swing.StringUtils.isEmpty(this.editData.getString("id"))))
    {
      idList.add(this.editData.getString("id"));
    }
    if ((idList == null) || (idList.size() == 0) || (getTDQueryPK() == null) || (getTDFileName() == null))
    {
      MsgBox.showWarning(this, FDCClientUtils.getRes("cantPrint"));
      return;
    }
    InviteAppraiseDataProvider data = new InviteAppraiseDataProvider(this.editData.getString("id"), getTDQueryPK());

    KDNoteHelper appHlp = new KDNoteHelper();
    appHlp.print(getTDFileName(), data, SwingUtilities.getWindowAncestor(this));
  }

  protected IMetaDataPK getTDQueryPK()
  {
    return MetaDataPK.create("com.kingdee.eas.fdc.invite.news.app.InviteAppraiseQueryForPrint");
  }

  protected String getTDFileName() {
    return "bim/fdc/invite/InivteAppraiseForPrint";
  }

  protected void loadData() throws Exception
  {
    super.loadData();

    if ((this.editData.getId() != null) && (FdcWfUtil.isBillInWorkflow(null, this.editData.getId().toString())) && 
      (this.editData.getOrgUnit() != null)) {
      String orgUnitId = this.editData.getOrgUnit().getId().toString();

      this.isEnabledYGZ = FdcYgzUtil.getParam4isEnableYgz(null, null, orgUnitId);
    }
  }

  public void actionThanksLetter_actionPerformed(ActionEvent e)
    throws Exception
  {
    if ((this.editData != null) && (this.editData.getId() != null) && (this.editData.getState() == FDCBillStateEnum.AUDITTED))
    {
      UIContext context = new UIContext(this);

      context.put("data", this.editData);
      IUIFactory uiFactory = null;
      uiFactory = UIFactory.createUIFactory("com.kingdee.eas.base.uiframe.client.UIModelDialogFactory");
      IUIWindow uiWindow = uiFactory.create("com.kingdee.eas.fdc.invite.news.client.TenderThanksLetterUI", context, null, OprtState.EDIT);

      TenderThanksLetterUI editUI = (TenderThanksLetterUI)uiWindow.getUIObject();

      uiWindow.show();

      inOnload();
      getUILifeCycleHandler().fireAfterLoadField(this, this.editData);
      initOldData(this.editData);
    }
    else {
      MsgBox.showWarning(this, "δͨ͸л!");
    }
  }
}