/**
 * output package name
 */
package com.kingdee.eas.custom.workflow.client;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.kds.KDSBook;
import com.kingdee.bos.ctrl.kdf.kds.KDSSheet;
import com.kingdee.bos.ctrl.kdf.read.POIXlsReader;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.KDPanel;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.master.material.IMaterial;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.custom.workflow.IWorkflowPostion;
import com.kingdee.eas.custom.workflow.WorkflowPostionCollection;
import com.kingdee.eas.custom.workflow.WorkflowPostionFactory;
import com.kingdee.eas.custom.workflow.WorkflowPostionInfo;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.eas.xr.helper.EASExcelHelper;

/**
 * output class name
 */
public class CompanyWorkflowEditUI extends AbstractCompanyWorkflowEditUI
{
    private static final Logger logger = CoreUIObject.getLogger(CompanyWorkflowEditUI.class);
    
    /**
     * output class constructor
     */
    public CompanyWorkflowEditUI() throws Exception
    {
        super();
    }
    public void onLoad() throws Exception {
    	// TODO Auto-generated method stub
    	super.onLoad();
    	kDLabelContainer1.setVisible(false);
    	kDLabelContainer2.setVisible(false);
    	kDLabelContainer3.setVisible(false);
    	kDLabelContainer4.setVisible(false);
    	actionAddNew.setVisible(false);
    	actionRemove.setVisible(false);
    	
    	actionCopy.setVisible(false);
    	
    	
    	if(OprtState.ADDNEW.equals(getOprtState())||OprtState.EDIT.equals(getOprtState())){
    		Map workMap=getWorkflowPostion();
    		 if(kdtEntry.getRowCount()>0){
    			 for(int i=0;i<kdtEntry.getRowCount();i++){
    				 WorkflowPostionInfo workInfo= (WorkflowPostionInfo) kdtEntry.getCell(i, "postion").getValue();
    				 if(workMap.get(workInfo.getId().toString())!=null){
    					 workMap.remove(workInfo.getId().toString());
    				 }
    			 }
    			 Iterator entries = workMap.entrySet().iterator(); 
    			 while (entries.hasNext()) { 
    			   Map.Entry entry = (Map.Entry) entries.next(); 
    			   String key = (String)entry.getKey(); 
    			   WorkflowPostionInfo value = (WorkflowPostionInfo)entry.getValue(); 
    			   IRow row=  kdtEntry.addRow();
    			   row.getCell("postion").setValue(value);
    			 }
    			 
    		 }else{
    			 Iterator entries = workMap.entrySet().iterator(); 
    			 while (entries.hasNext()) { 
    			   Map.Entry entry = (Map.Entry) entries.next(); 
    			   String key = (String)entry.getKey(); 
    			   WorkflowPostionInfo value = (WorkflowPostionInfo)entry.getValue(); 
    			   IRow row=  kdtEntry.addRow();
    			   row.getCell("postion").setValue(value);
    			 }
    		 }
    	}
   	 KDWorkButton btnExcle = new KDWorkButton();
	  btnExcle.getAncestorListeners();
		btnExcle.setName("btnAddnewLine");
		btnExcle.setIcon(EASResource.getIcon("imgTbtn_importexcel"));
		btnExcle.setToolTipText("Excle");
		if(kdtEntry_detailPanel.getComponents().length>0){
			for(int  i=0;i<kdtEntry_detailPanel.getComponents().length;i++){
				Component component=kdtEntry_detailPanel.getComponent(i);
				if(component.getName().equals("controlPanel")){
					KDPanel controlPanel=(KDPanel) component;
					controlPanel.add(btnExcle, new com.kingdee.bos.ctrl.swing.KDLayout.Constraints(kdtEntry.getBounds().width-112, 5, 22, 19, 9));
				}
			}
		}
   btnExcle.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(java.awt.event.ActionEvent e) {
          beforeActionPerformed(e);
          try {
       	   btnExcle_actionPerformed(e);
          } catch (Exception exc) {
              handUIException(exc);
          } finally {
              afterActionPerformed(e);
          }
      }
  });
    }
   public void btnExcle_actionPerformed(ActionEvent e) throws Exception
   {
   	String fileName = EASExcelHelper.showExcelSelectDlg(this);
		importExcelToTable(kdtEntry,fileName,1,1);
	}
   public static int importExcelToTable(KDTable table,String fileName, int headRowCount, int keyColumnCount) throws Exception {
		KDSBook kdsbook = null;
		try {
			kdsbook = POIXlsReader.parse2(fileName);
		} catch (Exception e) {
			e.printStackTrace();
			MsgBox.showError("!");
			SysUtil.abort();
		}
		if (kdsbook == null) {
			SysUtil.abort();
		}
		IWorkflowPostion  CompanyOrgUnit=WorkflowPostionFactory.getRemoteInstance();
		IPerson iMeasureUnit=PersonFactory.getRemoteInstance();
		KDSSheet excelSheet = kdsbook.getSheet(new Integer(0));
		int size =0;
		int maxRow = excelSheet.getRowCount();
		IMaterial  iMaterial=MaterialFactory.getRemoteInstance();
		SelectorItemCollection sic = new SelectorItemCollection();
		 sic.add(new SelectorItemInfo("id"));
		 sic.add(new SelectorItemInfo("number"));
		 sic.add(new SelectorItemInfo("name"));
		for (int rowIndex = headRowCount; rowIndex < maxRow; rowIndex++) {
			String comNum = excelSheet.getCell(rowIndex, 0, true).getText();
			String ckMan = excelSheet.getCell(rowIndex, 2, true).getText();
			if(comNum.trim().length()>0){
				WorkflowPostionInfo info= CompanyOrgUnit.getWorkflowPostionInfo("where number='"+comNum+"'");
				IRow row=table.addRow();
				row.getCell("postion").setValue(info);
				if(ckMan.trim().length()>0){
					 EntityViewInfo viewInfo2 = new EntityViewInfo();
					 FilterInfo filter2 = new FilterInfo();
					 filter2.getFilterItems().add(new FilterItemInfo("number",ckMan.trim()));
					 viewInfo2.setFilter(filter2);
					viewInfo2.setSelector(sic);
					PersonCollection sybinfo= iMeasureUnit.getPersonCollection(viewInfo2);
					row.getCell("person").setValue(sybinfo.get(0));
				}
				size=size+1;
			}
		}
		 MsgBox.showInfo("ɹ:"+size+"!");
		 return size;
		}
    	
    
    public  Map<String, WorkflowPostionInfo> getWorkflowPostion() throws BOSException{
    	Map<String, WorkflowPostionInfo>  worMap=new LinkedHashMap<String, WorkflowPostionInfo>();
    	  EntityViewInfo evInfo = new EntityViewInfo();
	    SorterItemInfo item = new SorterItemInfo("number");
  		item.setSortType(SortType.ASCEND);
  		evInfo.getSorter().add(item);
    	WorkflowPostionCollection coll=WorkflowPostionFactory.getRemoteInstance().getWorkflowPostionCollection(evInfo);
    	for(int i=0;i<coll.size();i++){
    		worMap.put(coll.get(i).getId().toString(), coll.get(i));
    	}
		return worMap;
    	
    }
    
    
    /**
     * output loadFields method
     */
    public void loadFields()
    {
        super.loadFields();
    }

    /**
     * output storeFields method
     */
    public void storeFields()
    {
        super.storeFields();
    }

    /**
     * output actionPageSetup_actionPerformed
     */
    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionPageSetup_actionPerformed(e);
    }

    /**
     * output actionExitCurrent_actionPerformed
     */
    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionExitCurrent_actionPerformed(e);
    }

    /**
     * output actionHelp_actionPerformed
     */
    public void actionHelp_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionHelp_actionPerformed(e);
    }

    /**
     * output actionAbout_actionPerformed
     */
    public void actionAbout_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionAbout_actionPerformed(e);
    }

    /**
     * output actionOnLoad_actionPerformed
     */
    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionOnLoad_actionPerformed(e);
    }

    /**
     * output actionSendMessage_actionPerformed
     */
    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionSendMessage_actionPerformed(e);
    }

    /**
     * output actionCalculator_actionPerformed
     */
    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionCalculator_actionPerformed(e);
    }

    /**
     * output actionExport_actionPerformed
     */
    public void actionExport_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionExport_actionPerformed(e);
    }

    /**
     * output actionExportSelected_actionPerformed
     */
    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionExportSelected_actionPerformed(e);
    }

    /**
     * output actionRegProduct_actionPerformed
     */
    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionRegProduct_actionPerformed(e);
    }

    /**
     * output actionPersonalSite_actionPerformed
     */
    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionPersonalSite_actionPerformed(e);
    }

    /**
     * output actionProcductVal_actionPerformed
     */
    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionProcductVal_actionPerformed(e);
    }

    /**
     * output actionExportSave_actionPerformed
     */
    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionExportSave_actionPerformed(e);
    }

    /**
     * output actionExportSelectedSave_actionPerformed
     */
    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    /**
     * output actionKnowStore_actionPerformed
     */
    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionKnowStore_actionPerformed(e);
    }

    /**
     * output actionAnswer_actionPerformed
     */
    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionAnswer_actionPerformed(e);
    }

    /**
     * output actionRemoteAssist_actionPerformed
     */
    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionRemoteAssist_actionPerformed(e);
    }

    /**
     * output actionPopupCopy_actionPerformed
     */
    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionPopupCopy_actionPerformed(e);
    }

    /**
     * output actionHTMLForMail_actionPerformed
     */
    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionHTMLForMail_actionPerformed(e);
    }

    /**
     * output actionExcelForMail_actionPerformed
     */
    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionExcelForMail_actionPerformed(e);
    }

    /**
     * output actionHTMLForRpt_actionPerformed
     */
    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    /**
     * output actionExcelForRpt_actionPerformed
     */
    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionExcelForRpt_actionPerformed(e);
    }

    /**
     * output actionLinkForRpt_actionPerformed
     */
    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionLinkForRpt_actionPerformed(e);
    }

    /**
     * output actionPopupPaste_actionPerformed
     */
    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionPopupPaste_actionPerformed(e);
    }

    /**
     * output actionToolBarCustom_actionPerformed
     */
    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionToolBarCustom_actionPerformed(e);
    }

    /**
     * output actionCloudFeed_actionPerformed
     */
    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionCloudFeed_actionPerformed(e);
    }

    /**
     * output actionCloudShare_actionPerformed
     */
    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionCloudShare_actionPerformed(e);
    }

    /**
     * output actionCloudScreen_actionPerformed
     */
    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionCloudScreen_actionPerformed(e);
    }

    /**
     * output actionXunTongFeed_actionPerformed
     */
    public void actionXunTongFeed_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionXunTongFeed_actionPerformed(e);
    }

    /**
     * output actionSave_actionPerformed
     */
    public void actionSave_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionSave_actionPerformed(e);
    }

    /**
     * output actionSubmit_actionPerformed
     */
    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionSubmit_actionPerformed(e);
    }

    /**
     * output actionCancel_actionPerformed
     */
    public void actionCancel_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionCancel_actionPerformed(e);
    }

    /**
     * output actionCancelCancel_actionPerformed
     */
    public void actionCancelCancel_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionCancelCancel_actionPerformed(e);
    }

    /**
     * output actionFirst_actionPerformed
     */
    public void actionFirst_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionFirst_actionPerformed(e);
    }

    /**
     * output actionPre_actionPerformed
     */
    public void actionPre_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionPre_actionPerformed(e);
    }

    /**
     * output actionNext_actionPerformed
     */
    public void actionNext_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionNext_actionPerformed(e);
    }

    /**
     * output actionLast_actionPerformed
     */
    public void actionLast_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionLast_actionPerformed(e);
    }

    /**
     * output actionPrint_actionPerformed
     */
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionPrint_actionPerformed(e);
    }

    /**
     * output actionPrintPreview_actionPerformed
     */
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionPrintPreview_actionPerformed(e);
    }

    /**
     * output actionCopy_actionPerformed
     */
    public void actionCopy_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionCopy_actionPerformed(e);
    }

    /**
     * output actionAddNew_actionPerformed
     */
    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionAddNew_actionPerformed(e);
    }

    /**
     * output actionEdit_actionPerformed
     */
    public void actionEdit_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionEdit_actionPerformed(e);
    }

    /**
     * output actionRemove_actionPerformed
     */
    public void actionRemove_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionRemove_actionPerformed(e);
    }

    /**
     * output actionAttachment_actionPerformed
     */
    public void actionAttachment_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionAttachment_actionPerformed(e);
    }

    /**
     * output actionSubmitOption_actionPerformed
     */
    public void actionSubmitOption_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionSubmitOption_actionPerformed(e);
    }

    /**
     * output actionReset_actionPerformed
     */
    public void actionReset_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionReset_actionPerformed(e);
    }

    /**
     * output actionMsgFormat_actionPerformed
     */
    public void actionMsgFormat_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionMsgFormat_actionPerformed(e);
    }

    /**
     * output getBizInterface method
     */
    protected com.kingdee.eas.framework.ICoreBase getBizInterface() throws Exception
    {
        return com.kingdee.eas.custom.workflow.CompanyWorkflowFactory.getRemoteInstance();
    }

    /**
     * output createNewData method
     */
    protected com.kingdee.bos.dao.IObjectValue createNewData()
    {
        com.kingdee.eas.custom.workflow.CompanyWorkflowInfo objectValue = new com.kingdee.eas.custom.workflow.CompanyWorkflowInfo();
        objectValue.setCreator((com.kingdee.eas.base.permission.UserInfo)(com.kingdee.eas.common.client.SysContext.getSysContext().getCurrentUser()));
        if(getUIContext().get("orgInfo")!=null){
			FullOrgUnitInfo orgInfo = (FullOrgUnitInfo)getUIContext().get("orgInfo");
            AdminOrgUnitInfo org11 = (AdminOrgUnitInfo) orgInfo.cast(AdminOrgUnitInfo.class);
            
            objectValue.setDeparment(org11);
        }
        return objectValue;
    }

}