/**
 * output package name
 */
package com.kingdee.eas.custom.gggl.client;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.log4j.Logger;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.xr.helper.DateXRHelper;

/**
 * output class name
 */
public class GgRPaymentReportFulterUI extends AbstractGgRPaymentReportFulterUI
{
    private static final Logger logger = CoreUIObject.getLogger(GgRPaymentReportFulterUI.class);
    
    /**
     * output class constructor
     */
    public GgRPaymentReportFulterUI() throws Exception
    {
        super();
        startDate.setValue(DateXRHelper.getFirstYearDate(new Date()));
        endDate.setValue(DateXRHelper.getLastYearDate(new Date()));
    }

    /**
     * output storeFields method
     */
    public void storeFields()
    {
        super.storeFields();
    }
	@Override
	public RptParams getCustomCondition() {
		RptParams params = new RptParams();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		if(startDate.getValue()!=null){
			String  start=  sdf.format(startDate.getValue());
			params.setString("startDate", start);
		}
		if(endDate.getValue()!=null){
			String  end=  sdf.format(endDate.getValue());
			params.setString("endDate", end);
		}		
		return params;
	}

	@Override
	public void onInit(RptParams arg0) throws Exception {
		// TODO Auto-generated method stub
		
	}

	@Override
	public void setCustomCondition(RptParams arg0) {
		// TODO Auto-generated method stub
		
	}

}