/**
 * output package name
 */
package com.kingdee.eas.custom.gggl.client;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;

import javax.swing.event.TreeSelectionEvent;

import org.apache.log4j.Logger;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDataRequestManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.base.commonquery.client.CustomerQueryPanel;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.permission.client.longtime.LongTimeDialog;
import com.kingdee.eas.basedata.org.FullOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.custom.gggl.GgAnalyseReportFacdeFactory;
import com.kingdee.eas.framework.report.ICommRptBase;
import com.kingdee.eas.framework.report.client.CommRptBaseConditionUI;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableHeader;

/**
 * output class name
 */
public class GgAnalyseReportUI extends AbstractGgAnalyseReportUI
{
    private static final Logger logger = CoreUIObject.getLogger(GgAnalyseReportUI.class);
    private boolean isOnLoad = false;
	private boolean isQuery = false;
    /**
     * output class constructor
     */
    public GgAnalyseReportUI() throws Exception
    {
        super();
        kDTable1.checkParsed();
		kDTable1.getDataRequestManager().addDataRequestListener(this);
		kDTable1.getDataRequestManager().setDataRequestMode(KDTDataRequestManager.REAL_MODE);
		enableExportExcel(kDTable1);
    }

    /**
     * output storeFields method
     */
    public void storeFields()
    {
        super.storeFields();
    }
    @Override
	public void onLoad() throws Exception {
		// TODO Auto-generated method stub
		setShowDialogOnLoad(false);
		isOnLoad=true;
		kDTable1.getStyleAttributes().setLocked(true);

		super.onLoad();

		isOnLoad=false;
		setUITitle("ӦտԤ");
	}
    /**
     * output actionPageSetup_actionPerformed
     */
    public void actionPageSetup_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionPageSetup_actionPerformed(e);
    }

    /**
     * output actionExitCurrent_actionPerformed
     */
    public void actionExitCurrent_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionExitCurrent_actionPerformed(e);
    }

    /**
     * output actionHelp_actionPerformed
     */
    public void actionHelp_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionHelp_actionPerformed(e);
    }

    /**
     * output actionAbout_actionPerformed
     */
    public void actionAbout_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionAbout_actionPerformed(e);
    }

    /**
     * output actionOnLoad_actionPerformed
     */
    public void actionOnLoad_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionOnLoad_actionPerformed(e);
    }

    /**
     * output actionSendMessage_actionPerformed
     */
    public void actionSendMessage_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionSendMessage_actionPerformed(e);
    }

    /**
     * output actionCalculator_actionPerformed
     */
    public void actionCalculator_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionCalculator_actionPerformed(e);
    }

    /**
     * output actionExport_actionPerformed
     */
    public void actionExport_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionExport_actionPerformed(e);
    }

    /**
     * output actionExportSelected_actionPerformed
     */
    public void actionExportSelected_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionExportSelected_actionPerformed(e);
    }

    /**
     * output actionRegProduct_actionPerformed
     */
    public void actionRegProduct_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionRegProduct_actionPerformed(e);
    }

    /**
     * output actionPersonalSite_actionPerformed
     */
    public void actionPersonalSite_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionPersonalSite_actionPerformed(e);
    }

    /**
     * output actionProcductVal_actionPerformed
     */
    public void actionProcductVal_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionProcductVal_actionPerformed(e);
    }

    /**
     * output actionExportSave_actionPerformed
     */
    public void actionExportSave_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionExportSave_actionPerformed(e);
    }

    /**
     * output actionExportSelectedSave_actionPerformed
     */
    public void actionExportSelectedSave_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionExportSelectedSave_actionPerformed(e);
    }

    /**
     * output actionKnowStore_actionPerformed
     */
    public void actionKnowStore_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionKnowStore_actionPerformed(e);
    }

    /**
     * output actionAnswer_actionPerformed
     */
    public void actionAnswer_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionAnswer_actionPerformed(e);
    }

    /**
     * output actionRemoteAssist_actionPerformed
     */
    public void actionRemoteAssist_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionRemoteAssist_actionPerformed(e);
    }

    /**
     * output actionPopupCopy_actionPerformed
     */
    public void actionPopupCopy_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionPopupCopy_actionPerformed(e);
    }

    /**
     * output actionHTMLForMail_actionPerformed
     */
    public void actionHTMLForMail_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionHTMLForMail_actionPerformed(e);
    }

    /**
     * output actionExcelForMail_actionPerformed
     */
    public void actionExcelForMail_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionExcelForMail_actionPerformed(e);
    }

    /**
     * output actionHTMLForRpt_actionPerformed
     */
    public void actionHTMLForRpt_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionHTMLForRpt_actionPerformed(e);
    }

    /**
     * output actionExcelForRpt_actionPerformed
     */
    public void actionExcelForRpt_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionExcelForRpt_actionPerformed(e);
    }

    /**
     * output actionLinkForRpt_actionPerformed
     */
    public void actionLinkForRpt_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionLinkForRpt_actionPerformed(e);
    }

    /**
     * output actionPopupPaste_actionPerformed
     */
    public void actionPopupPaste_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionPopupPaste_actionPerformed(e);
    }

    /**
     * output actionToolBarCustom_actionPerformed
     */
    public void actionToolBarCustom_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionToolBarCustom_actionPerformed(e);
    }

    /**
     * output actionCloudFeed_actionPerformed
     */
    public void actionCloudFeed_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionCloudFeed_actionPerformed(e);
    }

    /**
     * output actionCloudShare_actionPerformed
     */
    public void actionCloudShare_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionCloudShare_actionPerformed(e);
    }

    /**
     * output actionCloudScreen_actionPerformed
     */
    public void actionCloudScreen_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionCloudScreen_actionPerformed(e);
    }

    /**
     * output actionXunTongFeed_actionPerformed
     */
    public void actionXunTongFeed_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionXunTongFeed_actionPerformed(e);
    }

    /**
     * output actionRefresh_actionPerformed
     */
    public void actionRefresh_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionRefresh_actionPerformed(e);
    }

    /**
     * output actionQuery_actionPerformed
     */
    public void actionQuery_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionQuery_actionPerformed(e);
    }

    /**
     * output actionPrint_actionPerformed
     */
    public void actionPrint_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionPrint_actionPerformed(e);
    }

    /**
     * output actionPrintPreview_actionPerformed
     */
    public void actionPrintPreview_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionPrintPreview_actionPerformed(e);
    }

    /**
     * output actionChart_actionPerformed
     */
    public void actionChart_actionPerformed(ActionEvent e) throws Exception
    {
        super.actionChart_actionPerformed(e);
    }

	@Override
	protected RptParams getParamsForInit() {
		// TODO Auto-generated method stub
		return null;
	}


	public boolean isShowFilter() {
		// TODO Auto-generated method stub
		return false;
	}
    
    protected boolean initDefaultFilter()
    {
        return true;
    }
    

	@Override
	protected ICommRptBase getRemoteInstance() throws BOSException {
		// TODO Auto-generated method stub
		return GgAnalyseReportFacdeFactory.getRemoteInstance();
	}

	@Override
	protected KDTable getTableForPrintSetting() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	protected void query() {
		// TODO Auto-generated method stub
		kDTable1.removeColumns();
		kDTable1.removeRows();
	}
	protected void treeMain_valueChanged(TreeSelectionEvent e) throws Exception {

		OrgStructureInfo orgStruct =new OrgStructureInfo();
		FullOrgUnitInfo orgInfo = FullOrgUnitFactory.getRemoteInstance()
		.getFullOrgUnitInfo(new ObjectUuidPK(orgStruct.getUnit().getId()));
		params.setObject("selectedOrgInfo", orgInfo);

		query();
	}
	  protected CommRptBaseConditionUI getQueryDialogUserPanel() throws Exception {
			return new GgAnalyseReportFiterUI();
		}
	    protected Dimension getQueryDialogSize(CustomerQueryPanel[] userPanels) {
	    	Dimension size = new Dimension(600, 120);
	    	return size;
	    }
	  
	public void tableDataRequest(KDTDataRequestEvent arg0) {
		if(isQuery) 
			return;
		isQuery=true;

		LongTimeDialog dialog = null;

		dialog = new LongTimeDialog(new Frame());
		dialog.setLongTimeTask(new ILongTimeTask() {
			public void afterExec(Object result) throws Exception {
				RptParams pp=(RptParams)params.clone();
				RptParams rpt = getRemoteInstance().createTempTable(pp);
				RptTableHeader header = (RptTableHeader)rpt.getObject("header");
				com.kingdee.eas.framework.report.util.KDTableUtil.setHeader(header, kDTable1);
				RptRowSet rs = (RptRowSet)((RptParams)result).getObject("rowSet");
				kDTable1.setRowCount(rs.getRowCount());
				com.kingdee.eas.framework.report.util.KDTableUtil.insertRows(rs,0, kDTable1);
				com.kingdee.bos.ctrl.kdf.table.IRow row=kDTable1.getRow(1);
				loadColor();
			}
			
			public Object exec() throws Exception {
				RptParams pp=(RptParams)params.clone();
				kDTable1.setRefresh(false);
				RptParams resultRpt= getRemoteInstance().query(pp);
				return resultRpt;
			}
		});
		dialog.show();
		isQuery = false;
	}
	
	private void loadColor() {
		for(int i=0;i<kDTable1.getRowCount();i++){
			IRow row=kDTable1.getRow(i);
			BigDecimal ceAmount = UIRuleUtil.getBigDecimal(row.getCell("ceAmount").getValue());
			if(ceAmount.compareTo(BigDecimal.ZERO) == 1){
				row.getCell("ceAmount").getStyleAttributes().setBackground(new Color(255, 253, 0));
			}
		}
	}
}
