/**
 * output package name
 */
package com.kingdee.eas.custom.gggl.client;

import java.awt.Color;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;

import org.apache.log4j.Logger;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTDataRequestEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.custom.gggl.AdvertFactory;
import com.kingdee.eas.custom.gggl.AdvertInfo;
import com.kingdee.eas.custom.gggl.DTypeEnum;
import com.kingdee.eas.custom.gggl.SaleContractE1Collection;
import com.kingdee.eas.custom.gggl.SaleContractE1Factory;
import com.kingdee.eas.fm.common.DateHelper;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.xr.XRSQLFacadeFactory;
import com.kingdee.jdbc.rowset.IRowSet;

/**
 * output class name
 */
public class AdvertGuangGaoPaiQiUI extends AbstractAdvertGuangGaoPaiQiUI
{
    private static final Logger logger = CoreUIObject.getLogger(AdvertGuangGaoPaiQiUI.class);
    
    /**
     * output class constructor
     */
    public AdvertGuangGaoPaiQiUI() throws Exception
    {
        super();
    }

    public void onLoad() throws Exception {
		super.onLoad();
		actionAddNew.setVisible(false);
		actionRemove.setVisible(false);
		actionEdit.setVisible(false);
		actionView.setVisible(false);
		actionPrint.setVisible(false);
		actionPrintPreview.setVisible(false);
		actionQuery.setVisible(false);
		Date date = new Date();
    	int year = Integer.parseInt(DateHelper.DateToString(date).substring(0,4));
    	SpinnerNumberModel startYearLevelModel = new SpinnerNumberModel(2000,2000,2999,1);
    	kdsYear.setModel(startYearLevelModel);
    	kdsYear.setValue(new Integer(year));
//    	kDTable1.getDataRequestManager().setDataRequestMode(KDTDataRequestManager.VIRTUAL_MODE_PAGE);
    	kDTable1.getStyleAttributes().setLocked(true);
    
    	EntityViewInfo view = new EntityViewInfo();
		FilterInfo filInfo = new FilterInfo();
		filInfo.getFilterItems().add(new FilterItemInfo("treeid.id","JQcAAAAAgOrsyXfw" ,CompareType.NOTEQUALS));//idǹλ Ӧͥ
		view.setFilter(filInfo);
		kDBizPromptBox1.setEntityViewInfo(view);
		
		this.setUITitle("ͬڱ");
		 setPreferredSize(getMaximumSize());
		
		
    	if(getUIContext().get("ggname")!=null){
    		String ggname=getUIContext().get("ggname").toString();
    		AdvertInfo info11 =  AdvertFactory.getRemoteInstance().getAdvertInfo("where  name='"+ggname+"' ");
    		kDBizPromptBox1.setValue(info11);
	
    	}
	}
	
	public void loadFields() {
		// TODO Auto-generated method stub
		super.loadFields();
	}
	public void onShow() throws Exception {

		super.onShow();
	}
	protected IQueryExecutor getQueryExecutor(IMetaDataPK arg0,EntityViewInfo arg1) {
		CompanyOrgUnitInfo info= SysContext.getSysContext().getCurrentFIUnit();
		EntityViewInfo view = (EntityViewInfo)arg1.clone();
		FilterInfo filInfo = new FilterInfo();
		filInfo.getFilterItems().add(new FilterItemInfo("djType",DTypeEnum.GG_VALUE));
		if(!info.getNumber().toString().equals("HY")){
			filInfo.getFilterItems().add(new FilterItemInfo("company.number",info.getNumber()));
			}
		view.setFilter(filInfo);
		return super.getQueryExecutor(arg0, view);
	}
	protected void afterTableFillData(KDTDataRequestEvent e) {
		super.afterTableFillData(e);
//		showTypelist();
	}
	
	//ͨ͹б
	private void showTypelist() {
		//		super.actionRefresh_actionPerformed(e);
		for(int i=0;i<this.tblMain.getRowCount();i++){
			IRow row = this.tblMain.getRow(i);
			if(row.getCell("djType").getValue()!=null){
				String djType = row.getCell("djType").getValue().toString();
				if(djType.equals(DTypeEnum.gg.toString())){
					row.getStyleAttributes().setHided(false);
				}else{
					row.getStyleAttributes().setHided(true);
				}
			}
		}
	}
	
	protected void kdsYear_stateChanged(ChangeEvent e) throws Exception {
		super.kdsYear_stateChanged(e);
		kDTable1.removeRows();
		int year=Integer.parseInt(kdsYear.getValue().toString());
		getAddRow(year);
	}
	protected void kDBizPromptBox1_dataChanged(DataChangeEvent e)throws Exception {
		super.kDBizPromptBox1_dataChanged(e);
		kDTable1.removeRows();
		int year=Integer.parseInt(kdsYear.getValue().toString());
		getAddRow(year);
	}
	
    /**
     * output ݹλ
     */
    public void getAddRow(int year) throws BOSException, SQLException
    {
    	
    	StringBuffer sql=new StringBuffer();
		sql.append(" SELECT  a.fid id ,a.fnumber numbers,a.fname_l2 names FROM CT_GGL_Advert a  ");
		sql.append(" left join  T_GGL_AdvertTREE tree ON a.FTREEID=tree.fid   ");
		sql.append(" where 1=1 and tree.fid !=  'JQcAAAAAgOrsyXfw' "); //ͥ
		
         if(kDBizPromptBox1.getValue()!=null){
        	AdvertInfo info =  (AdvertInfo) kDBizPromptBox1.getValue(); 
           sql.append(" and  a.fid='"+info.getId()+"'  ");
		}
         sql.append(" order by a.fnumber ");
		
		IRowSet rowset=XRSQLFacadeFactory.getRemoteInstance().executeQuery(sql.toString(), null);
		while(rowset.next()){
			String id =rowset.getString("id");
			String numbers =rowset.getString("numbers");
			String names =rowset.getString("names");
			 DateFormat FORMAT_DAY = new SimpleDateFormat("yyyy-MM-dd");
	    	 Map dateMap =  new HashMap();
	    	SaleContractE1Collection accol = null;
	    	try {
	    		accol = SaleContractE1Factory.getRemoteInstance().getSaleContractE1Collection(
	    				"select zlStartDate,zlEndDate,ggw.id,ggw.name from where ggw = '"+ id+"' and ( parent.status != '0' and parent.status != '1' and parent.status != '3'  ) ");//and ( parent.status != '0' and parent.status != '1' and parent.status != '3'  )
	    		for (int i = 0; i < accol.size(); i++) {
	    			dateMap =  getBetweenDatesMap(dateMap,accol.get(i).getZlStartDate(), accol.get(i).getZlEndDate() );
	    		}

	    	} catch (BOSException e) {
				e.printStackTrace();
			}
	    	
			getH12( kDTable1,  id, numbers, names,year, dateMap);
		}
	    mergeThemeRow(kDTable1, "id", 0);
	    mergeThemeRow(kDTable1, "id", 1);
	    mergeThemeRow(kDTable1, "id", 2);
	    mergeThemeRow(kDTable1, "id", 3);
		
    }
    
	
    /**
     * ֵ¸Ԫֵ
     */
    public void getH12(KDTable kdtable,String  id,String number,String name,int year ,Map dateMap)
    {
    	
    	for(int i=1;i<=12;i++){//12
    		IRow row=kdtable.addRow();
    		row.getCell("id").setValue(id);
    		row.getCell("number").setValue(number);
    		row.getCell("name").setValue(name);
    		row.getCell("month").setValue(getMonth(i));
    		row.getCell("months").setValue(i);
    		
    		int monthdays= getDaysByYearMonth(year,i);//·
    		for(int j=1;j<=monthdays;j++){
    			row.getCell(""+j+"").setValue(j);//ֵһ
    			if(dateMap.get(year+"-"+i+"-"+j)!=null){
    				row.getCell(""+j+"").getStyleAttributes().setBackground(Color.green);	
    			}
    		}
    	}
    }
    public static String getMonth(int j) {
    	String month="";
    	if(j==1){
    		month="һ";
		}else if(j==2){
			month="";
		}
        else if(j==3){
        	month="";
		}
         else if(j==4){
        	month="";
		}
         else if(j==5){
        		month="";
				
			}
         else if(j==6){
        		month="";
				
			}
         else if(j==7){
        		month="";
			}
         else if(j==8){
        		month="";
			}
         else if(j==9){
        		month="";
			}
         else if(j==10){
        		month="ʮ";
			}
         else if(j==11){
        		month="ʮһ";
			}
         else if(j==12){
        		month="ʮ";
			}
    	
    	return month;
    }
    
    /**
     * ȡ֮
     * @param start ʼ
     * @param end 
     * @return ڼ
     */
    private List<Date> getBetweenDates(Date start, Date end) {
        List<Date> result = new ArrayList<Date>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd)) {
            result.add(tempStart.getTime());
            tempStart.add(Calendar.DAY_OF_YEAR, 1);
        }
        return result;
    }
    
    /**
     * ȡ֮
     * @param start ʼ
     * @param end 
     * @return ڼ
     */
    private Map getBetweenDatesMap(Map DateMap,Date start, Date end) {
    	DateFormat FORMAT_DAY = new SimpleDateFormat("yyyy-MM-dd");
    	
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd)) {
        	DateMap.put(tempStart.get(Calendar.YEAR)+"-"+(tempStart.get(Calendar.MONTH)+1)+"-"+tempStart.get(Calendar.DATE) , tempStart);
            tempStart.add(Calendar.DAY_OF_YEAR, 1);
            DateMap.put(tempStart.get(Calendar.YEAR)+"-"+(tempStart.get(Calendar.MONTH)+1)+"-"+tempStart.get(Calendar.DATE) , tempStart);
        }
        return DateMap;
    }
    
    /**
     *   ȡӦ· 
     */
    public static int getDaysByYearMonth(int year, int month) {
       Calendar a = Calendar.getInstance();
       a.set(Calendar.YEAR, year);
       a.set(Calendar.MONTH, month - 1);
       a.set(Calendar.DATE, 1);
       a.roll(Calendar.DATE, -1);
       int maxDate = a.get(Calendar.DATE);
       return maxDate;
     }
    

	  /**
	 * ںϢ
	 * */
	private void mergeThemeRow(KDTable table,String columnName,int colIndex){
		  String theme = "";
	        String lastTheme = "";
	        KDTMergeManager mm = table.getMergeManager();
	        int rowIndx = 0;
	        int endIndx = 0;
	        for(int i=0 ;i<table.getRowCount();i++){
	        	endIndx = i;
	        	theme = (String)table.getRow(i).getCell(columnName).getValue(); //ǰ
	        	if(i>0){
	        		lastTheme = (String)table.getRow(i-1).getCell(columnName).getValue(); //һ
	            	if(theme!=null&&!theme.equals(lastTheme)){ // ȡǰ  һ ͬڵк
	            		mm.mergeBlock(rowIndx, colIndex,endIndx-1, colIndex); // ͬں
	            		rowIndx = endIndx;
	            	}
	        	}
	        }
	        mm.mergeBlock(rowIndx, colIndex,endIndx, colIndex); // ͬں
	}
    /**
     * output storeFields method
     */
    public void storeFields()
    {
        super.storeFields();
    }


	@Override
	protected ICoreBase getBizInterface() throws Exception {
		return null;
	}

	@Override
	protected String getEditUIName() {
		return null;
	}

}