package com.kingdee.eas.custom.gggl.app;

import java.sql.Timestamp;
import java.util.Map;

import org.apache.log4j.Logger;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.gggl.ContractFirstFactory;
import com.kingdee.eas.custom.gggl.ContractFirstInfo;
import com.kingdee.eas.custom.gggl.IContractFirst;
import com.kingdee.eas.custom.gggl.SaleContractInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.xr.XRBillBaseInfo;
import com.kingdee.eas.xr.app.XRBillStatusEnum;

public class SaleContractControllerBean extends AbstractSaleContractControllerBean
{
    private static Logger logger =
        Logger.getLogger("com.kingdee.eas.custom.gggl.app.SaleContractControllerBean");
    
    
    public void _audit(Context ctx, IObjectPK pk) throws BOSException,
    		EASBizException {
    	ContractFirstInfo finfo = new ContractFirstInfo();
		XRBillBaseInfo aXRBillBaseInfo = getXRBillBaseInfo(ctx, pk);
		
		_checkAudit(ctx, aXRBillBaseInfo, true);
		_checkSubmit(ctx, aXRBillBaseInfo, false);
		aXRBillBaseInfo.setAuditor(ContextUtil.getCurrentUserInfo(ctx));
		aXRBillBaseInfo.setAuditTime( new Timestamp(System.currentTimeMillis()));
		aXRBillBaseInfo.setStatus(XRBillStatusEnum.AUDITED);
		update(ctx, pk, aXRBillBaseInfo);
		IContractFirst iContractFirst= ContractFirstFactory.getLocalInstance(ctx);
		if(iContractFirst.exists("where number='"+aXRBillBaseInfo.getNumber()+"'")){
			iContractFirst.delete("where number='"+aXRBillBaseInfo.getNumber()+"'");
		}
		SaleContractInfo info = (SaleContractInfo)aXRBillBaseInfo;
    		try {
    			info.setId(BOSUuid.create(finfo.getBOSType()));
    			iContractFirst.addnew(info);
    			iContractFirst.submit(info);
    			iContractFirst.audit(new ObjectUuidPK(info.getId().toString()));
    		} catch (EASBizException e) {
    			e.printStackTrace();
    		}
    }
    
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException,
	EASBizException {
// TODO Auto-generated method stub
    super._unAudit(ctx, pk);
    }
    
    public Map audit(Context ctx, IObjectPK[] pks) throws BOSException,
    		EASBizException {
    	ContractFirstInfo finfo = new ContractFirstInfo();
    	for(int i=0;i<pks.length;i++){
    		XRBillBaseInfo aXRBillBaseInfo = getXRBillBaseInfo(ctx, pks[i]);
    		SaleContractInfo info = (SaleContractInfo)aXRBillBaseInfo;
    			try {
    				info.setId(BOSUuid.create(finfo.getBOSType()));
    				ContractFirstFactory.getLocalInstance(ctx).addnew(info);
    				ContractFirstFactory.getLocalInstance(ctx).submit(info);
    				ContractFirstFactory.getLocalInstance(ctx).audit(new ObjectUuidPK(info.getId().toString()));
    			} catch (EASBizException e) {
    				e.printStackTrace();
    			}
    	}
    	return super.audit(ctx, pks);
    }
    
    
}