package com.kingdee.eas.custom.gggl.app;

import java.util.Map;

import org.apache.log4j.Logger;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.gggl.ContractChangeE1Info;
import com.kingdee.eas.custom.gggl.ContractChangeE2Info;
import com.kingdee.eas.custom.gggl.ContractChangeInfo;
import com.kingdee.eas.custom.gggl.ISaleContract;
import com.kingdee.eas.custom.gggl.ISaleContractE1;
import com.kingdee.eas.custom.gggl.ISaleContractE2;
import com.kingdee.eas.custom.gggl.SaleContractE1Factory;
import com.kingdee.eas.custom.gggl.SaleContractE1Info;
import com.kingdee.eas.custom.gggl.SaleContractE2Factory;
import com.kingdee.eas.custom.gggl.SaleContractE2Info;
import com.kingdee.eas.custom.gggl.SaleContractFactory;
import com.kingdee.eas.custom.gggl.SaleContractInfo;
import com.kingdee.eas.xr.XRBillBaseInfo;

public class ContractChangeControllerBean extends AbstractContractChangeControllerBean
{
    private static Logger logger =
        Logger.getLogger("com.kingdee.eas.custom.gggl.app.ContractChangeControllerBean");
    
    public void _audit(Context ctx, IObjectPK pk) throws BOSException,
			EASBizException {
		// TODO Auto-generated method stub
		super._audit(ctx, pk);
    	XRBillBaseInfo aXRBillBaseInfo = getXRBillBaseInfo(ctx, pk);
    	ContractChangeInfo info = (ContractChangeInfo)aXRBillBaseInfo;
    	
    	ISaleContract isc = SaleContractFactory.getLocalInstance(ctx);
    	SaleContractInfo  scinfo = isc.getSaleContractInfo(new ObjectUuidPK(info.getSourceBillId()));
//    	scinfo.setNumber(info.getNumber());//ݱ
    	scinfo.setCustomer(info.getCustomer());//ͻ
    	scinfo.setHtAmount(info.getHtAmount());//ͬ˰
    	scinfo.setBizDate(info.getBizDate());//ǩԼ
    	scinfo.setZrPerson(info.getZrPerson());//
    	scinfo.setYjAmount(info.getYjAmount());//Ѻ
    	scinfo.setPp(info.getPp());//Ʒ
    	scinfo.setDeparment(info.getDeparment());//β
    	scinfo.setHtnn(info.getHtnn());//ͬ
    	scinfo.setBeiz(info.getBeiz());//ע
    	isc.update(new ObjectUuidPK(scinfo.getId().toString()), scinfo);
    	ISaleContractE1 iSaleContractE1=SaleContractE1Factory.getLocalInstance(ctx);
    	ISaleContractE2 iSaleContractE2=SaleContractE2Factory.getLocalInstance(ctx);
    	
    	for (int i = 0; i < info.getE1().size(); i++) {
    		ContractChangeE1Info e1 = info.getE1().get(i);
    		SaleContractE1Info sce1 =null ;
    		if(e1.getSourceEnID()!=null){
    			sce1 =  iSaleContractE1.getSaleContractE1Info(new ObjectUuidPK(e1.getSourceEnID()));
    			sce1.setParent(scinfo);
    			sce1.setSeq(e1.getSeq());
    			sce1.setGgw(e1.getGgw());
    			sce1.setZlStartDate(e1.getZlStartDate());
    			sce1.setZlEndDate(e1.getZlEndDate());
    			sce1.setZlzq(e1.getZlzq());
    			sce1.setZlAmount(e1.getZlAmount());
    			sce1.setZlPayDate(e1.getZlPayDate());
    			sce1.setZzAmount(e1.getZzAmount());
    			sce1.setZzPayDate(e1.getZzPayDate());
    			sce1.setRemak(e1.getRemak());
    			iSaleContractE1.update(new ObjectUuidPK(e1.getSourceEnID()), sce1);
    		}else{
    			sce1 =  new SaleContractE1Info();
    			sce1.setParent(scinfo);
    			sce1.setSeq(e1.getSeq());
    			sce1.setGgw(e1.getGgw());
    			sce1.setZlStartDate(e1.getZlStartDate());
    			sce1.setZlEndDate(e1.getZlEndDate());
    			sce1.setZlzq(e1.getZlzq());
    			sce1.setZlAmount(e1.getZlAmount());
    			sce1.setZlPayDate(e1.getZlPayDate());
    			sce1.setZzAmount(e1.getZzAmount());
    			sce1.setZzPayDate(e1.getZzPayDate());
    			sce1.setRemak(e1.getRemak());
    			iSaleContractE1.save(sce1);
    		}
		}
    	
      	for (int i = 0; i < info.getE2().size(); i++) {
    		ContractChangeE2Info e1 = info.getE2().get(i);
    		SaleContractE2Info sce1 =null ;
    		if(e1.getSourceEnID()!=null){
    			sce1 =  iSaleContractE2.getSaleContractE2Info(new ObjectUuidPK(e1.getSourceEnID()));
    			sce1.setParent(scinfo);
    			sce1.setSeq(e1.getSeq());
    			sce1.setGgw(e1.getGgw());
    			sce1.setRecType(e1.getRecType());
    			sce1.setSkAmount(e1.getSkAmount());
    			sce1.setSkDate(e1.getRecDate());
    			iSaleContractE2.update(new ObjectUuidPK(e1.getSourceEnID()), sce1);
    		}else{
    			sce1 =  new SaleContractE2Info();
    			sce1.setParent(scinfo);
    			sce1.setSeq(e1.getSeq());
    			sce1.setGgw(e1.getGgw());
    			sce1.setRecType(e1.getRecType());
    			sce1.setSkAmount(e1.getSkAmount());
    			sce1.setSkDate(e1.getRecDate());
    			iSaleContractE2.save(sce1);
    		}
		}
	}
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException,
    		EASBizException {
    	// TODO Auto-generated method stub
    	super._unAudit(ctx, pk);
    }
    
    public Map audit(Context ctx, IObjectPK[] pks) throws BOSException,
    		EASBizException {
    	return super.audit(ctx, pks);
    }
    
}