package com.kingdee.eas.fi.cas.app;

import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.Iterator;
import java.util.Set;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.custom.gggl.ISaleContractE2;
import com.kingdee.eas.custom.gggl.SaleContractE2Factory;
import com.kingdee.eas.custom.gggl.SaleContractE2Info;
import com.kingdee.eas.fi.cas.IReceivingBill;
import com.kingdee.eas.fi.cas.IReceivingBillType;
import com.kingdee.eas.fi.cas.ReceivingBillEntryInfo;
import com.kingdee.eas.fi.cas.ReceivingBillFactory;
import com.kingdee.eas.fi.cas.ReceivingBillInfo;
import com.kingdee.eas.fi.cas.ReceivingBillTypeFactory;
import com.kingdee.eas.fi.cas.ReceivingBillTypeInfo;

public class ReceivingBillControllerBeanEx extends ReceivingBillControllerBean {
	
	   protected void _audit(Context ctx, Set set) throws BOSException,EASBizException {
	    	super._audit(ctx, set);
	    	 IReceivingBill iReceivingBill= ReceivingBillFactory.getLocalInstance(ctx);
	    	 ISaleContractE2 iSaleContractE2=SaleContractE2Factory.getLocalInstance(ctx);
	    	 IReceivingBillType iReceivingBillType=ReceivingBillTypeFactory.getLocalInstance(ctx);
	    	 Iterator iterator = set.iterator();
	    	 while(iterator.hasNext()){
	    		String id=iterator.next().toString();
	    		ReceivingBillInfo info =iReceivingBill.getReceivingBillInfo(new ObjectUuidPK(id));
	    		ReceivingBillTypeInfo typeInfo=iReceivingBillType.getReceivingBillTypeInfo(new ObjectUuidPK(info.getRecBillType().getId()));
	    		if(!typeInfo.getNumber().equals("106")){
	    			if(info.get("saleContract")!=null&&!info.getBoolean("isHy")){
		    			for(int i=0;i<info.getEntries().size();i++){
		    				ReceivingBillEntryInfo enInfo=info.getEntries().get(i);
		    				SaleContractE2Info sEnInfo =iSaleContractE2.getSaleContractE2Info(new ObjectUuidPK(enInfo.getCoreBillEntryId()));
		    				BigDecimal recAmount=UIRuleUtil.getBigDecimal(sEnInfo.getRecAmount()).add(enInfo.getActualAmt());
							sEnInfo.setRecAmount(recAmount);
							sEnInfo.setRecDate(new Timestamp(System.currentTimeMillis()));
							iSaleContractE2.update(new ObjectUuidPK(enInfo.getCoreBillEntryId()), sEnInfo);
		    			}
		    		}
	    		}
	    	 }
	    }
	protected void _antiAudit(Context arg0, Set arg1) throws BOSException,
			EASBizException {
		// TODO Auto-generated method stub
		super._antiAudit(arg0, arg1);
	  	 IReceivingBill iReceivingBill= ReceivingBillFactory.getLocalInstance(arg0);
    	 ISaleContractE2 iSaleContractE2=SaleContractE2Factory.getLocalInstance(arg0);
    	 IReceivingBillType iReceivingBillType=ReceivingBillTypeFactory.getLocalInstance(arg0);
    	 
    	 Iterator iterator = arg1.iterator();
    	 while(iterator.hasNext()){
    		String id=iterator.next().toString();
    		ReceivingBillInfo info =iReceivingBill.getReceivingBillInfo(new ObjectUuidPK(id));
    		ReceivingBillTypeInfo typeInfo=iReceivingBillType.getReceivingBillTypeInfo(new ObjectUuidPK(info.getRecBillType().getId()));
    		if(!typeInfo.getNumber().equals("106")){
    			if(info.get("saleContract")!=null&&!info.getBoolean("isHy")){
        			for(int i=0;i<info.getEntries().size();i++){
        				ReceivingBillEntryInfo enInfo=info.getEntries().get(i);
        				SaleContractE2Info sEnInfo =iSaleContractE2.getSaleContractE2Info(new ObjectUuidPK(enInfo.getCoreBillEntryId()));
        				BigDecimal recAmount=UIRuleUtil.getBigDecimal(UIRuleUtil.getBigDecimalValue(sEnInfo.getRecAmount())).subtract(enInfo.getActualAmt());
        				sEnInfo.setRecAmount(recAmount);
        				sEnInfo.setRecDate(null);
    					iSaleContractE2.update(new ObjectUuidPK(enInfo.getCoreBillEntryId()), sEnInfo);
        			}
        		}
    		}
    	 }
	}

}
