/**
 * output package name
 */
package com.kingdee.eas.custom.gggl.client;

import java.awt.event.*;
import java.text.SimpleDateFormat;
import java.util.Date;

import org.apache.log4j.Logger;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.framework.*;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.xr.helper.DateXRHelper;

/**
 * output class name
 */
public class GgAnalyseReportFiterUI extends AbstractGgAnalyseReportFiterUI
{
    private static final Logger logger = CoreUIObject.getLogger(GgAnalyseReportFiterUI.class);
    
    /**
     * output class constructor
     */
    public GgAnalyseReportFiterUI() throws Exception
    {
        super();
        kDDatePicker1.setValue(DateXRHelper.getFirstYearDate(new Date()));
        kDDatePicker2.setValue(DateXRHelper.getLastYearDate(new Date()));
    }

    /**
     * output storeFields method
     */
    public void storeFields()
    {
        super.storeFields();
    }

	public RptParams getCustomCondition() {
		RptParams pp = new RptParams();
		
		if(kDDatePicker1.getValue()!=null){
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			String  zlStartDates=  sdf.format(kDDatePicker1.getValue());
			pp.setObject("startDate", zlStartDates);
		}
		if(kDDatePicker2.getValue()!=null){
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			String  endDates=  sdf.format(kDDatePicker2.getValue());
			pp.setObject("endDate", endDates);
			
		}
		return pp;
	}

	public void onInit(RptParams arg0) throws Exception {
		
	}

	public void setCustomCondition(RptParams arg0) {
		
	}

}