# 1. 目的
为了保证系统稳定性运行，严格管理、规范实施，制定本项目部署和版本发布规范。
# 2. 项目部署环境
## 2.1 Spring Boot 项目
### 2.1.1 部署路径目录

- app --资源总目录
   - fatjar  --项目Jar包目录
   - tool --项目启动脚本目录
      - logs --日志目录
   - backup --备份目录
   - tmp --临时目录
### 2.1.2 启动脚本定义
Linux:
```shell
#!/bin/bash
FAT_JAR_DIR=../fatjar/
APP_NAME=check-service*
APP_PATH=$FAT_JAR_DIR$APP_NAME
PROFILES_ACTIVE=test
if [ "$2" ]; then
    PROFILES_ACTIVE=$2
fi
PID=$(ps -ef|grep $APP_NAME|grep -v grep|grep -v kill|awk '{print $2}')
case "$1" in
start)
  if [ "$PID" ]; then
    kill -9 "$PID"
          echo kill $APP_NAME "$PID"
  fi
  java -jar $APP_PATH --spring.profiles.active="$PROFILES_ACTIVE" > /dev/null 2>&1 &
  echo $APP_NAME is start at profiles "$PROFILES_ACTIVE"
;;
stop)
  if [ -z "$PID" ]
  then
    echo $APP_NAME is already stopped
  else
    echo kill "$PID"
    kill -9 "$PID"
        echo $APP_NAME is stopped
  fi
;;
status)
  if [ -z "$PID" ]
  then
    echo $APP_NAME is already stopped
  else
    echo $APP_NAME is running
  fi
;;
*)
  echo "useing generator-boot.sh (start|stop|status)"
esac
```
> **修改脚本参数参数：**
> FAT_JAR_DIR：默认../fatjar/，一般不用调整
> APP_NAME：Jar名称，例如：check-service-1.0.0.jar，可写成check-service*，但必须保证唯一，通过check-service*只能找到一个文件，如再出现check-service-biz-1.0.0.jar则会找到2个将存在问题
> PROFILES_ACTIVE：项目环境，根据服务器是属于DEV/TEST/PORD进行调整
> 
> **如何启动, 停止, 以及查询服务的运行状态：**
> ./run-xxx.sh start //启动项目
> ./run-xxx.sh stop //停止项目
> ./run-xxx.sh status //查看项目状态
> 
> **注意事项：**
> 如果当前服务器存在多个用户账号去启停程序，需要注意采用原始账号操作，否则可能会启动多个进程，操作程序错误。
> 有特殊场景下会存在多个程序进程执行，可通过命令：ps -ef | grep java 查找到PID，再通过kill -9 PID 结束进程。

## 2.2 Tomcat 项目

- Tomcat 安装略过
- Tomcat 同级创建backup目录，用于备份项目包
- 直接将 Web 项目文件拷贝到 webapps 目录中
## 2.3 Vue 项目
开发完的vue的项目 首先运行 以下命令 对项目进行打包
### **2.3.1 打包**
默认情况下，使用vue-cli创建的项目，package.json里的script应该已经配置了build指令，直接执行yarn build 或者 npm run build即可。
### **2.3.1 部署路径目录**
第一种方式：将vue打包后放在springboot项目的resource下的static文件夹下，将vue当成一个静态资源去访问，部署相对方便，能跟springboot项目一起被打成jar包，启动方便。
第二种方式：用ngnix去做代理，vue、springboot分开部署，分开部署不会相互影响。
通用情况下采用第二种方式，部署到nginx的html目录下。

**域名根目录部署**
比如我们希望项目部署到[http://shxrtech.com](https://link.zhihu.com/?target=http%3A//a.com/test)下，这样访问[http://shxrtech.com](https://link.zhihu.com/?target=http%3A//a.com/test)访问到的是项目的首页
```shell
这里给出的是示例，具体需要按自己项目来
server {
        #端口
        listen       8081;
        #ip地址
        server_name  localhost;
        
        #这里为项目访问的根路径，以及默认访问的文件
        location / {
            #将打包后的前端项目放到root设置的路径下
            root  html/cosco;
            #这里默认即可
            index  index.html index.htm;
        }
        #请求代理配置到你后端启动的地址
        location /api {
            proxy_pass http://localhost:8080/api;
        }
}
```
**非域名根路径部署**
有时候同一台服务器同一端口下可能会根据目录划分出多个不同的项目，比如我们希望项目部署到[http://shxrtech.com/test](https://link.zhihu.com/?target=http%3A//a.com/test)下，这样访问[http://shxrtech.com/test](https://link.zhihu.com/?target=http%3A//a.com/test)访问到的是项目的首页，而非test前缀的地址会访问到其它项目。此时需要修改nginx配置以及Vue打包配置。
```shell
这里给出的是示例，具体需要按自己项目来
server {
        #端口
        listen       8081;
        #ip地址
        server_name  localhost;
        
        #这里为项目访问的根路径，以及默认访问的文件
        location / {
            #将打包后的前端项目放到root设置的路径下
            root  html/cosco;
            #这里默认即可
            index  index.html index.htm;
        }
        
        location /test {
            #将打包后的前端项目放到root设置的路径下
            root  html/test;
            #这里默认即可
            index  index.html index.htm;
        }
        
        #请求代理配置到你后端启动的地址
        location /api {
            proxy_pass http://localhost:8080/api;
        }
}
```
**最后就是nginx修改配置一定要重启！！**
> **#进入nginx安装目录**
> cd /usr/local/nginx/sbin/
> **#检查配置文件是否正确**
> ./nginx –t
> **#重启nginx服务**
> ./nginx –s reload

### **2.3.1 **解决刷新路由404问题
Vue项目采用了history的路由方式后打包出现404
解决问题的办法：

1. 将路由模式改为hash
1. 修改nginx配置
```shell
location / {
    root ...
    index ...
    try_files $uri $uri/ /index.html; ---解决页面刷新404问题
}
```
# 3. 部署事项
## 3.1 部署前期

- 测试环境应与生产环境采用相同的操作系统、数据库和服务器版本
- 合并代码到预发布分支，部署到测试环境进行测试验证，源代码必须保持一致，能够分环境配置参数的项目必须采用配置文件
- 部署中涉及到第三方配合的，需要制定上线计划，上线计划应该清晰地表明执行步骤和负责人
- 需要准备好回退计划
## 3.2 部署中
### 3.2.1 单节点发布：

- 编译---从git的master分支或指定tag拉取代码
- 上传---编译完成后的程序包上传到指定机器的目录下
- 停止---在指定服务器上停止当前需要更新的程序包
- 备份---在指定服务器上备份当前需要更新的程序包（必须要备份）
- 更新---在指定服务器上启动最新的程序包
### 3.2.2 多节点发布：
多节点部署是一种可以保证系统在不间断提供服务的情况下上线部署方式；
在系统升级的时候，先把集群中的节点A进行剔除，进行新版本的更新，此时集群中的节点B仍然在继续的提供服务；当节点A升级完毕，再把节点A添加到集群当中，然后在将节点B从集群中剔除进行升级，节点A进行提供服务，当节点B升级完毕后，再把节点B也恢复到负载列表中去。
### 3.2.3 数据库操作：

- 生产环境新增字段采用Alert 语句，详细记录到部署文件中。
- 涉及批量操作（含CURD）必须备份全表数据，规则采用：原表名_bakup_yyyymmdd，备份数据可根据时间周期选择性删除。
### 3.3 部署验证

- 服务启动验证，确保相关的服务均已启动。
- 检查日志中是否有错误信息
- 更新内容测试，对本次版本新增功能和修正BUG进行1次验证（部分无法验证的，在第二天进行观察日志输出是否正常）。
- 验证结果不达标，可选择回滚、现场修复、后期更新等方式。
- 项目部署完成或回滚后应及时通知项目负责人或客户此次发布相关结果。
- 上线完成后，更新归档上线文档



