# 分支管理规范



# 1. 发布主分支(master)

- 每个代码库有且仅有一个主分支 master。所有提供给用户使用的正式版本，都在这个主分支上发布。
- master 分支仅用于发布正式版本，同时需确保主分支的任何内容都是可部署的。并且只允许对 master 进行其他分支的合并和创建标记操作，不能单独在 master 分支上进行提交。

# 2.开发主分支(develop)

- develop 分支是进行开发的基础分支，其他的短特性分支是基于develop分支切分出来的，当开始一个新的功能分支时，它将是开发的基础。
- 新功能的开发分支会合并在develop分支中，等待被整合到 master 分支中。

# 3. 功能分支(feature)

- feature 分支为开发某个功能点而创建。
- 完成功能点的开发后，feature 分支的最新内容部署 test 环境进行功能测试验收。功能点测试完成后再合并入 develop分支，并删除 feature 分支。
# 4. 热修复分支（hotfix）

- 正式发布以后，出现 Bug 。这时就需要创建一个 hotfix分支 ，进行 Bug 热修复，hotfix是基于master分支进行切分的，完成会合并入master分支，再合并到develop分支。
- 分支的命名格式为hotfix-[新版本号码]，例如hotfix-0.1.1。
- 漏洞修复后需要为hotfix 分支制作一个新的修订号版本标记。最后，根据实际情况可选的合并入 master 分支，再合并到develop分支，并删除 hotfix 分支。

**仓库中存在两种长期分支：master和develop。master中存放对外发布的版本，只有稳定的发布版本才会合并到master中。develop用于日常开发，存放最新的开发版本。**
**二种临时分支：feature,hotfix，仅仅只是临时存在的，根据需要来创建，此类分支完成了自己的任务之后就会被删除掉。**
# 分支命名规约
| 前缀 | 含义 |
| --- | --- |
| master | 主分支，可用的、稳定的、可直接发布的版本 |
| develop | 开发主分支，最新的代码分支 |
| feature-** | 功能开发分支 |
| hotfix-** | 已发布bug修复分支 |

## 版本号规范
版本格式：主版本号.次版本号.修订号，版本号递增规则如下：
1.主版本号：当你做了不兼容的 API 修改。
2.次版本号：当你做了向下兼容的功能性新增。
3.修订号：当你做了向下兼容的问题修正。
先行版本号及版本编译信息可以加到“主版本号.次版本号.修订号”的后面，作为延伸。
