# Java开发注意事项



# 一、异常

## 1. 六类典型空指针问题

- 包装类型的空指针问题
```java
public class NullPointTest {
    
    public static void main(String[] args) throws InterruptedException {
        System.out.println(testInteger(null));
    }
    
    private static Integer testInteger(Integer i) {
        return i + 1;  //包装类型，传参可能为null，直接计算，则会导致空指针问题
    }
}
```

- 级联调用的空指针问题
```java
public class NullPointTest {
    public static void main(String[] args) {
        //fruitService.getAppleService() 可能为空，会导致空指针问题
        fruitService.getAppleService().getWeight().equals("18");
    }
}
```

- Equals方法左边的空指针问题
```java
public class NullPointTest {
    public static void main(String[] args) {
        String s = null;
        if (s.equals("666")) { //s可能为空，会导致空指针问题
            System.out.println("公众号：捡田螺的小男孩，666");
        }
    }
}
```

- ConcurrentHashMap 类似容器不支持 k-v为 null
```java
public class NullPointTest {
    public static void main(String[] args) {
        Map map = new ConcurrentHashMap<>();
        String key = null;
        String value = null;
        map.put(key, value);
    }
}
```

- 集合，数组直接获取元素
```java
public class NullPointTest {
    public static void main(String[] args) {
        int [] array=null;
        List list = null;
        System.out.println(array[0]); //空指针异常
        System.out.println(list.get(0)); //空指针一场
    }
}
```

- 对象直接获取属性
```java
public class NullPointTest {
    public static void main(String[] args) {
        User user=null;
        System.out.println(user.getAge()); //空指针异常
    }
}
```
## 2. 异常的几个坑

- **finally重新抛出的异常也要注意**
```java
public void wrong() {
    try {
        log.info("try");
        //异常丢失
        throw new RuntimeException("try");
    } finally {
        log.info("finally");
        throw new RuntimeException("finally");
    }
}
```
一个方法是不会出现两个异常的呢，所以finally的异常会把try的**异常覆盖**。正确的使用方式应该是，finally 代码块**负责自己的异常捕获和处理**。
```java
public void right() {
    try {
        log.info("try");
        throw new RuntimeException("try");
    } finally {
        log.info("finally");
        try {
            throw new RuntimeException("finally");
        } catch (Exception ex) {
            log.error("finally", ex);
        }
    }
}
```
# 二、Spring事务未生效
日常业务开发中，我们经常跟事务打交道，**事务失效**主要有以下几个场景：

- 底层数据库引擎不支持事务
- 在非public修饰的方法使用
- rollbackFor属性设置错误
- 本类方法直接调用
- 异常被try...catch吃了，导致事务失效。

其中，最容易踩的坑就是后面两个，**注解的事务方法给本类方法直接调用**，伪代码如下：
```java
public class TransactionTest{
    public void A(){
        //插入一条数据
        //调用方法B (本地的类调用，事务失效了)
        B();
    }
    
    @Transactional
    public void B(){
        //插入数据
    }
}
```
如果用异常catch住，**那事务也是会失效呢**~，伪代码如下：

```java
@Transactional
public void method(){
    try{
        //插入一条数据
        insertA();
        //更改一条数据
        updateB();
    }catch(Exception e){
        logger.error("异常被捕获了，那你的事务就失效咯",e);
    }
}
```
# 三、数据访问
## 1. Mysql8数据库的时区坑
对mysql数据库进行升级，新版本为8.0.12。但是升级完之后，发现now()函数，获取到的时间比北京时间晚8小时，原来是因为mysql8默认为美国那边的时间，需要指定时区。
:::info
jdbc:mysql://localhost:3306/test?useUnicode=true&characterEncoding=UTF-8& **serverTimezone=Asia/Shanghai**
:::
## 2. 数据库使用utf-8存储， 插入表情异常的坑
低版本的MySQL支持的utf8编码，最大字符长度为 3字节，但是呢，存储表情需要4个字节，因此如果用utf8存储表情的话，会报SQLException: Incorrect string value: '\xF0\x9F\x98\x84' for column，所以一般用utf8mb4编码去存储表情。
# 四、待定
## 1. 疏忽switch的return和break
```java
public class SwitchTest {

    public static void main(String[] args) throws InterruptedException {
        System.out.println("testSwitch结果是："+testSwitch("1"));
    }

    private static String testSwitch(String key) {
        switch (key) {
            case "1":
                System.out.println("1");
            case "2":
                System.out.println(2);
                return "2";
            case "3":
                System.out.println("3");
            default:
                System.out.println("返回默认值");
                return "4";
        }
    }
}
```
输出结果：
```java
1 
2 
testSwitch结果是：2
```
switch 是会**沿着case一直往下匹配的，直到遇到return或者break。** 所以，在写代码的时候留意一下，是不是你要的结果。

