# 前端开发注意事项

- 在函数内用了this.xxx=,抛出Cannot set property ‘xxx’ of undefined
```
mounted(){ // this指向问题
	console.log(this)
	setTimeout(()=>{
		console.log(this) // Vue
		console.log (this.b)
	},500)
	setTimeout(function(){
		console.log(this) // Window
		console.log(this.b) // undefined
	},500)
}
```

- 遍历的数组值更新了,值也赋值了,为什么视图不更新<br/>
```
使用this.$set()赋值
```

- 组件间的样式继承或者被覆写<br/>
```
确认是否开启了 css模块化功能!也就是scoped <style lang="scss" scoped></style>
```

- Uncaught ReferenceError: xxx is not define
```
data() {
	return {
		
	}
},
mounted(){
	console.log(this.name) // 没有在data声明就使用
}
```

- CSSbackground引入图片打包后,访问路径错误<br/>
把图片什么丢到assets目录下,然后相对路径,打包后是正常的

- 安装模块时命令窗口输出unsupported platform xxx<br/>
node版本不兼容,系统不兼容

- 在 scoped 样式中，类选择器比元素选择器更好，因为大量使用元素选择器是很慢的

- 移动端Cache-Control指定请求和响应遵循的缓存机制，不想使用浏览器缓存就禁止

```
<meta http-equiv="Cache-Control" content="no-cache">
```

- 想动画更流畅开启GPU硬件加速
```
.elem { transform: translate3d(0, 0, 0); }
```

- 页面使用缓存，退出时要清除
```
created() {
  sessionStorage.setItem('NAME') // 如果是本页面单独使用的，退出页面要清除
  localStorage.setItem('NAME')
},
destroyed() {
  sessionStorage.removeItem('NAME')
  localStorage.removeItem('NAME')
}

```
- 对数据操作都要加上防抖和二级确认
```
 this.$confirm('确定提交?', '消息提示！', {
  confirmButtonText: '确定',
  cancelButtonText: '取消',
  type: 'warning'
}).then(() => {
  // 在此处执行后续操作
})
```
- 图标使用优先级SVG -> 图标库 -> 图片（不建议使用）
- if尽量不要简写
```
if (column.property === 'status') return true //简写
if (column.property === 'status') { // 正常
  return true
}
```
- 数组、对象取值优先判空
```
activeMethod(row) {
  if (row) { // 不确定有没有值先判空，防止取值报错影响运行
    console.log(row.name)
  }
},
```
- 定时器使用后需要清除
```
export default {
  data() {
    return {
      timer: '',
      value: 0
    };
  },
  methods: {
    get() {
      this.value ++;
      console.log(this.value);
    }
  },
  mounted() {
    this.timer = setInterval(this.get, 1000);
  },
  beforeDestroy() { // 清除
    clearInterval(this.timer);
  }
};
```
- 保持页面样式一致性，尽量使用公共的样式
```
.title {
  font-size: var(--van-font-size-sm);
  color: var(--van-black);
  background: var(--van-gray-1);
}
```
- 页面开了keep-alive，页面切换要及时更新数据
```
activated() {
  if (this.dataTableSearch && this._url) {
    this.dataTableSearch()
  }
}
```
- 提交的loading要在校验结束后，调用接口前开启,接口结束动作最好放在finally内
```
this.validate() // 校验
this.loading = true // 开启loading
save(params).then(res => {

}).finally(() => {
  this.loading = true //结束loading
})
```
- 动态DOM要加上key(不使用index值)才会保持更新<br/>
key值 是在DOM树进行diff算法时候发挥作用，一个是用来判断新旧 Vnode 是否为同一个，从而进行下一步的比较以及渲染，
另外一个作用就是判断组件是否可以复用，是否需要重新渲染

- 异步操作尽量加上try catch

- 对不使用但是需要占位的参数，在参数前加_
```
activeMethod(row, column) { // ESLint提示row未使用
  console.log(column)
}
activeMethod(_row, column) { // 无提示
  console.log(column)
}
```
- 给组件内的原生控件添加事件不生效原因
```
<el-input placeholder="请输入特定消费金额 " @mouseover="test()"></el-input> // mouseover不生效
<el-input placeholder="请输入特定消费金额 " @mouseover="test()"></el-input> // 增加.native修饰符
```
- Object合并注意覆盖顺序
```
Object.assign(obj1, obj2, obj3) // 有同名的属性（方法），后合并的属性（方法）会覆盖之前的同名属性（方法）
```
- 操作数组，对象时，不改变源数据需要clone操作（表单校验尤其注意）
```
data() {
  return {
    list: [
      {
        name: '测试',
        code: 'S-20220830-0001'
      }
    ]
  }
}
methods: {
  save() {
    list.forEach() // 直接操作会修改源数据
    deepClone(list).forEach()
  }
}
```
- 在变量名或函数名前加下划线，一般表示“私有”。是约定俗成的开发规范，没有强制限制



