package com.dst.slms.contractmange.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.entity.CoreInfo;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.contractmange.entity.ReceiptInfo;
import com.dst.slms.contractmange.entity.SaleContractInfo;
import com.dst.slms.contractmange.service.IReceiptService;
import com.dst.slms.contractmange.service.ISaleContractService;

import java.util.HashMap;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;

import com.dst.slms.base.entity.MarketProjectInfo;
import com.dst.slms.base.service.IMarketProjectService;
import com.dst.slms.common.annotation.SysPermissionName;
import org.springframework.web.bind.annotation.PostMapping;
/**   
 * @Title: 验收单 Controller
 * @Description: 验收单
 * @author 
 * @date 2020-05-02 16:18:39
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/receiptController")
@SysPermissionName(name="验收单",type=Constant.MENU)
public class ReceiptController extends AbstractReceiptController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(ReceiptController.class);
	
	@Autowired
	private IReceiptService iReceiptService;
	@Autowired
	private IMarketProjectService iMarketProjectService;
	@Autowired
	private ISaleContractService iSaleContractService;
	/**
	 * 审核
	 */
	@SysPermissionName(name="审核")
	@RequiresPermissions("ret:receipt:audit")
	@ResponseBody
    @PostMapping(value = "/audit")
	public R auditAction(ReceiptInfo info, HttpServletRequest req) {
		return iReceiptService.audit(info.getId(),com.dst.slms.common.utils.SysContext.getUserId());
	}
	
	/**
	 * 反审核
	 */
	@SysPermissionName(name="反审核")
	@RequiresPermissions("ret:receipt:unAudit")	 
	@ResponseBody
    @PostMapping(value = "/unAudit")
	public R unAuditAction(ReceiptInfo info, HttpServletRequest req) {
		return iReceiptService.unAudit(info.getId());
	}
	@Override
	public Object createNewModel(HttpServletRequest req) {
		ReceiptInfo info = new ReceiptInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		info.setState("SAVE");
		String id = req.getParameter("id");
		MarketProjectInfo proinfo = iMarketProjectService.getEntity(MarketProjectInfo.class, id,new String[]{"name","org.id","org.name"});
		info.setProject(proinfo);
		return info;
	}
	@Override
	public EntityQuery getQueryExecutor(HttpServletRequest request, CoreInfo info, DataGrid dataGrid) {
		EntityQuery queryExecutor = super.getQueryExecutor(request, info, dataGrid);
		//选中左边树节点ID
		String selectTreeId = request.getParameter("selectTreeId");
		 
		if(UIRuleUtil.isNotNull(selectTreeId)){
			String[] split = selectTreeId.split(",");
			queryExecutor.in("project.id", split);
		}else{
			queryExecutor.eq("project.id", "xxxx");
		}
		queryExecutor.add();
		return queryExecutor;
	}
	/**
	 * 获取合同信息
	 */
	@ResponseBody
    @RequestMapping(value = "/getContractMes")
	public R getContractMes(HttpServletRequest req) {
		String conId = req.getParameter("conId");
		SaleContractInfo coninfo=iSaleContractService.getEntity(SaleContractInfo.class, conId);
		Map objmap=new HashMap();
		objmap.put("contractNum", coninfo.getNumber());
		objmap.put("conDate", coninfo.getSignDate());
		objmap.put("conAmt", coninfo.getTaxConAmt());
		Map partA=new HashMap();
		if(coninfo.getPartA()!=null){
			partA.put("id", coninfo.getPartA().getId());
			partA.put("name", coninfo.getPartA().getName());
			objmap.put("partA", partA);
		}
		Map contractType=new HashMap();
		if(coninfo.getContractType()!=null){
			contractType.put("id", coninfo.getContractType().getId());
			contractType.put("name", coninfo.getContractType().getName());
			objmap.put("contractType", contractType);
		}
		Map supplier=new HashMap();
		if(coninfo.getSupplier()!=null){
			supplier.put("id", coninfo.getSupplier().getId());
			supplier.put("name", coninfo.getSupplier().getName());
			objmap.put("supplier", supplier);
		}
		Map kjcontract=new HashMap();
		if(coninfo.getKjcontract()!=null){
			kjcontract.put("id", coninfo.getKjcontract().getId());
			kjcontract.put("name", coninfo.getKjcontract().getName());
			objmap.put("kjcontract", kjcontract);
		}
		return R.ok("成功", objmap,"0");
	}
}
