package com.dst.slms.contractmange.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.contractmange.entity.PaymentReqInfo;
import com.dst.slms.contractmange.service.IPaymentReqService;

/**   
 * 付款申请单 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 付款申请单
 * @author 
 * @date 2020-05-05 08:36:02
 * @version V1.0   
 *
 */
public abstract class AbstractPaymentReqController extends CoreBaseController {

	@Autowired
	private IPaymentReqService iPaymentReqService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/contractmange/paymentreq/paymentReqList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/contractmange/paymentreq/paymentReqEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iPaymentReqService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		PaymentReqInfo info = new PaymentReqInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		info.setState("SAVE");
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("sourceBillId");
		sic.add("state");
		sic.add("auditor.id");
		sic.add("auditor.number");
		sic.add("auditor.name");
		sic.add("auditTime");
		sic.add("orgunit.id");
		sic.add("orgunit.number");
		sic.add("orgunit.name");
		sic.add("project.id");
		sic.add("project.number");
		sic.add("project.name");
		sic.add("contract.id");
		sic.add("contract.number");
		sic.add("contract.name");
		sic.add("jzcompany.id");
		sic.add("jzcompany.number");
		sic.add("jzcompany.name");
		sic.add("bizDate");
		sic.add("payType.id");
		sic.add("payType.number");
		sic.add("payType.name");
		sic.add("taxReqAmt");
		sic.add("noTaxReqAmt");
		sic.add("taxRate.id");
		sic.add("taxRate.number");
		sic.add("taxRate.name");
		sic.add("taxAmt");
		sic.add("supplier.id");
		sic.add("supplier.number");
		sic.add("supplier.name");
		sic.add("ljfpAmt");
		sic.add("monAmt");
		sic.add("contractAmt");
		sic.add("ljpayAmt");
		sic.add("receipt.id");
		sic.add("receipt.number");
		sic.add("receipt.name");
		sic.add("paymentReqE1.parent.id");
		sic.add("paymentReqE1.parent.number");
		sic.add("paymentReqE1.parent.name");
		sic.add("paymentReqE1.invoiceNum");
		sic.add("paymentReqE1.invoiceCode");
		sic.add("paymentReqE1.invoiceType");
		sic.add("paymentReqE1.kpdate");
		sic.add("paymentReqE1.name");
		sic.add("paymentReqE1.noTaxConAmt");
		sic.add("paymentReqE1.taxRate.id");
		sic.add("paymentReqE1.taxRate.number");
		sic.add("paymentReqE1.taxRate.name");
		sic.add("paymentReqE1.taxAmt");
		sic.add("paymentReqE1.taxConAmt");
		sic.add("paymentReqE1.gfname");
		sic.add("paymentReqE1.gfnumber");
		sic.add("paymentReqE1.xfname");
		sic.add("paymentReqE1.xfnumber");
		return sic;
	}

	@RequiresPermissions("paq:paymentReq:list")	
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(PaymentReqInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}
	
	@SysPermissionName(name="列表查看")
	@RequiresPermissions("paq:paymentReq:list")
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("paq:paymentReq:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}

	@SysPermissionName(name="表单查看")
	@RequiresPermissions("paq:paymentReq:view")		
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(PaymentReqInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("paq:paymentReq:edit")	
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(PaymentReqInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("paq:paymentReq:save")	
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(PaymentReqInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}

	@SysPermissionName(name="提交")
	@RequiresPermissions("paq:paymentReq:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(PaymentReqInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}

	@SysPermissionName(name="删除")
	@RequiresPermissions("paq:paymentReq:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(PaymentReqInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("paq:paymentReq:downExcel")		 
	@RequestMapping(value = "/downExcel")
	public void downExcel(PaymentReqInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
