package com.dst.slms.contractmange.entity;


import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import com.dst.slms.common.entity.CoreBaseInfo;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import com.dst.slms.common.entity.CoreBillBaseInfo;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.OrderBy;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 营销合同 Info 对象
 * @Description: 营销合同
 * @author 
 * @date 2020-05-02 17:43:18
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractSaleContractInfo  extends CoreBillBaseInfo implements java.io.Serializable {
	
	@Column(name ="FNAME")
	@FieldMeta(name="合同名称" )
	private java.lang.String name;
	
	@Column(name ="FNUMBER")
	@FieldMeta(name="合同编号" )
	private java.lang.String number;
	
	@Column(name ="FREMAKE")
	@FieldMeta(name="备注" )
	private java.lang.String remake;
	
	@Column(name ="FSOURCEBILLID")
	@FieldMeta(name="单据来源" )
	private java.lang.String sourceBillId;
	
	
	
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "ForgunitID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="组织" )
	private com.dst.slms.system.entity.SysOrgInfo orgunit;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FprojectID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="项目" )
	private com.dst.slms.base.entity.MarketProjectInfo project;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FcontractTypeID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="合同类型" )
	private com.dst.slms.base.entity.ContractTypeInfo contractType;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FpartAID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="甲方" )
	private com.dst.slms.system.entity.SysOrgInfo partA;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FkjcontractID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="框架合同" )
	private com.dst.slms.contractmange.entity.SaleContractInfo kjcontract;
	
	@Column(name ="FsaleConNature")
	@FieldMeta(name="合同性质" ,enumGroupNumber="saleConNature")
	private java.lang.String saleConNature;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FprojectApproveID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="立项单" )
	private com.dst.slms.proapproval.entity.ProjectApproveInfo projectApprove;
	
	@Column(name ="FisSettlement")
	@FieldMeta(name="是否结算" )@org.hibernate.annotations.Type(type="yes_no")
	private boolean isSettlement;
	
	@Column(name ="FsettlementAmt")
	@FieldMeta(name="结算金额" )
	private java.math.BigDecimal settlementAmt;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FdutyDepID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="责任部门" )
	private com.dst.slms.system.entity.SysOrgInfo dutyDep;
	
	@Column(name ="FsignDate")
	@FieldMeta(name="签约日期" )
	private java.util.Date signDate;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FdutyPersonID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="责任人" )
	private com.dst.slms.system.entity.SysPersonInfo dutyPerson;
	
	@Column(name ="FlxAmt")
	@FieldMeta(name="立项金额" )
	private java.math.BigDecimal lxAmt;
	
	@Column(name ="Fbizdate")
	@FieldMeta(name="业务日期" )
	private java.util.Date bizdate;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FmarkAccountID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="营销科目" )
	private com.dst.slms.base.entity.MarketAccountInfo markAccount;
	
	@Column(name ="FtaxConAmt")
	@FieldMeta(name="含税合同金额" )
	private java.math.BigDecimal taxConAmt;
	
	@Column(name ="Ftax")
	@FieldMeta(name="综合税率(%)" )
	private java.math.BigDecimal tax;
	
	@Column(name ="FnotaxConAmt")
	@FieldMeta(name="不含税合同金额" )
	private java.math.BigDecimal notaxConAmt;
	
	@Column(name ="FtaxAmt")
	@FieldMeta(name="税额" )
	private java.math.BigDecimal taxAmt;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FsupplierID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="供应商" )
	private com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplier;
	
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<SaleContractTaxEInfo> saleContractTaxE = new ArrayList<SaleContractTaxEInfo>(); 

	public List<SaleContractTaxEInfo> getSaleContractTaxE() {
		return saleContractTaxE;
	}

	public void setSaleContractTaxE(List<SaleContractTaxEInfo> saleContractTaxE) {
		this.saleContractTaxE = saleContractTaxE;
	}
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<SaleConEconomicsInfo> saleConEconomics = new ArrayList<SaleConEconomicsInfo>(); 

	public List<SaleConEconomicsInfo> getSaleConEconomics() {
		return saleConEconomics;
	}

	public void setSaleConEconomics(List<SaleConEconomicsInfo> saleConEconomics) {
		this.saleConEconomics = saleConEconomics;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  合同名称
	 */
	public java.lang.String getName(){
		return this.name;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  合同名称
	 */
	public void setName(java.lang.String name){
		this.name = name;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  合同编号
	 */
	public java.lang.String getNumber(){
		return this.number;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  合同编号
	 */
	public void setNumber(java.lang.String number){
		this.number = number;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  备注
	 */
	public java.lang.String getRemake(){
		return this.remake;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  备注
	 */
	public void setRemake(java.lang.String remake){
		this.remake = remake;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  单据来源
	 */
	public java.lang.String getSourceBillId(){
		return this.sourceBillId;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  单据来源
	 */
	public void setSourceBillId(java.lang.String sourceBillId){
		this.sourceBillId = sourceBillId;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysOrgInfo
	 *@return: com.dst.slms.system.entity.SysOrgInfo  组织
	 */
	public com.dst.slms.system.entity.SysOrgInfo getOrgunit(){
		return this.orgunit;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysOrgInfo
	 *@param: com.dst.slms.system.entity.SysOrgInfo  组织
	 */
	public void setOrgunit(com.dst.slms.system.entity.SysOrgInfo orgunit){
		this.orgunit = orgunit;
	}
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketProjectInfo
	 *@return: com.dst.slms.base.entity.MarketProjectInfo  项目
	 */
	public com.dst.slms.base.entity.MarketProjectInfo getProject(){
		return this.project;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketProjectInfo
	 *@param: com.dst.slms.base.entity.MarketProjectInfo  项目
	 */
	public void setProject(com.dst.slms.base.entity.MarketProjectInfo project){
		this.project = project;
	}
	/**
	 *方法: 取得com.dst.slms.base.entity.ContractTypeInfo
	 *@return: com.dst.slms.base.entity.ContractTypeInfo  合同类型
	 */
	public com.dst.slms.base.entity.ContractTypeInfo getContractType(){
		return this.contractType;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.ContractTypeInfo
	 *@param: com.dst.slms.base.entity.ContractTypeInfo  合同类型
	 */
	public void setContractType(com.dst.slms.base.entity.ContractTypeInfo contractType){
		this.contractType = contractType;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysOrgInfo
	 *@return: com.dst.slms.system.entity.SysOrgInfo  甲方
	 */
	public com.dst.slms.system.entity.SysOrgInfo getPartA(){
		return this.partA;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysOrgInfo
	 *@param: com.dst.slms.system.entity.SysOrgInfo  甲方
	 */
	public void setPartA(com.dst.slms.system.entity.SysOrgInfo partA){
		this.partA = partA;
	}
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.SaleContractInfo
	 *@return: com.dst.slms.contractmange.entity.SaleContractInfo  框架合同
	 */
	public com.dst.slms.contractmange.entity.SaleContractInfo getKjcontract(){
		return this.kjcontract;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.SaleContractInfo
	 *@param: com.dst.slms.contractmange.entity.SaleContractInfo  框架合同
	 */
	public void setKjcontract(com.dst.slms.contractmange.entity.SaleContractInfo kjcontract){
		this.kjcontract = kjcontract;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  合同性质
	 */
	public java.lang.String getSaleConNature(){
		return this.saleConNature;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  合同性质
	 */
	public void setSaleConNature(java.lang.String saleConNature){
		this.saleConNature = saleConNature;
	}
	/**
	 *方法: 取得com.dst.slms.proapproval.entity.ProjectApproveInfo
	 *@return: com.dst.slms.proapproval.entity.ProjectApproveInfo  立项单
	 */
	public com.dst.slms.proapproval.entity.ProjectApproveInfo getProjectApprove(){
		return this.projectApprove;
	}

	/**
	 *方法: 设置com.dst.slms.proapproval.entity.ProjectApproveInfo
	 *@param: com.dst.slms.proapproval.entity.ProjectApproveInfo  立项单
	 */
	public void setProjectApprove(com.dst.slms.proapproval.entity.ProjectApproveInfo projectApprove){
		this.projectApprove = projectApprove;
	}
	/**
	 *方法: 取得java.lang.Boolean
	 *@return: java.lang.Boolean  是否结算
	 */
	public boolean getIsSettlement(){
		return this.isSettlement;
	}

	/**
	 *方法: 设置java.lang.Boolean
	 *@param: java.lang.Boolean  是否结算
	 */
	public void setIsSettlement(boolean isSettlement){
		this.isSettlement = isSettlement;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  结算金额
	 */
	public java.math.BigDecimal getSettlementAmt(){
		return this.settlementAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  结算金额
	 */
	public void setSettlementAmt(java.math.BigDecimal settlementAmt){
		this.settlementAmt = settlementAmt;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysOrgInfo
	 *@return: com.dst.slms.system.entity.SysOrgInfo  责任部门
	 */
	public com.dst.slms.system.entity.SysOrgInfo getDutyDep(){
		return this.dutyDep;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysOrgInfo
	 *@param: com.dst.slms.system.entity.SysOrgInfo  责任部门
	 */
	public void setDutyDep(com.dst.slms.system.entity.SysOrgInfo dutyDep){
		this.dutyDep = dutyDep;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  签约日期
	 */
	public java.util.Date getSignDate(){
		return this.signDate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  签约日期
	 */
	public void setSignDate(java.util.Date signDate){
		this.signDate = signDate;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysPersonInfo
	 *@return: com.dst.slms.system.entity.SysPersonInfo  责任人
	 */
	public com.dst.slms.system.entity.SysPersonInfo getDutyPerson(){
		return this.dutyPerson;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysPersonInfo
	 *@param: com.dst.slms.system.entity.SysPersonInfo  责任人
	 */
	public void setDutyPerson(com.dst.slms.system.entity.SysPersonInfo dutyPerson){
		this.dutyPerson = dutyPerson;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  立项金额
	 */
	public java.math.BigDecimal getLxAmt(){
		return this.lxAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  立项金额
	 */
	public void setLxAmt(java.math.BigDecimal lxAmt){
		this.lxAmt = lxAmt;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  业务日期
	 */
	public java.util.Date getBizdate(){
		return this.bizdate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  业务日期
	 */
	public void setBizdate(java.util.Date bizdate){
		this.bizdate = bizdate;
	}
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketAccountInfo
	 *@return: com.dst.slms.base.entity.MarketAccountInfo  营销科目
	 */
	public com.dst.slms.base.entity.MarketAccountInfo getMarkAccount(){
		return this.markAccount;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketAccountInfo
	 *@param: com.dst.slms.base.entity.MarketAccountInfo  营销科目
	 */
	public void setMarkAccount(com.dst.slms.base.entity.MarketAccountInfo markAccount){
		this.markAccount = markAccount;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  含税合同金额
	 */
	public java.math.BigDecimal getTaxConAmt(){
		return this.taxConAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  含税合同金额
	 */
	public void setTaxConAmt(java.math.BigDecimal taxConAmt){
		this.taxConAmt = taxConAmt;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  综合税率(%)
	 */
	public java.math.BigDecimal getTax(){
		return this.tax;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  综合税率(%)
	 */
	public void setTax(java.math.BigDecimal tax){
		this.tax = tax;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  不含税合同金额
	 */
	public java.math.BigDecimal getNotaxConAmt(){
		return this.notaxConAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  不含税合同金额
	 */
	public void setNotaxConAmt(java.math.BigDecimal notaxConAmt){
		this.notaxConAmt = notaxConAmt;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  税额
	 */
	public java.math.BigDecimal getTaxAmt(){
		return this.taxAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  税额
	 */
	public void setTaxAmt(java.math.BigDecimal taxAmt){
		this.taxAmt = taxAmt;
	}
	/**
	 *方法: 取得com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@return: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  供应商
	 */
	public com.dst.slms.supplierprofile.entity.SupplierProfileInfo getSupplier(){
		return this.supplier;
	}

	/**
	 *方法: 设置com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@param: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  供应商
	 */
	public void setSupplier(com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplier){
		this.supplier = supplier;
	}
	
	public void setBosType(String bosType) {
		this.bosType = "GST4V800";
	}
}
