package com.dst.slms.base.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.utils.R;
import com.dst.slms.base.entity.PayTypeInfo;
import com.dst.slms.base.service.IPayTypeService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
/**   
 * @Title: 付款类型 Controller
 * @Description: 付款类型
 * @author 
 * @date 2020-05-02 15:33:23
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/payTypeController")
@SysPermissionName(name="付款类型",type=Constant.MENU)
public class PayTypeController extends AbstractPayTypeController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(PayTypeController.class);

	@Autowired
	private IPayTypeService iPayTypeService;	
	/**
	 * 变更启用禁用状态
	 */
	@ResponseBody
    @RequestMapping(value = "/changeEnable")
	public R auditAction(PayTypeInfo info, HttpServletRequest req) {
		return iPayTypeService.changeEnable(info,req);
	}
	
}
