package com.dst.slms.base.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.base.entity.CitycbaseInfo;
import com.dst.slms.base.service.ICitycbaseService;

/**   
 * 城市 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 城市
 * @author 
 * @date 2020-05-02 15:10:59
 * @version V1.0   
 *
 */
public abstract class AbstractCitycbaseController extends CoreBaseController {

	@Autowired
	private ICitycbaseService iCitycbaseService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/base/citycbase/citycbaseList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/base/citycbase/citycbaseEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iCitycbaseService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		CitycbaseInfo info = new CitycbaseInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("isEnable");
		return sic;
	}
	
	@RequiresPermissions("cie:citycbase:list")		
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(CitycbaseInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}

	@SysPermissionName(name="列表查看")
	@RequiresPermissions("cie:citycbase:list")	
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("cie:citycbase:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}
	
	@SysPermissionName(name="表单查看")
	@RequiresPermissions("cie:citycbase:view")	
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(CitycbaseInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("cie:citycbase:edit")
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(CitycbaseInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("cie:citycbase:save")
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(CitycbaseInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}
	
	@SysPermissionName(name="提交")
	@RequiresPermissions("cie:citycbase:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(CitycbaseInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}
	
	@SysPermissionName(name="删除")
	@RequiresPermissions("cie:citycbase:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(CitycbaseInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("cie:citycbase:downExcel")
	@RequestMapping(value = "/downExcel")
	public void downExcel(CitycbaseInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
