package com.dst.slms.util;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;

import com.alibaba.fastjson.JSONObject;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.utils.DateUtils;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.SpringContextUtils;
import com.dst.slms.common.utils.SysContext;
import com.dst.slms.common.utils.UIRuleUtil;
import com.dst.slms.system.entity.CommonUserInfo;
import com.dst.slms.system.entity.SysOrgInfo;
import com.dst.slms.system.entity.SysPersonInfo;
import com.dst.slms.system.entity.SysPosInfo;
import com.dst.slms.system.entity.SysPosMemberInfo;
import com.dst.slms.system.service.Imp.SysConstants;

/**
* 人员帮助类
* @author dst email:shilcentry@163.com
* @version V1.0
* @date 创建时间：2020年2月28日 上午9:20:53
*/
public class PersonHelper {
	/**
	 * 获取主要部门
	 * @param personId 
	 */
	public static SysOrgInfo getPersonForSysOrgUnit(String personId) {
		List<SysPosMemberInfo> sysPosMemberList = getSysPosMemberList(personId);
		if(sysPosMemberList == null ||sysPosMemberList.size() ==0)return null;
		SysPosInfo posInfo = sysPosMemberList.get(0).getPos();
		if(posInfo == null)return null;
		return posInfo.getOrg();
	}
	/**
	 * 通过人员id 获取任职情况列表
	 * @param personId 
	 */
	public static List<SysPosMemberInfo> getSysPosMemberList(String personId) {
		if(UIRuleUtil.isNull(personId))return null;
		EntityQuery eq = new EntityQuery(SysPosMemberInfo.class);
		eq.eq("person.id", personId);
		eq.eq("isPrimary", true);
		eq.add();
		return getBaseService().getEntityList(eq,new String[] {"pos.id","pos.number","pos.name","pos.org.id","pos.org.number","pos.org.name","pos.org.isCompany","pos.org.isCost","pos.org.isHR","pos.org.isCU","pos.org.parent"});
	}
	/**
	 * 获取baseservice
	 * @return ICrudService
	 */
	public static ICrudService getBaseService(){
		return SpringContextUtils.getBean(ICrudService.class);
	}
}
