package com.dst.slms.supplierreview.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.utils.R;
import com.dst.slms.supplierreview.entity.ReviewTemplateInfo;
import com.dst.slms.supplierreview.service.IReviewTemplateService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
/**   
 * @Title: 评审模板 Controller
 * @Description: 评审模板
 * @author 
 * @date 2020-05-02 14:59:42
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/reviewTemplateController")
@SysPermissionName(name="评审模板",type=Constant.MENU)
public class ReviewTemplateController extends AbstractReviewTemplateController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(ReviewTemplateController.class);

	@Autowired
	private IReviewTemplateService iReviewTemplateService;	
	/**
	 * 变更启用禁用状态
	 */
	@ResponseBody
    @RequestMapping(value = "/changeEnable")
	public R auditAction(ReviewTemplateInfo info, HttpServletRequest req) {
		return iReviewTemplateService.changeEnable(info,req);
	}
	
}
