package com.dst.slms.supplierreview.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.supplierreview.entity.ReviewTypeInfo;
import com.dst.slms.supplierreview.service.IReviewTypeService;

/**   
 * 评审类型 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 评审类型
 * @author 
 * @date 2020-05-02 14:59:42
 * @version V1.0   
 *
 */
public abstract class AbstractReviewTypeController extends CoreBaseController {

	@Autowired
	private IReviewTypeService iReviewTypeService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/supplierreview/reviewtype/reviewTypeList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/supplierreview/reviewtype/reviewTypeEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iReviewTypeService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		ReviewTypeInfo info = new ReviewTypeInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("isEnable");
		return sic;
	}
	
	@RequiresPermissions("ree:reviewType:list")		
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(ReviewTypeInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}

	@SysPermissionName(name="列表查看")
	@RequiresPermissions("ree:reviewType:list")	
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("ree:reviewType:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}
	
	@SysPermissionName(name="表单查看")
	@RequiresPermissions("ree:reviewType:view")	
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(ReviewTypeInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("ree:reviewType:edit")
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(ReviewTypeInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("ree:reviewType:save")
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(ReviewTypeInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}
	
	@SysPermissionName(name="提交")
	@RequiresPermissions("ree:reviewType:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(ReviewTypeInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}
	
	@SysPermissionName(name="删除")
	@RequiresPermissions("ree:reviewType:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(ReviewTypeInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("ree:reviewType:downExcel")
	@RequestMapping(value = "/downExcel")
	public void downExcel(ReviewTypeInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
