package com.dst.slms.supplierreview.entity;


import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import com.dst.slms.common.entity.CoreBaseInfo;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import com.dst.slms.common.entity.CoreBaseInfo;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.OrderBy;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 评审模板 Info 对象
 * @Description: 评审模板
 * @author 
 * @date 2020-05-02 14:59:42
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractReviewTemplateInfo  extends CoreBaseInfo implements java.io.Serializable {
	
	/**模板名称*/
	@Column(name ="FNAME")
	@FieldMeta(name="模板名称" )
	private java.lang.String name;
	
	/**模板编号*/
	@Column(name ="FNUMBER")
	@FieldMeta(name="模板编号" )
	private java.lang.String number;
	
	/**备注*/
	@Column(name ="FREMAKE")
	@FieldMeta(name="备注" )
	private java.lang.String remake;
	
	/**是否启用*/
	@Column(name ="FISENABLE")
	@FieldMeta(name="是否启用" )@org.hibernate.annotations.Type(type="yes_no")
	private boolean isEnable;
	
	/**评审类型*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FreviewTypeID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="评审类型" )
	private com.dst.slms.supplierreview.entity.ReviewTypeInfo reviewType;
	
	/**是否工程实例考察*/
	@Column(name ="FisgCKC")
	@FieldMeta(name="是否工程实例考察" )@org.hibernate.annotations.Type(type="yes_no")
	private boolean isgCKC;
	
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<UnitWeightInfo> unitWeight = new ArrayList<UnitWeightInfo>(); 

	public List<UnitWeightInfo> getUnitWeight() {
		return unitWeight;
	}

	public void setUnitWeight(List<UnitWeightInfo> unitWeight) {
		this.unitWeight = unitWeight;
	}
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<TemplateChildInfo> templateChild = new ArrayList<TemplateChildInfo>(); 

	public List<TemplateChildInfo> getTemplateChild() {
		return templateChild;
	}

	public void setTemplateChild(List<TemplateChildInfo> templateChild) {
		this.templateChild = templateChild;
	}
	
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  模板名称
	 */
	public java.lang.String getName(){
		return this.name;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  模板名称
	 */
	public void setName(java.lang.String name){
		this.name = name;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  模板编号
	 */
	public java.lang.String getNumber(){
		return this.number;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  模板编号
	 */
	public void setNumber(java.lang.String number){
		this.number = number;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  备注
	 */
	public java.lang.String getRemake(){
		return this.remake;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  备注
	 */
	public void setRemake(java.lang.String remake){
		this.remake = remake;
	}
	
	/**
	 *方法: 取得java.lang.Boolean
	 *@return: java.lang.Boolean  是否启用
	 */
	public boolean getIsEnable(){
		return this.isEnable;
	}

	/**
	 *方法: 设置java.lang.Boolean
	 *@param: java.lang.Boolean  是否启用
	 */
	public void setIsEnable(boolean isEnable){
		this.isEnable = isEnable;
	}
	
	/**
	 *方法: 取得com.dst.slms.supplierreview.entity.ReviewTypeInfo
	 *@return: com.dst.slms.supplierreview.entity.ReviewTypeInfo  评审类型
	 */
	public com.dst.slms.supplierreview.entity.ReviewTypeInfo getReviewType(){
		return this.reviewType;
	}

	/**
	 *方法: 设置com.dst.slms.supplierreview.entity.ReviewTypeInfo
	 *@param: com.dst.slms.supplierreview.entity.ReviewTypeInfo  评审类型
	 */
	public void setReviewType(com.dst.slms.supplierreview.entity.ReviewTypeInfo reviewType){
		this.reviewType = reviewType;
	}
	
	/**
	 *方法: 取得java.lang.Boolean
	 *@return: java.lang.Boolean  是否工程实例考察
	 */
	public boolean getIsgCKC(){
		return this.isgCKC;
	}

	/**
	 *方法: 设置java.lang.Boolean
	 *@param: java.lang.Boolean  是否工程实例考察
	 */
	public void setIsgCKC(boolean isgCKC){
		this.isgCKC = isgCKC;
	}
	
			
	@Override
	public void setBosType(String bosType) {
		this.bosType = "7D7U5DFK";
	}
}
