package com.dst.slms.plan.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 年计划明细 Info 对象
 * @Description: 年计划明细
 * @author 
 * @date 2020-05-03 11:15:04
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractAnnualPlanDetailsInfo  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.plan.entity.AnnualPaymentPlanInfo parent;
	
	/**科目编码*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FmarketAccounID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="科目编码" )
	private com.dst.slms.base.entity.MarketAccountInfo marketAccoun;
	
	/**科目名称*/
	@Column(name ="FmarketAccounName")
	@FieldMeta(name="科目名称" )
	private java.lang.String marketAccounName;
	
	/**合计金额*/
	@Column(name ="FamountTotal")
	@FieldMeta(name="合计金额" )
	private java.math.BigDecimal amountTotal;
	
	/**1月*/
	@Column(name ="Fjan")
	@FieldMeta(name="1月" )
	private java.math.BigDecimal jan;
	
	/**2月*/
	@Column(name ="Ffeb")
	@FieldMeta(name="2月" )
	private java.math.BigDecimal feb;
	
	/**3月*/
	@Column(name ="Fmar")
	@FieldMeta(name="3月" )
	private java.math.BigDecimal mar;
	
	/**4月*/
	@Column(name ="Fapr")
	@FieldMeta(name="4月" )
	private java.math.BigDecimal apr;
	
	/**5月*/
	@Column(name ="Fmay")
	@FieldMeta(name="5月" )
	private java.math.BigDecimal may;
	
	/**6月*/
	@Column(name ="Fjun")
	@FieldMeta(name="6月" )
	private java.math.BigDecimal jun;
	
	/**7月*/
	@Column(name ="Fjul")
	@FieldMeta(name="7月" )
	private java.math.BigDecimal jul;
	
	/**8月*/
	@Column(name ="Faug")
	@FieldMeta(name="8月" )
	private java.math.BigDecimal aug;
	
	/**9月*/
	@Column(name ="Fsep")
	@FieldMeta(name="9月" )
	private java.math.BigDecimal sep;
	
	/**10月*/
	@Column(name ="Foct")
	@FieldMeta(name="10月" )
	private java.math.BigDecimal oct;
	
	/**11月*/
	@Column(name ="Fnov")
	@FieldMeta(name="11月" )
	private java.math.BigDecimal nov;
	
	/**12月*/
	@Column(name ="Fdec")
	@FieldMeta(name="12月" )
	private java.math.BigDecimal dec;
	
	
	/**
	 *方法: 取得com.dst.slms.plan.entity.AnnualPaymentPlanInfo
	 *@return: com.dst.slms.plan.entity.AnnualPaymentPlanInfo  父对象关联
	 */
	public com.dst.slms.plan.entity.AnnualPaymentPlanInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.plan.entity.AnnualPaymentPlanInfo
	 *@param: com.dst.slms.plan.entity.AnnualPaymentPlanInfo  父对象关联
	 */
	public void setParent(com.dst.slms.plan.entity.AnnualPaymentPlanInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketAccountInfo
	 *@return: com.dst.slms.base.entity.MarketAccountInfo  科目编码
	 */
	public com.dst.slms.base.entity.MarketAccountInfo getMarketAccoun(){
		return this.marketAccoun;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketAccountInfo
	 *@param: com.dst.slms.base.entity.MarketAccountInfo  科目编码
	 */
	public void setMarketAccoun(com.dst.slms.base.entity.MarketAccountInfo marketAccoun){
		this.marketAccoun = marketAccoun;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  科目名称
	 */
	public java.lang.String getMarketAccounName(){
		return this.marketAccounName;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  科目名称
	 */
	public void setMarketAccounName(java.lang.String marketAccounName){
		this.marketAccounName = marketAccounName;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  合计金额
	 */
	public java.math.BigDecimal getAmountTotal(){
		return this.amountTotal;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  合计金额
	 */
	public void setAmountTotal(java.math.BigDecimal amountTotal){
		this.amountTotal = amountTotal;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  1月
	 */
	public java.math.BigDecimal getJan(){
		return this.jan;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  1月
	 */
	public void setJan(java.math.BigDecimal jan){
		this.jan = jan;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  2月
	 */
	public java.math.BigDecimal getFeb(){
		return this.feb;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  2月
	 */
	public void setFeb(java.math.BigDecimal feb){
		this.feb = feb;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  3月
	 */
	public java.math.BigDecimal getMar(){
		return this.mar;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  3月
	 */
	public void setMar(java.math.BigDecimal mar){
		this.mar = mar;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  4月
	 */
	public java.math.BigDecimal getApr(){
		return this.apr;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  4月
	 */
	public void setApr(java.math.BigDecimal apr){
		this.apr = apr;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  5月
	 */
	public java.math.BigDecimal getMay(){
		return this.may;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  5月
	 */
	public void setMay(java.math.BigDecimal may){
		this.may = may;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  6月
	 */
	public java.math.BigDecimal getJun(){
		return this.jun;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  6月
	 */
	public void setJun(java.math.BigDecimal jun){
		this.jun = jun;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  7月
	 */
	public java.math.BigDecimal getJul(){
		return this.jul;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  7月
	 */
	public void setJul(java.math.BigDecimal jul){
		this.jul = jul;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  8月
	 */
	public java.math.BigDecimal getAug(){
		return this.aug;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  8月
	 */
	public void setAug(java.math.BigDecimal aug){
		this.aug = aug;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  9月
	 */
	public java.math.BigDecimal getSep(){
		return this.sep;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  9月
	 */
	public void setSep(java.math.BigDecimal sep){
		this.sep = sep;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  10月
	 */
	public java.math.BigDecimal getOct(){
		return this.oct;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  10月
	 */
	public void setOct(java.math.BigDecimal oct){
		this.oct = oct;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  11月
	 */
	public java.math.BigDecimal getNov(){
		return this.nov;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  11月
	 */
	public void setNov(java.math.BigDecimal nov){
		this.nov = nov;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  12月
	 */
	public java.math.BigDecimal getDec(){
		return this.dec;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  12月
	 */
	public void setDec(java.math.BigDecimal dec){
		this.dec = dec;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "GLZCA2E5";
	}
}
