package com.dst.slms.contractmange.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.BillBaseCrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

import com.dst.slms.contractmange.entity.EconTermsAdjustE1Info;
import com.dst.slms.contractmange.entity.EconTermsAdjustInfo;
import com.dst.slms.contractmange.entity.SaleConEconomicsInfo;
import com.dst.slms.contractmange.entity.SaleContractInfo;
import com.dst.slms.contractmange.service.IEconTermsAdjustService;
import com.dst.slms.contractmange.service.ISaleContractService;

/**   
 * @Title: 经济条款调整单 ServiceImpl
 * @Description: 经济条款调整单
 * @author 
 * @date 2020-05-03 14:36:19
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class IEconTermsAdjustServiceImpl extends BillBaseCrudServiceImpl<EconTermsAdjustInfo> implements IEconTermsAdjustService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(IEconTermsAdjustServiceImpl.class);
	
	@Autowired
	private ISaleContractService iSaleContractService;
	
	@Override
	protected R verifyInput(EconTermsAdjustInfo entity) {
		BigDecimal tolRate = BigDecimal.ZERO;
		BigDecimal tolAmt = BigDecimal.ZERO;
		for (int i = 0; i < entity.getEconTermsAdjustE1().size(); i++) {
			EconTermsAdjustE1Info e1Info = entity.getEconTermsAdjustE1().get(i);
			BigDecimal rate = e1Info.getRate();
			BigDecimal amount = e1Info.getAmount();
			BigDecimal payAmount = e1Info.getPayAmount();
			tolRate = tolRate.add(rate);
			tolAmt = tolAmt.add(amount).add(payAmount);
		}
		if(tolRate.compareTo(new BigDecimal(100))!=0){
			throw new BizException("付款比例合计不等于100%，无法保存");
		}
		if(tolAmt.compareTo(UIRuleUtil.getBigDecimal(entity.getConAmount()))!=0){
			throw new BizException("付款金额合计不等于合同金额，无法保存");
		}
		return super.verifyInput(entity);
	}
	
	@Override
	public R audit(String billId, String userId) {
		R audit = super.audit(billId, userId);
		EconTermsAdjustInfo info = getEntity(EconTermsAdjustInfo.class, billId);
		SaleContractInfo contract = info.getContract();
		contract = getEntity(SaleContractInfo.class, contract.getId());
		contract.getSaleConEconomics().clear();
		for (int i = 0; i < info.getEconTermsAdjustE1().size(); i++) {
			EconTermsAdjustE1Info e1Info = info.getEconTermsAdjustE1().get(i);
			
			SaleConEconomicsInfo economicsInfo = new SaleConEconomicsInfo();
			economicsInfo.setParent(contract);
			economicsInfo.setBizDate(e1Info.getAdjustDate());
			economicsInfo.setPayType(e1Info.getPayType());
			economicsInfo.setPay(e1Info.getConditions());
			economicsInfo.setPayScale(e1Info.getRate());
			
			BigDecimal payAmount = UIRuleUtil.getBigDecimal(e1Info.getPayAmount());
			BigDecimal amount = UIRuleUtil.getBigDecimal(e1Info.getAmount());
			economicsInfo.setPayAmt(payAmount.add(amount));
			
			contract.getSaleConEconomics().add(economicsInfo);
		}
		iSaleContractService.save(contract);
		
		return audit;
	}
}