package com.dst.slms.contractmange.entity;


import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import com.dst.slms.common.entity.CoreBaseInfo;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import com.dst.slms.common.entity.CoreBillBaseInfo;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.OrderBy;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 验收单 Info 对象
 * @Description: 验收单
 * @author 
 * @date 2020-05-04 14:11:42
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractReceiptInfo  extends CoreBillBaseInfo implements java.io.Serializable {
	
	@Column(name ="FNAME")
	@FieldMeta(name="验收单名称" )
	private java.lang.String name;
	
	@Column(name ="FNUMBER")
	@FieldMeta(name="编号" )
	private java.lang.String number;
	
	@Column(name ="FREMAKE")
	@FieldMeta(name="备注" )
	private java.lang.String remake;
	
	@Column(name ="FSOURCEBILLID")
	@FieldMeta(name="单据来源" )
	private java.lang.String sourceBillId;
	
	
	
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FreqPersonID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="申请人" )
	private com.dst.slms.system.entity.SysPersonInfo reqPerson;
	
	@Column(name ="FreqDate")
	@FieldMeta(name="申请日期" )
	private java.util.Date reqDate;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FprojectID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="项目" )
	private com.dst.slms.base.entity.MarketProjectInfo project;
	
	@Column(name ="Fexecution")
	@FieldMeta(name="执行情况" )
	private java.lang.String execution;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FcontractID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="合同名称" )
	private com.dst.slms.contractmange.entity.SaleContractInfo contract;
	
	@Column(name ="FcontractNum")
	@FieldMeta(name="合同号" )
	private java.lang.String contractNum;
	
	@Column(name ="FconDate")
	@FieldMeta(name="合同签约" )
	private java.util.Date conDate;
	
	@Column(name ="FconAmt")
	@FieldMeta(name="合同签约" )
	private java.math.BigDecimal conAmt;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FpartAID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="甲方" )
	private com.dst.slms.system.entity.SysOrgInfo partA;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FsupplierID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="乙方" )
	private com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplier;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FkjcontractID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="框架合同" )
	private com.dst.slms.contractmange.entity.SaleContractInfo kjcontract;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FcontractTypeID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="合同类型" )
	private com.dst.slms.base.entity.ContractTypeInfo contractType;
	
	@Column(name ="Fsjphone")
	@FieldMeta(name="实际来电" )
	private java.lang.String sjphone;
	
	@Column(name ="Fsjperson")
	@FieldMeta(name="实际来人" )
	private java.lang.String sjperson;
	
	@Column(name ="FysAmt")
	@FieldMeta(name="验收金额" )
	private java.math.BigDecimal ysAmt;
	
	@Column(name ="Fscore")
	@FieldMeta(name="评估得分" )
	private java.lang.Integer score;
	
	@Column(name ="Fresult")
	@FieldMeta(name="评估结果" ,enumGroupNumber="result")
	private java.lang.String result;
	
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<ReceiptE3Info> receiptE3 = new ArrayList<ReceiptE3Info>(); 

	public List<ReceiptE3Info> getReceiptE3() {
		return receiptE3;
	}

	public void setReceiptE3(List<ReceiptE3Info> receiptE3) {
		this.receiptE3 = receiptE3;
	}
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<ReceiptE1Info> receiptE1 = new ArrayList<ReceiptE1Info>(); 

	public List<ReceiptE1Info> getReceiptE1() {
		return receiptE1;
	}

	public void setReceiptE1(List<ReceiptE1Info> receiptE1) {
		this.receiptE1 = receiptE1;
	}
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<ReceiptE2Info> receiptE2 = new ArrayList<ReceiptE2Info>(); 

	public List<ReceiptE2Info> getReceiptE2() {
		return receiptE2;
	}

	public void setReceiptE2(List<ReceiptE2Info> receiptE2) {
		this.receiptE2 = receiptE2;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  验收单名称
	 */
	public java.lang.String getName(){
		return this.name;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  验收单名称
	 */
	public void setName(java.lang.String name){
		this.name = name;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  编号
	 */
	public java.lang.String getNumber(){
		return this.number;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  编号
	 */
	public void setNumber(java.lang.String number){
		this.number = number;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  备注
	 */
	public java.lang.String getRemake(){
		return this.remake;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  备注
	 */
	public void setRemake(java.lang.String remake){
		this.remake = remake;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  单据来源
	 */
	public java.lang.String getSourceBillId(){
		return this.sourceBillId;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  单据来源
	 */
	public void setSourceBillId(java.lang.String sourceBillId){
		this.sourceBillId = sourceBillId;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysPersonInfo
	 *@return: com.dst.slms.system.entity.SysPersonInfo  申请人
	 */
	public com.dst.slms.system.entity.SysPersonInfo getReqPerson(){
		return this.reqPerson;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysPersonInfo
	 *@param: com.dst.slms.system.entity.SysPersonInfo  申请人
	 */
	public void setReqPerson(com.dst.slms.system.entity.SysPersonInfo reqPerson){
		this.reqPerson = reqPerson;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  申请日期
	 */
	public java.util.Date getReqDate(){
		return this.reqDate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  申请日期
	 */
	public void setReqDate(java.util.Date reqDate){
		this.reqDate = reqDate;
	}
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketProjectInfo
	 *@return: com.dst.slms.base.entity.MarketProjectInfo  项目
	 */
	public com.dst.slms.base.entity.MarketProjectInfo getProject(){
		return this.project;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketProjectInfo
	 *@param: com.dst.slms.base.entity.MarketProjectInfo  项目
	 */
	public void setProject(com.dst.slms.base.entity.MarketProjectInfo project){
		this.project = project;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  执行情况
	 */
	public java.lang.String getExecution(){
		return this.execution;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  执行情况
	 */
	public void setExecution(java.lang.String execution){
		this.execution = execution;
	}
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.SaleContractInfo
	 *@return: com.dst.slms.contractmange.entity.SaleContractInfo  合同名称
	 */
	public com.dst.slms.contractmange.entity.SaleContractInfo getContract(){
		return this.contract;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.SaleContractInfo
	 *@param: com.dst.slms.contractmange.entity.SaleContractInfo  合同名称
	 */
	public void setContract(com.dst.slms.contractmange.entity.SaleContractInfo contract){
		this.contract = contract;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  合同号
	 */
	public java.lang.String getContractNum(){
		return this.contractNum;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  合同号
	 */
	public void setContractNum(java.lang.String contractNum){
		this.contractNum = contractNum;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  合同签约
	 */
	public java.util.Date getConDate(){
		return this.conDate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  合同签约
	 */
	public void setConDate(java.util.Date conDate){
		this.conDate = conDate;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  合同签约
	 */
	public java.math.BigDecimal getConAmt(){
		return this.conAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  合同签约
	 */
	public void setConAmt(java.math.BigDecimal conAmt){
		this.conAmt = conAmt;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysOrgInfo
	 *@return: com.dst.slms.system.entity.SysOrgInfo  甲方
	 */
	public com.dst.slms.system.entity.SysOrgInfo getPartA(){
		return this.partA;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysOrgInfo
	 *@param: com.dst.slms.system.entity.SysOrgInfo  甲方
	 */
	public void setPartA(com.dst.slms.system.entity.SysOrgInfo partA){
		this.partA = partA;
	}
	/**
	 *方法: 取得com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@return: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  乙方
	 */
	public com.dst.slms.supplierprofile.entity.SupplierProfileInfo getSupplier(){
		return this.supplier;
	}

	/**
	 *方法: 设置com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@param: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  乙方
	 */
	public void setSupplier(com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplier){
		this.supplier = supplier;
	}
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.SaleContractInfo
	 *@return: com.dst.slms.contractmange.entity.SaleContractInfo  框架合同
	 */
	public com.dst.slms.contractmange.entity.SaleContractInfo getKjcontract(){
		return this.kjcontract;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.SaleContractInfo
	 *@param: com.dst.slms.contractmange.entity.SaleContractInfo  框架合同
	 */
	public void setKjcontract(com.dst.slms.contractmange.entity.SaleContractInfo kjcontract){
		this.kjcontract = kjcontract;
	}
	/**
	 *方法: 取得com.dst.slms.base.entity.ContractTypeInfo
	 *@return: com.dst.slms.base.entity.ContractTypeInfo  合同类型
	 */
	public com.dst.slms.base.entity.ContractTypeInfo getContractType(){
		return this.contractType;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.ContractTypeInfo
	 *@param: com.dst.slms.base.entity.ContractTypeInfo  合同类型
	 */
	public void setContractType(com.dst.slms.base.entity.ContractTypeInfo contractType){
		this.contractType = contractType;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  实际来电
	 */
	public java.lang.String getSjphone(){
		return this.sjphone;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  实际来电
	 */
	public void setSjphone(java.lang.String sjphone){
		this.sjphone = sjphone;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  实际来人
	 */
	public java.lang.String getSjperson(){
		return this.sjperson;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  实际来人
	 */
	public void setSjperson(java.lang.String sjperson){
		this.sjperson = sjperson;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  验收金额
	 */
	public java.math.BigDecimal getYsAmt(){
		return this.ysAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  验收金额
	 */
	public void setYsAmt(java.math.BigDecimal ysAmt){
		this.ysAmt = ysAmt;
	}
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer  评估得分
	 */
	public java.lang.Integer getScore(){
		return this.score;
	}

	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer  评估得分
	 */
	public void setScore(java.lang.Integer score){
		this.score = score;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  评估结果
	 */
	public java.lang.String getResult(){
		return this.result;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  评估结果
	 */
	public void setResult(java.lang.String result){
		this.result = result;
	}
	
	public void setBosType(String bosType) {
		this.bosType = "T2JXSN1P";
	}
}
