package com.dst.slms.contractmange.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 发票明细页签 Info 对象
 * @Description: 发票明细页签
 * @author 
 * @date 2020-05-05 08:36:02
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractPaymentReqE1Info  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.contractmange.entity.PaymentReqInfo parent;
	
	/**发票号码*/
	@Column(name ="FinvoiceNum")
	@FieldMeta(name="发票号码" )
	private java.lang.String invoiceNum;
	
	/**发票代码*/
	@Column(name ="FinvoiceCode")
	@FieldMeta(name="发票代码" )
	private java.lang.String invoiceCode;
	
	/**发票类型*/
	@Column(name ="FinvoiceType")
	@FieldMeta(name="发票类型" ,enumGroupNumber="invoiceType")
	private java.lang.String invoiceType;
	
	/**开票日期*/
	@Column(name ="Fkpdate")
	@FieldMeta(name="开票日期" )
	private java.util.Date kpdate;
	
	/**货物或应税劳务，服务名称*/
	@Column(name ="Fname")
	@FieldMeta(name="货物或应税劳务，服务名称" )
	private java.lang.String name;
	
	/**不含税金额*/
	@Column(name ="FnoTaxConAmt")
	@FieldMeta(name="不含税金额" )
	private java.math.BigDecimal noTaxConAmt;
	
	/**税率(%)*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FtaxRateID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="税率(%)" )
	private com.dst.slms.base.entity.TaxRateInfo taxRate;
	
	/**税额*/
	@Column(name ="FtaxAmt")
	@FieldMeta(name="税额" )
	private java.math.BigDecimal taxAmt;
	
	/**价税合计*/
	@Column(name ="FtaxConAmt")
	@FieldMeta(name="价税合计" )
	private java.math.BigDecimal taxConAmt;
	
	/**购方名称*/
	@Column(name ="Fgfname")
	@FieldMeta(name="购方名称" )
	private java.lang.String gfname;
	
	/**购方纳税人识别号*/
	@Column(name ="Fgfnumber")
	@FieldMeta(name="购方纳税人识别号" )
	private java.lang.String gfnumber;
	
	/**销方名称*/
	@Column(name ="Fxfname")
	@FieldMeta(name="销方名称" )
	private java.lang.String xfname;
	
	/**消方纳税人识别号*/
	@Column(name ="Fxfnumber")
	@FieldMeta(name="消方纳税人识别号" )
	private java.lang.String xfnumber;
	
	
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.PaymentReqInfo
	 *@return: com.dst.slms.contractmange.entity.PaymentReqInfo  父对象关联
	 */
	public com.dst.slms.contractmange.entity.PaymentReqInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.PaymentReqInfo
	 *@param: com.dst.slms.contractmange.entity.PaymentReqInfo  父对象关联
	 */
	public void setParent(com.dst.slms.contractmange.entity.PaymentReqInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  发票号码
	 */
	public java.lang.String getInvoiceNum(){
		return this.invoiceNum;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  发票号码
	 */
	public void setInvoiceNum(java.lang.String invoiceNum){
		this.invoiceNum = invoiceNum;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  发票代码
	 */
	public java.lang.String getInvoiceCode(){
		return this.invoiceCode;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  发票代码
	 */
	public void setInvoiceCode(java.lang.String invoiceCode){
		this.invoiceCode = invoiceCode;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  发票类型
	 */
	public java.lang.String getInvoiceType(){
		return this.invoiceType;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  发票类型
	 */
	public void setInvoiceType(java.lang.String invoiceType){
		this.invoiceType = invoiceType;
	}
	
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  开票日期
	 */
	public java.util.Date getKpdate(){
		return this.kpdate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  开票日期
	 */
	public void setKpdate(java.util.Date kpdate){
		this.kpdate = kpdate;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  货物或应税劳务，服务名称
	 */
	public java.lang.String getName(){
		return this.name;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  货物或应税劳务，服务名称
	 */
	public void setName(java.lang.String name){
		this.name = name;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  不含税金额
	 */
	public java.math.BigDecimal getNoTaxConAmt(){
		return this.noTaxConAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  不含税金额
	 */
	public void setNoTaxConAmt(java.math.BigDecimal noTaxConAmt){
		this.noTaxConAmt = noTaxConAmt;
	}
	
	/**
	 *方法: 取得com.dst.slms.base.entity.TaxRateInfo
	 *@return: com.dst.slms.base.entity.TaxRateInfo  税率(%)
	 */
	public com.dst.slms.base.entity.TaxRateInfo getTaxRate(){
		return this.taxRate;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.TaxRateInfo
	 *@param: com.dst.slms.base.entity.TaxRateInfo  税率(%)
	 */
	public void setTaxRate(com.dst.slms.base.entity.TaxRateInfo taxRate){
		this.taxRate = taxRate;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  税额
	 */
	public java.math.BigDecimal getTaxAmt(){
		return this.taxAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  税额
	 */
	public void setTaxAmt(java.math.BigDecimal taxAmt){
		this.taxAmt = taxAmt;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  价税合计
	 */
	public java.math.BigDecimal getTaxConAmt(){
		return this.taxConAmt;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  价税合计
	 */
	public void setTaxConAmt(java.math.BigDecimal taxConAmt){
		this.taxConAmt = taxConAmt;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  购方名称
	 */
	public java.lang.String getGfname(){
		return this.gfname;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  购方名称
	 */
	public void setGfname(java.lang.String gfname){
		this.gfname = gfname;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  购方纳税人识别号
	 */
	public java.lang.String getGfnumber(){
		return this.gfnumber;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  购方纳税人识别号
	 */
	public void setGfnumber(java.lang.String gfnumber){
		this.gfnumber = gfnumber;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  销方名称
	 */
	public java.lang.String getXfname(){
		return this.xfname;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  销方名称
	 */
	public void setXfname(java.lang.String xfname){
		this.xfname = xfname;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  消方纳税人识别号
	 */
	public java.lang.String getXfnumber(){
		return this.xfnumber;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  消方纳税人识别号
	 */
	public void setXfnumber(java.lang.String xfnumber){
		this.xfnumber = xfnumber;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "LVJ75VW0";
	}
}
