package com.dst.slms.base.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.utils.R;
import com.dst.slms.base.entity.SalesTargetInfo;
import com.dst.slms.base.service.ISalesTargetService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
/**   
 * @Title: 销售目标 Controller
 * @Description: 销售目标
 * @author 
 * @date 2020-05-07 10:39:23
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/salesTargetController")
@SysPermissionName(name="销售目标",type=Constant.MENU)
public class SalesTargetController extends AbstractSalesTargetController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(SalesTargetController.class);

	@Autowired
	private ISalesTargetService iSalesTargetService;	
	/**
	 * 变更启用禁用状态
	 */
	@ResponseBody
    @RequestMapping(value = "/changeEnable")
	public R auditAction(SalesTargetInfo info, HttpServletRequest req) {
		return iSalesTargetService.changeEnable(info,req);
	}
	
}
