package com.dst.slms.base.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.base.entity.ContractTypeInfo;
import com.dst.slms.base.service.IContractTypeService;

/**   
 * 合同类型 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 合同类型
 * @author 
 * @date 2020-05-02 16:17:45
 * @version V1.0   
 *
 */
public abstract class AbstractContractTypeController extends CoreBaseController {

	@Autowired
	private IContractTypeService iContractTypeService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/base/contracttype/contractTypeList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/base/contracttype/contractTypeEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iContractTypeService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		ContractTypeInfo info = new ContractTypeInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("isEnable");
		return sic;
	}
	
	@RequiresPermissions("coe:contractType:list")		
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(ContractTypeInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}

	@SysPermissionName(name="列表查看")
	@RequiresPermissions("coe:contractType:list")	
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("coe:contractType:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}
	
	@SysPermissionName(name="表单查看")
	@RequiresPermissions("coe:contractType:view")	
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(ContractTypeInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("coe:contractType:edit")
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(ContractTypeInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("coe:contractType:save")
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(ContractTypeInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}
	
	@SysPermissionName(name="提交")
	@RequiresPermissions("coe:contractType:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(ContractTypeInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}
	
	@SysPermissionName(name="删除")
	@RequiresPermissions("coe:contractType:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(ContractTypeInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("coe:contractType:downExcel")
	@RequestMapping(value = "/downExcel")
	public void downExcel(ContractTypeInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
