package com.dst.slms.base.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.CrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import com.dst.slms.base.entity.CustomerInfoInfo;
import com.dst.slms.base.service.ICustomerInfoService;

/**   
 * @Title: 客户信息 ServiceImpl
 * @Description: 客户信息
 * @author 
 * @date 2020-05-02 10:08:28
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class ICustomerInfoServiceImpl extends CrudServiceImpl<CustomerInfoInfo> implements ICustomerInfoService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(ICustomerInfoServiceImpl.class);

	@Autowired
	private ICustomerInfoService iCustomerInfoService;
	
	public R changeEnable(CustomerInfoInfo info, HttpServletRequest req) {
		Map<String, Object> params = new HashMap<>();
		params.put("isEnable", info.getIsEnable());
		params.put("fid", info.getId());
		iCustomerInfoService.executeHql("update CustomerInfoInfo set isEnable=:isEnable where fid=:fid", params);
		return R.ok("执行成功");
	}
}