<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@include file="/common/common.jsp"%>
<head>
<Dst:SMBase type="jquery,eui" pakgagePath="com.dst.slms.plan.monthlypaymentplan.monthlyPaymentPlanEdit" uipk="monthlyPaymentPlanController" title="月度支付计划"/>
</head>
<body class="dst-mainbackground">
<div class="dst-container">

<Dst:SMMain title="月度支付计划">
	<Dst:SMEDBillToolBar >
	   <Dst:SMDGToolBar title="保存" icon="fa fa-save" bindAction="saveAction"/>
	   <Dst:SMDGToolBar title="提交并关闭" icon="fa fa-clipboard" bindAction="submitAction"/>
	   <Dst:SMDGToolBar title="查看流程图" icon="fa fa-cubes" bindAction="viewFlowAction"/>
	   <Dst:SMDGToolBar title="关闭" icon="fa fa-rotate-left" bindAction="closeAction"/>
	</Dst:SMEDBillToolBar> 
	<Dst:SMForm formid="formobj" >
		<input id="id" name="id" type="hidden" value="${model.id }">
		<div class="easyui-panel" title="月度支付计划" style="width:100%;" data-options="bodyCls:'panle-background',collapsible:true,headerCls:'panel-block-teal panel-description'">
			<div style="padding-top: 10px"></div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">编号</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="number" readonly="false" validType="['maxLength[100]']" width="100%" value="${model.number}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">名称</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="name" required="true" validType="['maxLength[100]']" width="100%" value="${model.name}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">所属组织</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="org" required="true" queryFieldItem="number,name" url="/systemPop/orgPage"  width="100%" value="${model.org}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">项目名称</label>
					<div class="dst-input-block">
						<Dst:SMBizPromptBox id="marketProject" DSTFilter=" isEnable='Y'" onDataChange="updateMarketProject" required="true" queryFieldItem="number,name" entityPath="com.dst.slms.base.entity.MarketProjectInfo" width="100%" value="${model.marketProject}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">年份</label>
					<div class="dst-input-block">
						<Dst:SMEnumDicBox id="year" required="true" dicGroupCode="year" width="100%"  value="${model.year}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<label class="dst-form-label">月份</label>
					<div class="dst-input-block">
						<Dst:SMEnumDicBox id="month" required="true" dicGroupCode="month" width="100%" value="${model.month}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm4">
					<label class="dst-form-label">版本号</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="versions" readonly="true" validType="['maxLength[100]']" width="100%" value="${model.versions}"/>
					</div>
				</div>
				<div class="dst-col-sm4">
					<div class="dst-input-block">
						<Dst:SMCheckBox id="isnew" label="是否最新版" readonly="true" value="${model.isnew}"/>
					</div>
				</div>
			</div>
			<div class="dst-row">
				<div class="dst-col-sm12">
					<label class="dst-form-label">备注</label>
					<div class="dst-input-block">
						<Dst:SMTextBox id="remake"  height="100" validType="['maxLength[500]']" width="100%" value="${model.remake}"/>
					</div>
				</div>
			</div>
		</div>	
		<div style="padding-top: 10px"></div>
			<div class="easyui-tabs tabs-underline tab-color-teal" data-options="plain:true,border:false,fit:true,selected:0">
				<div title="已签约">
						<Dst:SMEDDatagrid entityPath="com.dst.slms.plan.entity.SignedInfo" style="width:100%;height:250px;" enableCellEdit="true" rownumbers="true" 
						ctrlSelect="true" title="已签约" url="/monthlyPaymentPlanController?getSignedByid&parentid=${model.id}" id="signed" >
							<Dst:SMEDColumnMoreHeaderGroup>
								<Dst:SMEDColumnTextBox title="id" field="id" hidden="true" width="100"/>
								<Dst:SMEDColumnBizPromptBox field="saleContract" readonly="true" queryFieldItem="number,name" disPlayFormatName="number" title="合同编码" entityPath="com.dst.slms.contractmange.entity.SaleContractInfo"></Dst:SMEDColumnBizPromptBox>
								<Dst:SMEDColumnTextBox field="saleContractName" readonly="true" title="合同名称" width="100"></Dst:SMEDColumnTextBox>
								<Dst:SMEDColumnBizPromptBox field="supplierProfile" readonly="true" queryFieldItem="number,name" title="供应商" entityPath="com.dst.slms.supplierprofile.entity.SupplierProfileInfo"></Dst:SMEDColumnBizPromptBox>
								<Dst:SMEDColumnBizPromptBox field="marketAccount" readonly="true" queryFieldItem="number,name" title="营销科目" entityPath="com.dst.slms.base.entity.MarketAccountInfo"></Dst:SMEDColumnBizPromptBox>
								<Dst:SMEDColumnNumberBox field="contractAmount" readonly="true" title="合同金额" precision="2"></Dst:SMEDColumnNumberBox>
								<Dst:SMEDColumnNumberBox field="amountPaid" readonly="true" title="已付金额" precision="2"></Dst:SMEDColumnNumberBox>
								<Dst:SMEDColumnNumberBox field="unpaidAmount" readonly="true" title="未付金额" precision="2"></Dst:SMEDColumnNumberBox>
								<Dst:SMEDColumnNumberBox field="monthOne" readonly="true" title="月份1" precision="2"></Dst:SMEDColumnNumberBox>
								<Dst:SMEDColumnNumberBox field="monthTwo" readonly="true" title="月份2" precision="2"></Dst:SMEDColumnNumberBox>
								<Dst:SMEDColumnNumberBox field="monthThree" readonly="true" title="月份3" precision="2"></Dst:SMEDColumnNumberBox>
							</Dst:SMEDColumnMoreHeaderGroup>
						</Dst:SMEDDatagrid>
				</div>
				<div title="逾期未支付">
					<Dst:SMEDDatagrid entityPath="com.dst.slms.plan.entity.ExpectedUnpaidInfo" style="width:100%;height:250px;" enableCellEdit="true" rownumbers="true" 
					ctrlSelect="true" title="逾期未支付" url="/monthlyPaymentPlanController?getExpectedUnpaidByid&parentid=${model.id}" id="expectedUnpaid" >
						<Dst:SMEDColumnMoreHeaderGroup>
							<Dst:SMEDColumnTextBox title="id" field="id" hidden="true" width="100"/>
							<Dst:SMEDColumnBizPromptBox field="saleContract" readonly="true" queryFieldItem="number,name" title="合同编码" disPlayFormatName="number" entityPath="com.dst.slms.contractmange.entity.SaleContractInfo"></Dst:SMEDColumnBizPromptBox>
							<Dst:SMEDColumnTextBox field="saleContractName" readonly="true"  title="合同名称" width="100"></Dst:SMEDColumnTextBox>
							<Dst:SMEDColumnBizPromptBox field="supplierProfile" readonly="true" queryFieldItem="number,name" title="供应商" entityPath="com.dst.slms.supplierprofile.entity.SupplierProfileInfo"></Dst:SMEDColumnBizPromptBox>
							<Dst:SMEDColumnBizPromptBox field="marketAccount" readonly="true" queryFieldItem="number,name" title="营销科目" entityPath="com.dst.slms.base.entity.MarketAccountInfo"></Dst:SMEDColumnBizPromptBox>
							<Dst:SMEDColumnNumberBox field="contractAmount" readonly="true" title="合同金额" precision="2"></Dst:SMEDColumnNumberBox>
							<Dst:SMEDColumnNumberBox field="amountPaid" readonly="true" title="已付金额" precision="2"></Dst:SMEDColumnNumberBox>
							<Dst:SMEDColumnNumberBox field="unpaidAmount" readonly="true" title="未付款金额" precision="2"></Dst:SMEDColumnNumberBox>
							<Dst:SMEDColumnNumberBox field="overdue" readonly="true" title="逾期未支付" precision="2"></Dst:SMEDColumnNumberBox>
						</Dst:SMEDColumnMoreHeaderGroup>
					</Dst:SMEDDatagrid>
				</div>
				<div title="规划余额">
					<table id="monthlyPaymentPlanE" ></table> 
<%-- 					<Dst:SMEDDatagrid entityPath="com.dst.slms.plan.entity.MonthlyPaymentPlanEInfo" style="width:100%;height:250px;" enableCellEdit="true" rownumbers="true" 
					ctrlSelect="true" title="规划余额" url="/monthlyPaymentPlanController?getMonthlyPaymentPlanEByid&parentid=${model.id}" id="monthlyPaymentPlanE" >
						<Dst:SMEDColumnMoreHeaderGroup>
							<Dst:SMEDColumnTextBox title="id" field="id" hidden="true" width="100"/>
							<Dst:SMEDColumnBizPromptBox field="marketAccount" readonly="true" disPlayFormatName="number"  queryFieldItem="number,name" title="科目编码" entityPath="com.dst.slms.base.entity.MarketAccountInfo"></Dst:SMEDColumnBizPromptBox>
							<Dst:SMEDColumnTextBox field="marketAccountName" readonly="true"  title="科目名称" width="100"></Dst:SMEDColumnTextBox>
							<Dst:SMEDColumnNumberBox field="currentApplication" readonly="true" title="本期申请（A）" precision="2"></Dst:SMEDColumnNumberBox>
							<Dst:SMEDColumnNumberBox field="oldBalance" readonly="true" title="上期结余（B）" precision="2"></Dst:SMEDColumnNumberBox>
							<Dst:SMEDColumnNumberBox field="monthlyBalance" readonly="true" title="当月预算（C）" precision="2"></Dst:SMEDColumnNumberBox>
							<Dst:SMEDColumnTextBox field="verifyabc" readonly="true" title="校验（A-B-C）" width="100"></Dst:SMEDColumnTextBox>
						</Dst:SMEDColumnMoreHeaderGroup>
					</Dst:SMEDDatagrid> --%>
					</div>
				</div>
	</Dst:SMForm>	
</Dst:SMMain>
</div>
</body>
