package com.dst.slms.supplierreview.entity;


import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import com.dst.slms.common.entity.CoreBaseInfo;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import com.dst.slms.common.entity.CoreBillBaseInfo;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.OrderBy;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 供应商评审 Info 对象
 * @Description: 供应商评审
 * @author 
 * @date 2020-05-02 18:55:41
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractSupplierReviewInfo  extends CoreBillBaseInfo implements java.io.Serializable {
	
	@Column(name ="FNAME")
	@FieldMeta(name="供应商名称" )
	private java.lang.String name;
	
	@Column(name ="FNUMBER")
	@FieldMeta(name="编号" )
	private java.lang.String number;
	
	@Column(name ="FREMAKE")
	@FieldMeta(name="说明" )
	private java.lang.String remake;
	
	@Column(name ="FSOURCEBILLID")
	@FieldMeta(name="单据来源" )
	private java.lang.String sourceBillId;
	
	
	
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FsupplierProfileID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="供应商编码" )
	private com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplierProfile;
	
	@Column(name ="FserviceArea")
	@FieldMeta(name="服务区域" )
	private java.lang.String serviceArea;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FreviewTypeID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="评审类型" )
	private com.dst.slms.supplierreview.entity.ReviewTypeInfo reviewType;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FreviewTemplateID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="评审模板" )
	private com.dst.slms.supplierreview.entity.ReviewTemplateInfo reviewTemplate;
	
	@Column(name ="FreviewDate")
	@FieldMeta(name="评审日期" )
	private java.util.Date reviewDate;
	
	@Column(name ="FeffectiveBegin")
	@FieldMeta(name="生效开始日期" )
	private java.util.Date effectiveBegin;
	
	@Column(name ="FeffectiveEnd")
	@FieldMeta(name="生效结束日期" )
	private java.util.Date effectiveEnd;
	
	@Column(name ="FfinalScore")
	@FieldMeta(name="最终得分" )
	private java.math.BigDecimal finalScore;
	
	@Column(name ="Freferrer")
	@FieldMeta(name="推荐人" )
	private java.lang.String referrer;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FsaleContractID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="合同" )
	private com.dst.slms.contractmange.entity.SaleContractInfo saleContract;
	
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<SupplierReviewScoreInfo> supplierReviewScore = new ArrayList<SupplierReviewScoreInfo>(); 

	public List<SupplierReviewScoreInfo> getSupplierReviewScore() {
		return supplierReviewScore;
	}

	public void setSupplierReviewScore(List<SupplierReviewScoreInfo> supplierReviewScore) {
		this.supplierReviewScore = supplierReviewScore;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  供应商名称
	 */
	public java.lang.String getName(){
		return this.name;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  供应商名称
	 */
	public void setName(java.lang.String name){
		this.name = name;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  编号
	 */
	public java.lang.String getNumber(){
		return this.number;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  编号
	 */
	public void setNumber(java.lang.String number){
		this.number = number;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  说明
	 */
	public java.lang.String getRemake(){
		return this.remake;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  说明
	 */
	public void setRemake(java.lang.String remake){
		this.remake = remake;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  单据来源
	 */
	public java.lang.String getSourceBillId(){
		return this.sourceBillId;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  单据来源
	 */
	public void setSourceBillId(java.lang.String sourceBillId){
		this.sourceBillId = sourceBillId;
	}
	/**
	 *方法: 取得com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@return: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  供应商编码
	 */
	public com.dst.slms.supplierprofile.entity.SupplierProfileInfo getSupplierProfile(){
		return this.supplierProfile;
	}

	/**
	 *方法: 设置com.dst.slms.supplierprofile.entity.SupplierProfileInfo
	 *@param: com.dst.slms.supplierprofile.entity.SupplierProfileInfo  供应商编码
	 */
	public void setSupplierProfile(com.dst.slms.supplierprofile.entity.SupplierProfileInfo supplierProfile){
		this.supplierProfile = supplierProfile;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  服务区域
	 */
	public java.lang.String getServiceArea(){
		return this.serviceArea;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  服务区域
	 */
	public void setServiceArea(java.lang.String serviceArea){
		this.serviceArea = serviceArea;
	}
	/**
	 *方法: 取得com.dst.slms.supplierreview.entity.ReviewTypeInfo
	 *@return: com.dst.slms.supplierreview.entity.ReviewTypeInfo  评审类型
	 */
	public com.dst.slms.supplierreview.entity.ReviewTypeInfo getReviewType(){
		return this.reviewType;
	}

	/**
	 *方法: 设置com.dst.slms.supplierreview.entity.ReviewTypeInfo
	 *@param: com.dst.slms.supplierreview.entity.ReviewTypeInfo  评审类型
	 */
	public void setReviewType(com.dst.slms.supplierreview.entity.ReviewTypeInfo reviewType){
		this.reviewType = reviewType;
	}
	/**
	 *方法: 取得com.dst.slms.supplierreview.entity.ReviewTemplateInfo
	 *@return: com.dst.slms.supplierreview.entity.ReviewTemplateInfo  评审模板
	 */
	public com.dst.slms.supplierreview.entity.ReviewTemplateInfo getReviewTemplate(){
		return this.reviewTemplate;
	}

	/**
	 *方法: 设置com.dst.slms.supplierreview.entity.ReviewTemplateInfo
	 *@param: com.dst.slms.supplierreview.entity.ReviewTemplateInfo  评审模板
	 */
	public void setReviewTemplate(com.dst.slms.supplierreview.entity.ReviewTemplateInfo reviewTemplate){
		this.reviewTemplate = reviewTemplate;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  评审日期
	 */
	public java.util.Date getReviewDate(){
		return this.reviewDate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  评审日期
	 */
	public void setReviewDate(java.util.Date reviewDate){
		this.reviewDate = reviewDate;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  生效开始日期
	 */
	public java.util.Date getEffectiveBegin(){
		return this.effectiveBegin;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  生效开始日期
	 */
	public void setEffectiveBegin(java.util.Date effectiveBegin){
		this.effectiveBegin = effectiveBegin;
	}
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  生效结束日期
	 */
	public java.util.Date getEffectiveEnd(){
		return this.effectiveEnd;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  生效结束日期
	 */
	public void setEffectiveEnd(java.util.Date effectiveEnd){
		this.effectiveEnd = effectiveEnd;
	}
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  最终得分
	 */
	public java.math.BigDecimal getFinalScore(){
		return this.finalScore;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  最终得分
	 */
	public void setFinalScore(java.math.BigDecimal finalScore){
		this.finalScore = finalScore;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  推荐人
	 */
	public java.lang.String getReferrer(){
		return this.referrer;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  推荐人
	 */
	public void setReferrer(java.lang.String referrer){
		this.referrer = referrer;
	}
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.SaleContractInfo
	 *@return: com.dst.slms.contractmange.entity.SaleContractInfo  合同
	 */
	public com.dst.slms.contractmange.entity.SaleContractInfo getSaleContract(){
		return this.saleContract;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.SaleContractInfo
	 *@param: com.dst.slms.contractmange.entity.SaleContractInfo  合同
	 */
	public void setSaleContract(com.dst.slms.contractmange.entity.SaleContractInfo saleContract){
		this.saleContract = saleContract;
	}
	
	public void setBosType(String bosType) {
		this.bosType = "D86R7MR6";
	}
}
