package com.dst.slms.plan.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 预算年度拆解 Info 对象
 * @Description: 预算年度拆解
 * @author 
 * @date 2020-05-04 17:39:29
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractCyclePaymentPlanE2Info  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.plan.entity.CyclePaymentPlanInfo parent;
	
	/**年份*/
	@Column(name ="Fyear")
	@FieldMeta(name="年份" ,enumGroupNumber="year")
	private java.lang.String years;
	
	/**规划金额百分比%*/
	@Column(name ="FplanAmountRate")
	@FieldMeta(name="规划金额百分比%" )
	private java.math.BigDecimal planAmountRate;
	
	/**规划金额*/
	@Column(name ="FplanAmount")
	@FieldMeta(name="规划金额" )
	private java.math.BigDecimal planAmount;
	
	/**已发生金额*/
	@Column(name ="FyfsAmount")
	@FieldMeta(name="已发生金额" )
	private java.math.BigDecimal yfsAmount;
	
	/**支付金额*/
	@Column(name ="FpayAmount")
	@FieldMeta(name="支付金额" )
	private java.math.BigDecimal payAmount;
	
	/**年份*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FyearID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="年份" )
	private com.dst.slms.base.entity.SysYearInfo year;
	
	
	/**
	 *方法: 取得com.dst.slms.plan.entity.CyclePaymentPlanInfo
	 *@return: com.dst.slms.plan.entity.CyclePaymentPlanInfo  父对象关联
	 */
	public com.dst.slms.plan.entity.CyclePaymentPlanInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.plan.entity.CyclePaymentPlanInfo
	 *@param: com.dst.slms.plan.entity.CyclePaymentPlanInfo  父对象关联
	 */
	public void setParent(com.dst.slms.plan.entity.CyclePaymentPlanInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  年份
	 */
	public java.lang.String getYears(){
		return this.years;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  年份
	 */
	public void setYears(java.lang.String years){
		this.years = years;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  规划金额百分比%
	 */
	public java.math.BigDecimal getPlanAmountRate(){
		return this.planAmountRate;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  规划金额百分比%
	 */
	public void setPlanAmountRate(java.math.BigDecimal planAmountRate){
		this.planAmountRate = planAmountRate;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  规划金额
	 */
	public java.math.BigDecimal getPlanAmount(){
		return this.planAmount;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  规划金额
	 */
	public void setPlanAmount(java.math.BigDecimal planAmount){
		this.planAmount = planAmount;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  已发生金额
	 */
	public java.math.BigDecimal getYfsAmount(){
		return this.yfsAmount;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  已发生金额
	 */
	public void setYfsAmount(java.math.BigDecimal yfsAmount){
		this.yfsAmount = yfsAmount;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  支付金额
	 */
	public java.math.BigDecimal getPayAmount(){
		return this.payAmount;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  支付金额
	 */
	public void setPayAmount(java.math.BigDecimal payAmount){
		this.payAmount = payAmount;
	}
	
	/**
	 *方法: 取得com.dst.slms.base.entity.SysYearInfo
	 *@return: com.dst.slms.base.entity.SysYearInfo  年份
	 */
	public com.dst.slms.base.entity.SysYearInfo getYear(){
		return this.year;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.SysYearInfo
	 *@param: com.dst.slms.base.entity.SysYearInfo  年份
	 */
	public void setYear(com.dst.slms.base.entity.SysYearInfo year){
		this.year = year;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "7HW9BFVR";
	}
}
