package com.dst.slms.contractmange.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.contractmange.entity.EconTermsAdjustInfo;
import com.dst.slms.contractmange.service.IEconTermsAdjustService;

/**   
 * 经济条款调整单 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 经济条款调整单
 * @author 
 * @date 2020-05-03 14:57:21
 * @version V1.0   
 *
 */
public abstract class AbstractEconTermsAdjustController extends CoreBaseController {

	@Autowired
	private IEconTermsAdjustService iEconTermsAdjustService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/contractmange/econtermsadjust/econTermsAdjustList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/contractmange/econtermsadjust/econTermsAdjustEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iEconTermsAdjustService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		EconTermsAdjustInfo info = new EconTermsAdjustInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		info.setState("SAVE");
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("sourceBillId");
		sic.add("state");
		sic.add("auditor.id");
		sic.add("auditor.number");
		sic.add("auditor.name");
		sic.add("auditTime");
		sic.add("project.id");
		sic.add("project.number");
		sic.add("project.name");
		sic.add("contract.id");
		sic.add("contract.number");
		sic.add("contract.name");
		sic.add("org.id");
		sic.add("org.number");
		sic.add("org.name");
		sic.add("supplier.id");
		sic.add("supplier.number");
		sic.add("supplier.name");
		sic.add("conAmount");
		sic.add("econTermsAdjustE1.parent.id");
		sic.add("econTermsAdjustE1.parent.number");
		sic.add("econTermsAdjustE1.parent.name");
		sic.add("econTermsAdjustE1.adjustDate");
		sic.add("econTermsAdjustE1.payType.id");
		sic.add("econTermsAdjustE1.payType.number");
		sic.add("econTermsAdjustE1.payType.name");
		sic.add("econTermsAdjustE1.conditions");
		sic.add("econTermsAdjustE1.rate");
		sic.add("econTermsAdjustE1.amount");
		sic.add("econTermsAdjustE1.payAmount");
		return sic;
	}

	@RequiresPermissions("Ect:EconTermsAdjust:list")	
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(EconTermsAdjustInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}
	
	@SysPermissionName(name="列表查看")
	@RequiresPermissions("Ect:EconTermsAdjust:list")
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("Ect:EconTermsAdjust:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}

	@SysPermissionName(name="表单查看")
	@RequiresPermissions("Ect:EconTermsAdjust:view")		
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(EconTermsAdjustInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("Ect:EconTermsAdjust:edit")	
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(EconTermsAdjustInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("Ect:EconTermsAdjust:save")	
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(EconTermsAdjustInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}

	@SysPermissionName(name="提交")
	@RequiresPermissions("Ect:EconTermsAdjust:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(EconTermsAdjustInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}

	@SysPermissionName(name="删除")
	@RequiresPermissions("Ect:EconTermsAdjust:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(EconTermsAdjustInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("Ect:EconTermsAdjust:downExcel")		 
	@RequestMapping(value = "/downExcel")
	public void downExcel(EconTermsAdjustInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
