package com.dst.slms.contractmange.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 调整明细 Info 对象
 * @Description: 调整明细
 * @author 
 * @date 2020-05-03 14:57:21
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractEconTermsAdjustE1Info  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.contractmange.entity.EconTermsAdjustInfo parent;
	
	/**日期*/
	@Column(name ="FadjustDate")
	@FieldMeta(name="日期" )
	private java.util.Date adjustDate;
	
	/**付款类型*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FpayTypeID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="付款类型" )
	private com.dst.slms.base.entity.PayTypeInfo payType;
	
	/**付款条件*/
	@Column(name ="Fconditions")
	@FieldMeta(name="付款条件" )
	private java.lang.String conditions;
	
	/**付款比例%*/
	@Column(name ="Frate")
	@FieldMeta(name="付款比例%" )
	private java.math.BigDecimal rate;
	
	/**已付金额*/
	@Column(name ="Famount")
	@FieldMeta(name="已付金额" )
	private java.math.BigDecimal amount;
	
	/**付款金额*/
	@Column(name ="FpayAmount")
	@FieldMeta(name="付款金额" )
	private java.math.BigDecimal payAmount;
	
	
	/**
	 *方法: 取得com.dst.slms.contractmange.entity.EconTermsAdjustInfo
	 *@return: com.dst.slms.contractmange.entity.EconTermsAdjustInfo  父对象关联
	 */
	public com.dst.slms.contractmange.entity.EconTermsAdjustInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.contractmange.entity.EconTermsAdjustInfo
	 *@param: com.dst.slms.contractmange.entity.EconTermsAdjustInfo  父对象关联
	 */
	public void setParent(com.dst.slms.contractmange.entity.EconTermsAdjustInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得java.util.Date
	 *@return: java.util.Date  日期
	 */
	public java.util.Date getAdjustDate(){
		return this.adjustDate;
	}

	/**
	 *方法: 设置java.util.Date
	 *@param: java.util.Date  日期
	 */
	public void setAdjustDate(java.util.Date adjustDate){
		this.adjustDate = adjustDate;
	}
	
	/**
	 *方法: 取得com.dst.slms.base.entity.PayTypeInfo
	 *@return: com.dst.slms.base.entity.PayTypeInfo  付款类型
	 */
	public com.dst.slms.base.entity.PayTypeInfo getPayType(){
		return this.payType;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.PayTypeInfo
	 *@param: com.dst.slms.base.entity.PayTypeInfo  付款类型
	 */
	public void setPayType(com.dst.slms.base.entity.PayTypeInfo payType){
		this.payType = payType;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  付款条件
	 */
	public java.lang.String getConditions(){
		return this.conditions;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  付款条件
	 */
	public void setConditions(java.lang.String conditions){
		this.conditions = conditions;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  付款比例%
	 */
	public java.math.BigDecimal getRate(){
		return this.rate;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  付款比例%
	 */
	public void setRate(java.math.BigDecimal rate){
		this.rate = rate;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  已付金额
	 */
	public java.math.BigDecimal getAmount(){
		return this.amount;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  已付金额
	 */
	public void setAmount(java.math.BigDecimal amount){
		this.amount = amount;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  付款金额
	 */
	public java.math.BigDecimal getPayAmount(){
		return this.payAmount;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  付款金额
	 */
	public void setPayAmount(java.math.BigDecimal payAmount){
		this.payAmount = payAmount;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "MG2QVOEN";
	}
}
