package com.dst.slms.base.web.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import com.dst.slms.common.config.Constant;
import com.dst.slms.common.utils.R;
import com.dst.slms.base.entity.CitycbaseInfo;
import com.dst.slms.base.service.ICitycbaseService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
/**   
 * @Title: 城市 Controller
 * @Description: 城市
 * @author 
 * @date 2020-05-02 15:10:59
 * @version V1.0   
 *
 */
@SuppressWarnings("unchecked")
@Controller
@RequestMapping("/citycbaseController")
@SysPermissionName(name="城市",type=Constant.MENU)
public class CitycbaseController extends AbstractCitycbaseController {
	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(CitycbaseController.class);

	@Autowired
	private ICitycbaseService iCitycbaseService;	
	/**
	 * 变更启用禁用状态
	 */
	@ResponseBody
    @RequestMapping(value = "/changeEnable")
	public R auditAction(CitycbaseInfo info, HttpServletRequest req) {
		return iCitycbaseService.changeEnable(info,req);
	}
	
}
