package com.dst.slms.base.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.base.entity.SigningInfoInfo;
import com.dst.slms.base.service.ISigningInfoService;

/**   
 * 签约信息 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 签约信息
 * @author 
 * @date 2020-05-02 11:14:43
 * @version V1.0   
 *
 */
public abstract class AbstractSigningInfoController extends CoreBaseController {

	@Autowired
	private ISigningInfoService iSigningInfoService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/base/signinginfo/signingInfoList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/base/signinginfo/signingInfoEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iSigningInfoService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		SigningInfoInfo info = new SigningInfoInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("isEnable");
		sic.add("project.id");
		sic.add("project.number");
		sic.add("project.name");
		sic.add("customer.id");
		sic.add("customer.number");
		sic.add("customer.name");
		sic.add("amount");
		sic.add("successDate");
		return sic;
	}
	
	@RequiresPermissions("sio:signingInfo:list")		
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(SigningInfoInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}

	@SysPermissionName(name="列表查看")
	@RequiresPermissions("sio:signingInfo:list")	
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("sio:signingInfo:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}
	
	@SysPermissionName(name="表单查看")
	@RequiresPermissions("sio:signingInfo:view")	
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(SigningInfoInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("sio:signingInfo:edit")
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(SigningInfoInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("sio:signingInfo:save")
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(SigningInfoInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}
	
	@SysPermissionName(name="提交")
	@RequiresPermissions("sio:signingInfo:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(SigningInfoInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}
	
	@SysPermissionName(name="删除")
	@RequiresPermissions("sio:signingInfo:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(SigningInfoInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("sio:signingInfo:downExcel")
	@RequestMapping(value = "/downExcel")
	public void downExcel(SigningInfoInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
