package com.dst.slms.base.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.base.entity.MarketProjectInfo;
import com.dst.slms.base.service.IMarketProjectService;

/**   
 * 营销项目 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 营销项目
 * @author 
 * @date 2020-05-02 11:14:43
 * @version V1.0   
 *
 */
public abstract class AbstractMarketProjectController extends CoreBaseController {

	@Autowired
	private IMarketProjectService iMarketProjectService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/base/marketproject/marketProjectList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/base/marketproject/marketProjectEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iMarketProjectService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		MarketProjectInfo info = new MarketProjectInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("isEnable");
		sic.add("org.id");
		sic.add("org.number");
		sic.add("org.name");
		return sic;
	}
	
	@RequiresPermissions("mat:marketProject:list")		
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(MarketProjectInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}

	@SysPermissionName(name="列表查看")
	@RequiresPermissions("mat:marketProject:list")	
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("mat:marketProject:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}
	
	@SysPermissionName(name="表单查看")
	@RequiresPermissions("mat:marketProject:view")	
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(MarketProjectInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("mat:marketProject:edit")
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(MarketProjectInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("mat:marketProject:save")
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(MarketProjectInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}
	
	@SysPermissionName(name="提交")
	@RequiresPermissions("mat:marketProject:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(MarketProjectInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}
	
	@SysPermissionName(name="删除")
	@RequiresPermissions("mat:marketProject:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(MarketProjectInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("mat:marketProject:downExcel")
	@RequestMapping(value = "/downExcel")
	public void downExcel(MarketProjectInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
