package com.dst.slms.base.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.CrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import com.dst.slms.base.entity.SysYearInfo;
import com.dst.slms.base.service.ISysYearService;

/**   
 * @Title: 年份 ServiceImpl
 * @Description: 年份
 * @author 
 * @date 2020-05-04 17:38:01
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class ISysYearServiceImpl extends CrudServiceImpl<SysYearInfo> implements ISysYearService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(ISysYearServiceImpl.class);

	@Autowired
	private ISysYearService iSysYearService;
	
	public R changeEnable(SysYearInfo info, HttpServletRequest req) {
		Map<String, Object> params = new HashMap<>();
		params.put("isEnable", info.getIsEnable());
		params.put("fid", info.getId());
		iSysYearService.executeHql("update SysYearInfo set isEnable=:isEnable where fid=:fid", params);
		return R.ok("执行成功");
	}
}