package com.dst.slms.base.service.impl;

import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.dst.slms.common.excetion.BizException;
import com.dst.slms.common.support.CrudServiceImpl;
import com.dst.slms.common.utils.R;
import com.dst.slms.common.utils.UIRuleUtil;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import com.dst.slms.base.entity.SigningInfoInfo;
import com.dst.slms.base.service.ISigningInfoService;

/**   
 * @Title: 签约信息 ServiceImpl
 * @Description: 签约信息
 * @author 
 * @date 2020-05-02 10:08:28
 * @version V1.0   
 */
@SuppressWarnings("unchecked")
@Service
@Transactional
public class ISigningInfoServiceImpl extends CrudServiceImpl<SigningInfoInfo> implements ISigningInfoService{

	/**
	 * Logger for this class
	 */
	private static final Logger logger = LoggerFactory.getLogger(ISigningInfoServiceImpl.class);

	@Autowired
	private ISigningInfoService iSigningInfoService;
	
	public R changeEnable(SigningInfoInfo info, HttpServletRequest req) {
		Map<String, Object> params = new HashMap<>();
		params.put("isEnable", info.getIsEnable());
		params.put("fid", info.getId());
		iSigningInfoService.executeHql("update SigningInfoInfo set isEnable=:isEnable where fid=:fid", params);
		return R.ok("执行成功");
	}
}