dst.defineClass("com.dst.slms.plan.cyclepaymentplan.cyclePaymentPlanEdit", dst.framework.coreBillBaseEdit, {
	gridEditId:'',
	initalizeDOM:function(){
		com.dst.slms.plan.cyclepaymentplan.cyclePaymentPlanEdit.superClass.initalizeDOM.call(this);
		
		var billId = $('#id').val();
		var oldId = $('#oldId').val();
		var _self = this;
		$('#editTreeGrid').treegrid({
			url:'getAccountEntryData?id='+billId+'&oldId='+oldId,
		    idField:'id',    
		    treeField:'name',    
		    cls:'datagrid-simple',
			singleSelect:true,
			rownumbers:true,
			striped:true,
			fit:true,
			editorHeight:30,
			title:'科目规划金额',
			rowStyler: function(row,index){
				if(!row.isLeaf){
					return 'background-color:#cbcccd;';
				}
			},
		    columns:[[    
		        {title:'id',field:'id',hidden:true},    
		        {field:'name',title:'科目名称',width:220},    
		        {field:'number',title:'科目编码',width:120},    
		        {field:'planAmount',title:'规划金额*',width:100,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)},editor:{type:'numberbox',options:{prompt:'请输入金额',precision:2,groupSeparator:',',min:-9999999999999,max:9999999999999}}},    
		        {field:'rate',title:'占比%',width:60,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
		        {field:'yfsAmount',title:'已发生金额',width:80,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
		        {field:'planYe',title:'规划余额',width:80,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
		        {field:'payAmount',title:'已支付',width:80,align:'right',formatter:function(value,rec,index){return _self.fmt_Amount(value)}},    
		        {field:'remarks',title:'说明',width:250,align:'center',editor:{type:'textbox',options:{prompt:'请填写说明'}}},    
		    ]],
		    onClickCell:function(field,row){
		    	if('ADDNEW' != _self.getOperateState() && 'EDIT' != _self.getOperateState()){
		    		return;
		    	}
		    	if(_self.gridEditId){
		    		$('#editTreeGrid').treegrid('endEdit',_self.gridEditId);
		    		_self.cacl_runAmount();
		    	}
		    	if(field == 'planAmount' || field == 'remarks'){
		    		if(!row.isLeaf){
		    			return;
		    		}
		    		$('#editTreeGrid').treegrid('beginEdit',row.id);
		    		_self.gridEditId = row.id;
		    	}
		    },
		    onLoadSuccess:function(data){
		    	_self.cacl_runAmount();
		    }
		});
	},
	cacl_runAmount:function(){
		var rows = $('#editTreeGrid').treegrid('getData');
		var row = null;
		for (var v = 0; v < rows.length; v++) {
			row = rows[v];
			this.calAmount(row);
		}
		if(row && row.children){
			var planAmount = 0;
			var rate = 0;
			var yfsAmount = 0;
			var payAmount = 0;
			var planYe = 0;
			for (var o = 0; o < row.children.length; o++) {
				var ro = row.children[o];
				planAmount = Number(planAmount) + Number(ro.planAmount);
//				rate = Number(rate) + Number(ro.rate);
				yfsAmount = Number(yfsAmount) + Number(ro.yfsAmount);
				payAmount = Number(payAmount) + Number(ro.payAmount);
				planYe = Number(planYe) + Number(ro.planYe);
			}
			$('#editTreeGrid').treegrid('update',{id:row.id,row:{planAmount:planAmount,rate:rate,yfsAmount:yfsAmount,payAmount:payAmount,planYe:planYe}});
			
			for (var o = 0; o < row.children.length; o++) {
				var ro = row.children[o];
				var payrate = Number(ro.planAmount) / Number(planAmount) * Number(100);
				var ghye = Number(ro.planAmount) - Number(ro.yfsAmount);
				$('#editTreeGrid').treegrid('update',{id:ro.id,row:{rate:payrate,planYe:ghye}});
			}
		}
		
		for (var v = 0; v < rows.length; v++) {
			row = rows[v];
			$("#budget").numberspinner("setValue",row.planAmount);
		}
		this.entryPlanAmount();
	},
	calAmount:function(rows){
		for (var v = 0; v < rows.children.length; v++) {
			var row = rows.children[v];
			if(row.children){
				var planAmount = 0;
				var rate = 0;
				var yfsAmount = 0;
				var payAmount = 0;
				var planYe = 0;
				for (var o = 0; o < row.children.length; o++) {
					var ro = row.children[o];
					
					var ghye = Number(ro.planAmount) - Number(ro.yfsAmount);
					$('#editTreeGrid').treegrid('update',{id:ro.id,row:{planYe:ghye}});
					
					planAmount = Number(planAmount) + Number(ro.planAmount);
//					rate = Number(rate) + Number(ro.rate);
					yfsAmount = Number(yfsAmount) + Number(ro.yfsAmount);
					payAmount = Number(payAmount) + Number(ro.payAmount);
					planYe = Number(planYe) + Number(ro.planYe);
				}
				$('#editTreeGrid').treegrid('update',{id:row.id,row:{planAmount:planAmount,yfsAmount:yfsAmount,payAmount:payAmount,planYe:planYe}});
				
				for (var o = 0; o < row.children.length; o++) {
					var ro = row.children[o];
					var payrate = Number(ro.planAmount) / Number(planAmount) * Number(100);
					var ghye = Number(ro.planAmount) - Number(ro.yfsAmount);
					$('#editTreeGrid').treegrid('update',{id:ro.id,row:{rate:payrate,planYe:ghye}});
				}
			}
		}
	},
	
	entryPlanAmount:function(){
		var budget = $('#budget').numberspinner('getValue');      // 预算金额
		var saleTarget = $('#saleTarget').numberspinner('getValue');      // 销售目标
		var dg = $('#cyclePaymentPlanE2-entity');
		var rows = dg.datagrid('getRows');
		for (var i = 0; i < rows.length; i++) {
			var row = rows[i];
			var a = row["planAmountRate"]==undefined?0:row["planAmountRate"];
			var amt = Number(a)/Number(100) * Number(budget);
			var v = {};
			v.planAmount = amt;
			dg.datagrid("updateRow",{index:i,row: v});
		}
		
		var rate = Number(budget)/Number(saleTarget);
		$("#rate").numberspinner("setValue",rate*Number(100));
	},
	
	fmt_Amount:function(value){
		var number = Number(value);
    	if(isNaN(number)) {
    		return ''
    	}else{
    		var source = String(parseFloat(value).toFixed(2)).split(".");
    		source[0] = source[0].replace(new RegExp('(\\d)(?=(\\d{3})+$)','ig'),"$1,");
    		return source.join(".");
    	}
	},
	verify: function() {
		if(this.gridEditId){
    		$('#editTreeGrid').treegrid('endEdit',this.gridEditId);
    	}
		this.cacl_runAmount();
		var rows = $('#editTreeGrid').treegrid('getData');
    	if($('#editTreeGrid_JSON').length==0){
    		$('#id').append('<input id="editTreeGrid_JSON" name="editTreeGrid_JSON" type="hidden">');
    	}
		$('#editTreeGrid_JSON').val(encodeURIComponent(JSON.stringify(rows)));
		return true;
	},
	
	//可编辑表格值改变事件，可对表格进行值代入、带出操作
	e2_editChange:function(datagridTarget,target,index,field,newValue,oldValue){
		//获取编辑行数据
		var row = datagridTarget.datagrid('getRows')[index];
		row[field]=newValue;
		if(field=='planAmountRate'){
			var budget = $('#budget').numberspinner('getValue');      // 获取值

			var a = row["planAmountRate"]==undefined?0:row["planAmountRate"];
			var xx= Number(a)/Number(100) * Number(budget);
			//更新行数据
			datagridTarget.datagrid("updateRow",{index:index,row:{planAmount:xx}});
		}
		if(field=='year'){
			var budget = $('#budget').numberspinner('getValue');      // 获取值
			var projectid =$('#project').textbox("getBizValue").id;
			
			var year = row["year"].id;
			dst.remoteCall({
				method : "getAmt",
				async:true,  
				url: this.uipk,
				param : {projectid:projectid,year:year},
				success : function(data, textStatus) {
					datagridTarget.datagrid("updateRow",{index:index,row:{yfsAmount:data.yfsAmount,payAmount:data.payAmount}});
				}
			});
		}
	},
});

