package com.dst.slms.util;

import com.baomidou.mybatisplus.toolkit.StringUtils;
import com.dst.slms.common.utils.UIRuleUtil;

/**
 * @Title: 对应数据字典的枚举类
 * @author wanghb
 * @date 2019-07-18
 */
public interface ParamEnum {
    /**
     * R 返回结果
     * @author wanghb
     * @date 2019-06-25
     */
    enum R {
        OK("200", "成功");
        private String code;
        private String value;
        R(String code, String value) {
            this.code = code;
            this.value = value;
        }
        public static String getName(String code) {
            for (R ws : R.values()) {
                if (ws.getCode().equals(code)) {
                    return ws.getName();
                }
            }
            return StringUtils.EMPTY;
        }
        public String getCode() {
            return code;
        }
        public String getName() {
            return value;
        }
    }


    /**
     * 表单状态 系统预设 对应的参数编号  BILLSTATUS
     * 所有地方状态手动插入均调用此状态 维护好维护
     * @author wanghb
     * @date 2019-06-25
     */
    enum BILLSTATUS {
        AUDIT("AUDIT", "审批通过"),
        AUDITFAIL("AUDITFAIL", "审批不通过"),
        AUDITING("AUDITING", "流程中"),
        CLOSE("CLOSE", "关闭"),
        SAVE("SAVE", "保存"),
        SIGNED("SIGNED", "已签署"),
        SUBMIT("SUBMIT", "已提交");
        private String code;
        private String value;
        BILLSTATUS(String code, String value) {
            this.code = code;
            this.value = value;
        }
        public static String getName(String code) {
            for (BILLSTATUS ws : BILLSTATUS.values()) {
                if (ws.getCode().equals(code)) {
                    return ws.getName();
                }
            }
            return StringUtils.EMPTY;
        }
        public String getCode() {
            return code;
        }
        public String getName() {
            return value;
        }
    }

    /**
     * MarketAccountInfo  营销科目
     * @author wanghb
     * @date 2019-06-25
     */
    enum MarketAccount {
        Market1("", "营销科目"),
        ;
        private String code;
        private String value;
        MarketAccount(String code, String value) {
            this.code = code;
            this.value = value;
        }
        public static String getName(String code) {
            for (MarketAccount ws : MarketAccount.values()) {
                if (ws.getCode().equals(code)) {
                    return ws.getName();
                }
            }
            return StringUtils.EMPTY;
        }
        public String getCode() {
            return code;
        }
        public String getName() {
            return value;
        }
    }



    /**
     * 是否
     * @author wanghb
     * @date 2019年8月8日
     */
    enum ISYN {
        YES("Y","是"),
        NO("N","否");

        private String code;
        private String value;
        ISYN(String code, String value) {
            this.code = code;
            this.value = value;
        }
        public static String getName(String code) {
            for (ISYN ws : ISYN.values()) {
                if (ws.getCode().equals(code)) {
                    return ws.getName();
                }
            }
            return StringUtils.EMPTY;
        }
        public String getCode() {
            return code;
        }
        public String getName() {
            return value;
        }
    }


}
