package com.dst.slms.plan.web.controller;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import com.dst.slms.common.entity.sic.SelectorItemCollection;
import com.dst.slms.common.service.util.DataGrid;
import com.dst.slms.common.service.util.EntityQuery;
import com.dst.slms.common.support.ICrudService;
import com.dst.slms.common.support.controller.CoreBaseController;
import com.dst.slms.common.utils.FieldMetaAnnotationHelper;
import com.dst.slms.common.utils.R;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import com.dst.slms.common.annotation.SysPermissionName;
import com.dst.slms.plan.entity.MonthlyPaymentPlanInfo;
import com.dst.slms.plan.service.IMonthlyPaymentPlanService;

/**   
 * 月度支付计划 控制类此类会在发布元数据时覆盖
 * @Title: Controller
 * @Description: 月度支付计划
 * @author 
 * @date 2020-05-04 18:55:28
 * @version V1.0   
 *
 */
public abstract class AbstractMonthlyPaymentPlanController extends CoreBaseController {

	@Autowired
	private IMonthlyPaymentPlanService iMonthlyPaymentPlanService;
	
	@Override
	public String getListName() {
		return "com/dst/slms/plan/monthlypaymentplan/monthlyPaymentPlanList";
	}
	
	@Override
	public String getEditName() {
		return "com/dst/slms/plan/monthlypaymentplan/monthlyPaymentPlanEdit";
	}

	@Override
	public String getModleName() {
		return "model";
	}
	
	@Override
	public ICrudService getService() {
		return iMonthlyPaymentPlanService;
	}
	
	public Object createNewModel(HttpServletRequest req) {
		MonthlyPaymentPlanInfo info = new MonthlyPaymentPlanInfo();
		info.setNumber(getService().getNumber(info.getClass().getName()));
		info.setState("SAVE");
		return info;
	}
	
	@Override
	public SelectorItemCollection getEditSelector() {
		SelectorItemCollection sic = new SelectorItemCollection();
		sic.add("name");
		sic.add("number");
		sic.add("remake");
		sic.add("sourceBillId");
		sic.add("state");
		sic.add("auditor.id");
		sic.add("auditor.number");
		sic.add("auditor.name");
		sic.add("auditTime");
		sic.add("year");
		sic.add("month");
		sic.add("versions");
		sic.add("org.id");
		sic.add("org.number");
		sic.add("org.name");
		sic.add("marketProject.id");
		sic.add("marketProject.number");
		sic.add("marketProject.name");
		sic.add("isnew");
		sic.add("expectedUnpaid.parent.id");
		sic.add("expectedUnpaid.parent.number");
		sic.add("expectedUnpaid.parent.name");
		sic.add("expectedUnpaid.saleContract.id");
		sic.add("expectedUnpaid.saleContract.number");
		sic.add("expectedUnpaid.saleContract.name");
		sic.add("expectedUnpaid.saleContractName");
		sic.add("expectedUnpaid.supplierProfile.id");
		sic.add("expectedUnpaid.supplierProfile.number");
		sic.add("expectedUnpaid.supplierProfile.name");
		sic.add("expectedUnpaid.marketAccount.id");
		sic.add("expectedUnpaid.marketAccount.number");
		sic.add("expectedUnpaid.marketAccount.name");
		sic.add("expectedUnpaid.contractAmount");
		sic.add("expectedUnpaid.amountPaid");
		sic.add("expectedUnpaid.unpaidAmount");
		sic.add("expectedUnpaid.overdue");
		sic.add("signed.parent.id");
		sic.add("signed.parent.number");
		sic.add("signed.parent.name");
		sic.add("signed.saleContract.id");
		sic.add("signed.saleContract.number");
		sic.add("signed.saleContract.name");
		sic.add("signed.saleContractName");
		sic.add("signed.supplierProfile.id");
		sic.add("signed.supplierProfile.number");
		sic.add("signed.supplierProfile.name");
		sic.add("signed.marketAccount.id");
		sic.add("signed.marketAccount.number");
		sic.add("signed.marketAccount.name");
		sic.add("signed.contractAmount");
		sic.add("signed.amountPaid");
		sic.add("signed.unpaidAmount");
		sic.add("signed.monthOne");
		sic.add("signed.monthTwo");
		sic.add("signed.monthThree");
		sic.add("monthlyPaymentPlanE.parent.id");
		sic.add("monthlyPaymentPlanE.parent.number");
		sic.add("monthlyPaymentPlanE.parent.name");
		sic.add("monthlyPaymentPlanE.marketAccount.id");
		sic.add("monthlyPaymentPlanE.marketAccount.number");
		sic.add("monthlyPaymentPlanE.marketAccount.name");
		sic.add("monthlyPaymentPlanE.marketAccountName");
		sic.add("monthlyPaymentPlanE.currentApplication");
		sic.add("monthlyPaymentPlanE.oldBalance");
		sic.add("monthlyPaymentPlanE.monthlyBalance");
		sic.add("monthlyPaymentPlanE.verifyabc");
		return sic;
	}

	@RequiresPermissions("mon:monthlyPaymentPlan:list")	
	@ResponseBody
    @RequestMapping(params = "list")
	public void list(MonthlyPaymentPlanInfo info, HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		super.list(info, request, response, dataGrid);
	}
	
	@SysPermissionName(name="列表查看")
	@RequiresPermissions("mon:monthlyPaymentPlan:list")
	@ResponseBody
    @RequestMapping(value = "/listPage")
	public ModelAndView listPage(HttpServletRequest request) {
		return super.listPage(request);
	}
	
	@SysPermissionName(name="列表新增")
	@RequiresPermissions("mon:monthlyPaymentPlan:addnew")	
	@ResponseBody
    @RequestMapping(value = "/addPage")
	public ModelAndView addPage(HttpServletRequest req) {
		return super.addPage(req);
	}

	@SysPermissionName(name="表单查看")
	@RequiresPermissions("mon:monthlyPaymentPlan:view")		
	@ResponseBody
    @RequestMapping(value = "/viewPage")
	public ModelAndView viewPage(MonthlyPaymentPlanInfo info, HttpServletRequest req) {
		return super.viewPage(info, req);
	}
	
	@SysPermissionName(name="列表修改")
	@RequiresPermissions("mon:monthlyPaymentPlan:edit")	
	@ResponseBody
    @RequestMapping(value = "/editPage")
	public ModelAndView editPage(MonthlyPaymentPlanInfo info, HttpServletRequest req) {
		return super.editPage(info, req);
	}
	
	@SysPermissionName(name="保存")
	@RequiresPermissions("mon:monthlyPaymentPlan:save")	
	@ResponseBody
    @RequestMapping(value = "/save")
	public R saveAction(MonthlyPaymentPlanInfo info, HttpServletRequest req) {
		return super.saveAction(info, req);
	}

	@SysPermissionName(name="提交")
	@RequiresPermissions("mon:monthlyPaymentPlan:submit")
	@ResponseBody
    @RequestMapping(value = "/submit")
	public R submitAction(MonthlyPaymentPlanInfo info, HttpServletRequest req) {
		return super.submitAction(info, req);
	}

	@SysPermissionName(name="删除")
	@RequiresPermissions("mon:monthlyPaymentPlan:delete")	
	@ResponseBody
    @RequestMapping(value = "/delete")
	public R deleteAction(MonthlyPaymentPlanInfo info, HttpServletRequest req) {
		return super.deleteAction(info, req);
	}
	
	/**
	 * 导出excel
	 */
	@SysPermissionName(name="导出excel")
	@RequiresPermissions("mon:monthlyPaymentPlan:downExcel")		 
	@RequestMapping(value = "/downExcel")
	public void downExcel(MonthlyPaymentPlanInfo info,HttpServletRequest request, HttpServletResponse response, DataGrid dataGrid) {
		EntityQuery cq = getQueryExecutor(request, info, dataGrid);
		listToExcel(cq, request, response,FieldMetaAnnotationHelper.getEntityName(info.getClass().getName()));
	}
}
