package com.dst.slms.plan.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;

import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import com.dst.slms.common.entity.CoreBaseEntryInfo;
import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 规划余额 Info 对象
 * @Description: 规划余额
 * @author 
 * @date 2020-05-04 18:55:28
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractMonthlyPaymentPlanEInfo  extends CoreBaseEntryInfo implements java.io.Serializable {
	
	/**父对象关联*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FparentId")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="父对象关联" )
	private com.dst.slms.plan.entity.MonthlyPaymentPlanInfo parent;
	
	/**科目编码*/
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FmarketAccountID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="科目编码" )
	private com.dst.slms.base.entity.MarketAccountInfo marketAccount;
	
	/**科目名称*/
	@Column(name ="FmarketAccountName")
	@FieldMeta(name="科目名称" )
	private java.lang.String marketAccountName;
	
	/**本期申请（A）*/
	@Column(name ="FcurrentApplication")
	@FieldMeta(name="本期申请（A）" )
	private java.math.BigDecimal currentApplication;
	
	/**上期结余（B）*/
	@Column(name ="FoldBalance")
	@FieldMeta(name="上期结余（B）" )
	private java.math.BigDecimal oldBalance;
	
	/**当月预算（C）*/
	@Column(name ="FmonthlyBalance")
	@FieldMeta(name="当月预算（C）" )
	private java.math.BigDecimal monthlyBalance;
	
	/**校验（A-B-C）*/
	@Column(name ="Fverifyabc")
	@FieldMeta(name="校验（A-B-C）" )
	private java.math.BigDecimal verifyabc;
	
	
	/**
	 *方法: 取得com.dst.slms.plan.entity.MonthlyPaymentPlanInfo
	 *@return: com.dst.slms.plan.entity.MonthlyPaymentPlanInfo  父对象关联
	 */
	public com.dst.slms.plan.entity.MonthlyPaymentPlanInfo getParent(){
		return this.parent;
	}

	/**
	 *方法: 设置com.dst.slms.plan.entity.MonthlyPaymentPlanInfo
	 *@param: com.dst.slms.plan.entity.MonthlyPaymentPlanInfo  父对象关联
	 */
	public void setParent(com.dst.slms.plan.entity.MonthlyPaymentPlanInfo parent){
		this.parent = parent;
	}
	
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketAccountInfo
	 *@return: com.dst.slms.base.entity.MarketAccountInfo  科目编码
	 */
	public com.dst.slms.base.entity.MarketAccountInfo getMarketAccount(){
		return this.marketAccount;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketAccountInfo
	 *@param: com.dst.slms.base.entity.MarketAccountInfo  科目编码
	 */
	public void setMarketAccount(com.dst.slms.base.entity.MarketAccountInfo marketAccount){
		this.marketAccount = marketAccount;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  科目名称
	 */
	public java.lang.String getMarketAccountName(){
		return this.marketAccountName;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  科目名称
	 */
	public void setMarketAccountName(java.lang.String marketAccountName){
		this.marketAccountName = marketAccountName;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  本期申请（A）
	 */
	public java.math.BigDecimal getCurrentApplication(){
		return this.currentApplication;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  本期申请（A）
	 */
	public void setCurrentApplication(java.math.BigDecimal currentApplication){
		this.currentApplication = currentApplication;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  上期结余（B）
	 */
	public java.math.BigDecimal getOldBalance(){
		return this.oldBalance;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  上期结余（B）
	 */
	public void setOldBalance(java.math.BigDecimal oldBalance){
		this.oldBalance = oldBalance;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  当月预算（C）
	 */
	public java.math.BigDecimal getMonthlyBalance(){
		return this.monthlyBalance;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  当月预算（C）
	 */
	public void setMonthlyBalance(java.math.BigDecimal monthlyBalance){
		this.monthlyBalance = monthlyBalance;
	}
	
	/**
	 *方法: 取得java.math.BigDecimal
	 *@return: java.math.BigDecimal  校验（A-B-C）
	 */
	public java.math.BigDecimal getVerifyabc(){
		return this.verifyabc;
	}

	/**
	 *方法: 设置java.math.BigDecimal
	 *@param: java.math.BigDecimal  校验（A-B-C）
	 */
	public void setVerifyabc(java.math.BigDecimal verifyabc){
		this.verifyabc = verifyabc;
	}
		
	@Override
	public void setBosType(String bosType) {
		this.bosType = "PULTOE29";
	}
}
