package com.dst.slms.plan.entity;


import org.hibernate.annotations.DynamicUpdate;
import com.dst.slms.common.annotation.EntityMeta;
import com.dst.slms.common.annotation.FieldMeta;
import com.dst.slms.common.entity.CoreBaseInfo;


import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.hibernate.annotations.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import com.dst.slms.common.entity.CoreBillBaseInfo;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.OrderBy;
import javax.persistence.MappedSuperclass;
/**   
 * @Title: 年度支付计划 Info 对象
 * @Description: 年度支付计划
 * @author 
 * @date 2020-05-03 11:15:04
 * @version V1.0   
 */
@MappedSuperclass
public class AbstractAnnualPaymentPlanInfo  extends CoreBillBaseInfo implements java.io.Serializable {
	
	@Column(name ="FNAME")
	@FieldMeta(name="名称" )
	private java.lang.String name;
	
	@Column(name ="FNUMBER")
	@FieldMeta(name="编号" )
	private java.lang.String number;
	
	@Column(name ="FREMAKE")
	@FieldMeta(name="修订原因" )
	private java.lang.String remake;
	
	@Column(name ="FSOURCEBILLID")
	@FieldMeta(name="单据来源" )
	private java.lang.String sourceBillId;
	
	
	
	
	@Column(name ="Fyear")
	@FieldMeta(name="年份" ,enumGroupNumber="year")
	private java.lang.String year;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "FmarketProjectID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="营销项目" )
	private com.dst.slms.base.entity.MarketProjectInfo marketProject;
	
	@OneToOne(fetch = FetchType.LAZY)@JoinColumn(name = "ForgID")@NotFound(action=NotFoundAction.IGNORE)@ForeignKey(name="null")
	@FieldMeta(name="所属组织" )
	private com.dst.slms.system.entity.SysOrgInfo org;
	
	@Column(name ="Fisnew")
	@FieldMeta(name="是否最新版" )@org.hibernate.annotations.Type(type="yes_no")
	private boolean isnew;
	
	@Column(name ="Feditionnumber")
	@FieldMeta(name="版本号" )
	private java.lang.Integer editionnumber;
	
	@OneToMany(fetch=FetchType.LAZY,cascade=javax.persistence.CascadeType.ALL,orphanRemoval=true)
	@JoinColumn(name="fparentid")   
    @OrderBy(clause = "fseq asc") 
	private List<AnnualPlanDetailsInfo> annualPlanDetails = new ArrayList<AnnualPlanDetailsInfo>(); 

	public List<AnnualPlanDetailsInfo> getAnnualPlanDetails() {
		return annualPlanDetails;
	}

	public void setAnnualPlanDetails(List<AnnualPlanDetailsInfo> annualPlanDetails) {
		this.annualPlanDetails = annualPlanDetails;
	}
	
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  名称
	 */
	public java.lang.String getName(){
		return this.name;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  名称
	 */
	public void setName(java.lang.String name){
		this.name = name;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  编号
	 */
	public java.lang.String getNumber(){
		return this.number;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  编号
	 */
	public void setNumber(java.lang.String number){
		this.number = number;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  修订原因
	 */
	public java.lang.String getRemake(){
		return this.remake;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  修订原因
	 */
	public void setRemake(java.lang.String remake){
		this.remake = remake;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  单据来源
	 */
	public java.lang.String getSourceBillId(){
		return this.sourceBillId;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  单据来源
	 */
	public void setSourceBillId(java.lang.String sourceBillId){
		this.sourceBillId = sourceBillId;
	}
	/**
	 *方法: 取得java.lang.String
	 *@return: java.lang.String  年份
	 */
	public java.lang.String getYear(){
		return this.year;
	}

	/**
	 *方法: 设置java.lang.String
	 *@param: java.lang.String  年份
	 */
	public void setYear(java.lang.String year){
		this.year = year;
	}
	/**
	 *方法: 取得com.dst.slms.base.entity.MarketProjectInfo
	 *@return: com.dst.slms.base.entity.MarketProjectInfo  营销项目
	 */
	public com.dst.slms.base.entity.MarketProjectInfo getMarketProject(){
		return this.marketProject;
	}

	/**
	 *方法: 设置com.dst.slms.base.entity.MarketProjectInfo
	 *@param: com.dst.slms.base.entity.MarketProjectInfo  营销项目
	 */
	public void setMarketProject(com.dst.slms.base.entity.MarketProjectInfo marketProject){
		this.marketProject = marketProject;
	}
	/**
	 *方法: 取得com.dst.slms.system.entity.SysOrgInfo
	 *@return: com.dst.slms.system.entity.SysOrgInfo  所属组织
	 */
	public com.dst.slms.system.entity.SysOrgInfo getOrg(){
		return this.org;
	}

	/**
	 *方法: 设置com.dst.slms.system.entity.SysOrgInfo
	 *@param: com.dst.slms.system.entity.SysOrgInfo  所属组织
	 */
	public void setOrg(com.dst.slms.system.entity.SysOrgInfo org){
		this.org = org;
	}
	/**
	 *方法: 取得java.lang.Boolean
	 *@return: java.lang.Boolean  是否最新版
	 */
	public boolean getIsnew(){
		return this.isnew;
	}

	/**
	 *方法: 设置java.lang.Boolean
	 *@param: java.lang.Boolean  是否最新版
	 */
	public void setIsnew(boolean isnew){
		this.isnew = isnew;
	}
	/**
	 *方法: 取得java.lang.Integer
	 *@return: java.lang.Integer  版本号
	 */
	public java.lang.Integer getEditionnumber(){
		return this.editionnumber;
	}

	/**
	 *方法: 设置java.lang.Integer
	 *@param: java.lang.Integer  版本号
	 */
	public void setEditionnumber(java.lang.Integer editionnumber){
		this.editionnumber = editionnumber;
	}
	
	public void setBosType(String bosType) {
		this.bosType = "RZJ5TWD5";
	}
}
